'\""
'\" Copyright (c) 2001 Frank Pilhofer"
'\""
'\".so man.macros"
.TH YLEX n 0.4 ylex "Yeti Scanner"
.BS
.SH NAME
Ylex \- Yeti's Scanner
.SH SYNOPSIS
.PD 0
.PP
\fBpackage require ylex ?0.4?\fR
.PD
.PP
.PD 0
\fByeti::ylex\fR \fIname\fR
.PP
\fIname\fR \fBmacro\fR \fIname\fR \fIregex\fR ?\fI...\fI?
.PP
\fIname\fR \fBmacro\fR \fIargs\fR
.PP
\fIname\fR \fBadd\fR ?\fIoptions\fR? \fIregex\fR \fIscript\fR ?\fI...\fI?
.PP
\fIname\fR \fBadd\fR ?\fIoptions\fR? \fIargs\fR
.PP
\fIname\fR \fBcode\fR \fItoken\fR \fIscript\fR
.PP
\fIname\fR \fBdump\fR
.PP
\fIname\fR \fBconfigure\fR \fB-name\fR \fR?\fIvalue\fR?\fR
.PP
\fIname\fR \fBconfigure\fR \fB-start\fR \fR?\fIvalue\fR?\fR
.PP
\fIname\fR \fBconfigure\fR \fB-case\fR \fR?\fIvalue\fR?\fR
.PD
.BE
.SH SCANNER SYNOPSIS
.PP
.PD 0
\fIscannerName\fR \fIobjName\fR \fR?\fIoptions\fR?\fR
.PP
\fIname\fR \fBstart\fR \fIstring\fR
.PP
\fIname\fR \fBreset\fR
.PP
\fIname\fR \fBnext\fR
.PP
\fIname\fR \fBstep\fR
.PP
\fIname\fR \fBrun\fR
.PP
\fIname\fR \fBconfigure\fR \fB-case\fR \fR?\fIvalue\fR?\fR
.PP
\fIname\fR \fBconfigure\fR \fB-yydata\fR \fR?\fIvalue\fR?\fR
.PP
\fIname\fR \fBconfigure\fR \fB-verbose\fR \fR?\fIvalue\fR?\fR
.PP
\fIname\fR \fBconfigure\fR \fB-verbout\fR \fR?\fIvalue\fR?\fR
.PD
.BE
.SH DESCRIPTION
.PP
This manual page describes \fBylex\fR, a scanner generator that comes
with the \fByeti\fR package. \fBylex\fR is modeled after the standard
\fBlex\fR utility, which is used to create scanners in the C
programming language.
.PP
A scanner consists of a number of rules. Each rule associates a
regular expression with a Tcl script; this script is executed whenever
the regular expression is matched in the input. This code can either
act on its own, or it can generate a stream of tokens that can then be
evaluated outside of the scanner - e.g. in a parser.
.PP
\fBylex\fR does not do the scanning by itself, rather it is used,
quite like \fBlex\fR, to generate scanners (by way of the \fBdump\fR
method). Generated scanners are \fB[incr Tcl]\fR classes that act
independently of \fBylex\fR, see the \fBScanner\fR section
below. These scanners can be customized; you can use the \fBcode\fR
method to add user variables and methods to the class.
.SH COMMANDS
.TP
\fByeti::ylex\fR \fIname\fR
Creates a new scanner generator by the name of \fIname\fR. The new
scanner generator has an empty set of rules. \fIoptions\fR can be used
to configure the scanner generator's public variables, see the
\fIvariables\fR section below.
.SH METHODS
.PD 0
.TP
\fIname\fR \fBmacro\fR \fIname\fR \fIregex\fR ?\fI...\fI?
.TP
\fIname\fR \fBmacro\fR \fIargs\fR
.PD
Defines \fImacros\fR, which are regular expressions that are stored
for later use. Macros can be used in other macros or rules using their
name in angular brackets, e.g. \fI<digit>\fR would reference the
\fIdigit\fR macro. Macro names must be alphanumerical. In the first
form, the \fBmacro\fR method takes an even number of parameters. The
first parameter of each pair is the name, the second parameter is a
regular expression that may itself contain other macros. In the second
form, the method takes a list as single parameter, where this list is
composed as above of alternating names and regular expressions. The
second form may be more convenient to define multiple macros.
.TP
\fIname\fR \fBadd\fR ?\fIoptions\fR? \fIregex\fR \fIscript\fR ?\fI...\fI?
.PD 0
.TP
\fIname\fR \fBadd\fR ?\fIoptions\fR? \fIargs\fR
.PD
Adds new rules to the scanner. In the first form, the \fBadd\fR method
takes an even number of parameters (not counting options). The first
parameter of each pair is a regular expression, the second parameter
is a script. In the second form, the method takes a list as single
parameter (not counting options), where this list is composed as above
of alternating regular expressions and scripts.
.RS
.PP
Whenever the regular expression \fIregex\fR is matched in the input
string, its corresponding \fIscript\fR will be executed by the
scanner.
.PP
The following options are supported:
.IP "-nocase"
This option has the same meaning as on \fBregexp\fR. In matching this
rule, upper-case characters in the input will be treated as
lower-case.
.IP "-state \fIname\fR"
This rule will only be considered if the scanner is in the state
\fIname\fR. See below for more information.
.IP "-states \fInames\fR"
Same as above, but \fInames\fR is a list of state names in which the
rule is active.
.RE
.TP
\fIname\fR \fBcode\fR \fItoken\fR \fIscript\fR
Adds custom user code to the generated scanner. \fItoken\fR must be
one of
.RS
.IP \fBconstructor\fR
Defines the class's constructor. The \fIscript\fR may have any of the
formats allowed by \fB[incr Tcl]\fR, without the \fBconstructor\fR
keyword.
.IP \fBdestructor\fR
Defines the body of the class's destructor.
.IP \fBerror\fR
Defines the body of the error handler that is called whenever an error
occurs, e.g. errors executing a rule's
script. \fIscript\fR has access to the \fByyerrmsg\fR parameter, which
contains a string with a description of the error and its
cause. \fIscript\fR is supposed to inform the user of the problem. The
default implementations prints the message to the channel set in the
\fBverbout\fR variable. \fIscript\fR is expected to return normally;
the parser then returns from the current invocation with the original
error.
.IP \fBreset\fR
The \fIscript\fR is added to the body of the scanner's \fIreset\fR
method.
.IP \fBpublic\fR
.PD 0
.IP \fBprotected\fR
.IP \fBprivate\fR
Defines public, protected or private class members. The \fIscript\fR
may contain many different member definitions, like the respective
keywords in an \fB[incr Tcl]\fR class definition.
.PD
.RE
.TP
\fIname\fR \fBdump\fR
Returns a script containing the generated scanner. This method is
called after all configuration options have been set and all rules
have been added; the scanner generator object is usually deleted after
this method has been called. The returned script can be passed to
\fBeval\fR for instant usage, or saved to a file, from where it can
later be sourced without involvement of the scanner generator.
.SH VARIABLES
.TP
\fIname\fR \fBconfigure\fR \fB-name\fR \fR?\fIvalue\fR?\fR
Defines the class name of the generated scanner class. The default
value is \fBunnamed\fR.
.TP
\fIname\fR \fBconfigure\fR \fB-start\fR \fR?\fIvalue\fR?\fR
Defines the initial state for the scanner. Setting this variable is
only required if your scanner needs multiple states, and you are not
satisfied with the default of \fBINITIAL\fR.
.TP
\fIname\fR \fBconfigure\fR \fB-case\fR \fR?\fIvalue\fR?\fR
If set to 0 (zero), the generated scanner will be case-insensitive
(i.e. \fB-nocase\fR will be used on all calls to \fBregexp\fR). The
default value is 1 for a case-sensitive scanner. This setting can be
overridden on a rule-by-rule basis using the \fB-nocase\fR option upon
adding a rule.
.SH SCANNER USAGE
.PP
Scanners are independent of \fBylex\fR, their only dependency is on
\fB[incr Tcl]\fR.
.PP
A scanner reads its input from a string that must be set before
scanning can begin. The regular expressions (rules) are then
repeatedly matched against the current input position within this
string. If more than one regular expression matches text at a certain
position, the rule matching the most text is selected. If more than
one regular expression matches the same amount of text, the rule that
was added to the scanner generator first is selected. If a rule
matches, its associated \fIscript\fR is executed, and the read pointer
is moved beyond the match. Unmatched text in the input is ignored and
skipped.
.PP
Scanners are \fB[incr Tcl]\fR objects, so its usual rules of object
handling (e.g. deletion of scanners) apply.
.SH SCANNER COMMANDS
.TP
\fIscannerName\fR \fIobjName\fR \fR?\fIoptions\fR?\fR
Creates a new scanner instance by the name of \fIobjName\fR.
\fIoptions\fR can be used to configure the scanner's public variables,
see the \fIscanner variables\fR section below.
.SH SCANNER METHODS
.TP
\fIobjName\fR \fBstart\fR \fIstring\fR
Initializes the scanner to scan \fIstring\fR. Calling \fBstart\fR
implies \fBreset\fR.
.TP
\fIobjName\fR \fBreset\fR
Resets the scanner to the beginning of the input string, and resets
the state to the initial state. If you want to scan a different
string, you need not call \fBreset\fR but only \fBstart\fR.
.TP
\fIobjName\fR \fBnext\fR
Starts the scanning process. Regular expressions are matched, and
their scripts are executed. This repeats until a script executes
\fBreturn\fR or until end of input is reached. If a script executes
\fBreturn\fR, the script's return value is returned. At the end of
input, an empty string is returned.
.TP
\fIobjName\fR \fBstep\fR
Single-steps the parser. This method returns after a single match has
been done, regardless of whether its script executed \fBreturn\fR or
not. \fBstep\fR returns a list of length three. The first element of
this list is the number of the rule that was matched or -1 if at the
end of input. The second element is 1 if the script executed
\fBreturn\fR, 0 otherwise. The third element is the script's return
value if the script executed \fBreturn\fR, empty otherwise.
.TP
\fIobjName\fR \fBrun\fR
Runs the scanning process to completion. \fBnext\fR is repeatedly
called until the end of input has been reached. A list of all the
results returned from \fBnext\fR is returned.
.SH SCANNER VARIABLES
.TP
\fIobjName\fR \fBconfigure\fR \fB-case\fR \fR?\fIvalue\fR?\fR
If this variable is zero, then the \fB-nocase\fR option is
implicitly set for all rules. The default value is determined by the
setting of the \fBcase\fR variable in the scanner generator. Setting
this variable after scanning has started may yield unexpected results
because of cached data.
.TP
\fIobjName\fR \fBconfigure\fR \fB-yydata\fR \fR?\fIvalue\fR?\fR
This variable holds the input string. This variable is not meant to be
modified, but it can be conveniently configured upon object
creation. If that is done, there is no need to call the \fBstart\fR
method.
.TP
\fIobjName\fR \fBconfigure\fR \fB-yyindex\fR \fR?\fIvalue\fR?\fR
This variable holds the current index into the input string. This
variable is not meant to be set, but reading it may be useful
e.g. to determine the position that causes an error in a parser. After
an invocation \fBstep\fR or \fBnext\fR, \fByyindex\fR points to the
character after the current match.
.TP
\fIobjName\fR \fBconfigure\fR \fB-verbose\fR \fR?\fIvalue\fR?\fR
If this value is non-zero, the scanner prints debug information about
its processing. The larger \fBverbose\fR is, the more information is
printed (sensible values are 0 to 3). By default, no debug information
is printed.
.TP
\fIobjName\fR \fBconfigure\fR \fB-verbout\fR \fR?\fIvalue\fR?\fR
This variable contains the channel that is used for debug output. By
default, this is \fBstderr\fR.
.SH SCRIPTS
.PP
Scripts are executed in the context of the scanner. Scripts have
access to the following variables.
.TP
\fByytext\fR
This variable contains the text that was matched by the regular
expression.
.TP
\fByystate\fR
This variable contains the current state of the scanner. The script may
modify this variable to switch the scanner to a different state.
.TP
\fByystart\fR
The absolute index of the first character of the current match.
.TP
\fByyend\fR
The absolute index of the last character of the current match.
.TP
\fI<i>\fR
These variables (\fB$1\fR, \fB$2\fR ...) contain any subexpressions
matched by the regular expression.
.PP
\fBylex\fR reserves names with the \fByy\fR prefix, so scripts should
not use or access variables with this prefix other than those
documented here. Also, a scanner's public methods and variables as
seen above must be respected.
.SH STATES
.PP
Initially, a scanner is in the initial state as determined by the
\fBstart\fR variable of the scanner generator. Scripts can switch to a
different state by modifying the \fByystate\fR variable during
execution of a script. In each state, only a subset of all
rules will be considered, as determined by the \fB-state\fR or
\fB-states\fR options upon adding rules to the scanner generator; if
no such option was used when adding a rule, it will be active in all
states.
.SH NOTES
.PP
Unmatched text in the input is ignored. In order to throw an error
upon unmatched text, add a "catch-all" rule at the end of the rule
set (usually with the regular expression "." that matches any
character).
.PP
Subexpressions are available in the \fI$<i>\fR variables only when
using Tcl 8.3 or above.
.PP
It is illegal to have rules that match the empty string.
.SH TODO
.PP
There should be a means of reading data from elsewhere than a
string. It might be inconvenient to have all the input in
memory. However, that is not possible with the current regexp engine.
.PP
Maybe there should be the possibility to read a lex-like input file.
.SH KEYWORDS
scanner, parser, token
