#!/bin/sh
# the next line restarts using wish \
	exec wish "$0" ${1+"$@"}
#
# dial.tcl - a test program for the Tk dial widget.
#
# jeff at hobbs org

source [file join [file dirname [info script]] load.tcl]
eval destroy [winfo children .]
raise .

dial .volume -label "Volume" -from -0.1 -to 0.1 -resolution 0.001 \
	-minortickinterval 0.01 -tickinterval 0.1 \
	-beginangle -20 -endangle 260 \
	-variable volume

dial .speed -label "Speed" -from 2000 -to 100 -resolution 10 \
	-tickinterval 200 -minortickinterval 0 \
	-variable speed -showtags label -showvalue 0
.speed tag -constrain 100 Fast 2000 Slow

dial .forward -from -10.0 -to -20.0 -resolution .1 \
	-tickinterval 5.0 -minortickinterval 1.0 -variable x

dial .reverse -from -20.0 -to -10.0 -resolution .1 \
	-tickinterval 5.0 -minortickinterval 1.0 -variable x

dial .small -font "Helvetica -10" -from 0 -to 10 -resolution 0.05 \
	-tickinterval 2	-minortickinterval 0.5 -radius 20 \
	-dialcolor red2 -activebackground red -variable rot

dial .large -font "Helvetica -8" -from 0 -to 10 -resolution 0.05 \
	-tickinterval 1 -minortickinterval 0.25 -radius 40 \
	-dialcolor red2 -activebackground red -variable rot

dial .turn -needlecolor red -label "Linked" -variable linked
scale .scale -label "Linked" -variable linked

dial .d1 -resolution 0.0001 -from -0.1 -to 0.1 -showvalue 1 \
	-minortickinterval 0.01 -tickinterval 0.1 -radius 30 \
	-label "Dial" -beginangle -20 -endangle 260 \
	-variable needles -relief raised

dial .d2 -resolution 0.01 -from -0.1 -to 0.1 -showvalue 1 \
	-minortickinterval 0.01 -tickinterval 0.1 -radius 30 \
	-label "Dial 2" -beginangle -20 -endangle 260 \
	-variable needles -dialrelief flat \
	-needlecolor red -needletype triangle -relief sunken

dial .d3 -resolution 0.001 -from -0.1 -to 0.1 -showvalue 1 \
	-minortickinterval 0.01 -tickinterval 0.1 -radius 30 \
	-label "Dial 3" -beginangle -20 -endangle 260 \
	-variable needles -dialrelief flat \
	-needlecolor blue -needletype arc -relief ridge

frame .btns
frame .sep -height 2 -relief sunken -bd 1
button .start -text "Start" -command start
button .stop -text "Stop" -command stop
button .exit -text "Exit" -command exit

grid .start -in .btns -sticky ew -padx 4 -pady 4
grid .stop -in .btns -sticky ew -padx 4 -pady 4
grid columnconfig .btns 0 -weight 1

grid .btns .speed .volume -sticky news
grid .sep - - -sticky news
grid .forward .reverse .d1 -sticky news
grid .small .large .d2 -sticky news
grid .turn .scale .d3 -sticky news

grid .exit - - -sticky ew -padx 4 -pady 4

grid columnconfig . 0 -weight 1
grid columnconfig . 1 -weight 1
grid columnconfig . 2 -weight 1
grid rowconfigure . 0 -weight 1
grid rowconfigure . 2 -weight 1
grid rowconfigure . 3 -weight 1
grid rowconfigure . 4 -weight 1

set volume -0.1
set speed 500

proc start {} {
    global speed volume
    if {$volume == [.volume cget -to]} {
	set volume [.volume cget -from]
    } else {
	set volume [expr {$volume+[.volume cget -resolution]}]
    }
    after $speed [info level 0]
}

proc stop {} {
    foreach i [after info] { after cancel $i }
}
