#!/bin/sh
# the next line restarts using wish \
	exec wish "$0" ${1+"$@"}

# canvLabel.tcl
#
# Modified from original demo
#
# jeff at hobbs org, crrw@gmx.de

#
# NOTE: The 'label' item is a canvas 'text' item with rotation.
# This is not part of the default Vu build.
#

source [file join [file dirname [info script]] load.tcl]
eval destroy [winfo children .]
raise .

pack [canvas .c]
if {[catch {.c create label 10 10} st]} {
    tk_messageBox -type ok -title "No label Item" \
	    -message "This build of vu does not include the label item"
    destroy .c
    return
} else {
    destroy .c
}

set INFO "This test generates a canvas LABEL and a canvas TEXT
<3> change text"
puts $INFO

#---
#--- set STRING {{x0 y0 x1 y1} {...tex...} {resize point: center}

#---CRRW: 1. trailig \0x00...
#         2. X Error

set LABEL1 "Tk is great \u00e4\u00f6\u00fc"
set LABEL2 "\u00e4\u00f6\u00fc to you too"
set LABEL $LABEL1
set ::DEG 0
set ::DELAY 500
set FONT "Helvetica 24"

#---GUI
option add *Font "Helvetica 24"
eval destroy [winfo children .]
foreach a [after info] {
    after cancel $a
}

canvas .c -bg white
label .d -text "Angle: " -font $FONT
label .l -textvar ::DEG -font $FONT
button .faster -text Faster -command {
    incr ::DELAY -100
    if {$::DELAY < 100} { set ::DELAY 100 }
}
button .slower -text Slower -command {
    incr ::DELAY 100
    if {$::DELAY > 10000} { set ::DELAY 10000 }
}
grid .c -columnspan 4 -sticky news
grid .d .l .faster .slower -sticky ew
grid columnconfigure . 1 -weight 1
grid rowconfigure . 0 -weight 1

#--- Create an "test" item
.c create text 10 10 -tags text \
	-font $FONT \
	-anchor nw \
	-text "text: $LABEL"

#--- Create an "label" item
.c create label 150 150 -tags label \
	-font $FONT \
	-anchor center \
	-text "label: $LABEL"

#--- Rotate
proc rotate {} {
    if {$::DEG >= 360.} { set ::DEG 0 }
    set ::DEG [expr {$::DEG + 10}]
    .c itemconfigure label -angle $::DEG
    update
    set ::RID [after $::DELAY rotate]
}

#--- START
rotate

#--- BINDINGS
bind .  <p>		{
    .c postscript -file DEMO.ps
    puts "DEMO.ps printed"
}
bind .  <q>	{ exit }

bind .c <3>     {
    set LABEL [expr {($LABEL==$LABEL1)?$LABEL2:$LABEL1}]
    .c itemconfigure label -text "label: $LABEL"
    .c itemconfigure text -text "text: $LABEL"
}
