Ukaž
====

A graph widget written in pure Tcl/Tk.

This is a package which provides a widget to plot data in x-y format for
scientific applications. It sets reasonable defaults to display most datasets
without the need for individual settings. Ukaž was designed to be easy to use and
borrows most of the syntax from the popular gnuplot package
[http://www.gnuplot.info], slightly adapted to be more Tcl friendly.

The simplest usage looks like this:

	package require ukaz
	pack [ukaz::graph .g] -expand yes -fill both
	set data {1 4.5 2 7.3 3 1.2 4 6.5}
	.g plot $data

This displays a resizable plot of the data, which is expected as a list of
alternating x-y coordinates. The range of the axis, the number and placement of
the the tic marks and the plot style is automatically chosen. The data can be
zoomed in by dragging the left mouse button over the canvas, and zoomed out by
clicking the right mouse button.

The style of the plot can be adjusted by passing more options to the plot
command, and by setting global options using either gnuplot-style commands or
Tcl-style configure commands:


	package require ukaz
	pack [ukaz::graph .g] -expand yes -fill both
	set data {1 4.5 2 7.3 3 1.2 4 6.5}
	.g plot $data with points pointtype filled-squares color "#A0FFA0"
	.g set log y

This displays the same data with light-green squares on a logarithmic y-axis.

Datafiles can be displayed by the /using/ modifier as in gnuplot:

	.g plot "somedata.dat" using 1:2 with lines lc blue
	.g plot "somedata.dat" using {1:($2/$4)}

This reads the file "somedata.dat" and plots the second column versus the first
with a blue line. In addition, it plots the ratio of the 2nd to the 4th column
with points.

Interactive features
--------------------

The graph widget sends virtual events when the user zooms the data or clicks
into the plot. This enables simple interactive data dialogs. In addition,
special widget-like objects, controls, can be added to the graph. The first implemented one
is the /dragline/. This is a horizontal or vertical line, which displays a
variable in the graph, e.g. a threshold, and can be dragged by the user.

	dragline d -orient horizontal -variable v
	set v 0
	.g addcontrol d


How does ukaž compare to
------------------------

* Plotchart
Data management, automatic scaling

* Gnuplot
much simpler, not easy to embed, many terminals

...

TODO
====
	* More gnuplot-like set methods (set xrange, xtics, xlabel ...)
	* More examples
	* Data transformation for lists
	* Legend

