#
# twi_dac.tcl
#
# Enables TWI pins, and writes incrementing and decrementing values to the
# analog outputs of a MAX518 TWI DAC every 20ms.
#

package require tfirmata

set bd [tfirmata::open /dev/ttyUSB0]
$bd twiconfig

set addr 0x2c
set incVal 0
set decVal 255 
while {1} {
    $bd twiset $addr 0 $incVal
    $bd twiset $addr 1 $decVal
    tfirmata::sleep 20
    incr incVal 10
    incr decVal -10
    if {$incVal > 255} {
        set incVal 0 
    }
    if {$decVal < 0} {
        set decVal 255
    }
}

