#
# gui.tcl
#
# GUI for:
#   - reading state of pins 7:4, with pull-ups enabled
#   - setting output state of pins 13:10
#   - reading analog channels 0 and 1
#   - setting pin 9 pwm value
#

package require Tk
package require tfirmata

# variables for gui elements
set out10 0
set out11 0
set out12 0
set out13 0
set inputs -
set an0 -
set an1 -
set out9 0

# gui elements
wm title . Arduino
ttk::frame .f
ttk::label .f.inputsLbl -text "Inputs 7-4: "
ttk::label .f.inputs -textvariable inputs
ttk::checkbutton .f.out10 -text "Output 10" -variable out10 \
        -command updateBdOutputs
ttk::checkbutton .f.out11 -text "Output 11" -variable out11 \
        -command updateBdOutputs
ttk::checkbutton .f.out12 -text "Output 12" -variable out12 \
        -command updateBdOutputs
ttk::checkbutton .f.out13 -text "Output 13" -variable out13 \
        -command updateBdOutputs
ttk::label .f.an0Lbl -text "Analog 0: "
ttk::label .f.an0 -textvariable an0
ttk::label .f.an1Lbl -text "Analog 1: "
ttk::label .f.an1 -textvariable an1
ttk::label .f.out9Lbl -text "Output 9: " 
tk::spinbox .f.out9 -from 0 -to 255 -width 5 -textvariable out9 \
        -validate key -vcmd {string is integer %P} -command updateBdPwm

# layout gui
grid .f -sticky nesw -padx 5 -pady 5
grid .f.inputsLbl .f.inputs
grid x .f.out10 -sticky w
grid x .f.out11 -sticky w
grid x .f.out12 -sticky w
grid x .f.out13 -sticky w
grid .f.an0Lbl .f.an0
grid .f.an1Lbl .f.an1
grid .f.out9Lbl .f.out9
grid configure .f.inputsLbl .f.an0Lbl .f.an1Lbl .f.out9Lbl -sticky e
grid configure .f.inputs .f.an0 .f.an1 .f.out9 -sticky w

# update board digital output pins
proc updateBdOutputs {} {
    global bd out10 out11 out12 out13
    $bd dset 10 $out10 11 $out11 12 $out12 13 $out13
}

# update board pin pwm output setting
proc updateBdPwm {} {
    global bd out9
    $bd aset 9 $out9
}

# update GUI digital inputs values
proc updateGuiInputs {} {
    global bd inputs
    set inputs [$bd dget 7 6 5 4]
}

# update GUI analog input values
proc updateGuiAnalogs {} {
    global bd an0 an1
    lassign [$bd aget 0 1] an0 an1
}

# board config and callback commands
set bd [tfirmata::open /dev/ttyUSB0]
$bd mode 4 5 6 7 in 9 pwm 10 11 12 13 out 
$bd dset 4 1 5 1 6 1 7 1
$bd dcommand updateGuiInputs
$bd acommand updateGuiAnalogs
$bd dstream 0 on
$bd astream 0 1 on
$bd period 500

