#
# encoder.tcl
#
# Configures encoder on pins 2, 3, then outputs
# encoder position on encoder events
#

package require tfirmata

set bd [tfirmata::open /dev/ttyUSB0]
$bd eattach 0 2 3

# set callback
$bd ecommand {print_encoder %C %V}

# enable reports
$bd ereport on

# callback function
proc print_encoder {enc val} {
    puts "ENCODER $enc: $val"
}

# main loop
while {1} {
    tfirmata::sleep 10000
    $bd equery
}
