#
# bg2_temp_sys.tcl
#
# For use with ia_temp_sys.tcl and iatclsh. Load as a background script for 
# interactively driving hardware, and for display of temperature and LDR
# values in status bar.
#

set celcius 1

proc initialise {} {
    addCBAction Celcius celcius
}

proc run {} {
    set temp [cmd temp]
    if {$::celcius} {
        setStatusLeft "temp: $temp"
    } else {
        setStatusLeft "temp: [expr {$temp * 9.0 / 5 + 32}]"
    }
    return 500
}

