#
# keyltools.tcl --
#
# Extended Tcl array/keyed list converters.
#
#------------------------------------------------------------------------------
# Copyright 2021 chw at ch minus werner dot de
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  Christian Werner
# makes no representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied warranty.
#------------------------------------------------------------------------------
#

proc keyl2array {lvar avar {prefix {}}} {
    upvar $lvar kl
    upvar $avar ar
    if {$prefix ne {}} {
	set prefix [string trimright $prefix .]
	if {$prefix ne {}} {
	    append prefix .
	}
    }
    foreach key [keylkeys kl] {
	if {[catch {keylget kl $key} value]} {
	    continue
	}
	set akey ${prefix}$key
	if {[catch {keylkeys value} keys]} {
	    set ar($akey) $value
	} else {
	    keyl2array value ar $akey
	}
    }
    return {}
}

proc array2keyl {avar lvar {key {}}} {
    upvar $avar ar
    upvar $lvar kl
    if {$key ne {}} {
	set key [string trimright $key *]
	append key *
	set alist [array get ar $key]
    } else {
	set alist [array get ar]
    }
    foreach {name value} $alist {
	keylset kl $name $value
    }
    return {}
}
