package require Tk
package require tcluvc

# callback: (un)plugged device
proc devicecb {but img {op {}} {dev {}}} {
    set dev [uvc info]
    if {$dev eq ""} {
	init $but $img
    } else {
	uvc close $dev
	$but configure -text "No Camera"
    }
}

# callback: image ready or error
proc imagecb {but img dev} {
    uvc image $dev $img
}

# button handler: start/stop image capture
proc startstop {but img} {
    set dev [uvc info]
    if {$dev eq ""} {
	if {$::ANDROID} {
	    devicecb $but $img
	}
	return
    }
    switch -glob -- [uvc state $dev] {
	capture {
	    uvc stop $dev
	    $but configure -text "Start"
	}
	* {
	    uvc start $dev
	    $but configure -text "Stop"
	}
    }
}

# init device
proc init {but img {name {}}} {
    if {$name eq ""} {
	if {$::ANDROID} {
	    foreach {dev vidpid ifs} [borg usbdevices 1] {
		if {[string match -nocase {*:0E02??:*} $ifs]} {
		    set name $vidpid
		    break
		}
	    }
	} else {	
	    set name [lindex [uvc devices] 0]
	}
    }
    if {$name eq ""} {
	$but configure -text "No Camera"
	return
    }
    if {$::ANDROID} {
	if {[borg usbpermission $dev 1] <= 0} {
	    $but configure -text "No Camera"
	    return
	}
    }
    set dev [uvc open $name [list imagecb $but $img]]
    array set d [uvc parameters $dev]
    if {[info exists d(frame-size)] &&
	[scan $d(frame-size) %dx%d w h] == 2} {
	$img configure -width $w -height $h
	$img blank
    }
    $but configure -text "Start"
}

proc changemirror {w} {
    set dev [uvc info]
    if {$dev ne ""} {
	lassign [uvc mirror $dev] x y
	set n [expr {$x + $y * 2 + 1}]
	uvc mirror $dev [expr {$n & 1}] [expr {$n & 2}]
    }
}

proc changeorientation {w} {
    set dev [uvc info]
    if {$dev ne ""} {
	set n [uvc orientation $dev]
	set n [expr {($n + 90) % 360}]
	uvc orientation $dev $n
	set img [$w cget -image]
	$img configure -width 1 -height 1
	$img configure -width 0 -height 0
    }
}

# user interface
if {([info command sdltk] ne "") && [sdltk android]} {
    set ANDROID 1
    wm attributes . -fullscreen 1
    borg screenorientation landscape
    . configure -bg black
    frame .f -bg black
    pack .f -side top -fill x
    label .l -image [image create photo] -bg black
    pack .l -side top -fill both -expand 1
    button .b -command [list startstop .b [.l cget -image]]
    button .m -text "Mirror" -command [list changemirror .l]
    button .o -text "Rotate" -command [list changeorientation .l]
    pack .b .m .o -in .f -side left -expand 1
    bind . <<USBAttached>> [list devicecb .b [.l cget -image]]
    bind . <<USBDetached>> [list devicecb .b [.l cget -image]]
    bind all <Break> exit
    bind .l <Double-1> {console hide ; console show}
} else {
    set ANDROID 0
    label .l -image [image create photo]
    button .b -command [list startstop .b [.l cget -image]]
    pack .b .l -side top
    bind .l <1> {changemirror %W}
    bind .l <3> {changeorientation %W}
    # watch for (un)plugged devices
    uvc listen [list devicecb .b [.l cget -image]]
}

# try to init device
init .b [.l cget -image]
