# SNACK w/ accelerometer organ

package require snack
wm attributes . -fullscreen 1
borg screenorientation portrait
. configure -bg black
canvas .c -bg black -bd 0 -highlightthickness 0
pack .c -side top -fill both -expand 1 -padx 0 -pady 0
bind all <Break> exit
bind . <<Accelerometer>> {config .c %s %x}
sdltk accelerometer on
sdltk touchtranslate 0
set f [open [info script]]
.c create text 20 20 -anchor nw -tag s -font {Courier 5} -text [read $f] \
    -fill gray50
close $f
set s(snd) [snack::sound -rate 22040 -channels 1]
set s(filt) [snack::filter generator 440.0]
set s(freq) 440.0
set s(ampl) 0
$s(snd) stop
$s(snd) play -filter $s(filt)
$s(filt) configure $s(freq) $s(ampl) 0.0 sine -1

proc config {canvas axis value} {
    set ix 0
    set iy 0
    if {$axis == 1} {
	set ix [expr {$value / 256}]
    } elseif {$axis == 2} {
	set iy [expr {$value / 256}]
    } elseif {$axis == 3} {
	set ::pos(t) [expr {($value / 256) % 360}]
    }
    if {![info exists ::pos(x)]} {
	set ::pos(x) [expr [winfo width $canvas] / 4]
	set ::pos(y) [expr [winfo height $canvas] / 4]
	set ::pos(t) 0
    }
    set ::pos(x) [expr {$::pos(x) + $ix}]
    set ::pos(y) [expr {$::pos(y) + $iy}]
    if {$::pos(x) < 50} {
	set ::pos(x) 50
    } elseif {$::pos(x) > [winfo width $canvas] - 50} {
	set ::pos(x) [expr {[winfo width $canvas] - 50}]
    }
    if {$::pos(y) < 50} {
	set ::pos(y) 50
    } elseif {$::pos(y) > [winfo height $canvas] - 50} {
	set ::pos(y) [expr {[winfo height $canvas] - 50}]
    }
    if {$axis >= 3} {
	$canvas delete a
	set x0 [expr {$::pos(x) - 48}]
	set x1 [expr {$x0 + 96}]
	set y0 [expr {$::pos(y) - 48}]
	set y1 [expr {$y0 + 96}]
	$canvas create arc $x0 $y0 $x1 $y1 -fill yellow -outline red \
	    -width 6 -start [expr {330 - $::pos(t)}] -extent -300.0 -tags a
	set rx [expr {1.0 * ($::pos(x) - 50) / ([winfo width $canvas] - 100)}]
	set ry [expr {1.0 * ($::pos(y) - 50) / ([winfo height $canvas] - 100)}]
	set ::s(ampl) [expr {round(32767 * $rx)}]
	set ::s(freq) [expr {round(220 * pow(2, $ry * 4))}]
	$::s(filt) configure $::s(freq) $::s(ampl) 0.5 triangle -1
    }
}

proc finger {canvas x y} {
    set ::pos(x) $x
    set ::pos(y) $y
    set ::pos(t) 0
    config $canvas 4 0
}

bind .c <1> {finger %W %x %y ; borg vibrate 150}
bind .c <B1-Motion> {finger %W %x %y}
bind . <<WillEnterBackground>> [list $s(snd) stop]
bind . <<DidEnterForeground>> [list $s(snd) play -filter $s(filt)]
