# icons.tcl --
#
#	A set of stock icons for use in Tk dialogs. The icons used here
#	were provided by the Tango Desktop project which provides a
#	unified set of high quality icons licensed under the
#	Creative Commons Attribution Share-Alike license
#	(http://creativecommons.org/licenses/by-sa/3.0/)
#
#	See http://tango.freedesktop.org/Tango_Desktop_Project
#
# Copyright (c) 2009 Pat Thoyts <patthoyts@users.sourceforge.net>

namespace eval ::tk::icons {}

image create photo ::tk::icons::warning -data {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}

image create photo ::tk::icons::error -data {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}

image create photo ::tk::icons::information -data {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}

image create photo ::tk::icons::question -data {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}
