#!/usr/bin/tclsh
#
# This code is in the public domain.
# Originally written by Brad Lanam 2020-2-16

package require Tk 8.5-
package require tdbc::mysql

source ./scrolldata.tcl

variable vars

proc configureLine { w r didx } {
  variable vars

  $vars(sd) reconfWidget sl $w.id$r \
      [list ttk::label $w.id$r -width 10]
  $vars(sd) reconfWidget sl $w.val$r \
      [list ttk::label $w.val$r -width 10]
  grid {*}$sl -in $w -row $r -padx 5 -sticky w
  return $sl
}

proc populateLine { w r didx winlist } {
  variable vars

  lassign $winlist lid lval
  if { ! [dict exists $vars(data) $didx] } {
    set max [$vars(sd) getdispmax]
    unset -nocomplain vars(data)
    set vars(data) {}
    # this is slower, but is certainly useful in some cases.
    # set sql "select id, val from sdtest order by id
    #    limit $didx, $max"
    set sql "select id, val from sdtest where
        id >= :tmin and
        id < :tmax"
    set stmt [$vars(db) prepare $sql]
    set tmin $didx
    set tmax [expr {$didx+$max}]
    set data [$stmt allrows -as dicts]
    set tdidx $didx
    foreach {item} $data {
      dict set vars(data) $tdidx $item
      incr tdidx
    }
    $stmt close
  }
  $lid configure -text [dict get $vars(data) $didx id]
  $lval configure -text [dict get $vars(data) $didx val]
}

proc dbconn { } {
  variable vars

  set vars(db) [tdbc::mysql::connection new \
      -user sd -passwd abc123 -db sd \
      -compress 1]
}

proc dbdisconn { } {
  variable vars

  $vars(db) close
}

proc doexit { } {
  dbdisconn
  exit 0
}


proc main { } {
  variable vars

  set vars(maxdisp) 20

  dbconn
  set vars(data) {}

  set col 0
  set f .l
  ttk::frame $f
  set lab [string trim $f .]
  set sbnm .sb$lab
  ttk::scrollbar $sbnm -style Vertical.TScrollbar -orient vertical
  grid $sbnm -in . -sticky ns -row 0 -column [expr {$col*2+1}]

  ttk::label .h1$lab -text id
  ttk::label .h2$lab -text val
  grid .h1$lab .h2$lab -in $f -row 0

  # do this last so it shrinks first
  grid $f -in . -row 0 -column [expr {$col*2}] -sticky news
  grid columnconfigure . [expr {$col*2}] -weight 1
  grid rowconfigure . 0 -weight 1

  set vars(sd) [scrolldata new $f $sbnm configureLine populateLine $vars(maxdisp)]
  $vars(sd) display 5000000
  bind $f <Configure> [list $vars(sd) resize %w %h]
  $vars(sd) bindWheel [list $vars(sd) wheelHandler]
  bind .h1$lab <Button-1> [list $vars(sd) chkScroll 11]
  bind .h2$lab <Button-1> [list $vars(sd) chkScroll 12]

  wm protocol . WM_DELETE_WINDOW doexit
}

::main
