#!/usr/bin/tclsh
#
# This code is in the public domain.
# Originally written by Brad Lanam 2015-08-19

package require Tk 8.5-

source ./scrolldata.tcl

variable vars

proc configureLine { w r didx } {
  variable vars

  if { $r % 2 == 1 } {
    $vars(sd) reconfWidget sl $w.l$r \
        [list ttk::label $w.l$r -width 5]
    grid {*}$sl -in $w -row $r -padx 5 -sticky w -column 0
  } else {
    $vars(sd) reconfWidget sl $w.e$r \
        [list ttk::entry $w.e$r -width 10]
    grid {*}$sl -in $w -row $r -padx 5 -sticky w -column 1
  }
  return $sl
}

proc populateLine { w r didx winlist } {
  variable vars

  lassign $winlist s
  set idx [expr {$didx/2}]
  if { $r % 2 == 1 } {
    $s configure -text $vars($idx)
  } else {
    $s configure -textvariable vars($idx)
  }
}

set maxdisp 20
set max 98

ttk::frame .f
ttk::scrollbar .sb -style Vertical.TScrollbar -orient vertical
grid .sb -in . -sticky ns -column 1 -row 0
set vars(sd) [scrolldata new .f .sb configureLine populateLine $maxdisp 2]

ttk::label .h1 -text Label
ttk::label .h2 -text Entry
grid .h1 .h2 -in .f -row 0

# do this last so it shrinks first
grid .f -in . -row 0 -sticky news
grid columnconfigure . 0 -weight 1
grid rowconfigure . 0 -weight 1

for { set i 0 } { $i < $max } { incr i } {
  set vars($i) $i
}
$vars(sd) display [expr {$max*2}]
bind .f <Configure> [list $vars(sd) resize %w %h]
$vars(sd) bindWheel [list $vars(sd) wheelHandler]
