package require pdf4tcl
package require pdf4tcl::graph

pdf4tcl::new mypdf -paper a4 -unit mm 
mypdf startPage

graph::setup pdf4tcl mypdf

set data(1) {21 17 5 9 25.4}
set data(2) {0.8 2.1 1.2 2.2 0.2}
set data(3) {85 96 73 99 88}


proc DrawGraph {} {
  set g [graph::graph -width 180]
  $g axis create y3 -color blue
  $g y2axis use {y3 y2}

  foreach {idx color axis} {1 green y  2 red y2  3 blue y3} {
    $g element create line$idx -label "Data $idx" -ydata data($idx) -fill $color -mapy $axis
  }

  $g grid configure -hide no
  $g axis configure x -min 0 -max 100
  $g axis configure y  -loose no -hide no -max 25 -title "Alpha"
  $g axis configure y2 -loose no -hide no -max 5 -title "Beta"
  $g axis configure y3 -loose no -hide no -title "Gamma"
  $g draw 15 15
  $g destroy
}

DrawGraph
mypdf write -file graph2.pdf
mypdf destroy
