package require pdf4tcl
package require pdf4tcl::graph

pdf4tcl::new mypdf -paper a4 -unit mm 
mypdf startPage
mypdf setFont 4 Helvetica
mypdf text "Hello World" -x 10 -y 10

graph::setup pdf4tcl mypdf

set mydata {21 17 5 9 24}

set g [graph::graph -title "Example" -width 180 -height 100]
$g axis create y3 -color blue
$g element create line1 -label "Data" -ydata mydata -fill red
$g grid configure -hide no
$g axis configure x -min 0 -max 100
$g axis configure y -loose no -hide no -max 25 -title Alpha
$g draw 15 15
$g destroy

mypdf write -file graph0.pdf
mypdf destroy
