#!/bin/sh
# -*-tcl-*-
# the next line restarts using tclsh\
exec tclsh "$0" "$@"

#-------------------------------------------------------------------------
# NAME: notebook.tcl
#
# PROJECT:
#  notebook: Your project description
#
# DESCRIPTION:
#  Loader script for the notebook(1) tool.
#
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
# Prepare to load application

set bindir [file dirname [info script]]
set libdir [file normalize [file join $bindir lib]]

if {([info command sdltk] eq "sdltk") && [sdltk android]} {
    catch {
        cd ~
        # no horizontal drag for listboxes and texts, please
        bind Listbox <2> {%W scan mark 0 %y}
        bind Listbox <B2-Motion> {%W scan dragto 0 %y}
        bind Text <2> {tk::TextScanMark %W 0 %y}
        bind Text <B2-Motion> {tk::TextScanDrag %W 0 %y}
        catch {
            # force landscape view
            package require Borg
            borg screenorientation landscape
        }
    }
} elseif {[lindex [file system [pwd]] 0] ne "native"} {
    catch {cd ~}
}

set auto_path [linsert $auto_path 0 $libdir]

# -quill-tcl-begin
package require Tcl 8.6.1
# -quill-tcl-end

# quillinfo(n) is a generated package containing this project's 
# metadata.
package require quillinfo

# If it's a gui, load Tk.
if {[quillinfo isgui notebook]} {
# -quill-tk-begin
package require Tk 8.6.1
package require tile
# -quill-tk-end
}

# app_notebook(n) is the package containing the bulk of the 
# notebook code.  In particular, this package defines the
# "main" procedure.
package require app_notebook
namespace import app_notebook::*

#-------------------------------------------------------------------------
# Invoke the application

if {!$tcl_interactive} {
    if {[catch {
        main $argv
    } result eopts]} {
        if {[dict get $eopts -errorcode] eq "FATAL"} {
            # The application has flagged a FATAL error; display it 
            # and halt.
            puts $result
            exit 1
        } else {
            puts "Unexpected error: $result"
            puts "Error Code: ([dict get $eopts -errorcode])\n"
            puts [dict get $eopts -errorinfo]
        }
    }
}
