#-------------------------------------------------------------------------
# TITLE: 
#    quillinfo.tcl
#
# PROJECT:
#    notebook: Notebook Personal Wiki
#
# DESCRIPTION:
#    Project Metadata
#
#    Generated by Quill
#
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
# Exported Commands

namespace eval ::quillinfo {
    variable meta
    array set meta {local-textutil::adjust 0 url http://my.home.page description {Notebook Personal Wiki} provides {} local-BWidget 0 homepage http://home.page.url requires {Tcl snit BWidget textutil::expander textutil::adjust} version-textutil::expander 1.3.1 version-BWidget 1.9 version-snit 2.3 exetype-notebook exe local-Tcl 0 gui-notebook 1 distpat-install-%platform {
    %apps
    docs/*.html
    docs/*/*.html
    docs/*.md
    LICENSE
    README.md

} apps notebook version-textutil::adjust 0.7.1 local-textutil::expander 0 local-snit 0 version 2.2.0 version-Tcl 8.6.1 project notebook dists install-%platform}

    namespace export \
        project      \
        description  \
        version      \
        homepage     \
        isgui

    namespace ensemble create
}

#-------------------------------------------------------------------------
# Commands

# project
#
# Returns the project name.

proc ::quillinfo::project {} {
    variable meta
    return $meta(project)
}

# description 
#
# Returns the project's description.

proc ::quillinfo::description {} {
    variable meta
    return $meta(description)
}

# version 
#
# Returns the project version number.

proc ::quillinfo::version {} {
    variable meta
    return $meta(version)
}

# homepage 
#
# Returns the project home page URL.

proc ::quillinfo::homepage {} {
    variable meta
    return $meta(homepage)
}

# isgui app
#
# app   - An app name for this project.
#
# Returns true if the app is a GUI and false otherwise.

proc ::quillinfo::isgui {app} {
    variable meta

    if {[info exists meta(gui-$app)]} {
        return $meta(gui-$app)
    } else {
        return 0
    }
}
