package require Tk
source [file join [file dirname [info script]] flexmenu.tcl]

proc tmfill { } {
  .tmmenu delete 0 end
  set tm [clock seconds]
  for {set i 0} {$i < 4} {incr i} {
    set disp [clock format $tm -format "%H:%M" -locale system]
    .tmmenu add radiobutton -label $disp -value $i -variable ::rb
    set tm [expr {$tm + 60}]
  }
}

set padx 3p
set pady 3p
set mode toplevel
set ar flat         ; # active relief
set sticky false
set ko false        ; # keep open
set yal 0 ; # y alignment
set xal 0 ; # x alignment
set abw 3p ; # active border width

ttk::style theme use clam

set ::rb 0
flexmenu .tmmenu -pady $pady -padx $padx \
    -activerelief $ar -activeborderwidth $abw -mode $mode \
    -keepopen true

flexmenu .mtop -type menubar -keepopen $ko -stickycascade $sticky
.mtop add command -label Exit -underline 0 -command exit
.mtop add cascade -label Pre-Command -underline 0 -menu .tmmenu \
        -precommand tmfill
pack .mtop -side top -fill x -expand 1 -anchor nw

frame .f -width 200 -height 200
pack .f
lower .f

