package require Tk
source [file join [file dirname [info script]] flexmenu.tcl]

set padx 3p
set pady 3p
set mode toplevel
set ar flat         ; # active relief
set sticky false
set ko false        ; # keep open
set yal 0 ; # y alignment
set xal 0 ; # x alignment
set abw 3p ; # active border width

flexmenu .mc -keepopen $ko -pady $pady -padx $padx \
    -activerelief $ar -activeborderwidth $abw -mode $mode
.mc add command -label Five -underline 1 -command { puts 5 }
.mc add command -label Six -underline 0 -command { puts 6 }
.mc add command -label Seven -underline 1 -command { puts 7 }
.mc add command -label Eight -underline 2 -command { puts 8 }

flexmenu .mleft -type menuleft -keepopen $ko -stickycascade $sticky
.mleft add command -label Exit -underline 1 -command exit
.mleft add cascade -label More -underline 0 -menu .mc
.mleft add command -label One -underline 0 -command {puts 1}
.mleft add command -label Two -underline 0 -command {puts 2}
.mleft add command -label Three -underline 1 -command {puts 3}
.mleft add command -label Four -underline 0 -command {puts 4}
pack .mleft -side left -fill y -expand 1 -anchor nw

frame .f -width 200 -height 200
pack .f
lower .f

