package require Tk
source [file join [file dirname [info script]] flexmenu.tcl]

set padx 3p
set pady 3p
set mode toplevel
set ar flat         ; # active relief
set sticky false
set ko false        ; # keep open
set yal 0 ; # y alignment
set xal 0 ; # x alignment
set abw 3p ; # active border width

flexmenu .mw  -keepopen $ko -pady $pady -padx $padx \
    -activerelief $ar -activeborderwidth $abw -mode $mode

foreach file \
    [glob -directory [file join [file dirname [info script]] i] *.png] {
  set img [file tail [file rootname $file]]
  set images($img) [image create photo -file $file -format png]
}
foreach {iname img} [array get images] {
  regsub {^weather-(.*)\.png$} $iname {\1} text
  .mw add command -text $text -marginimage $img
}

flexmenu .mtop -type menubar -keepopen $ko -stickycascade $sticky
.mtop add command -label Exit -underline 0 -command exit
.mtop add separator
.mtop add cascade -label Margin-Images -menu .mw -yalign $yal -xalign $xal
pack .mtop -side top -fill x -expand 1 -anchor nw

frame .f -width 200 -height 200
pack .f
lower .f
