package require Tk
source [file join [file dirname [info script]] flexmenu.tcl]

set padx 3p
set pady 3p
set mode toplevel
set ar flat         ; # active relief
set sticky false
set ko false        ; # keep open
set yal 0 ; # y alignment
set xal 0 ; # x alignment
set abw 3p ; # active border width

set clist {#000000 #ff0000 #00ff00 #0000ff #ff8000 #ff0080 #80ff00
    #00ff80 #8000ff #0080ff #ffff00 #ff00ff #00ffff #ffff80 #ff80ff
    #80ffff #ffffff #ff4040 #40ff40 #4040ff #404040 #808080 #ffff40
    #ff40ff #40ffff}

flexmenu .col -keepopen $ko -columnbreak 5 -pady $pady -padx $padx \
    -activerelief $ar -activeborderwidth $abw -mode $mode
set count 0
foreach {c} $clist {
  set tf [frame .col.x$c \
      -background $c -relief raised -borderwidth 2p \
      -width 20 -height 20 ]
  bind $tf <ButtonRelease-1> [list .f configure -background $c]
  .col add widget -widget $tf -hidemargin 1
  incr count
}

flexmenu .mtop -type menubar -keepopen $ko -stickycascade $sticky
.mtop add command -label Exit -underline 0 -command exit
.mtop add separator
.mtop add cascade -label {Column Break} -menu .col -yalign $yal -xalign $xal
pack .mtop -side top -fill x -expand 1 -anchor nw

frame .f -width 200 -height 200
pack .f
lower .f
