#!../src/bltwish

package require BLT
# --------------------------------------------------------------------------
# Starting with Tcl 8.x, the BLT commands are stored in their own 
# namespace called "blt".  The idea is to prevent name clashes with
# Tcl commands and variables from other packages, such as a "table"
# command in two different packages.  
#
# You can access the BLT commands in a couple of ways.  You can prefix
# all the BLT commands with the namespace qualifier "blt::"
#  
#    blt::graph .g
#    blt::table . .g -resize both
# 
# or you can import all the command into the global namespace.
#
#    namespace import blt::*
#    graph .g
#    table . .g -resize both
#
# --------------------------------------------------------------------------
if { $tcl_version >= 8.0 } {
    namespace import blt::*
}

source [file join [file dirname [info script]] scripts demo.tcl]

set tcl_precision 15 

set graph .graph

option add *Graph.Width			5i
option add *Graph.leftMargin		.25i
option add *Graph.Height		3.5i
option add *Graph.plotBackground	black

option add *LineMarker.color		white
option add *LineMarker.Dashes		5
option add *TextMarker.foreground	white
option add *TextMarker.Background	{}

option add *Graph.x.hide		yes
option add *Graph.x.title		""
option add *Graph.y.rotate		90
#option add *Graph.y.stepSize		2.0
option add *Graph.title			""
option add *graph.Title			"Example s27" 
option add *graph.x.hide		no
option add *graph.topMargin		0
option add *graph.bottomMargin		0
option add *x.Title			Time
option add *y.Title			Signals
option add *Pixels			1

option add *Reduce			0.5
option add *bufferElements no

option add *Element.color		green4
option add *Element.ScaleSymbols	true
option add *Element.Color		grey70
option add *Element.Symbol		none
option add *Element.LineWidth		1
#option add *Element.Smooth		natural
option add *Element.Smooth		catrom

option add *activeLine.LineWidth	2
option add *activeLine.Color		white
option add *activeLine.Color		green1

#option add *Legend.Hide		yes
option add *Legend.Position		right
option add *Legend.Relief		flat
option add *Legend.activeRelief		sunken
option add *Legend.borderWidth		2
if {[tk windowingsystem] eq "win32"} {
    option add *Legend.Font		{Arial 10}
} else {
    option add *Legend.Font		{Helvetica 10}
}
option add *Grid.hide			no
option add *Grid.dashes			"1 5"

#option add *foreground white
option add *zoomOutline.outline		yellow

graph .graph

vector x -variable ""
for { set i 1 } { $i <= 39 } { incr i } {
    vector create v${i} -variable ""
}

x set {
    0 1e-10 2e-10 3e-10 4e-10 5e-10 6e-10 7e-10 8e-10 9e-10 
    1e-09 1.1e-09 1.2e-09 1.3e-09 1.4e-09 1.5e-09 1.6e-09 1.7e-09 
    1.8e-09 1.9e-09 2e-09 2.1e-09 2.2e-09 2.3e-09 2.4e-09 2.5e-09 
    2.6e-09 2.7e-09 2.8e-09 2.9e-09 3e-09 3.1e-09 3.2e-09 3.3e-09 
    3.4e-09 3.5e-09 3.6e-09 3.7e-09 3.8e-09 3.9e-09 4e-09 4.1e-09 
    4.2e-09 4.3e-09 4.4e-09 4.5e-09 4.6e-09 4.7e-09 4.8e-09 
    4.9e-09 5e-09 5.1e-09 5.2e-09 5.3e-09 5.4e-09 5.5e-09 5.6e-09 
    5.7e-09 5.8e-09 5.9e-09 6e-09 6.1e-09 6.2e-09 6.3e-09 6.4e-09 
    6.5e-09 6.6e-09 6.7e-09 6.8e-09 6.9e-09 7e-09 7.1e-09 7.2e-09 
    7.3e-09 7.4e-09 7.5e-09 7.6e-09 7.7e-09 7.8e-09 7.9e-09 
    8e-09 8.1e-09 8.2e-09 8.3e-09 8.4e-09 8.5e-09 8.6e-09 8.7e-09 
    8.8e-09 8.9e-09 9e-09 9.1e-09 9.2e-09 9.3e-09 9.4e-09 9.5e-09 
    9.6e-09 9.7e-09 9.8e-09 9.9e-09 1e-08 1.01e-08 1.02e-08 
    1.03e-08 1.04e-08 1.05e-08 1.06e-08 1.07e-08 1.08e-08 1.09e-08 
    1.1e-08 1.11e-08 1.12e-08 1.13e-08 1.14e-08 1.15e-08 1.16e-08 
    1.17e-08 1.18e-08 1.19e-08 1.2e-08 1.21e-08 1.22e-08 1.23e-08 
    1.24e-08 1.25e-08 1.26e-08 1.27e-08 1.28e-08 1.29e-08 1.3e-08 
    1.31e-08 1.32e-08 1.33e-08 1.34e-08 1.35e-08 1.36e-08 1.37e-08 
    1.38e-08 1.39e-08 1.4e-08 1.41e-08 1.42e-08 1.43e-08 1.44e-08 
    1.45e-08 1.46e-08 1.47e-08 1.48e-08 1.49e-08 1.5e-08 1.51e-08 
    1.52e-08 1.53e-08 1.54e-08 1.55e-08 1.56e-08 1.57e-08 1.58e-08 
    1.59e-08 1.6e-08 1.61e-08 1.62e-08 1.63e-08 1.64e-08 1.65e-08 
    1.66e-08 1.67e-08 1.68e-08 1.69e-08 1.7e-08 1.71e-08 1.72e-08 
    1.73e-08 1.74e-08 1.75e-08 1.76e-08 1.77e-08 1.78e-08 1.79e-08 
    1.8e-08 1.81e-08 1.82e-08 1.83e-08 1.84e-08 1.85e-08 1.86e-08 
    1.87e-08 1.88e-08 1.89e-08 1.9e-08 1.91e-08 1.92e-08 1.93e-08 
    1.94e-08 1.95e-08 1.96e-08 1.97e-08 1.98e-08 1.99e-08 2e-08 
    2.01e-08 2.02e-08 2.03e-08 2.04e-08 2.05e-08 2.06e-08 2.07e-08 
    2.08e-08 2.09e-08 2.1e-08 2.11e-08 2.12e-08 2.13e-08 2.14e-08 
    2.15e-08 2.16e-08 2.17e-08 2.18e-08 2.19e-08 2.2e-08 2.21e-08 
    2.22e-08 2.23e-08 2.24e-08 2.25e-08 2.26e-08 2.27e-08 2.28e-08 
    2.29e-08 2.3e-08 2.31e-08 2.32e-08 2.33e-08 2.34e-08 2.35e-08 
    2.36e-08 2.37e-08 2.38e-08 2.39e-08 2.4e-08 2.41e-08 2.42e-08 
    2.43e-08 2.44e-08 2.45e-08 2.46e-08 2.47e-08 2.48e-08 2.49e-08 
    2.5e-08 2.51e-08 2.52e-08 2.53e-08 2.54e-08 2.55e-08 2.56e-08 
    2.57e-08 2.58e-08 2.59e-08 2.6e-08 2.61e-08 2.62e-08 2.63e-08 
    2.64e-08 2.65e-08 2.66e-08 2.67e-08 2.68e-08 2.69e-08 2.7e-08 
    2.71e-08 2.72e-08 2.73e-08 2.74e-08 2.75e-08 2.76e-08 2.77e-08 
    2.78e-08 2.79e-08 2.8e-08 2.81e-08 2.82e-08 2.83e-08 2.84e-08 
    2.85e-08 2.86e-08 2.87e-08 2.88e-08 2.89e-08 2.9e-08 2.91e-08 
    2.92e-08 2.93e-08 2.94e-08 2.95e-08 2.96e-08 2.97e-08 2.98e-08 
    2.99e-08 3e-08 3.01e-08 3.02e-08 3.03e-08 3.04e-08 3.05e-08 
    3.06e-08 3.07e-08 3.08e-08 3.09e-08 3.1e-08 3.11e-08 3.12e-08 
    3.13e-08 3.14e-08 3.15e-08 3.16e-08 3.17e-08 3.18e-08 3.19e-08 
    3.2e-08 3.21e-08 3.22e-08 3.23e-08 3.24e-08 3.25e-08 3.26e-08 
    3.27e-08 3.28e-08 3.29e-08 3.3e-08 3.31e-08 3.32e-08 3.33e-08 
    3.34e-08 3.35e-08 3.36e-08 3.37e-08 3.38e-08 3.39e-08 3.4e-08 
    3.41e-08 3.42e-08 3.43e-08 3.44e-08 3.45e-08 3.46e-08 3.47e-08 
    3.48e-08 3.49e-08 3.5e-08 3.51e-08 3.52e-08 3.53e-08 3.54e-08 
    3.55e-08 3.56e-08 3.57e-08 3.58e-08 3.59e-08 3.6e-08 
}

wm min . 0 0 

v1 set {
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
}

.graph element create V1 -x x -y v1

v2 set {
    0 1 2 3 4 5 5 5 5 5 5 5 5 5 5 5 4 3 2 1 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 1 2 3 4 5 5 5 5 5 5 5 5 5 5 5 4 3 2 1 
    5.32907e-15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 4 5 5 
    5 5 5 5 5 5 5 5 5 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 
}

.graph element create V2 -x x -y v2 

v3 set {
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 4 3 2 1 8.88178e-16 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 1 2 3 4 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 4 3 2 1 2.13718e-14 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 
}

.graph element create V3 -x x -y v3 

v4 set {
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 4 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 1 2 3 4 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
}

.graph element create V4 -x x -y v4 

v5 set {
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 4 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 1 2 3 4 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
}

.graph element create V5 -x x -y v5 
v6 set {
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 4 3 2 1 8.88178e-16 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 1 2 3 4 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 4 3 2 1 2.13718e-14 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
    0 0 0 0 
}
.graph element create V6 -x x -y v6 
v7 set {
    5 5.16904 4.84159 3.34542 0.317102 0.103304 0.0275721 0.0221534 
    0.017689 0.0142639 0.0113974 0.00918238 0.00742541 0.00616602 
    0.00481195 0.00397049 -0.0659889 -0.025671 0.165495 0.986891 
    3.05229 4.55511 4.91611 4.98192 4.99428 4.99833 4.99095 
    4.97295 4.95493 4.93428 4.90723 4.94799 4.98584 4.99566 
    4.99813 4.99907 4.99947 4.99965 4.99976 4.99984 4.99989 
    4.99992 4.99994 4.99996 4.99998 5.00002 5.00006 5.00002 
    4.99996 4.99994 4.99999 5.00003 5.00002 5 4.99997 4.99997 
    4.99997 4.99997 4.99997 4.99996 4.99997 4.99997 4.99998 
    4.99998 4.99999 5 5 5 5 5 5 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5 5 5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99998 4.99998 4.99998 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 5 5 5 5 5 5 5 5.16575 
    4.69986 2.43862 0.0230224 0.035229 -0.0210607 -0.0292766 
    -0.0172693 -0.00271479 -0.000912251 -0.000349106 -0.000116866 
    -4.24733e-05 -1.39536e-05 -3.01179e-05 -0.0657192 -0.0204835 
    0.183378 1.07181 3.118 4.46472 4.84158 4.94795 4.98173 4.99236 
    4.99762 5.01939 5.0433 5.05332 5.04959 5.03955 5.02851 5.02052 
    5.01422 5.00965 5.00631 5.00405 5.00248 5.00083 5.00012 
    5.00209 5.00387 5.00347 4.99917 4.99213 4.98411 4.97521 
    4.96332 4.94601 4.9304 4.94633 4.97936 4.99264 4.99685 4.99857 
    4.99925 4.99954 4.9997 4.99973 4.9997 4.99973 4.99979 4.99983 
    4.99986 4.99988 4.9999 4.9999 4.99992 4.99993 4.99994 4.99995 
    4.99996 4.99996 4.99997 4.99997 4.99998 4.99998 4.99998 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    5 5 5 5.00001 5.00001 5.00001 5.00001 5.00002 5.00002 5.00002 
    5.00002 5.00001 5.00001 5.00001 5 5 5 5 5 5 5 5 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 5 5 5.14242 4.76101 3.16003 0.299374 
    0.0645506 -0.000498424 -2.45108e-05 -2.27986e-05 -5.24401e-05 
    -4.9884e-05 -4.92491e-05 -2.93354e-05 -3.21402e-05 -2.11851e-05 
    -3.37925e-05 -0.0657892 -0.020563 0.182582 1.06058 3.12484 
    4.46552 4.84146 4.95102 4.98556 4.99472 4.99806 4.99909 
    4.99955 4.99976 4.99994 4.99992 5.00029 4.99967 4.99849 
    4.99736 4.99884 5.00099 5.00377 5.00215 4.99994 4.99893 
    4.99788 4.99862 5.00055 5.00134 5.00127 5.00073 5.00039 
    5.00018 5.00006 5.00001 4.99985 5.00026 5.00018 5.00003 
    4.99981 4.99985 4.99987 4.99985 4.99982 4.99982 4.99982 
    4.99983 4.99985 4.99987 4.99989 4.99991 4.99992 4.99994 
    4.99995 4.99995 4.99994 4.99994 4.99996 4.99999 5.00002 
    5.00008 5.00009 5.00006 5.00001 5 4.99999 4.99998 4.99997 
    4.99996 4.99997 4.99997 4.99998 4.99998 4.99999 4.99999 
    4.99999 5 5 5 5 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 4.99998 4.99998 
    4.99998 
}

.graph element create V7 -x x -y v7 

v8 set {
    5 5.03758 5.04711 4.96911 4.20882 3.96295 4.01117 4.15521 
    4.2967 4.42274 4.5295 4.6176 4.69014 4.74831 4.7966 4.83537 
    4.80526 4.787 4.79295 4.88588 5.08978 5.15615 5.10778 5.07718 
    5.06652 5.08225 4.9744 4.52977 3.77452 2.69426 1.15294 0.245509 
    0.0981544 0.0567527 0.0367487 0.0252578 0.0180599 0.0133837 
    0.0101497 0.0078616 0.00620186 0.00499056 0.0041027 0.00344223 
    0.00295808 0.00260089 0.00229887 0.00200817 0.00176397 0.00160116 
    0.00147381 0.00134645 0.00125029 0.00116043 0.00107371 0.00101981 
    0.000965921 0.000912028 0.000858135 0.000804242 0.000761669 
    0.00072672 0.000691771 0.000656823 0.000621874 0.000588722 
    0.00057041 0.000552098 0.000533785 0.000515473 0.000497162 
    0.00047885 0.000460537 0.000442226 0.000423914 0.000405601 
    0.000388399 0.000378694 0.000368989 0.000359284 0.00034958 
    0.000339875 0.00033017 0.000320465 0.00031076 0.000301055 
    0.00029135 0.000282207 0.000276247 0.000270287 0.000264327 
    0.000258367 0.000252407 0.000246447 0.000240487 0.000234527 
    0.000228567 0.000222607 0.000217086 0.000213696 0.000210307 
    0.000206918 0.000203528 0.000200139 0.00019675 0.00019336 
    0.000189971 0.000186582 0.000183192 0.000179803 0.000176414 
    0.000173025 0.000169635 0.000166246 0.000162857 0.000159467 
    0.000156078 0.000152689 0.000149299 0.00014591 0.00014255 
    0.0316021 0.163272 0.348732 0.603651 0.35745 0.135965 0.0707354 
    0.0314595 0.0201047 0.00994945 0.00389601 0.00138839 0.00060778 
    0.000329648 0.000492396 -0.0732035 -0.0844077 -0.0789062 
    -0.0390837 0.0197559 0.0183094 -0.00180099 -0.0189565 -0.0424144 
    -0.0735904 -0.0892423 0.285039 1.13702 2.10809 2.95826 3.60164 
    4.0435 4.35771 4.57254 4.71769 4.81329 4.87534 4.91487 4.94264 
    4.97375 5.01526 5.06517 5.10154 5.06259 4.89005 4.5787 4.12226 
    3.46151 2.49023 1.2586 0.32725 0.116753 0.0701865 0.0455509 
    0.0286914 0.0178176 0.0117599 0.00902715 0.00760583 0.00637745 
    0.00543811 0.00439377 0.00352448 0.0030151 0.00285771 0.002465 
    0.00203114 0.00173004 0.0014839 0.00125177 0.00105327 0.000894905 
    0.000766372 0.000658894 0.000569105 0.000492114 0.000427938 
    0.000370217 0.000314758 0.000266569 0.000233726 0.000209048 
    0.000191957 0.000177169 0.000166604 0.000161 0.000157314 
    0.000143828 0.000130342 0.000116857 0.000103371 8.98855e-05 
    7.63998e-05 6.29141e-05 5.76583e-05 5.30027e-05 4.8347e-05 
    4.36913e-05 3.90357e-05 3.438e-05 2.97243e-05 2.72507e-05 
    2.59083e-05 2.45659e-05 2.32235e-05 2.18811e-05 2.05387e-05 
    1.91963e-05 1.78539e-05 1.65115e-05 1.51691e-05 1.38267e-05 
    1.24843e-05 1.11419e-05 9.79954e-06 8.51574e-06 7.69807e-06 
    6.8804e-06 6.06273e-06 5.24506e-06 0.0287318 0.0317111 -0.0320087 
    -0.103609 0.0369639 0.0121128 0.00961197 0.00934971 0.00820853 
    0.00699769 0.00607002 0.00535541 0.00476552 0.00427601 0.00376357 
    -0.073012 -0.0866964 -0.0809538 -0.038005 0.0277001 0.0188906 
    0.00614597 0.00373629 0.00489787 0.0146573 0.0191052 0.0151708 
    0.0124224 0.0105859 0.00879272 0.00729464 0.0070047 0.00449575 
    -0.00626652 -0.0252417 -0.0147287 0.022538 0.0822905 0.0947372 
    0.0657516 0.0445506 0.0316753 0.0220971 0.0158101 0.0140971 
    0.0161498 0.0139876 0.0122447 0.0106994 0.009397 0.00822236 
    0.00686509 0.00797431 0.00751269 0.00671173 0.00595243 0.00524633 
    0.00459528 0.00401688 0.00350109 0.00303954 0.00260569 0.00222792 
    0.00191033 0.00163917 0.00140949 0.00121464 0.0010471 0.000900638 
    0.000768847 0.000645236 0.000524807 0.000460275 0.000442237 
    0.000446775 0.000397026 0.000301585 0.000228994 0.000190894 
    0.000166569 0.000152261 0.000137953 0.000123644 0.000109336 
    9.50281e-05 8.56557e-05 7.78437e-05 7.00318e-05 6.22198e-05 
    5.44079e-05 4.87539e-05 4.57761e-05 4.27982e-05 3.98203e-05 
    3.68425e-05 3.38646e-05 3.08868e-05 2.79089e-05 2.4931e-05 
    2.19532e-05 1.89753e-05 1.75244e-05 1.64095e-05 1.52946e-05 
    1.41797e-05 1.30648e-05 1.19499e-05 1.0835e-05 9.72011e-06 
    8.60521e-06 7.4903e-06 6.5117e-06 6.10334e-06 5.69497e-06 
    5.2866e-06 4.87824e-06 4.46987e-06 4.06151e-06 3.65314e-06 
    3.24477e-06 
}

.graph element create V8 -x x -y v8 

v9 set {
    1.86175 1.99708 2.07867 2.01211 2.43309 3.27194 3.63896 
    3.90426 4.11074 4.27932 4.41496 4.52543 4.61491 4.68862 
    4.7479 4.79666 4.72895 4.68886 4.70354 4.81353 5.01568 5.14184 
    5.10482 5.07362 5.05143 5.03638 5.02323 5.01465 5.00853 
    5.00383 4.99985 5.00454 5.00652 5.00546 5.00411 5.003 5.00214 
    5.00151 5.00106 5.00073 5.0005 5.00034 5.00023 5.00015 5.0001 
    5.00005 5 5.00001 5.00005 5.00005 5.00003 5 4.99998 4.99996 
    4.99994 4.99995 4.99997 4.99998 5 5.00001 5.00002 5.00002 
    5.00003 5.00003 5.00003 5.00003 5.00003 5.00003 5.00002 
    5.00002 5.00001 5.00001 5.00001 5 5 5 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99998 
    4.99998 4.99998 4.99999 4.99999 4.99999 4.99999 5 5 5 5 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.17392 4.94828 3.78491 
    1.52079 0.608874 0.244031 0.127087 0.0552995 0.0361032 0.0169025 
    0.006364 0.00217624 0.000921391 0.000457305 0.000786754 
    -0.120016 -0.148054 -0.15898 -0.0801463 0.16463 0.174017 
    0.0799249 0.0318788 0.0129696 0.00483397 0.0025677 0.0042079 
    0.00350003 0.00178404 -8.72902e-05 -0.00128497 -0.00142213 
    -0.00130018 -0.00106874 -0.000789207 -0.000824335 -0.00104518 
    -0.00136799 -0.004366 -0.0102621 -0.0109254 -0.00649259 
    -0.00194842 0.00029793 0.00148673 0.00221085 0.00228291 
    0.00185261 0.00139687 0.00148183 0.00562266 0.00844119 0.00754627 
    0.00657396 0.00591212 0.00539269 0.0049282 0.00448417 0.0040572 
    0.00363719 0.00320392 0.00279607 0.00243938 0.00211505 0.00182302 
    0.00156254 0.0013341 0.00113834 0.000971865 0.00082776 0.000706193 
    0.000602499 0.000515059 0.000441401 0.00037897 0.000325459 
    0.00028083 0.000242096 0.000207274 0.000176444 0.000150372 
    0.000126407 0.000103373 9.05522e-05 8.53555e-05 8.63685e-05 
    9.02593e-05 8.37346e-05 7.72099e-05 7.06852e-05 6.41605e-05 
    5.76358e-05 5.11112e-05 4.45865e-05 4.08176e-05 3.72497e-05 
    3.36818e-05 3.01138e-05 2.65459e-05 2.2978e-05 1.94101e-05 
    1.76154e-05 1.67399e-05 1.58645e-05 1.4989e-05 1.41136e-05 
    1.32381e-05 1.23626e-05 1.14872e-05 1.06117e-05 9.73629e-06 
    8.86083e-06 7.98538e-06 7.10993e-06 6.23447e-06 5.44363e-06 
    5.32578e-06 5.20792e-06 5.09007e-06 4.97222e-06 0.0784323 
    0.0474527 -0.0764232 -0.151146 0.0615785 0.0144489 0.00974161 
    0.00947176 0.00849005 0.00728201 0.00630581 0.00554032 0.00487809 
    0.00441504 0.00384139 -0.118943 -0.149894 -0.161173 -0.0825299 
    0.171686 0.176912 0.0816085 0.0335236 0.013791 0.0056976 
    0.00238833 0.00105348 0.000526199 0.00025969 0.000396026 
    0.000837835 0.00170131 0.00196699 -0.000553314 -0.0061621 
    -0.0111895 -0.0142698 -0.0124608 -0.00795847 -0.00467822 
    -0.0043058 -0.00874449 -0.0118584 -0.00871386 -0.00377892 
    1.95244e-05 0.00218952 0.00325486 0.00386497 0.00422837 
    0.00446883 0.00447065 0.00486647 0.00547838 0.00565398 0.00559092 
    0.00538752 0.00507015 0.00466305 0.00420756 0.00373465 0.00328404 
    0.00287059 0.00250057 0.00216124 0.00184861 0.00156815 0.00134624 
    0.00117857 0.00103412 0.0008948 0.000761012 0.000619853 
    0.000462614 0.000319965 0.000287666 0.000356415 0.000379946 
    0.000339183 0.00027972 0.000252982 0.000226244 0.000199507 
    0.000172769 0.000146031 0.000130097 0.000117578 0.000105059 
    9.25401e-05 8.00213e-05 7.11204e-05 6.67061e-05 6.22918e-05 
    5.78775e-05 5.34632e-05 4.90489e-05 4.46346e-05 4.02203e-05 
    3.5806e-05 3.13916e-05 2.69773e-05 2.4827e-05 2.31747e-05 
    2.15225e-05 1.98702e-05 1.8218e-05 1.65658e-05 1.49135e-05 
    1.32613e-05 1.1609e-05 9.95678e-06 8.50108e-06 7.86765e-06 
    7.23422e-06 6.60079e-06 5.96736e-06 5.33393e-06 4.7005e-06 
    4.06707e-06 3.43363e-06 
}

.graph element create V9 -x x -y v9 

v10 set {
    1.86175 1.99308 2.16619 2.46661 3.09359 3.76864 4.31299 
    4.65564 4.83425 4.92153 4.96157 4.98063 4.98649 4.99039 
    4.9945 4.9972 4.96206 4.89882 4.83865 4.83202 4.91016 5.04479 
    5.06078 5.04827 5.03474 5.0246 5.01639 5.00996 5.00569 5.00239 
    5.00043 5.00296 5.00437 5.00382 5.00287 5.00208 5.00148 
    5.00104 5.00073 5.0005 5.00034 5.00023 5.00016 5.00011 5.00008 
    5.00007 5.00007 5.00004 5 4.99998 4.99998 4.99997 4.99998 
    4.99999 5 5 5.00001 5.00001 5.00001 5.00002 5.00002 5.00001 
    5.00001 5.00001 5.00001 5 5 5 5 5 5 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 5 5 5 5 5 5 5 5 5 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5 5 5 5 5 5 5 5 5.10081 
    5.10949 4.98359 5.00733 5.15145 4.37298 2.36126 0.470759 
    0.0577238 0.0115884 0.00262611 0.000671499 0.000389038 0.000291291 
    0.000317347 -0.0167823 -0.0158344 -0.0140559 0.0104849 0.0865874 
    0.107813 0.0524688 0.0214369 0.00876443 0.00341595 0.00170778 
    0.00259042 0.0022241 0.00118519 1.10217e-06 -0.000784506 
    -0.000948169 -0.000856256 -0.000696719 -0.000485987 -0.000724787 
    -0.000981491 -0.001454 -0.00552498 -0.0114992 -0.0105266 
    -0.00543527 -0.000982798 0.00127356 0.00224212 0.00275439 
    0.00281098 0.0025471 0.00230368 0.00222576 0.00485522 0.00729453 
    0.00691796 0.0062615 0.00573987 0.0052688 0.00481185 0.00436934 
    0.00394326 0.00352712 0.00309978 0.00270038 0.00235335 0.00203742 
    0.00175256 0.00150067 0.00128126 0.00109323 0.000933619 
    0.000795113 0.000678182 0.00057843 0.000494345 0.000423609 
    0.000363821 0.000312766 0.000269856 0.000232389 0.000198382 
    0.000168126 0.00014267 0.000119293 9.69034e-05 8.5669e-05 
    8.26828e-05 8.64066e-05 9.26665e-05 8.5454e-05 7.82416e-05 
    7.10291e-05 6.38167e-05 5.66043e-05 4.93918e-05 4.21794e-05 
    3.86073e-05 3.53007e-05 3.19941e-05 2.86876e-05 2.5381e-05 
    2.20744e-05 1.87678e-05 1.70933e-05 1.62648e-05 1.54363e-05 
    1.46079e-05 1.37794e-05 1.2951e-05 1.21225e-05 1.12941e-05 
    1.04656e-05 9.63716e-06 8.80871e-06 7.98026e-06 7.1518e-06 
    6.32335e-06 5.5374e-06 5.08959e-06 4.64178e-06 4.19397e-06 
    3.74616e-06 0.0438026 0.0242078 -0.0602019 -0.0840866 0.00148461 
    -0.00292489 0.000442098 0.00219489 0.00281478 0.00290756 
    0.00277945 0.00263896 0.00240099 0.00223283 0.001947 -0.0153629 
    -0.0148815 -0.0128673 0.0126017 0.0905161 0.11051 0.0538958 
    0.022562 0.00935726 0.00397422 0.00172534 0.000790207 0.000416322 
    0.000191632 0.000469721 0.0009779 0.00192566 0.00200688 
    -0.0016502 -0.00733932 -0.0128113 -0.0147608 -0.0115456 
    -0.00668995 -0.00401368 -0.00463908 -0.0101197 -0.0118993 
    -0.0076276 -0.00262656 0.000813059 0.00264455 0.00350796 
    0.00399494 0.0043049 0.00451658 0.00444739 0.00503842 0.00559516 
    0.00568213 0.00556459 0.0053176 0.00496654 0.00454337 0.00408592 
    0.00362171 0.00317793 0.00277001 0.00240394 0.00207009 0.00176575 
    0.00149725 0.00129045 0.00114257 0.00101135 0.000871672 
    0.000723764 0.000580438 0.000427507 0.000296956 0.000281834 
    0.000376628 0.000412266 0.000367547 0.000295305 0.000264513 
    0.000233721 0.000202929 0.000172137 0.000141345 0.000124721 
    0.000112577 0.000100433 8.82893e-05 7.61453e-05 6.75517e-05 
    6.33609e-05 5.91701e-05 5.49792e-05 5.07884e-05 4.65976e-05 
    4.24067e-05 3.82159e-05 3.40251e-05 2.98342e-05 2.56434e-05 
    2.36401e-05 2.21181e-05 2.05961e-05 1.90741e-05 1.75521e-05 
    1.60301e-05 1.45081e-05 1.29861e-05 1.14641e-05 9.94208e-06 
    8.59252e-06 7.96439e-06 7.33626e-06 6.70813e-06 6.07999e-06 
    5.45186e-06 4.82373e-06 4.1956e-06 3.56747e-06 
}

.graph element create V10 -x x -y v10 

v11 set {
    1.86175 1.73419 1.42874 1.04055 0.943004 0.268275 0.0826455 
    0.0388346 0.0214104 0.0135431 0.00961322 0.00712846 0.00588262 
    0.00432397 0.00377774 0.00270134 -0.00393731 -0.00542187 
    -0.00126596 0.0113777 0.0134522 0.00477056 -0.00211067 -0.00229253 
    -0.00173355 -0.00122404 -0.00113426 -0.000744931 -0.000520112 
    -0.000410048 -0.000220439 0.000508104 5.15856e-05 -0.000112593 
    -0.000118917 -9.57394e-05 -7.15727e-05 -5.11847e-05 -3.58275e-05 
    -2.47166e-05 -1.68866e-05 -1.14082e-05 -7.66646e-06 -5.12139e-06 
    -3.63426e-06 -3.01815e-06 -2.64862e-06 -1.4947e-06 -1.91403e-07 
    -2.5763e-08 -7.73699e-07 -1.52164e-06 -1.07268e-06 -3.81696e-07 
    2.6727e-07 4.75489e-07 6.83708e-07 8.91926e-07 1.10014e-06 
    1.30836e-06 1.2482e-06 1.00726e-06 7.66311e-07 5.25364e-07 
    2.84417e-07 6.27857e-08 7.43904e-10 -6.12979e-08 -1.2334e-07 
    -1.85382e-07 -2.47423e-07 -3.09465e-07 -3.71507e-07 -4.33549e-07 
    -4.95591e-07 -5.57633e-07 -6.04571e-07 -5.4944e-07 -4.9431e-07 
    -4.3918e-07 -3.84049e-07 -3.28919e-07 -2.73789e-07 -2.18659e-07 
    -1.63528e-07 -1.08398e-07 -5.32678e-08 1.062e-09 5.08502e-08 
    1.00638e-07 1.50427e-07 2.00215e-07 2.50003e-07 2.99791e-07 
    3.4958e-07 3.99368e-07 4.49156e-07 4.98944e-07 5.34512e-07 
    5.01032e-07 4.67553e-07 4.34073e-07 4.00593e-07 3.67113e-07 
    3.33633e-07 3.00153e-07 2.66674e-07 2.33194e-07 1.99714e-07 
    1.66234e-07 1.32754e-07 9.92744e-08 6.57945e-08 3.23147e-08 
    -1.16513e-09 -3.4645e-08 -6.81248e-08 -1.01605e-07 -1.35084e-07 
    -1.68564e-07 -2.18729e-07 0.0114926 -0.0245378 -0.111828 
    0.0964775 1.61491 3.22668 4.22041 4.54492 4.82845 4.94868 
    4.98588 4.99609 4.9981 4.99908 4.99788 4.98395 4.99294 4.99724 
    5.01939 5.0471 5.00902 4.98194 4.98496 4.99188 4.99623 4.99862 
    5.00025 4.99974 4.99953 4.99946 4.99958 5.00012 4.99997 
    4.99992 4.99988 4.99985 4.9998 4.9997 4.9988 4.99806 4.99982 
    5.00143 5.00159 5.00098 5.00053 5.00028 5.00007 4.99977 
    4.99992 5.00005 5.00133 5.0009 4.99993 4.99972 4.99975 4.9998 
    4.99982 4.99983 4.99983 4.99983 4.99983 4.99984 4.99986 
    4.99987 4.99989 4.9999 4.99991 4.99992 4.99994 4.99995 4.99995 
    4.99996 4.99997 4.99997 4.99998 4.99998 4.99998 4.99998 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    5 5 5 5.00001 5.00001 5.00001 5.00002 5.00002 5.00002 5.00002 
    5.00002 5.00001 5.00001 5.00001 5 5 5 5 5 5 5 5 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 5 5 5.01457 4.99482 4.96561 4.99326 
    5.03452 5.00424 5.00101 5.00045 5.00004 4.99965 4.99997 
    4.99994 4.99958 4.99999 4.99936 4.9839 4.99248 4.99717 5.01976 
    5.04869 5.0087 4.98143 4.98488 4.99199 4.99622 4.9983 4.99928 
    4.99971 4.99986 5.00031 5.00022 5.00035 5.0001 4.99884 4.99811 
    4.99803 4.99887 5.00078 5.00151 5.00116 5.00007 4.99843 
    4.99915 5.00107 5.00168 5.00141 5.00092 5.00055 5.0003 5.00016 
    5.0001 5.00001 5.00016 5.0002 5.00009 4.99993 4.99975 4.99984 
    4.99991 4.99991 4.99982 4.99974 4.99974 4.99985 4.99995 
    4.99999 4.99998 5.00004 5.00013 5.00015 5.00007 4.99988 
    4.99982 4.99985 4.99995 5.00006 5.0002 5.00025 5.0002 5.00009 
    5.00006 5.00004 5.00002 5 4.99998 4.99997 4.99998 4.99998 
    4.99999 4.99999 4.99999 5 5 5 5 5 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 
    4.99998 4.99998 4.99998 
}

.graph element create V11 -x x -y v11 

v12 set {
    5 5.16975 4.78685 2.94241 0.126698 0.0487004 -0.00422591 
    -0.00130689 -0.000486756 -0.000195875 -0.000108988 -6.66736e-05 
    -7.26005e-05 -5.63608e-05 -3.81859e-05 -2.123e-05 -0.0646846 
    -0.0184474 0.182248 1.06731 3.10988 4.46133 4.84133 4.95113 
    4.98364 4.99455 4.99694 4.99727 4.9994 4.99975 5.0001 5.00132 
    5.00089 5.00039 5.00019 5.00011 5.00006 5.00005 5.00004 
    5.00001 4.99992 4.99992 5.00002 5.00013 5.00017 5.00009 
    4.99992 4.99991 4.99994 4.99996 4.99998 4.99999 5.00001 
    5.00004 5.00006 5.00005 5.00004 5.00003 5.00002 5.00001 
    5 4.99999 4.99999 4.99998 4.99998 4.99997 4.99997 4.99998 
    4.99998 4.99998 4.99998 4.99999 4.99999 4.99999 4.99999 
    5 5 5 5 5 5 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00002 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 5 5.14699 4.78074 
    3.19424 0.305663 0.0611255 -0.00179951 -0.0012032 0.000405978 
    0.000989399 0.000445194 0.000191447 8.30476e-05 3.96236e-05 
    1.91866e-05 1.70665e-05 -0.0655239 -0.0210234 0.1827 1.06848 
    3.11554 4.46518 4.84212 4.94853 4.98244 4.99434 4.9997 5.00081 
    5.00009 4.99972 4.99985 4.99974 4.9995 4.99949 4.99958 4.99973 
    4.99948 4.99914 4.99874 4.99946 5.00309 5.0091 5.01576 5.01835 
    5.01852 5.0176 5.01625 5.01479 5.01345 5.01264 5.011 5.01092 
    5.01344 5.01363 5.01289 5.01184 5.01071 5.00956 5.00848 
    5.00751 5.00663 5.00577 5.00497 5.00427 5.00365 5.0031 5.00264 
    5.00224 5.00191 5.00163 5.00138 5.00117 5.00099 5.00083 
    5.00071 5.00061 5.00053 5.00045 5.00037 5.00029 5.00022 
    5.00019 5.0002 5.00023 5.00024 5.00023 5.00023 5.00022 5.0002 
    5.00018 5.00016 5.00014 5.00011 5.00009 5.00007 5.00006 
    5.00005 5.00005 5.00004 5.00003 5.00002 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00002 5.00002 5.00002 5.00002 5.00002 5.00002 5.00002 
    5.00002 5.00001 5.00001 5.00001 5.14298 4.79809 3.32704 
    0.498385 0.105773 0.0160646 0.0319912 0.0299434 0.0240102 
    0.0185844 0.0130411 0.0106532 0.00864871 0.00744519 0.00660887 
    -0.0612913 -0.0203719 0.174998 0.991787 3.06292 4.60005 
    4.93058 4.98917 5.00033 4.9999 4.99909 4.9966 4.9955 4.99488 
    4.99374 4.9943 5.00131 5.00506 4.99311 4.96288 4.93567 4.92439 
    4.94236 4.9732 4.98864 4.99458 5.00031 5.00694 5.01525 5.01945 
    5.01998 5.01953 5.01874 5.01766 5.0164 5.01509 5.01326 5.01423 
    5.01455 5.01361 5.01245 5.01122 5.01002 5.00888 5.00783 
    5.00687 5.00596 5.00514 5.00442 5.00379 5.00325 5.00279 
    5.0024 5.00208 5.0018 5.00153 5.00126 5.00107 5.00094 5.00085 
    5.00078 5.00072 5.00063 5.00053 5.00042 5.00038 5.00034 
    5.0003 5.00027 5.00023 5.00021 5.00019 5.00017 5.00015 5.00013 
    5.00012 5.00011 5.0001 5.0001 5.00009 5.00008 5.00007 5.00007 
    5.00006 5.00005 5.00005 5.00004 5.00004 5.00003 5.00003 
    5.00002 5.00002 5.00002 5.00001 5.00001 5 5 5 5.00001 5.00001 
    5.00001 5.00002 5.00002 5.00002 5.00002 
}

.graph element create V12 -x x -y v12 

v13 set {
    9.73784e-10 0.0189926 0.0926769 0.206309 0.111533 0.0953491 
    0.0426966 0.0214177 0.0117943 0.00741442 0.00528816 0.00398417 
    0.0032967 0.00266499 0.00206647 0.00158788 -0.0371391 -0.0439528 
    -0.0408653 -0.0188706 0.0150241 0.0126852 0.00209817 -0.000239206 
    -5.31488e-05 0.000876324 -0.00451221 -0.0165223 -0.0284127 
    -0.0427584 -0.0502453 -0.0257366 -0.00903938 -0.00376456 
    -0.00233385 -0.00169922 -0.00130397 -0.00102542 -0.000811435 
    -0.000648115 -0.000529266 -0.00043795 -0.00036574 -0.00030716 
    -0.00026221 -0.000229662 -0.000205112 -0.000181038 -0.000162045 
    -0.000148988 -0.000137633 -0.000126278 -0.000115562 -0.000104976 
    -9.49324e-05 -9.0585e-05 -8.62375e-05 -8.18901e-05 -7.75426e-05 
    -7.31952e-05 -6.93752e-05 -6.59106e-05 -6.24461e-05 -5.89815e-05 
    -5.55169e-05 -5.22412e-05 -5.05263e-05 -4.88114e-05 -4.70966e-05 
    -4.53817e-05 -4.36668e-05 -4.19519e-05 -4.0237e-05 -3.85222e-05 
    -3.68073e-05 -3.50924e-05 -3.34782e-05 -3.25442e-05 -3.16102e-05 
    -3.06763e-05 -2.97423e-05 -2.88083e-05 -2.78744e-05 -2.69404e-05 
    -2.60064e-05 -2.50725e-05 -2.41385e-05 -2.32635e-05 -2.27232e-05 
    -2.21829e-05 -2.16426e-05 -2.11023e-05 -2.0562e-05 -2.00217e-05 
    -1.94814e-05 -1.89411e-05 -1.84007e-05 -1.78604e-05 -1.73647e-05 
    -1.70853e-05 -1.68059e-05 -1.65265e-05 -1.62471e-05 -1.59677e-05 
    -1.56883e-05 -1.54089e-05 -1.51295e-05 -1.48501e-05 -1.45707e-05 
    -1.42913e-05 -1.40119e-05 -1.37325e-05 -1.34531e-05 -1.31737e-05 
    -1.28943e-05 -1.26149e-05 -1.23355e-05 -1.20561e-05 -1.17767e-05 
    -1.14973e-05 -1.10954e-05 0.0152675 0.0228237 -0.00460678 
    -0.0341525 0.0232109 -0.0138039 -0.0416538 -0.0458764 -0.0201967 
    -0.00878316 -0.00379173 -0.00164621 -0.000785131 -0.00037575 
    -0.000352375 -0.0545586 -0.0746881 -0.0771865 -0.05386 -0.0022199 
    0.0136703 0.00633526 0.00138826 -0.00108934 0.0038886 0.0298077 
    0.0475776 0.0481003 0.0464167 0.047818 0.042789 0.035207 
    0.0264423 0.0193959 0.0151614 0.00624257 -0.00913057 -0.0310696 
    -0.0430238 0.016426 0.189762 0.49025 0.820116 1.13919 1.43549 
    1.70658 1.95183 2.17414 2.38506 2.5657 2.73958 2.97905 3.21403 
    3.43025 3.62645 3.8028 3.96002 4.09996 4.22443 4.33427 4.42886 
    4.51097 4.5817 4.64326 4.6957 4.74132 4.7797 4.81298 4.84102 
    4.86512 4.88523 4.90224 4.91649 4.92846 4.93868 4.94755 
    4.95483 4.96114 4.96682 4.97161 4.97502 4.9776 4.97944 4.98141 
    4.98319 4.98467 4.98585 4.9869 4.98796 4.98902 4.99008 4.99114 
    4.9922 4.99326 4.9938 4.99429 4.99479 4.99528 4.99578 4.99628 
    4.99677 4.99704 4.99718 4.99733 4.99747 4.99762 4.99777 
    4.99791 4.99806 4.9982 4.99835 4.9985 4.99864 4.99879 4.99893 
    4.99907 4.99916 4.99925 4.99934 4.99943 5.01473 4.92293 
    4.61974 4.0316 3.7835 3.74195 3.78344 3.87272 3.97386 4.07319 
    4.16686 4.25256 4.33126 4.40264 4.46697 4.49249 4.51807 
    4.55803 4.64055 4.78574 4.86074 4.88334 4.8999 4.91455 4.92814 
    4.93926 4.94761 4.95433 4.95907 4.9654 4.98317 5.0208 5.05134 
    4.85852 4.16041 3.00077 1.68376 0.672707 0.240838 0.0794725 
    -0.0106347 -0.00879443 0.107196 0.368163 0.701424 1.03581 
    1.3601 1.6678 1.95731 2.22701 2.47544 2.69099 2.92327 3.16648 
    3.3877 3.59067 3.77344 3.93584 4.08066 4.20863 4.32065 4.41791 
    4.50211 4.57423 4.63614 4.68888 4.73377 4.7721 4.80519 4.83338 
    4.85732 4.87815 4.89514 4.90927 4.92108 4.93122 4.94014 
    4.94845 4.95601 4.96251 4.96576 4.969 4.97225 4.9755 4.97874 
    4.98087 4.98265 4.98442 4.9862 4.98797 4.98924 4.9899 4.99055 
    4.9912 4.99186 4.99251 4.99316 4.99381 4.99447 4.99512 4.99577 
    4.99609 4.99634 4.99659 4.99683 4.99708 4.99732 4.99757 
    4.99782 4.99806 4.99831 4.99853 4.99863 4.99873 4.99883 
    4.99893 4.99903 4.99913 4.99923 4.99933 
}

.graph element create V13 -x x -y v13 

v14 set {
    1.86175 2.00147 1.85141 1.0654 0.275481 0.205547 0.0712627 
    0.0313387 0.0151431 0.00864531 0.00593861 0.00438111 0.0037479 
    0.00305857 0.00221221 0.0017081 -0.0896128 -0.109079 -0.121356 
    -0.0542001 0.175821 0.177442 0.0814591 0.0333042 0.0134909 
    0.00625777 0.00100092 -0.00552776 -0.00411139 -0.00150395 
    -0.000564784 3.48169e-05 -0.000287014 -0.000538515 -0.000456537 
    -0.000325677 -0.000275468 -0.000166452 -8.27481e-05 -8.28704e-05 
    -7.47644e-05 -4.60552e-05 -2.61481e-06 2.26359e-05 2.53852e-05 
    -1.39853e-06 -4.23456e-05 -4.0907e-05 -2.8501e-05 -1.5945e-05 
    -9.01122e-06 -2.07747e-06 1.49328e-06 4.38398e-06 6.84248e-06 
    4.76711e-06 2.69173e-06 6.16362e-07 -1.45901e-06 -3.53438e-06 
    -4.14256e-06 -3.76238e-06 -3.3822e-06 -3.00202e-06 -2.62184e-06 
    -2.24878e-06 -1.93456e-06 -1.62033e-06 -1.3061e-06 -9.91867e-07 
    -6.77638e-07 -3.63409e-07 -4.91792e-08 2.6505e-07 5.7928e-07 
    8.93509e-07 1.16076e-06 1.11055e-06 1.06034e-06 1.01014e-06 
    9.59927e-07 9.09719e-07 8.59511e-07 8.09302e-07 7.59094e-07 
    7.08886e-07 6.58678e-07 5.99251e-07 4.87523e-07 3.75795e-07 
    2.64068e-07 1.5234e-07 4.06119e-08 -7.1116e-08 -1.82844e-07 
    -2.94572e-07 -4.063e-07 -5.18027e-07 -6.08517e-07 -5.95879e-07 
    -5.83241e-07 -5.70604e-07 -5.57966e-07 -5.45328e-07 -5.3269e-07 
    -5.20053e-07 -5.07415e-07 -4.94777e-07 -4.8214e-07 -4.69502e-07 
    -4.56864e-07 -4.44226e-07 -4.31589e-07 -4.18951e-07 -4.06313e-07 
    -3.93676e-07 -3.81038e-07 -3.684e-07 -3.55762e-07 -3.43125e-07 
    1.06736e-05 0.0797407 0.0437947 -0.0645098 -0.0877312 0.0653203 
    -0.00621184 -0.0353188 -0.0491378 -0.0251957 -0.0110996 
    -0.00481123 -0.0020941 -0.000998038 -0.000478747 -0.000445332 
    -0.102046 -0.135753 -0.154351 -0.0827509 0.163348 0.174012 
    0.0794822 0.0310624 0.0112213 0.00249061 0.00130764 0.00181315 
    0.00163875 0.00101454 0.000497435 0.000195258 5.31901e-05 
    2.4607e-05 6.62736e-05 7.90718e-05 4.0372e-05 -0.000141184 
    -0.000280623 5.5608e-05 0.000799565 0.000920189 0.000931616 
    0.000494527 0.000162303 -8.24884e-05 -0.000183938 -0.000203899 
    -0.000144788 -9.87063e-05 -0.000227929 2.93932e-05 0.000208563 
    1.88958e-06 -7.6335e-05 -0.000172472 -0.000165656 -0.000145889 
    -0.000177311 -0.000191058 -0.000168287 -0.00015755 -0.00013142 
    -8.10488e-05 -6.36115e-05 -7.8699e-05 -8.11282e-05 -7.98625e-05 
    -5.98807e-05 -3.40879e-05 -1.95464e-05 -1.79247e-05 -4.45514e-05 
    -7.47995e-05 -8.7682e-05 -7.50806e-05 -3.25561e-05 -4.34114e-05 
    -7.69099e-05 -0.000141101 -0.00018743 -0.000148471 -5.06546e-05 
    0.000120195 0.000177635 0.000177052 0.000146344 9.75126e-05 
    8.31233e-05 6.8734e-05 5.43447e-05 3.99554e-05 2.55661e-05 
    1.11768e-05 -3.21253e-06 -3.88937e-06 -3.56628e-06 -3.24318e-06 
    -2.92008e-06 -2.59699e-06 -2.27389e-06 -1.9508e-06 -1.73227e-06 
    -1.56796e-06 -1.40365e-06 -1.23934e-06 -1.07503e-06 -9.10722e-07 
    -7.46412e-07 -5.82101e-07 -4.1779e-07 -2.5348e-07 -8.91694e-08 
    7.51412e-08 2.39452e-07 4.03762e-07 5.95733e-07 1.00771e-06 
    1.41969e-06 1.83167e-06 2.24365e-06 0.0828257 0.231038 0.465438 
    1.54516 2.8461 3.19221 3.40395 3.6382 3.80758 3.93848 4.04882 
    4.15428 4.247 4.32917 4.40235 4.36941 4.397 4.48862 4.64552 
    4.86595 5.03475 5.0348 5.02627 5.01967 5.01542 5.00925 4.98613 
    4.9519 4.91581 4.87357 4.82302 4.80403 4.82565 4.86102 4.89483 
    4.92253 4.94428 4.96257 4.97608 4.98373 4.98823 4.99182 
    4.99437 4.99635 4.99745 4.99802 4.99843 4.99873 4.99895 
    4.99912 4.99925 4.99931 4.99962 4.99973 4.99972 4.99971 
    4.9997 4.99969 4.9997 4.99971 4.99973 4.99974 4.99976 4.99978 
    4.9998 4.99982 4.99985 4.99987 4.99989 4.9999 4.99991 4.99991 
    4.99993 4.99994 4.99997 5.00001 5.00006 5.00008 5.00006 
    5.00002 5 4.99999 4.99998 4.99997 4.99995 4.99995 4.99995 
    4.99995 4.99995 4.99995 4.99995 4.99996 4.99997 4.99997 
    4.99998 4.99999 5 5 5.00001 5.00002 5.00002 5.00002 5.00002 
    5.00002 5.00002 5.00002 5.00002 5.00002 5.00002 5.00001 
    5.00001 5.00001 5.00001 5.00001 5 5 5 4.99999 4.99999 4.99999 
    
}

.graph element create V14 -x x -y v14

v15 set {
    1.86175 2.00199 2.08919 1.84314 1.08254 0.214737 0.0377351 
    0.00952455 0.00232763 0.000563614 0.000263477 0.000148642 
    0.000285086 0.000242592 7.34699e-05 -1.53467e-05 -0.0161874 
    -0.0157876 -0.0141194 0.0132576 0.0903272 0.109938 0.0535295 
    0.0224216 0.00940945 0.00466825 -0.000649972 -0.00654752 
    -0.00333248 -0.00103671 -0.000508276 -5.8896e-05 -0.00043938 
    -0.000544704 -0.00044444 -0.000307093 -0.00024517 -0.000154538 
    -8.78602e-05 -7.10461e-05 -6.06485e-05 -3.91039e-05 -8.45988e-06 
    9.43442e-06 1.28351e-05 -2.16734e-06 -2.6142e-05 -2.54768e-05 
    -1.88997e-05 -1.17906e-05 -7.3808e-06 -2.97101e-06 1.19146e-07 
    2.94246e-06 5.38942e-06 3.88851e-06 2.38761e-06 8.86704e-07 
    -6.14201e-07 -2.11511e-06 -2.59565e-06 -2.38885e-06 -2.18205e-06 
    -1.97525e-06 -1.76845e-06 -1.56241e-06 -1.36258e-06 -1.16276e-06 
    -9.62939e-07 -7.63116e-07 -5.63293e-07 -3.6347e-07 -1.63647e-07 
    3.61756e-08 2.35999e-07 4.35822e-07 6.07653e-07 5.90323e-07 
    5.72994e-07 5.55665e-07 5.38336e-07 5.21007e-07 5.03678e-07 
    4.86349e-07 4.6902e-07 4.51691e-07 4.34361e-07 4.11899e-07 
    3.60315e-07 3.08731e-07 2.57146e-07 2.05562e-07 1.53977e-07 
    1.02393e-07 5.08082e-08 -7.76222e-10 -5.23607e-08 -1.03945e-07 
    -1.47815e-07 -1.54225e-07 -1.60635e-07 -1.67045e-07 -1.73455e-07 
    -1.79864e-07 -1.86274e-07 -1.92684e-07 -1.99094e-07 -2.05504e-07 
    -2.11914e-07 -2.18324e-07 -2.24734e-07 -2.31144e-07 -2.37554e-07 
    -2.43964e-07 -2.50373e-07 -2.56783e-07 -2.63193e-07 -2.69603e-07 
    -2.76013e-07 -2.82423e-07 2.92534e-06 0.0446777 0.024278 
    -0.0518987 -0.0636547 0.00983929 -0.000518204 -0.000265194 
    0.000154772 0.000299538 3.12715e-05 -3.18225e-05 -2.48268e-05 
    -1.16701e-05 -6.05117e-06 7.61116e-06 -0.0163668 -0.0158244 
    -0.0141177 0.0100085 0.0857144 0.107784 0.051862 0.0204448 
    0.00629858 0.000967736 0.00121674 0.00190276 0.00154009 
    0.000860922 0.000410386 0.000164585 3.99493e-05 1.93797e-05 
    5.67594e-05 0.000110126 2.49925e-05 -7.17815e-05 -0.000142299 
    -1.63109e-05 0.000439529 0.000562489 0.000594599 0.000326164 
    0.000126423 -4.26063e-05 -0.000122927 -0.000114152 -6.72706e-05 
    -6.41242e-05 -0.000135588 2.61507e-05 0.000134036 6.43734e-06 
    -4.6223e-05 -0.000112047 -0.000101388 -8.67847e-05 -0.000117664 
    -0.000133957 -0.000116558 -0.000100873 -7.65448e-05 -4.44964e-05 
    -3.6677e-05 -5.26632e-05 -5.45172e-05 -5.13545e-05 -3.73869e-05 
    -1.99732e-05 -1.0907e-05 -1.10081e-05 -3.02609e-05 -5.18517e-05 
    -6.13597e-05 -5.30706e-05 -2.39572e-05 -3.24146e-05 -5.70062e-05 
    -0.000103448 -0.000135376 -0.0001024 -2.39007e-05 0.000110929 
    0.000151226 0.000142044 0.000105922 5.62834e-05 4.78476e-05 
    3.94117e-05 3.09759e-05 2.25401e-05 1.41042e-05 5.66837e-06 
    -2.76747e-06 -3.08639e-06 -2.81341e-06 -2.54043e-06 -2.26745e-06 
    -1.99447e-06 -1.72149e-06 -1.44851e-06 -1.26226e-06 -1.12096e-06 
    -9.79661e-07 -8.38363e-07 -6.97065e-07 -5.55768e-07 -4.1447e-07 
    -2.73173e-07 -1.31875e-07 9.42259e-09 1.5072e-07 2.92018e-07 
    4.33315e-07 5.74613e-07 7.10363e-07 8.01984e-07 8.93604e-07 
    9.85225e-07 1.07685e-06 0.04474 0.0928765 0.141327 0.0176048 
    -0.071675 -0.0124613 0.989022 2.28104 3.40619 4.21417 4.67173 
    4.87438 4.96044 4.98996 4.99858 4.96672 4.89502 4.79391 
    4.76433 4.8387 4.98612 5.0161 5.01722 5.01437 5.01256 4.99827 
    4.95807 4.9209 4.88217 4.83006 4.78461 4.80759 4.85548 4.89604 
    4.9254 4.94617 4.96126 4.97374 4.98255 4.98792 4.99126 4.99361 
    4.99554 4.99699 4.99792 4.99846 4.99881 4.99905 4.99924 
    4.99938 4.99949 4.99955 4.9997 4.9998 4.99982 4.99982 4.99982 
    4.99982 4.99982 4.99983 4.99984 4.99985 4.99986 4.99987 
    4.99988 4.99989 4.9999 4.99992 4.99993 4.99994 4.99995 4.99995 
    4.99996 4.99996 4.99998 4.99999 5.00001 5.00002 5.00002 
    5.00001 5.00001 5 4.99999 4.99999 4.99998 4.99998 4.99998 
    4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 
    4.99999 4.99999 4.99999 4.99999 5 5 5 5 5 5 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    
}
.graph element create V15 -x x -y v15

v16 set {
    1.86175 1.73073 1.50572 1.89001 3.39004 4.36034 4.79012 
    4.93798 4.98305 4.99539 4.9979 4.99904 4.99772 4.9983 4.99935 
    4.99975 4.98837 4.99456 4.99728 5.01838 5.04568 5.00759 
    4.98112 4.98479 4.99197 4.99641 4.99747 4.99775 5.00043 
    5.0007 5.00035 5.00023 4.99976 5.00002 5.00007 5.0002 4.99993 
    5.00003 5.00021 5.00006 4.99993 4.99992 5.00002 5.00013 
    5.00017 5.00009 4.99992 4.99991 4.99993 4.99996 4.99998 
    4.99999 5.00001 5.00003 5.00005 5.00004 5.00004 5.00003 
    5.00002 5.00001 5 4.99999 4.99999 4.99998 4.99998 4.99997 
    4.99997 4.99998 4.99998 4.99998 4.99998 4.99999 4.99999 
    4.99999 4.99999 5 5 5 5 5 5 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00002 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 5 5.01498 4.99342 4.96899 5.00301 5.02627 4.9977 
    4.99548 4.99757 5.00277 5.00245 5.0014 5.00069 5.00032 5.00014 
    5.00009 4.9867 4.99262 4.99607 5.01805 5.04713 5.00927 4.98184 
    4.98483 4.9914 4.99616 4.99902 4.9999 4.99987 4.99979 4.99981 
    4.99989 4.99994 4.99998 5.0002 5.00001 5.00008 5.00008 5.0001 
    5.00021 5.00032 5.00025 5.00019 5.00006 5.00007 4.99994 
    4.99997 4.99999 5.00023 5.00008 4.99993 4.99998 4.99986 
    4.99982 5.00003 4.99985 4.99996 5.00014 5 4.99984 4.99979 
    4.99982 4.99993 5.00008 5.00011 5.00002 4.99996 4.9999 4.99994 
    5.00001 5.00007 5.00009 4.99995 4.99978 4.99971 4.99976 
    4.99997 4.99996 4.99989 4.99972 4.99955 4.99953 4.99959 
    4.99976 4.9999 5.00005 5.00023 5.00039 5.00034 5.00029 5.00024 
    5.00019 5.00014 5.00009 5.00004 5.00003 5.00002 5.00001 
    5 5 4.99999 4.99998 4.99998 4.99998 4.99998 4.99998 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 5 5 5 5 
    5.00001 5.00002 5.00003 5.00004 5.01564 5.03395 5.04932 
    5.11868 3.92502 1.31888 0.163888 0.0946876 0.0789578 0.0565084 
    0.0260333 0.0156986 0.00907667 0.00613629 0.00468417 -0.00174008 
    -0.0021422 0.000586962 0.0124937 0.0147977 0.00838454 0.00039383 
    -0.000522021 -0.000426598 -0.000290214 -0.00173713 -0.00384132 
    -0.00382945 -0.00429219 -0.00580193 -0.00393246 0.0017543 
    0.00423045 0.00408931 0.0031976 0.00245457 0.00187293 0.00159068 
    0.00105697 0.000609902 0.000358825 0.000334125 0.000212708 
    0.000168116 8.97349e-05 5.21578e-05 3.84527e-05 2.93033e-05 
    2.10067e-05 1.59954e-05 1.13917e-05 5.49738e-06 2.77217e-05 
    6.51259e-06 -6.65468e-06 2.09837e-06 -6.617e-06 -4.80187e-06 
    1.55031e-06 4.26536e-06 7.69457e-07 -1.46213e-06 -7.25202e-07 
    3.26501e-06 6.55807e-06 7.524e-06 6.07209e-06 6.00701e-06 
    5.41166e-06 3.86573e-06 1.10651e-06 -2.74603e-06 -2.18566e-06 
    2.3658e-06 8.59956e-06 8.35046e-06 2.90621e-06 -8.75982e-07 
    -1.87189e-06 -2.1528e-06 -1.94875e-06 -1.74471e-06 -1.54067e-06 
    -1.33662e-06 -1.13258e-06 -8.40567e-07 -5.20743e-07 -2.00918e-07 
    1.18906e-07 4.38731e-07 6.11382e-07 6.01529e-07 5.91675e-07 
    5.81822e-07 5.71968e-07 5.62115e-07 5.52261e-07 5.42407e-07 
    5.32554e-07 5.227e-07 5.12847e-07 4.72812e-07 4.26137e-07 
    3.79462e-07 3.32786e-07 2.86111e-07 2.39436e-07 1.92761e-07 
    1.46086e-07 9.94107e-08 5.27356e-08 -2.77779e-10 -7.98079e-08 
    -1.59338e-07 -2.38868e-07 -3.18398e-07 -3.97928e-07 -4.77458e-07 
    -5.56988e-07 -6.36519e-07 
}
.graph element create V16 -x x -y v16

v17 set {
    5 5.16963 4.84136 3.33754 0.316206 0.103113 0.0273341 0.0221102 
    0.0177008 0.0143758 0.0115203 0.00929231 0.00752716 0.00625439 
    0.00489872 0.00403656 -0.0657317 -0.0256467 0.165394 0.985963 
    3.05067 4.55799 4.89728 4.92464 4.8882 4.90592 4.97315 4.99241 
    4.99694 4.99845 4.99905 4.99939 4.99959 4.99971 4.9998 4.99986 
    4.9999 4.99993 4.99995 4.99996 4.99997 4.99998 4.99998 4.99999 
    4.99999 4.99999 4.99999 4.99999 5 5.00001 5.00003 5.00005 
    5.00004 5.00002 5 4.99999 4.99999 4.99998 4.99998 4.99997 
    4.99997 4.99998 4.99998 4.99999 4.99999 5 5 5 5 5 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00002 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5 5 5 5 
    5 5 5 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99998 
    4.99998 4.99998 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 5 5 5 5 5 5 5.00025 5.1657 4.69981 2.43895 
    0.0229743 0.0351406 -0.0211974 -0.0312063 -0.0160331 -0.0021718 
    -0.000766597 -0.000251052 -5.49363e-05 -3.36364e-06 -2.01983e-06 
    -9.70575e-06 -0.0657007 -0.0205247 0.183332 1.07163 3.11839 
    4.46213 4.84163 4.95195 4.99159 5.02084 5.04029 5.04138 
    5.0271 5.00445 4.97957 4.95702 4.95231 4.97819 4.99191 4.9963 
    4.99822 4.99878 4.99903 4.99925 4.99942 4.9995 4.99954 4.99957 
    4.99961 4.99966 4.9997 4.99974 4.99977 4.99981 4.99983 4.99986 
    4.99988 4.9999 4.99991 4.99992 4.99994 4.99995 4.99995 4.99996 
    4.99997 4.99997 4.99998 4.99998 4.99998 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5.00001 5.00001 5.00001 
    5.00002 5.00002 5.00002 5.00002 5.00002 5.00002 5.00002 
    5.00002 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5 5 5 4.99999 4.99998 4.99997 4.99996 5.14239 4.76219 
    3.16574 0.299969 0.0631609 -0.00118611 -0.00026052 -5.96333e-05 
    -1.44904e-05 -4.3859e-06 -2.99454e-06 1.10547e-06 4.84662e-06 
    1.30971e-05 2.23082e-05 -0.0655844 -0.0204818 0.182507 1.05954 
    3.12277 4.46735 4.83915 4.94512 4.97679 4.98654 4.9966 5.00833 
    5.00776 5.00432 5.00199 5.00086 5.00033 5.00008 5 5.00001 
    5 5.00005 5.00002 4.99981 4.99991 4.99998 4.99979 4.99979 
    4.99984 4.9998 4.9998 5.00006 5.00002 5.00001 5 5 4.99992 
    4.99998 4.99999 5.00002 5.00014 4.99999 4.99987 4.99993 
    5.00003 5.00011 5.00005 4.99996 4.99987 4.99985 4.99994 
    5.00009 5.0001 5 4.99993 4.99997 5.00008 5.00015 5.00021 
    5.00021 5.00007 4.99978 4.99965 4.99973 4.9999 4.99992 4.99995 
    4.99997 4.99999 5.00001 5.00002 5.00001 5.00001 5.00001 
    5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99998 4.99998 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 5 5 5 5 5 5.00001 5.00001 5.00001 5.00002 
    5.00002 5.00002 
}
.graph element create V17 -x x -y v17

v18 set {
    5 5.0333 5.02472 4.92559 4.18383 3.93923 3.9961 4.14293 
    4.28591 4.41336 4.52157 4.61101 4.68472 4.7439 4.79294 4.83239 
    4.80697 4.78808 4.79322 4.8838 5.08529 5.21863 4.88852 3.90198 
    2.14586 0.383977 0.101103 0.0525711 0.0318287 0.020895 0.0146908 
    0.010831 0.00830272 0.00656377 0.00532066 0.00440078 0.00369956 
    0.00315713 0.00272614 0.00237965 0.00209659 0.00186339 0.00167014 
    0.0015081 0.00137172 0.00125607 0.00115393 0.00106076 0.000980166 
    0.000918015 0.000862837 0.00080766 0.000763488 0.000721541 
    0.000680825 0.000653026 0.000625226 0.000597426 0.000569627 
    0.000541827 0.000519087 0.000499756 0.000480424 0.000461093 
    0.000441761 0.000423291 0.000411941 0.00040059 0.00038924 
    0.000377889 0.000366539 0.000355188 0.000343838 0.000332487 
    0.000321137 0.000309786 0.000299055 0.000292509 0.000285963 
    0.000279417 0.000272871 0.000266325 0.000259779 0.000253233 
    0.000246686 0.00024014 0.000233594 0.000227387 0.0002231 
    0.000218813 0.000214526 0.00021024 0.000205953 0.000201666 
    0.000197379 0.000193092 0.000188805 0.000184519 0.000180526 
    0.000177963 0.0001754 0.000172837 0.000170274 0.000167711 
    0.000165148 0.000162585 0.000160022 0.000157459 0.000154895 
    0.000152332 0.000149769 0.000147206 0.000144643 0.00014208 
    0.000139517 0.000136954 0.000134391 0.000131828 0.000129265 
    0.000126702 0.000132838 0.0311184 0.163151 0.34986 0.604501 
    0.357125 0.136137 0.0711304 0.0346959 0.0212674 0.00872193 
    0.00252206 0.000455269 7.59332e-05 2.91532e-05 0.000320562 
    -0.0720911 -0.0840491 -0.0791345 -0.0404143 0.0182035 -0.0235871 
    -0.0426072 -0.0597501 0.00824773 0.481404 1.32496 2.11949 
    2.57317 2.58202 2.15054 1.33786 0.45702 0.153772 0.0913584 
    0.0604989 0.0421591 0.0271456 0.0170021 0.0115815 0.00907886 
    0.00742466 0.00626096 0.00531127 0.00450501 0.00381927 0.00323718 
    0.00274374 0.00232494 0.00196885 0.00166686 0.00141134 0.00119437 
    0.0010109 0.000855534 0.000723378 0.000611408 0.000516704 
    0.000436769 0.000369523 0.000313026 0.00026526 0.000223976 
    0.000188972 0.000159042 0.000134148 0.000112688 9.49738e-05 
    7.97877e-05 6.721e-05 5.65115e-05 4.77194e-05 4.03591e-05 
    3.42848e-05 2.92627e-05 2.50435e-05 2.1412e-05 1.84532e-05 
    1.58624e-05 1.34673e-05 1.14461e-05 1.00935e-05 9.12375e-06 
    8.50202e-06 7.81431e-06 7.20729e-06 6.73936e-06 6.3702e-06 
    5.90049e-06 5.43077e-06 4.96105e-06 4.49133e-06 4.02162e-06 
    3.5519e-06 3.08218e-06 2.79099e-06 2.51281e-06 2.23463e-06 
    1.95645e-06 1.67827e-06 1.40009e-06 1.12191e-06 1.01376e-06 
    9.9375e-07 9.73741e-07 9.53733e-07 9.33724e-07 9.13715e-07 
    8.93707e-07 8.73698e-07 8.5369e-07 8.33681e-07 8.13673e-07 
    7.93664e-07 7.73655e-07 7.53647e-07 7.21781e-07 5.956e-07 
    4.69419e-07 3.43239e-07 2.17058e-07 0.0284032 0.0374438 
    -0.0157543 -0.0680497 0.0504768 0.0100294 0.00222261 0.000528697 
    0.000132929 3.99489e-05 2.46066e-05 4.56327e-06 -6.54853e-06 
    1.33783e-05 -3.68221e-05 -0.0724498 -0.0843663 -0.0792935 
    -0.0406426 0.0200019 0.0426259 0.0220753 0.00668555 -0.000968483 
    0.024662 0.0383437 0.0911513 0.087848 0.0602076 0.0390559 
    0.0260573 0.0180444 0.012974 0.00985409 0.00788132 0.0064228 
    0.005545 0.00453571 0.00364245 0.00310278 0.00270523 0.00236439 
    0.0020945 0.00186808 0.00167493 0.00151731 0.00138594 0.00126945 
    0.00116695 0.0010762 0.000996366 0.000928387 0.000864414 
    0.000808258 0.000759574 0.000713865 0.000666712 0.000632716 
    0.000601262 0.000572163 0.000543986 0.000515253 0.0004897 
    0.000468112 0.000449313 0.000432981 0.000417911 0.000401307 
    0.000382712 0.000366678 0.000355736 0.000349171 0.000335727 
    0.000317091 0.000296086 0.000283543 0.000277366 0.000272233 
    0.000267001 0.000263147 0.000256699 0.000250251 0.000243803 
    0.000237355 0.000230907 0.000225424 0.000220247 0.000215069 
    0.000209892 0.000204714 0.000200213 0.000196548 0.000192884 
    0.00018922 0.000185556 0.000181892 0.000178228 0.000174564 
    0.0001709 0.000167236 0.000163572 0.000160824 0.000158279 
    0.000155733 0.000153187 0.000150641 0.000148095 0.000145549 
    0.000143003 0.000140457 0.000137911 0.000135457 0.000133386 
    0.000131315 0.000129245 0.000127174 0.000125103 0.000123032 
    0.000120961 0.000118891 
}
.graph element create V18 -x x -y v18

v19 set {
    1.86175 1.99994 2.0833 2.01627 2.42503 3.25769 3.62134 3.88827 
    4.09688 4.26773 4.40529 4.51734 4.60827 4.68313 4.74346 
    4.79302 4.72815 4.68959 4.70421 4.81316 5.01375 5.14493 
    5.10305 5.0699 5.04484 5.03751 5.03348 5.02504 5.01799 5.01271 
    5.00895 5.00628 5.0044 5.00309 5.00216 5.00151 5.00105 5.00073 
    5.00051 5.00034 5.00023 5.00015 5.0001 5.00007 5.00003 4.99998 
    4.99993 4.99993 4.99995 4.99999 5.00001 5.00003 5.00002 
    5.00001 5 5 5 5 4.99999 4.99999 4.99999 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5.00017 5.17398 
    4.94779 3.78508 1.52302 0.608808 0.244311 0.126053 0.0597175 
    0.038422 0.0158174 0.00481338 0.00107847 0.000301256 0.000114861 
    0.00059489 -0.118904 -0.147478 -0.158986 -0.080544 0.165361 
    0.171378 0.0776087 0.0435738 0.0428235 0.0423755 0.0347695 
    0.0225061 0.0155539 0.0121357 0.0107997 0.0103976 0.0124406 
    0.016814 0.0167556 0.0149852 0.01459 0.0141182 0.0131934 
    0.0120286 0.0108692 0.0097184 0.00855881 0.00744912 0.00643877 
    0.00554044 0.00475165 0.00406535 0.00347158 0.00295981 0.00251995 
    0.00214318 0.00182101 0.00154613 0.00131196 0.0011119 0.000941587 
    0.000796999 0.000674582 0.000571283 0.000484276 0.000410649 
    0.000347005 0.000292984 0.000246715 0.000208143 0.00017489 
    0.000147412 0.000123854 0.000104332 8.77229e-05 7.40686e-05 
    6.2637e-05 5.32e-05 4.53946e-05 3.88343e-05 3.31864e-05 
    2.85905e-05 2.45725e-05 2.08671e-05 1.77301e-05 1.55911e-05 
    1.40153e-05 1.29421e-05 1.18693e-05 1.09815e-05 1.03484e-05 
    9.87664e-06 9.14446e-06 8.41228e-06 7.68011e-06 6.94793e-06 
    6.21575e-06 5.48357e-06 4.7514e-06 4.38454e-06 4.04432e-06 
    3.7041e-06 3.36388e-06 3.02366e-06 2.68344e-06 2.34322e-06 
    2.15196e-06 2.03791e-06 1.92386e-06 1.80982e-06 1.69577e-06 
    1.58173e-06 1.46768e-06 1.35363e-06 1.23959e-06 1.12554e-06 
    1.0115e-06 8.9745e-07 7.83404e-07 6.69358e-07 4.76113e-07 
    -3.47071e-07 -1.17025e-06 -1.99344e-06 -2.81662e-06 0.0783754 
    0.0500262 -0.0659563 -0.120914 0.0815957 0.0154255 0.00347177 
    0.000840357 0.000214582 6.54655e-05 3.91709e-05 8.07396e-06 
    -4.44265e-07 1.74384e-05 -4.52725e-05 -0.119379 -0.147984 
    -0.159247 -0.0824604 0.169014 0.177628 0.0758742 0.010558 
    -0.0346506 -0.0710288 -0.0838952 -0.0599521 -0.034568 -0.0181615 
    -0.00968034 -0.00547115 -0.00333511 -0.00232468 -0.00181159 
    -0.00143841 -0.00116601 -0.000839755 -0.000569764 -0.000578683 
    -0.000490551 -0.000411712 -0.000437859 -0.000408185 -0.000356644 
    -0.000311332 -0.000269006 -0.000221396 -0.000210054 -0.0001923 
    -0.000175122 -0.000161039 -0.0001428 -0.000126123 -0.000127893 
    -8.14516e-05 -0.000120166 -0.000154909 -0.000112733 -8.40377e-05 
    -7.11342e-05 -8.09538e-05 -9.77789e-05 -9.82402e-05 -7.73531e-05 
    -5.28255e-05 -3.1096e-05 -1.87967e-05 -1.96552e-05 -4.16655e-05 
    -5.77185e-05 -5.24142e-05 -2.83153e-05 -1.90012e-05 -1.54415e-05 
    -2.52569e-05 -6.23747e-05 -0.000130543 -0.000149394 -0.000110886 
    -4.35517e-05 -4.17084e-05 -3.98651e-05 -3.80218e-05 -3.61785e-05 
    -3.43352e-05 -3.36249e-05 -3.32729e-05 -3.29208e-05 -3.25687e-05 
    -3.22166e-05 -3.17143e-05 -3.10258e-05 -3.03372e-05 -2.96486e-05 
    -2.89601e-05 -2.82715e-05 -2.75829e-05 -2.68944e-05 -2.62058e-05 
    -2.55173e-05 -2.48287e-05 -2.43043e-05 -2.38159e-05 -2.33276e-05 
    -2.28393e-05 -2.2351e-05 -2.18626e-05 -2.13743e-05 -2.0886e-05 
    -2.03977e-05 -1.99093e-05 -1.945e-05 -1.91122e-05 -1.87744e-05 
    -1.84366e-05 -1.80987e-05 -1.77609e-05 -1.74231e-05 -1.70853e-05 
    -1.67474e-05 
}
.graph element create V19 -x x -y v19

v20 set {
    1.86175 1.99724 2.17266 2.48439 3.15933 3.85231 4.38091 
    4.69033 4.85034 4.92851 4.96453 4.98188 4.98736 4.991 4.99482 
    4.9973 4.96422 4.89989 4.83907 4.83151 4.90868 5.04854 5.06104 
    5.04571 5.03219 5.03025 5.02273 5.01707 5.0123 5.0087 5.00611 
    5.00429 5.00301 5.00211 5.00148 5.00103 5.00072 5.0005 5.00035 
    5.00024 5.00016 5.00011 5.00007 5.00005 5.00003 5.00001 
    4.99999 4.99998 4.99998 4.99998 4.99998 4.99998 4.99999 
    5 5 5.00001 5.00001 5.00002 5.00002 5.00002 5.00002 5.00002 
    5.00002 5.00001 5.00001 5 5 5 5 5 5 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 5 5 5 5 5 5 5 5 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5 5 5 5 
    5 5 4.99981 5.10081 5.10903 4.98404 5.00999 5.14946 4.36501 
    2.23938 0.325144 0.00660272 -0.0102186 -0.0082401 -0.00556785 
    -0.00374178 -0.00264763 -0.00202823 -0.0182241 -0.0169551 
    -0.0150395 0.0103736 0.0877592 0.104382 0.0515938 0.0373818 
    0.0411547 0.0397009 0.0308946 0.0205793 0.0154037 0.0129191 
    0.0119327 0.011527 0.0124295 0.0161152 0.0161076 0.0145391 
    0.0144541 0.0139287 0.0129215 0.0117239 0.0105795 0.00942983 
    0.00827423 0.00718354 0.00619954 0.00532868 0.00456631 0.00390448 
    0.00333254 0.00284003 0.00241714 0.00205524 0.0017458 0.00148202 
    0.00125739 0.0010655 0.000902213 0.000763611 0.000646279 
    0.000547291 0.000463934 0.000393401 0.000332424 0.000280655 
    0.000236328 0.000199386 0.000167536 0.000141218 0.000118654 
    9.99559e-05 8.40479e-05 7.09694e-05 6.00188e-05 5.09786e-05 
    4.3502e-05 3.72191e-05 3.18114e-05 2.74071e-05 2.35539e-05 
    1.99967e-05 1.69871e-05 1.49449e-05 1.3451e-05 1.24492e-05 
    1.14256e-05 1.05669e-05 9.94487e-06 9.47514e-06 8.77318e-06 
    8.07123e-06 7.36927e-06 6.66731e-06 5.96536e-06 5.2634e-06 
    4.56144e-06 4.23044e-06 3.92649e-06 3.62254e-06 3.31858e-06 
    3.01463e-06 2.71068e-06 2.40673e-06 2.23063e-06 2.12082e-06 
    2.01102e-06 1.90121e-06 1.7914e-06 1.68159e-06 1.57178e-06 
    1.46197e-06 1.35216e-06 1.24235e-06 1.13255e-06 1.02274e-06 
    9.12929e-07 8.0312e-07 6.33171e-07 -1.51288e-08 -6.63428e-07 
    -1.31173e-06 -1.96003e-06 0.0437517 0.0265689 -0.0515377 
    -0.0658688 0.010727 -0.000511921 -8.36924e-05 2.13278e-05 
    1.45207e-05 4.54862e-06 -6.14726e-06 2.0062e-06 1.02709e-06 
    1.4152e-05 -3.08225e-05 -0.0166501 -0.0157139 -0.013957 
    0.0107537 0.0873717 0.111302 0.0454129 -0.00530142 -0.0468336 
    -0.0790063 -0.0826944 -0.0534753 -0.0288705 -0.0149009 -0.00801592 
    -0.0046342 -0.00291835 -0.00213019 -0.00170055 -0.001352 
    -0.00110593 -0.000742655 -0.000532042 -0.000544742 -0.000479206 
    -0.000407307 -0.000403575 -0.000366209 -0.000324161 -0.000286183 
    -0.000247579 -0.000214281 -0.000203435 -0.000186896 -0.000171033 
    -0.00015779 -0.000145259 -0.000128069 -0.000122647 -9.89398e-05 
    -0.000114926 -0.000132195 -0.000107872 -8.91015e-05 -7.87996e-05 
    -8.14061e-05 -8.9098e-05 -8.83368e-05 -7.6122e-05 -6.14668e-05 
    -4.75402e-05 -3.81855e-05 -3.69696e-05 -4.78656e-05 -5.61346e-05 
    -5.35007e-05 -4.1459e-05 -3.35411e-05 -2.52374e-05 -2.37479e-05 
    -4.6406e-05 -9.41884e-05 -0.000109222 -8.52676e-05 -4.25166e-05 
    -4.10125e-05 -3.95085e-05 -3.80045e-05 -3.65004e-05 -3.49964e-05 
    -3.41627e-05 -3.3541e-05 -3.29193e-05 -3.22976e-05 -3.16758e-05 
    -3.10334e-05 -3.03653e-05 -2.96971e-05 -2.9029e-05 -2.83609e-05 
    -2.76928e-05 -2.70246e-05 -2.63565e-05 -2.56884e-05 -2.50203e-05 
    -2.43521e-05 -2.38716e-05 -2.34324e-05 -2.29932e-05 -2.25539e-05 
    -2.21147e-05 -2.16755e-05 -2.12362e-05 -2.0797e-05 -2.03578e-05 
    -1.99186e-05 -1.95079e-05 -1.9217e-05 -1.8926e-05 -1.8635e-05 
    -1.8344e-05 -1.8053e-05 -1.7762e-05 -1.74711e-05 -1.71801e-05 
    
}
.graph element create V20 -x x -y v20

v21 set {
    1.86175 1.73273 1.42016 1.02483 0.944013 0.274107 0.0823742 
    0.0379366 0.020816 0.0132952 0.00955525 0.00717008 0.00592286 
    0.00437379 0.00383557 0.00273694 -0.0037467 -0.0054191 -0.00131454 
    0.0112179 0.0133918 0.00519747 -0.00260113 -0.00252847 -0.00181292 
    0.000183398 -0.000667607 -0.000750747 -0.000594314 -0.000433904 
    -0.000308985 -0.000217858 -0.000152926 -0.000107454 -7.54076e-05 
    -5.2675e-05 -3.66299e-05 -2.54341e-05 -1.75095e-05 -1.18848e-05 
    -7.97289e-06 -5.30239e-06 -3.53615e-06 -2.38504e-06 -2.40158e-06 
    -3.84485e-06 -5.29435e-06 -2.57099e-06 1.95189e-06 3.55083e-06 
    2.06179e-06 5.72753e-07 3.30469e-07 3.40296e-07 3.60221e-07 
    4.86081e-07 6.1194e-07 7.37799e-07 8.63659e-07 9.89518e-07 
    9.21274e-07 7.22275e-07 5.23276e-07 3.24277e-07 1.25278e-07 
    -5.59467e-08 -9.03265e-08 -1.24706e-07 -1.59086e-07 -1.93466e-07 
    -2.27846e-07 -2.62226e-07 -2.96605e-07 -3.30985e-07 -3.65365e-07 
    -3.99745e-07 -4.24266e-07 -3.82163e-07 -3.40061e-07 -2.97959e-07 
    -2.55857e-07 -2.13755e-07 -1.71652e-07 -1.2955e-07 -8.7448e-08 
    -4.53457e-08 -3.24353e-09 3.76901e-08 7.19937e-08 1.06297e-07 
    1.40601e-07 1.74904e-07 2.09208e-07 2.43512e-07 2.77815e-07 
    3.12119e-07 3.46422e-07 3.80726e-07 4.04507e-07 3.77191e-07 
    3.49876e-07 3.22561e-07 2.95246e-07 2.67931e-07 2.40616e-07 
    2.13301e-07 1.85986e-07 1.58671e-07 1.31356e-07 1.04041e-07 
    7.67256e-08 4.94105e-08 2.20955e-08 -5.21962e-09 -3.25347e-08 
    -5.98498e-08 -8.71649e-08 -1.1448e-07 -1.41795e-07 -1.6911e-07 
    7.87893e-06 0.0114592 -0.0245712 -0.111637 0.0961324 1.61168 
    3.22343 4.20442 4.53535 4.83834 4.95464 4.98874 4.99746 
    4.99883 4.99948 4.99815 4.98431 4.99298 4.99718 5.01948 
    5.04749 5.008 4.98243 4.98985 4.99781 4.99887 4.99679 4.99616 
    4.99743 4.99859 4.99936 4.99972 5.00058 5.00123 5.0002 4.99945 
    4.99983 4.9998 4.99966 4.99958 4.99956 4.99956 4.99956 4.99958 
    4.99961 4.99965 4.99969 4.99973 4.99977 4.9998 4.99983 4.99985 
    4.99987 4.99989 4.99991 4.99992 4.99993 4.99994 4.99995 
    4.99996 4.99997 4.99997 4.99998 4.99998 4.99998 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5.00001 5.00001 
    5.00001 5.00002 5.00002 5.00002 5.00002 5.00002 5.00002 
    5.00002 5.00002 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5 5 5 4.99999 4.99998 4.99997 4.99996 5.01454 
    4.99566 4.96796 4.99819 5.03232 5.00034 4.99867 4.99937 
    4.99977 4.99992 4.99997 4.99999 5.00001 5.00021 4.99974 
    4.98462 4.99301 4.99723 5.01936 5.04807 5.00929 4.9789 4.97876 
    4.98244 4.9863 4.99575 5.0069 5.00863 5.00624 5.00357 5.0019 
    5.00098 5.00048 5.00025 5.00016 5.00011 5.00013 5.00009 
    4.99982 4.99994 5.00005 4.99994 4.99988 4.99989 4.99997 
    5.00003 5.00005 5.00002 5.00001 5.00001 5.00001 4.99993 
    4.99999 5 5.00021 4.99997 4.99981 5 5.00009 5.0001 5.00001 
    4.99991 4.9999 5 5.00011 5.00017 5.00018 5.00018 5.00014 
    5.00007 4.99999 4.9999 4.9999 5.00001 5.00016 5.00014 4.99999 
    4.99993 4.99999 5.00009 5.00007 5.00006 5.00004 5.00003 
    5.00001 5.00001 5 4.99999 4.99998 4.99997 4.99997 4.99997 
    4.99998 4.99998 4.99998 4.99998 4.99999 4.99999 4.99999 
    5 5 5 5 5 5 5.00001 5.00001 5.00001 5.00001 5.00001 5.00002 
    5.00002 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5 5 
}
.graph element create V21 -x x -y v21

v22 set {
    7.10441e-10 0.00107105 0.000637109 -0.00236346 -0.018079 
    -0.0120077 -0.00217059 0.00266679 0.00403383 0.00403836 
    0.00356705 0.00303303 0.00244716 0.00198586 0.0016855 0.00136497 
    -3.96022e-05 -0.000367409 -3.77079e-05 0.00194085 0.00506964 
    -0.0400214 -0.0402572 0.0524434 0.286234 0.803011 1.44795 
    2.02473 2.54768 3.02748 3.4415 3.78287 4.09667 4.35152 4.53987 
    4.67614 4.77407 4.84319 4.89227 4.92702 4.95119 4.96764 
    4.97846 4.98557 4.98982 4.99209 4.99371 4.99569 4.99727 
    4.99802 4.99834 4.99867 4.99892 4.99915 4.99936 4.99939 
    4.99943 4.99946 4.9995 4.99953 4.99957 4.9996 4.99963 4.99967 
    4.9997 4.99973 4.99974 4.99975 4.99976 4.99977 4.99978 4.9998 
    4.99981 4.99982 4.99983 4.99984 4.99985 4.99986 4.99986 
    4.99986 4.99987 4.99987 4.99988 4.99988 4.99989 4.99989 
    4.9999 4.9999 4.9999 4.9999 4.99991 4.99991 4.99991 4.99991 
    4.99992 4.99992 4.99992 4.99992 4.99993 4.99993 4.99993 
    4.99993 4.99993 4.99993 4.99993 4.99993 4.99994 4.99994 
    4.99994 4.99994 4.99994 4.99994 4.99994 4.99994 4.99995 
    4.99995 4.99995 4.99995 4.99995 4.99995 4.99995 5.00145 
    5.00659 5.01209 5.01931 5.00279 4.99273 4.99217 4.99295 
    4.99471 4.99594 4.99696 4.9978 4.99844 4.99891 4.99924 4.99635 
    4.99699 4.99813 5.00068 5.00307 5.0588 4.96365 4.54012 3.6307 
    2.35176 1.0322 0.354379 0.115986 0.0435668 0.0245112 0.020786 
    0.0164656 0.0118409 0.00849698 0.00597078 0.0040105 0.0026076 
    0.0016597 0.00118185 0.00121067 0.00153587 0.00174836 0.00136519 
    -0.000189116 -0.00315555 -0.00646603 -0.00898042 -0.010203 
    -0.0110896 -0.0123764 -0.00953841 -0.00225795 0.000818314 
    0.00152252 0.00150269 0.00119025 0.000767068 0.000308852 
    -3.79272e-05 -0.00019691 -0.000186642 -9.73653e-05 -8.49784e-06 
    2.04147e-05 -9.91086e-06 -1.55959e-05 -1.80499e-05 -1.77097e-05 
    -1.51548e-05 -1.1978e-05 -9.84916e-06 -1.29728e-05 -1.67235e-05 
    -1.74153e-05 -1.39958e-05 -5.92272e-06 -8.08216e-06 -1.53077e-05 
    -2.92531e-05 -3.91049e-05 -2.98935e-05 -7.32122e-06 3.18534e-05 
    4.39134e-05 4.18753e-05 3.22759e-05 1.86766e-05 1.58432e-05 
    1.30098e-05 1.01765e-05 7.34312e-06 4.50975e-06 1.67639e-06 
    -1.15697e-06 -1.23877e-06 -1.11991e-06 -1.00106e-06 -8.82208e-07 
    -7.63355e-07 -6.44502e-07 -5.2565e-07 -4.29318e-07 -3.44661e-07 
    -2.60004e-07 -1.75347e-07 -9.06904e-08 -6.03349e-09 7.86234e-08 
    1.6328e-07 2.47937e-07 3.32594e-07 4.17251e-07 5.01908e-07 
    5.86565e-07 6.71222e-07 7.36123e-07 6.43886e-07 5.5165e-07 
    4.59414e-07 3.67178e-07 0.000334759 -4.60833e-05 -0.00106139 
    -0.00166624 0.000859563 0.00102606 0.00410037 0.00419931 
    0.00518997 0.00459791 0.00503125 0.00523877 0.00452158 0.00339924 
    0.00233399 0.000876915 0.000546439 0.000444299 0.000983968 
    0.00119304 -0.0429422 -0.0403983 0.0534896 0.288013 0.807345 
    1.44247 2.03448 2.57021 3.05049 3.47332 3.8131 4.1009 4.34677 
    4.53512 4.67127 4.76531 4.82526 4.86593 4.89586 4.91904 
    4.93806 4.95348 4.96597 4.97629 4.9843 4.98983 4.99335 4.9957 
    4.99741 4.99864 4.99946 4.99994 5.00047 5.00073 5.00086 
    5.00092 5.00094 5.00091 5.00087 5.00081 5.00074 5.00067 
    5.00059 5.00052 5.00046 5.0004 5.00034 5.0003 5.00026 5.00022 
    5.00019 5.00016 5.00014 5.00012 5.0001 5.00009 5.00007 5.00006 
    5.00006 5.00005 5.00004 5.00004 5.00004 5.00003 5.00003 
    5.00003 5.00002 5.00002 5.00002 5.00002 5.00001 5.00001 
    5.00001 5.00001 5.00001 5 5 5 5 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 5 5 5 5 5 5 5 5 5 5.00001 5.00001 
    5.00001 5.00001 5.00002 5.00002 
}
.graph element create V22 -x x -y v22

v23 set {
    5 5.00284 5.01266 5.01895 4.98936 4.99575 4.99217 4.99545 
    4.99775 4.99894 4.99946 4.99968 4.99975 4.99977 4.99986 
    4.9999 4.99528 4.99808 5.00039 5.00392 5.00512 4.99985 4.99863 
    4.99942 4.99992 5.00017 4.99897 4.99803 4.99784 4.99739 
    4.99883 5.00365 5.00298 5.00133 5.00048 5.00019 5.00008 
    5.00005 5.00004 5.00003 5.00002 5.00002 5.00001 5.00001 
    5.00001 5.00001 5.00001 5 5 4.99999 4.99997 4.99995 4.99996 
    4.99998 5 5.00001 5.00001 5.00002 5.00002 5.00003 5.00003 
    5.00002 5.00002 5.00001 5.00001 5 5 5 5 5 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99998 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 5 5 5 5 5 5 5 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00002 
    5.00002 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5 5 5 5 5 5 5 5.00217 5.00108 4.99547 4.99658 5.00667 
    4.99641 4.99532 4.99938 5.00328 5.00222 5.00114 5.00052 
    5.00024 5.00011 5.00009 4.99285 4.99591 4.99897 5.00403 
    5.00786 5.00318 4.99942 4.9992 4.99949 5.001 5.00408 5.00319 
    5.00063 4.99995 5.00014 4.99982 4.99832 4.99838 4.99865 
    4.99912 4.99836 4.99735 4.99606 4.99814 5.00958 5.02973 
    5.05293 5.06103 4.99342 4.80726 4.50744 4.07509 3.41358 
    2.37924 1.03194 0.261552 0.142392 0.0904482 0.0555071 0.0322869 
    0.018289 0.0113802 0.00875182 0.00757055 0.00629906 0.00523 
    0.00403349 0.0031953 0.00280864 0.00286119 0.00250389 0.00202815 
    0.001723 0.00147312 0.0012411 0.00104401 0.000886204 0.000758277 
    0.000651915 0.00056348 0.000487966 0.000424048 0.000365613 
    0.000308178 0.000258725 0.000228061 0.000207976 0.000198491 
    0.00018518 0.000172716 0.000163197 0.000155007 0.000141734 
    0.000128461 0.000115188 0.000101915 8.86417e-05 7.53686e-05 
    6.20956e-05 5.69164e-05 5.23275e-05 4.77385e-05 4.31495e-05 
    3.85605e-05 3.39716e-05 2.93826e-05 2.69449e-05 2.56224e-05 
    2.42999e-05 2.29774e-05 2.16549e-05 2.03324e-05 1.90099e-05 
    1.76873e-05 1.63648e-05 1.50423e-05 1.37198e-05 1.23973e-05 
    1.10748e-05 9.75232e-06 8.48447e-06 7.65129e-06 6.81811e-06 
    5.98494e-06 5.15176e-06 0.00056893 -0.00787906 -0.0217381 
    -0.0370066 -0.00770505 0.00659312 0.00975477 0.00949456 
    0.00777552 0.00655645 0.00568776 0.00508782 0.00458121 0.00410187 
    0.00365665 0.0015121 0.00160863 0.00263181 0.00638941 0.00772607 
    0.00225583 0.0010843 0.000882939 0.000801563 0.00075632 
    0.000554992 0.000435131 0.0003474 0.000217667 0.000491602 
    0.0012267 0.00250446 0.000212058 -0.0174972 -0.0527527 -0.0479071 
    0.194908 1.45838 3.40677 4.49242 4.86894 4.97215 5.01218 
    5.04342 5.06228 5.03069 4.87169 4.57056 4.11523 3.38264 
    2.19691 0.715839 0.172818 0.102162 0.0627162 0.0363388 0.020289 
    0.0119414 0.00826608 0.0066417 0.00549092 0.00492505 0.00439443 
    0.0037156 0.00306471 0.00247451 0.00195965 0.0014822 0.0010815 
    0.000904464 0.0010514 0.00152308 0.00120752 0.000228447 
    -0.00102833 -0.00116644 -0.00042067 4.78758e-05 5.09599e-05 
    -4.45756e-05 -3.22966e-06 3.81163e-05 7.94622e-05 0.000120808 
    0.000162154 0.000161895 0.000148481 0.000135068 0.000121654 
    0.000108241 9.81453e-05 9.2164e-05 8.61827e-05 8.02014e-05 
    7.42201e-05 6.82388e-05 6.22576e-05 5.62763e-05 5.0295e-05 
    4.43137e-05 3.83324e-05 3.54323e-05 3.321e-05 3.09877e-05 
    2.87654e-05 2.65431e-05 2.43209e-05 2.20986e-05 1.98763e-05 
    1.7654e-05 1.54317e-05 1.34612e-05 1.25441e-05 1.1627e-05 
    1.07099e-05 9.79276e-06 8.87564e-06 7.95851e-06 7.04139e-06 
    6.12427e-06 
}
.graph element create V23 -x x -y v23

v24 set {
    5 5.01099 5.00866 4.97845 4.92369 4.9273 4.97413 4.9929 
    4.99826 4.99958 4.99978 5.00005 4.99968 4.99959 5.00014 
    4.99979 4.99914 4.99982 5.00023 5.00295 5.00664 4.99854 
    4.99647 5.00438 5.01722 5.03681 5.04766 5.04799 5.04867 
    5.04873 5.04685 5.04413 5.0367 5.02505 5.01726 5.01183 5.00806 
    5.00549 5.00371 5.00246 5.00162 5.00105 5.00069 5.00045 
    5.00031 5.00024 5.00019 5.00012 5.00007 5.00004 5.00001 
    4.99998 4.99999 4.99999 5 5.00001 5.00001 5.00002 5.00002 
    5.00003 5.00003 5.00003 5.00002 5.00002 5.00001 5.00001 
    5.00001 5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    5 5 5 5 5 5 5 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00002 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5 5 5 5 5 5 5 5.00418 4.99953 4.99152 
    4.99807 5.00497 5.00112 5.00055 5.00038 5.00018 5.00006 
    5.00006 5.00007 5.00006 5.00004 5.00004 4.99853 4.99945 
    4.99998 5.00304 5.00935 5.00742 4.99181 4.97421 4.93603 
    4.8853 4.8927 4.93984 4.97458 4.99039 4.99614 4.99801 4.99851 
    4.99869 4.99924 5.00108 5.00181 5.00119 5.00059 5.00031 
    5.00022 5.00018 5.00011 5.00001 5.00006 4.99981 4.99977 
    4.99982 5.00012 4.99993 5.00008 5.00043 5.00048 5.00024 
    5.00008 4.99984 4.99993 5.00011 4.99996 4.9998 4.99977 4.9998 
    4.99993 5.00008 5.00011 5.00002 4.99995 4.99989 4.99993 
    5 5.00007 5.00009 4.99994 4.99977 4.9997 4.99975 4.99996 
    4.99996 4.99988 4.9997 4.99952 4.9995 4.99956 4.99973 4.99988 
    5.00005 5.00025 5.00042 5.00036 5.00031 5.00025 5.0002 5.00014 
    5.00009 5.00003 5.00002 5.00001 5.00001 5 4.99999 4.99998 
    4.99998 4.99997 4.99998 4.99998 4.99998 4.99998 4.99998 
    4.99998 4.99998 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 5.00284 
    5.00442 5.00381 4.98997 4.99092 5.00733 5.07791 4.98237 
    4.86434 4.76835 4.74067 4.79278 4.85094 4.90068 4.93603 
    4.95698 4.96984 4.97856 4.98869 4.99904 5.0005 4.99524 5.00181 
    5.01878 5.05177 5.07986 4.98917 4.56217 3.68 2.3539 1.18541 
    0.505772 0.221044 0.115287 0.0760938 0.0589194 0.0476784 
    0.0457213 0.0412911 0.033889 0.0259741 0.0191452 0.0139018 
    0.0100235 0.00711788 0.00497657 0.00349368 0.00250021 0.00176179 
    0.00121843 0.000838368 0.000582711 0.000423458 0.000294608 
    0.000201251 0.000133748 8.6227e-05 5.44252e-05 3.30514e-05 
    1.93926e-05 1.09814e-05 5.29857e-06 1.92247e-06 3.08708e-07 
    -3.74311e-07 -6.11121e-07 -7.27807e-07 -4.87604e-07 -4.80493e-07 
    -9.15925e-07 -2.03774e-06 -4.01128e-06 -2.46644e-06 2.10626e-06 
    8.22422e-06 1.04922e-05 9.83047e-06 7.27106e-06 3.29654e-06 
    -2.06736e-06 -2.18019e-06 -2.29303e-06 -2.40586e-06 -2.51869e-06 
    -2.63153e-06 -2.24615e-06 -1.70325e-06 -1.16036e-06 -6.17468e-07 
    -7.45754e-08 2.45198e-07 2.88285e-07 3.31373e-07 3.7446e-07 
    4.17548e-07 4.60635e-07 5.03723e-07 5.4681e-07 5.89898e-07 
    6.32985e-07 6.76073e-07 6.19054e-07 5.4001e-07 4.60967e-07 
    3.81923e-07 3.02879e-07 2.23836e-07 1.44792e-07 6.57488e-08 
    -1.32948e-08 -9.23383e-08 -1.6698e-07 -2.23206e-07 -2.79432e-07 
    -3.35658e-07 -3.91884e-07 -4.48109e-07 -5.04335e-07 -5.60561e-07 
    -6.16787e-07 
}
.graph element create V24 -x x -y v24

v25 set {
    1.34824 1.35838 1.36465 1.34675 1.29167 1.23161 1.2201 1.2185 
    1.2181 1.21798 1.21793 1.21788 1.21785 1.21782 1.21779 1.21776 
    1.21655 1.21656 1.21669 1.21871 1.22421 1.22247 1.21858 
    1.2228 1.23803 1.27737 1.10647 0.395248 0.0600669 0.027687 
    0.0192374 0.015425 0.0130881 0.00977445 0.00696598 0.00491122 
    0.00341952 0.00237078 0.00162339 0.00109178 0.000726647 
    0.000478886 0.00031568 0.000207902 0.000143494 0.000109768 
    8.62987e-05 5.69775e-05 3.36547e-05 2.30356e-05 1.86108e-05 
    1.41861e-05 1.08293e-05 7.68835e-06 4.79593e-06 4.51019e-06 
    4.22444e-06 3.9387e-06 3.65295e-06 3.36721e-06 3.04559e-06 
    2.69981e-06 2.35403e-06 2.00825e-06 1.66247e-06 1.34508e-06 
    1.26225e-06 1.17941e-06 1.09657e-06 1.01373e-06 9.30893e-07 
    8.48054e-07 7.65216e-07 6.82378e-07 5.9954e-07 5.16702e-07 
    4.37489e-07 3.82774e-07 3.2806e-07 2.73346e-07 2.18632e-07 
    1.63917e-07 1.09203e-07 5.4489e-08 -2.2523e-10 -5.49395e-08 
    -1.09654e-07 -1.52862e-07 -1.3079e-07 -1.08718e-07 -8.6646e-08 
    -6.45739e-08 -4.25019e-08 -2.04298e-08 1.64229e-09 2.37144e-08 
    4.57864e-08 6.78585e-08 8.71693e-08 9.30725e-08 9.89758e-08 
    1.04879e-07 1.10782e-07 1.16685e-07 1.22589e-07 1.28492e-07 
    1.34395e-07 1.40298e-07 1.46201e-07 1.52105e-07 1.58008e-07 
    1.63911e-07 1.69814e-07 1.75718e-07 1.81621e-07 1.87524e-07 
    1.93427e-07 1.9933e-07 2.05234e-07 2.11137e-07 2.19788e-07 
    0.000393944 -0.000218983 -0.00105784 0.00172403 -0.00027134 
    -0.000204147 8.79968e-06 5.93762e-05 5.83554e-05 4.13815e-05 
    3.71369e-05 3.03372e-05 2.25336e-05 1.5986e-05 1.07284e-05 
    -7.5239e-05 5.60593e-05 6.97571e-05 0.000667617 0.000960856 
    0.00131749 -0.00759564 -0.0217897 -0.0450321 -0.076646 -0.128569 
    -0.186391 -0.202175 -0.206953 -0.2082 -0.208416 -0.208669 
    -0.208934 -0.209111 -0.209234 -0.209329 -0.209389 -0.209416 
    -0.2094 -0.209329 -0.20926 -0.209204 -0.209208 -0.209285 
    -0.209454 -0.209641 -0.20977 -0.209811 -0.209833 -0.209887 
    -0.209653 -0.209127 -0.208893 -0.208811 -0.208777 -0.208758 
    -0.208747 -0.20874 -0.208726 -0.208697 -0.208657 -0.208611 
    -0.208565 -0.208524 -0.208488 -0.208451 -0.208412 -0.208373 
    -0.208333 -0.208294 -0.208256 -0.208219 -0.208183 -0.208145 
    -0.208107 -0.208066 -0.208029 -0.207993 -0.207959 -0.207923 
    -0.207883 -0.207838 -0.207789 -0.207747 -0.20771 -0.207675 
    -0.207642 -0.207605 -0.207568 -0.207531 -0.207494 -0.207457 
    -0.20742 -0.207383 -0.207346 -0.207308 -0.207271 -0.207233 
    -0.207196 -0.207158 -0.207121 -0.207084 -0.207046 -0.207009 
    -0.206972 -0.206935 -0.206898 -0.206861 -0.206823 -0.206786 
    -0.206749 -0.206712 -0.206675 -0.206638 -0.2066 -0.206563 
    -0.206526 -0.206489 -0.206452 -0.206415 -0.203384 -0.20015 
    -0.196872 -0.205024 -0.210727 -0.206779 -0.0685263 0.586138 
    1.4665 2.22945 2.77554 3.076 3.24926 3.34515 3.40164 3.43006 
    3.43713 3.43075 3.42886 3.4384 3.46567 3.49025 3.51287 3.53821 
    3.57841 3.39846 2.80753 2.22947 1.7549 1.30429 0.707786 
    0.303206 0.131352 0.0671706 0.0429955 0.032461 0.0257161 
    0.0239521 0.0217397 0.0179705 0.0138745 0.0102813 0.00749643 
    0.0054328 0.00386817 0.0027004 0.00189442 0.00135552 0.000954715 
    0.000659981 0.000453435 0.000313993 0.000231347 0.000159665 
    0.000108122 7.10528e-05 4.50233e-05 2.77892e-05 1.62765e-05 
    8.9893e-06 4.5471e-06 1.54614e-06 -1.6542e-07 -8.68508e-07 
    -1.04369e-06 -9.63086e-07 -8.44294e-07 -6.57339e-07 -7.35885e-07 
    -9.80056e-07 -1.39772e-06 -2.10199e-06 -1.37474e-06 6.13269e-07 
    3.3028e-06 4.60941e-06 4.91053e-06 4.14186e-06 2.45258e-06 
    -8.7388e-09 -3.59647e-07 -7.10554e-07 -1.06146e-06 -1.41237e-06 
    -1.76328e-06 -1.63073e-06 -1.34534e-06 -1.05995e-06 -7.74561e-07 
    -4.8917e-07 -2.95733e-07 -2.16326e-07 -1.3692e-07 -5.75135e-08 
    2.18929e-08 1.01299e-07 1.80706e-07 2.60112e-07 3.39519e-07 
    4.18925e-07 4.98332e-07 4.83984e-07 4.4901e-07 4.14035e-07 
    3.79061e-07 3.44087e-07 3.09112e-07 2.74138e-07 2.39163e-07 
    2.04189e-07 1.69215e-07 1.26002e-07 4.83213e-08 -2.9359e-08 
    -1.07039e-07 -1.8472e-07 -2.624e-07 -3.4008e-07 -4.1776e-07 
    -4.95441e-07 
}
.graph element create V25 -x x -y v25

v26 set {
    7.10441e-10 0.000309731 -0.000308186 -0.001694 -0.00360784 
    8.40909e-05 0.00203175 0.0012896 0.000596548 0.000277191 
    0.000161134 0.000120439 8.4915e-05 9.49929e-05 6.18812e-05 
    1.65433e-05 1.89682e-05 3.97578e-05 4.95446e-05 0.000225325 
    0.000214579 -0.00230134 -0.000451102 0.00997237 0.0341443 
    0.0449314 0.0424411 0.0341996 0.0315315 0.0308892 0.0291614 
    0.024365 0.0190282 0.0188976 0.017238 0.0138526 0.0105645 
    0.00778548 0.00561753 0.0039871 0.00279554 0.00194075 0.0013468 
    0.000934775 0.000664723 0.000498911 0.000377384 0.000254183 
    0.000163421 0.000120773 9.65058e-05 7.22384e-05 5.60316e-05 
    4.14549e-05 2.79516e-05 2.57096e-05 2.34677e-05 2.12257e-05 
    1.89837e-05 1.67417e-05 1.46737e-05 1.27228e-05 1.07719e-05 
    8.82099e-06 6.87009e-06 5.0896e-06 4.71705e-06 4.34451e-06 
    3.97196e-06 3.59941e-06 3.22686e-06 2.85431e-06 2.48176e-06 
    2.10921e-06 1.73666e-06 1.36411e-06 1.02855e-06 9.42931e-07 
    8.57316e-07 7.71701e-07 6.86086e-07 6.00471e-07 5.14856e-07 
    4.29241e-07 3.43626e-07 2.58011e-07 1.72396e-07 9.85409e-08 
    9.14091e-08 8.42773e-08 7.71456e-08 7.00138e-08 6.2882e-08 
    5.57503e-08 4.86185e-08 4.14867e-08 3.4355e-08 2.72232e-08 
    2.05821e-08 1.63235e-08 1.2065e-08 7.80643e-09 3.54786e-09 
    -7.10696e-10 -4.96926e-09 -9.22782e-09 -1.34864e-08 -1.77449e-08 
    -2.20035e-08 -2.62621e-08 -3.05206e-08 -3.47792e-08 -3.90378e-08 
    -4.32963e-08 -4.75549e-08 -5.18134e-08 -5.6072e-08 -6.03306e-08 
    -6.45891e-08 -6.88477e-08 -8.76373e-06 0.000131607 -0.00021685 
    -0.000433027 0.00047234 0.000211593 -0.000189601 3.2492e-05 
    0.000575955 7.72235e-05 -0.000285172 -0.000242061 -0.000135112 
    -3.50117e-05 -2.75868e-05 5.48974e-05 1.80604e-07 5.48911e-05 
    3.97478e-05 0.000192909 0.000297932 0.00402253 -0.0122366 
    -0.047853 -0.0963082 -0.108071 -0.0567275 -0.0239271 -0.0178628 
    -0.0233027 -0.031853 -0.0400843 -0.0482725 -0.0576154 -0.0627218 
    -0.0511236 -0.0279524 -0.0150986 -0.00931091 -0.00652876 
    -0.00479286 -0.00344346 -0.00249578 -0.0019532 -0.00157977 
    -0.00131848 -0.00111251 -0.000939229 -0.000797445 -0.000708384 
    -0.000630452 -0.000539722 -0.000508862 -0.000480596 -0.000439484 
    -0.000407217 -0.000363866 -0.000329506 -0.000318642 -0.000307362 
    -0.000286511 -0.000266253 -0.000242943 -0.000218107 -0.000204661 
    -0.00020241 -0.000194435 -0.000185062 -0.000173042 -0.000160549 
    -0.000151407 -0.000145626 -0.000145976 -0.000147342 -0.000145288 
    -0.000137979 -0.000124481 -0.000123218 -0.000127453 -0.000139006 
    -0.000145486 -0.000129764 -9.82749e-05 -4.72596e-05 -3.08671e-05 
    -3.28834e-05 -4.52254e-05 -6.25389e-05 -6.32516e-05 -6.39643e-05 
    -6.4677e-05 -6.53897e-05 -6.61023e-05 -6.6815e-05 -6.75277e-05 
    -6.61005e-05 -6.45173e-05 -6.29341e-05 -6.13509e-05 -5.97676e-05 
    -5.81844e-05 -5.66012e-05 -5.54231e-05 -5.4455e-05 -5.3487e-05 
    -5.25189e-05 -5.15508e-05 -5.05828e-05 -4.96147e-05 -4.86466e-05 
    -4.76785e-05 -4.67105e-05 -4.57424e-05 -4.47743e-05 -4.38063e-05 
    -4.28382e-05 -4.18821e-05 -4.10211e-05 -4.016e-05 -3.9299e-05 
    -3.8438e-05 4.29885e-05 5.14113e-05 -0.000127986 -0.000611463 
    -0.000149428 0.000882394 0.00297059 -0.00405825 -0.00591067 
    -0.00546997 -0.00158744 0.00190677 0.00298403 0.00268595 
    0.00196161 0.00130289 0.000783347 0.000520683 0.000565306 
    0.00053419 -0.00224696 -0.000920818 0.0132755 0.0322504 
    0.0442808 0.0638615 0.0701007 0.0539356 0.0247771 0.056244 
    0.294266 0.831368 1.45424 2.02898 2.54559 2.9937 3.35333 
    3.72609 4.06363 4.32789 4.52413 4.66504 4.7652 4.83637 4.88631 
    4.92109 4.94464 4.96046 4.97218 4.98079 4.98679 4.99076 
    4.99361 4.99555 4.99686 4.99783 4.99853 4.99902 4.99936 
    4.99959 4.99973 4.99983 4.9999 4.99993 4.99996 4.99998 5 
    5.00001 5 4.99999 4.99997 4.99994 4.99993 4.99994 4.99996 
    4.99999 5.00004 5.00006 5.00005 5.00003 5.00002 5.00001 
    5 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    5 5 5 5 5 5 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 4.99999 4.99998 
    
}
.graph element create V26 -x x -y v26

v27 set {
    5 4.99984 4.99796 4.99478 4.9889 4.98738 4.98896 4.99087 
    4.99262 4.99419 4.99552 4.99659 4.99743 4.99807 4.99855 
    4.9989 4.99894 4.99908 4.99935 5.00001 5.0007 5.00132 5.00032 
    4.99976 5.00134 5.00339 5.00315 5.00157 5.00091 5.00058 
    5.00012 4.99944 4.99886 4.9994 4.99934 4.99899 4.99876 4.99868 
    4.99872 4.99883 4.99898 4.99914 4.9993 4.99944 4.99956 4.99967 
    4.99976 4.99982 4.99986 4.9999 4.99993 4.99997 4.99997 4.99998 
    4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 
    4.99999 4.99999 4.99999 4.99999 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5.00009 5.00028 5.00015 4.99983 
    5.00036 4.99996 4.99834 4.99783 5.00383 5.00734 5.00387 
    5.00058 4.99893 4.99836 4.99832 4.99854 4.99873 4.99905 
    4.99927 4.99952 4.99969 4.99834 4.99536 4.99163 4.99073 
    5.0053 5.03631 5.03103 4.9008 4.62503 4.21887 3.70902 3.09967 
    2.35791 1.41912 0.519675 0.210458 0.131362 0.0980819 0.0708209 
    0.0471701 0.0323272 0.0253535 0.0199144 0.0152615 0.0117228 
    0.00917696 0.00738117 0.00609292 0.00512664 0.00436184 0.0037961 
    0.00331639 0.00289006 0.0025477 0.00226529 0.00202925 0.00182793 
    0.00165474 0.00150531 0.00137529 0.00125983 0.00115603 0.00106455 
    0.000982977 0.000911255 0.000846819 0.000790092 0.000738698 
    0.000692816 0.00065107 0.000613595 0.000579642 0.000548935 
    0.00052106 0.000495598 0.000472174 0.000450849 0.000431118 
    0.000412667 0.000395868 0.000381319 0.000368487 0.000357327 
    0.000344212 0.000330334 0.00031622 0.000303298 0.000295809 
    0.00028832 0.000280831 0.000273342 0.000265853 0.000258364 
    0.000250875 0.000245118 0.000239488 0.000233857 0.000228227 
    0.000222596 0.000216966 0.000211336 0.000207047 0.000203455 
    0.000199863 0.00019627 0.000192678 0.000189085 0.000185493 
    0.0001819 0.000178308 0.000174716 0.000171123 0.000167531 
    0.000163938 0.000160346 0.000156835 0.000153973 0.00015111 
    0.000148248 0.000145385 0.000296579 -3.96718e-05 -0.000449085 
    0.000323433 0.000750086 0.000268264 0.000149028 -0.000100249 
    7.00956e-05 0.00012605 0.00022592 0.000193036 0.000120453 
    8.07865e-05 7.65771e-05 -3.27828e-05 0.000116759 0.000169498 
    0.000409804 0.000414965 0.00092323 -0.00590633 -0.0175477 
    -0.032433 -0.0559842 -0.0820373 0.0688484 0.626629 1.32929 
    2.01657 2.60925 3.12329 3.38952 3.14128 2.38463 1.23802 
    0.316019 0.107832 0.0694707 0.051837 0.035247 0.0209999 
    0.0116618 0.00967674 0.00789182 0.00574566 0.00386872 0.00258612 
    0.00167126 0.00104169 0.000641093 0.000401246 0.000277928 
    0.000171775 0.000102266 5.89376e-05 3.29258e-05 1.80463e-05 
    1.0057e-05 6.4571e-06 5.10093e-06 4.06791e-06 3.62716e-06 
    3.63321e-06 3.99625e-06 4.64368e-06 5.20886e-06 4.77728e-06 
    3.23919e-06 1.14113e-06 -1.29416e-06 -4.15607e-06 -1.88532e-06 
    5.24411e-06 1.38678e-05 1.28823e-05 3.6758e-06 -2.52285e-06 
    -3.97133e-06 -4.03071e-06 -3.37154e-06 -2.71238e-06 -2.05321e-06 
    -1.39404e-06 -7.34872e-07 -3.73325e-07 -1.05873e-07 1.61578e-07 
    4.2903e-07 6.96482e-07 8.18468e-07 7.60065e-07 7.01662e-07 
    6.43258e-07 5.84855e-07 5.26452e-07 4.68049e-07 4.09646e-07 
    3.51243e-07 2.9284e-07 2.34437e-07 1.71213e-07 1.06928e-07 
    4.2644e-08 -2.16403e-08 -8.59247e-08 -1.50209e-07 -2.14493e-07 
    -2.78778e-07 -3.43062e-07 -4.07346e-07 -4.55065e-07 -4.3348e-07 
    -4.11896e-07 -3.90311e-07 -3.68726e-07 -3.47141e-07 -3.25556e-07 
    -3.03971e-07 -2.82386e-07 
}
.graph element create V27 -x x -y v27

v28 set {
    0.368163 0.361756 0.327463 0.269513 0.149476 0.0805716 0.0501146 
    0.03403 0.0230886 0.0160474 0.0116071 0.00870013 0.00679614 
    0.00542384 0.00432512 0.00340653 -0.00129719 -0.00399429 
    -0.00318719 0.00443085 0.0150156 0.0334147 0.0132288 -0.0189751 
    -0.0508377 -0.0252174 -0.0142489 -0.00675908 -0.0038653 
    -0.00243423 -0.00168891 -0.00120901 -0.000900426 -0.000685575 
    -0.000557595 -0.000457268 -0.000377427 -0.000315269 -0.000266613 
    -0.000228397 -0.000198283 -0.000174248 -0.000154886 -0.00013892 
    -0.000125864 -0.000115189 -0.000105841 -9.66611e-05 -8.84262e-05 
    -8.23872e-05 -7.74668e-05 -7.25463e-05 -6.79992e-05 -6.35276e-05 
    -5.92413e-05 -5.68994e-05 -5.45574e-05 -5.22154e-05 -4.98735e-05 
    -4.75315e-05 -4.54981e-05 -4.36726e-05 -4.18471e-05 -4.00216e-05 
    -3.81961e-05 -3.64559e-05 -3.54209e-05 -3.43858e-05 -3.33508e-05 
    -3.23157e-05 -3.12807e-05 -3.02456e-05 -2.92105e-05 -2.81755e-05 
    -2.71404e-05 -2.61054e-05 -2.51232e-05 -2.44984e-05 -2.38736e-05 
    -2.32487e-05 -2.26239e-05 -2.19991e-05 -2.13742e-05 -2.07494e-05 
    -2.01246e-05 -1.94998e-05 -1.88749e-05 -1.82865e-05 -1.79044e-05 
    -1.75224e-05 -1.71403e-05 -1.67582e-05 -1.63762e-05 -1.59941e-05 
    -1.56121e-05 -1.523e-05 -1.4848e-05 -1.44659e-05 -1.41138e-05 
    -1.39075e-05 -1.37011e-05 -1.34947e-05 -1.32883e-05 -1.30819e-05 
    -1.28755e-05 -1.26691e-05 -1.24627e-05 -1.22563e-05 -1.205e-05 
    -1.18436e-05 -1.16372e-05 -1.14308e-05 -1.12244e-05 -1.1018e-05 
    -1.08116e-05 -1.06052e-05 -1.03988e-05 -1.01924e-05 -9.98605e-06 
    -9.77966e-06 -2.85319e-05 0.00281092 0.00180106 -0.000981083 
    0.00551926 -0.00119763 -0.0295069 -0.0367677 0.064749 0.119022 
    0.0882007 0.0552062 0.03418 0.0223243 0.015545 0.011949 
    0.00757134 0.00667655 0.00583243 0.00644443 0.00650959 -0.0302575 
    -0.0437806 -0.0355466 0.0381776 0.282109 0.674178 1.07582 
    1.45189 1.789 2.08649 2.34663 2.57245 2.81211 3.04778 3.2523 
    3.45877 3.65593 3.83396 3.9923 4.13368 4.25864 4.36719 4.46064 
    4.54086 4.60962 4.66835 4.71838 4.76094 4.79716 4.82796 
    4.85413 4.87634 4.89518 4.91116 4.92476 4.93631 4.94608 
    4.95434 4.9613 4.96715 4.97211 4.97638 4.98001 4.98312 4.98571 
    4.98795 4.98979 4.99138 4.99269 4.99381 4.99474 4.99551 
    4.99615 4.99668 4.99713 4.99752 4.99783 4.99811 4.99836 
    4.99858 4.99873 4.99884 4.99892 4.999 4.99907 4.99912 4.99916 
    4.99921 4.99926 4.99932 4.99937 4.99942 4.99948 4.99953 
    4.99956 4.99958 4.99961 4.99963 4.99966 4.99968 4.99971 
    4.99972 4.99973 4.99974 4.99975 4.99976 4.99977 4.99978 
    4.99979 4.9998 4.9998 4.99981 4.99982 4.99983 4.99984 4.99985 
    4.99986 4.99986 4.99987 4.99987 5.00498 5.00354 4.99359 
    4.98981 5.00498 5.00099 5.00041 5.00022 5.00015 5.00012 
    5.0001 5.00008 5.00005 5.00003 5 4.99431 4.99459 4.99591 
    5.00087 5.01029 5.03935 4.92784 4.51643 3.78356 2.68745 
    1.43417 0.583128 0.205094 0.0777337 0.0391566 0.02723 0.023883 
    0.018808 0.010165 0.00254623 -0.00377463 -0.0038097 0.00144145 
    0.00267231 0.00193045 0.00144538 0.00121758 0.00112893 0.00109424 
    0.0010226 0.000948072 0.000882573 0.000826996 0.000776391 
    0.000729719 0.000686499 0.000647333 0.000610108 0.000575631 
    0.000545069 0.000515485 0.000488514 0.000465316 0.000443215 
    0.000422454 0.00040292 0.00038488 0.000368472 0.000353628 
    0.000339643 0.000326197 0.000313483 0.000302884 0.000294038 
    0.000284003 0.000270941 0.000254925 0.000246511 0.000244089 
    0.000245538 0.000242099 0.000235728 0.000227482 0.000218001 
    0.000207257 0.000202127 0.000196997 0.000191868 0.000186738 
    0.000181608 0.00017758 0.000173899 0.000170219 0.000166538 
    0.000162857 0.000159576 0.00015679 0.000154005 0.000151219 
    0.000148433 0.000145647 0.000142861 0.000140076 0.00013729 
    0.000134504 0.000131718 0.000129603 0.000127635 0.000125668 
    0.0001237 0.000121732 0.000119765 0.000117797 0.000115829 
    0.000113862 0.000111894 0.000109993 0.000108372 0.000106751 
    0.00010513 0.000103509 0.000101887 0.000100266 9.86449e-05 
    9.70237e-05 
}
.graph element create V28 -x x -y v28

v29 set {
    5 4.99899 4.99654 4.99327 4.9863 4.98954 4.99212 4.99378 
    4.9951 4.99624 4.99715 4.99786 4.99839 4.99879 4.99909 4.99931 
    4.99922 4.99933 4.99971 5.00064 5.00084 5.00123 4.99865 
    4.99853 4.99983 5.00457 5.00242 5.00105 5.00062 5.00042 
    4.99971 4.9994 4.9992 4.9996 4.99955 4.99932 4.99918 4.99915 
    4.99919 4.99927 4.99937 4.99948 4.99957 4.99966 4.99974 
    4.9998 4.99985 4.99989 4.99992 4.99993 4.99994 4.99994 4.99996 
    4.99998 5 5 5.00001 5.00001 5.00001 5.00002 5.00002 5.00001 
    5.00001 5.00001 5 5 5 5 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99998 4.99998 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 5 5 5 5 
    5 5 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00002 5.00002 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5 5 5 5 5 5 4.9997 4.99998 4.99954 4.99963 
    5.00059 4.99945 4.99732 4.99957 5.00919 5.00558 5.00033 
    4.99851 4.9983 4.99854 4.99871 4.99928 4.99914 4.99939 4.99952 
    4.9998 4.99976 4.99744 4.99598 4.99478 4.99806 5.01911 5.04602 
    5.05469 5.01317 4.89484 4.69655 4.42036 4.06069 3.60793 
    3.12531 2.72975 2.45187 2.25081 2.09841 1.98509 1.90211 
    1.84084 1.79411 1.7574 1.72763 1.70283 1.68188 1.66389 1.64823 
    1.63438 1.62201 1.61088 1.60081 1.59163 1.58323 1.57549 
    1.56835 1.56173 1.55558 1.54985 1.54451 1.53951 1.53479 
    1.53035 1.52615 1.5222 1.51845 1.5149 1.51153 1.50834 1.50529 
    1.5024 1.49964 1.497 1.49449 1.49208 1.48977 1.48755 1.48542 
    1.48336 1.48138 1.47948 1.47765 1.4759 1.47419 1.47255 1.47096 
    1.46949 1.46823 1.46696 1.4657 1.46444 1.46317 1.46191 1.46065 
    1.45956 1.4585 1.45743 1.45636 1.45529 1.45422 1.45315 1.45226 
    1.45145 1.45064 1.44983 1.44902 1.44821 1.4474 1.44659 1.44579 
    1.44498 1.44417 1.44336 1.44255 1.44174 1.44094 1.44019 
    1.43944 1.43868 1.43793 1.43765 1.43679 1.43515 1.43405 
    1.43478 1.43387 1.43345 1.43184 1.43086 1.43021 1.43003 
    1.42988 1.42944 1.42883 1.42818 1.42702 1.42642 1.42595 
    1.42586 1.42616 1.42783 1.41733 1.38106 1.30738 1.3877 2.09819 
    3.05285 3.58059 3.77601 3.87609 4.02557 4.24887 4.4608 4.60411 
    4.72109 4.8255 4.90465 4.97379 5.01253 5.01532 5.01239 5.0092 
    5.00665 5.00474 5.00333 5.00232 5.00163 5.00117 5.00082 
    5.00057 5.00039 5.00027 5.00019 5.00013 5.00009 5.00006 
    5.00004 5.00003 5.00002 5.00001 5.00001 5 5 5 4.99998 4.99995 
    4.99992 4.99996 5.00005 5.00012 5.00008 4.99996 4.9999 4.99985 
    4.99986 4.99997 5.00021 5.0003 5.00024 5.00009 5.00007 5.00005 
    5.00003 5.00001 4.99998 4.99998 4.99998 4.99999 4.99999 
    5 5 5 5 5 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00002 5.00002 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 4.99998 
    4.99998 4.99998 
}
.graph element create V29 -x x -y v29
v30 set {
    7.10441e-10 5.70385e-05 0.000226143 0.000131916 -0.000887764 
    -8.01837e-05 -3.49653e-05 9.40039e-05 0.000118663 0.000108025 
    8.6059e-05 6.33268e-05 4.99295e-05 3.16843e-05 3.60692e-05 
    2.07572e-05 -8.6375e-05 3.44583e-05 8.07397e-05 0.000196296 
    0.000115615 -7.12768e-05 -0.000129812 -4.18679e-05 7.94364e-05 
    0.000182034 -5.41226e-05 -0.000451819 -0.000713937 -0.00129863 
    -0.00262186 -0.00213417 -0.00133767 0.000775698 0.000969902 
    0.000549281 0.000280946 0.000140321 8.6919e-05 7.22446e-05 
    6.5631e-05 6.45263e-05 6.63087e-05 7.17391e-05 7.59042e-05 
    7.59172e-05 7.03353e-05 6.33558e-05 5.31136e-05 4.64278e-05 
    4.40594e-05 4.16909e-05 4.05674e-05 3.96957e-05 3.87875e-05 
    3.74977e-05 3.62079e-05 3.49181e-05 3.36283e-05 3.23385e-05 
    3.12427e-05 3.02775e-05 2.93124e-05 2.83472e-05 2.7382e-05 
    2.64613e-05 2.59077e-05 2.5354e-05 2.48004e-05 2.42468e-05 
    2.36931e-05 2.31395e-05 2.25859e-05 2.20322e-05 2.14786e-05 
    2.0925e-05 2.03916e-05 1.9995e-05 1.95984e-05 1.92019e-05 
    1.88053e-05 1.84087e-05 1.80122e-05 1.76156e-05 1.7219e-05 
    1.68225e-05 1.64259e-05 1.6051e-05 1.57991e-05 1.55471e-05 
    1.52952e-05 1.50433e-05 1.47913e-05 1.45394e-05 1.42875e-05 
    1.40356e-05 1.37836e-05 1.35317e-05 1.32978e-05 1.31513e-05 
    1.30048e-05 1.28583e-05 1.27118e-05 1.25653e-05 1.24188e-05 
    1.22724e-05 1.21259e-05 1.19794e-05 1.18329e-05 1.16864e-05 
    1.15399e-05 1.13934e-05 1.12469e-05 1.11005e-05 1.0954e-05 
    1.08075e-05 1.0661e-05 1.05145e-05 1.0368e-05 1.02215e-05 
    1.76447e-05 7.21516e-05 -3.59786e-05 -0.000159618 0.000156236 
    0.000135106 -0.000336402 -0.000302283 0.000699323 0.000473866 
    -0.000156146 -0.000225625 -0.000123592 -3.78116e-05 8.47472e-06 
    2.43387e-06 -7.44762e-05 7.80111e-05 9.43608e-05 0.000170159 
    8.83919e-05 -0.00018802 -0.000373512 -0.000390597 0.000156875 
    0.0032343 0.00776304 -0.000566905 -0.00760695 -0.0159226 
    -0.0245989 -0.0331402 -0.0100902 0.067837 0.266702 0.910818 
    1.82282 2.69714 3.43247 3.98325 4.32893 4.51529 4.67087 
    4.79288 4.87574 4.92797 4.95902 4.97655 4.98622 4.99195 
    4.99526 4.99735 4.9991 4.99974 4.99982 4.99974 4.99961 4.9995 
    4.99943 4.9994 4.9994 4.99942 4.99944 4.99948 4.99952 4.99956 
    4.99961 4.99965 4.9997 4.99974 4.99977 4.99981 4.99983 4.99986 
    4.99988 4.9999 4.99991 4.99992 4.99993 4.99994 4.99995 4.99995 
    4.99996 4.99997 4.99997 4.99998 4.99998 4.99999 4.99999 
    4.99999 5 5 5 5.00001 5.00001 5.00001 5.00001 5.00001 5 
    5 5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 5 5.00019 4.99888 4.99663 4.99457 4.99902 
    5.00229 5.00323 5.00302 5.0023 5.0015 5.00085 5.00041 5.00013 
    4.99993 4.99979 4.99948 4.99954 4.99983 5.00055 5.00109 
    5.00009 4.9987 4.998 4.99755 4.99676 4.99618 5.01091 5.05272 
    5.04156 4.80112 4.27692 3.42343 2.23953 0.967179 0.429813 
    0.540757 1.32991 2.32147 3.14903 3.78143 4.22325 4.47978 
    4.59448 4.69875 4.79798 4.87419 4.92339 4.95249 4.97174 
    4.98408 4.99124 4.99478 4.99729 4.99868 4.9992 4.99941 4.99947 
    4.99946 4.99943 4.9994 4.99939 4.9994 4.99942 4.99946 4.99951 
    4.99956 4.99961 4.99967 4.99973 4.99977 4.9998 4.99981 4.99983 
    4.99984 4.99987 4.99992 5.00001 5.00005 5.00001 4.99994 
    4.99995 4.99995 4.99996 4.99996 4.99996 4.99997 4.99997 
    4.99997 4.99998 4.99998 4.99998 4.99998 4.99999 4.99999 
    4.99999 4.99999 5 5 5 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5 5 5 5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 
    4.99998 4.99998 4.99998 
}
.graph element create V30 -x x -y v30

v31 set {
    1.8179e-09 -5.28841e-06 -1.44913e-05 -3.62932e-05 -9.75719e-05 
    0.000141781 3.73396e-05 -1.65603e-05 -1.5271e-05 -6.73884e-06 
    4.40157e-06 -4.85345e-06 -1.02964e-05 2.03126e-05 -1.89457e-05 
    -8.75564e-06 7.67422e-06 4.71103e-06 1.29798e-05 6.13469e-06 
    -1.14363e-05 -0.0394563 -0.0477298 -0.0622012 -0.0519225 
    0.262499 0.943611 1.67052 2.31017 2.84028 3.28467 3.61582 
    3.85887 4.13011 4.36511 4.54063 4.67013 4.76408 4.83263 
    4.8825 4.91837 4.94373 4.96117 4.97318 4.98093 4.98562 4.98906 
    4.99267 4.99539 4.99666 4.99731 4.99797 4.99844 4.99887 
    4.99927 4.99933 4.99938 4.99944 4.99949 4.99955 4.9996 4.99965 
    4.9997 4.99975 4.9998 4.99985 4.99986 4.99987 4.99989 4.9999 
    4.99991 4.99992 4.99993 4.99995 4.99996 4.99997 4.99998 
    4.99998 4.99999 4.99999 4.99999 4.99999 5 5 5 5 5.00001 
    5.00001 5.00001 5 5 5 5 5 5 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99997 5.00002 5.00004 5.0001 5.0001 4.99987 5.00009 
    5.00021 5.00002 5.00004 4.99988 5.00013 4.99993 5.00026 
    4.99973 5 5.00006 5.00009 5.00004 5.00004 5.04854 4.82711 
    4.04208 2.64155 0.838902 0.19014 0.0982549 0.0723197 0.0576863 
    0.0427644 0.0301979 0.020146 0.0135728 0.00980358 0.00774482 
    0.00586604 0.0036687 0.00211511 0.00121906 0.000647581 0.000828436 
    0.00190938 0.00224254 0.00199956 0.00165488 0.00135612 0.00113715 
    0.000984181 0.000877175 0.000789973 0.000741139 0.000689338 
    0.000625676 0.000586082 0.000550152 0.000529573 0.000505606 
    0.000482117 0.000460574 0.000441649 0.000424674 0.000408398 
    0.000391914 0.000376272 0.000361487 0.000348181 0.000336045 
    0.000324466 0.000313545 0.000303046 0.000293056 0.00028356 
    0.000274586 0.000266155 0.000258279 0.000250938 0.000243789 
    0.000236912 0.000230244 0.000224186 0.000219291 0.000215346 
    0.000212468 0.000207291 0.000200862 0.00019368 0.000186767 
    0.000183515 0.000180263 0.00017701 0.000173758 0.000170506 
    0.000167253 0.000164001 0.000161164 0.000158357 0.00015555 
    0.000152743 0.000149936 0.000147129 0.000144322 0.000142066 
    0.000140096 0.000138127 0.000136157 0.000134187 0.000132218 
    0.000130248 0.000128278 0.000126308 0.000124339 0.000122369 
    0.000120399 0.000118429 0.00011646 0.000114527 0.000112892 
    0.000111258 0.000109623 0.000107988 0.000103598 6.86052e-05 
    3.337e-05 7.00783e-05 0.000218764 0.000221318 0.000118593 
    -0.000113962 5.78552e-05 9.42068e-05 0.000237037 0.000171302 
    0.0001033 6.16066e-05 5.52908e-05 6.30233e-05 7.01897e-05 
    8.48573e-05 0.000106859 8.37213e-05 -0.0391541 -0.047722 
    -0.0618454 -0.0169804 0.345725 1.03426 1.74825 2.37152 2.88737 
    3.32173 3.66761 3.9707 4.17762 3.98832 3.30483 2.09737 0.710892 
    0.148159 0.0707463 0.0555808 0.045618 0.0319116 0.0199589 
    0.0133357 0.00898528 0.00586075 0.00375478 0.00245443 0.00156038 
    0.000962344 0.000590953 0.000375107 0.000250243 0.00015882 
    0.000100203 6.18122e-05 3.7372e-05 2.23009e-05 1.32569e-05 
    8.29437e-06 5.72457e-06 3.96832e-06 2.98935e-06 2.59699e-06 
    2.75024e-06 3.38689e-06 4.0453e-06 3.50095e-06 1.64988e-06 
    -3.84371e-07 -2.03828e-06 -3.46401e-06 -1.24301e-06 4.63458e-06 
    1.14104e-05 1.02619e-05 2.15487e-06 -2.98487e-06 -3.67221e-06 
    -2.94279e-06 -2.58649e-06 -2.23019e-06 -1.87389e-06 -1.5176e-06 
    -1.1613e-06 -7.92127e-07 -4.18889e-07 -4.56502e-08 3.27588e-07 
    7.00827e-07 8.79539e-07 8.17025e-07 7.5451e-07 6.91996e-07 
    6.29481e-07 5.66966e-07 5.04452e-07 4.41937e-07 3.79422e-07 
    3.16908e-07 2.54393e-07 1.90078e-07 1.25366e-07 6.0654e-08 
    -4.05776e-09 -6.87696e-08 -1.33481e-07 -1.98193e-07 -2.62905e-07 
    -3.27617e-07 -3.92329e-07 -4.40392e-07 -4.18802e-07 -3.97213e-07 
    -3.75624e-07 -3.54035e-07 -3.32446e-07 -3.10856e-07 -2.89267e-07 
    -2.67678e-07 
}
.graph element create V31 -x x -y v31
v32 set {
    1.10294 1.10297 1.10291 1.10277 1.10259 1.10294 1.10313 
    1.10306 1.10299 1.10296 1.10295 1.10295 1.10294 1.10294 
    1.10294 1.10294 1.10294 1.10294 1.10294 1.10296 1.10296 
    1.00547 0.998599 1.5201 2.49297 3.31258 3.73162 3.84757 
    3.92505 4.02965 4.16599 4.30294 4.41541 4.52886 4.64414 
    4.73865 4.81065 4.86391 4.90315 4.93188 4.95258 4.96726 
    4.97738 4.98436 4.98888 4.99162 4.99363 4.99573 4.99731 
    4.99804 4.99843 4.99881 4.99909 4.99934 4.99957 4.9996 4.99964 
    4.99967 4.9997 4.99973 4.99977 4.9998 4.99983 4.99986 4.99988 
    4.99991 4.99992 4.99992 4.99993 4.99994 4.99994 4.99995 
    4.99996 4.99996 4.99997 4.99997 4.99998 4.99998 4.99999 
    4.99999 4.99999 4.99999 5 5 5 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 5.00028 4.99988 4.99968 
    5.00019 4.99987 5.00021 4.99973 4.99977 4.99996 4.99997 
    5.0002 4.99957 5.00026 4.99947 5.00074 5.00003 4.99987 4.99979 
    5.00008 4.99997 5.08794 5.05993 4.76875 3.99197 3.10174 
    2.5197 2.21771 2.04 1.92235 1.83874 1.77592 1.72665 1.686 
    1.65276 1.6286 1.61299 1.60039 1.58934 1.57954 1.57083 1.56306 
    1.55604 1.54963 1.54375 1.53832 1.53331 1.52865 1.52432 
    1.52026 1.51645 1.51287 1.50949 1.50629 1.50327 1.50039 
    1.49766 1.49505 1.49257 1.49019 1.48792 1.48574 1.48365 
    1.48164 1.47971 1.47784 1.47604 1.47431 1.47264 1.47102 
    1.46945 1.46794 1.46647 1.46505 1.46367 1.46233 1.46103 
    1.45976 1.45853 1.45733 1.45616 1.45502 1.45392 1.45284 
    1.45179 1.45076 1.44975 1.4488 1.44795 1.44711 1.44626 1.44541 
    1.44457 1.44372 1.44287 1.44212 1.44138 1.44063 1.43989 
    1.43914 1.4384 1.43766 1.43701 1.43641 1.43581 1.43522 1.43462 
    1.43402 1.43342 1.43282 1.43223 1.43163 1.43103 1.43043 
    1.42984 1.42924 1.42865 1.42808 1.42752 1.42695 1.42639 
    1.42584 1.42529 1.42472 1.42412 1.42365 1.42326 1.42304 
    1.42162 1.42082 1.42032 1.42029 1.42026 1.41995 1.41947 
    1.41894 1.41841 1.4179 1.41742 1.41699 1.41656 1.32097 1.30963 
    1.78765 2.64656 3.35764 3.747 3.86589 3.94217 4.04185 4.18453 
    4.3561 4.53439 4.68621 4.74905 4.77848 4.84629 4.91261 4.97541 
    5.01284 5.01548 5.01248 5.00924 5.00666 5.00475 5.00334 
    5.00234 5.00164 5.00118 5.00083 5.00058 5.0004 5.00028 5.00019 
    5.00013 5.00009 5.00007 5.00004 5.00003 5.00002 5.00001 
    5.00001 5.00001 5 5 4.99999 4.99995 4.99992 4.99996 5.00006 
    5.00012 5.00009 4.99997 4.9999 4.99985 4.99986 4.99997 5.00021 
    5.00031 5.00024 5.0001 5.00007 5.00005 5.00003 5.00001 4.99998 
    4.99998 4.99999 4.99999 4.99999 5 5 5 5 5 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00002 5.00002 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5 5 5 5 
    5 4.99999 4.99999 4.99999 4.99998 4.99998 4.99998 
}
.graph element create V32 -x x -y v32
v33 set {
    5 5.00012 5.00023 5.0003 4.99972 4.99988 4.99984 4.99991 
    4.99996 4.99999 5.00008 5.00009 4.99986 5.00003 5.00007 
    4.99995 4.9999 4.99997 5.00013 5.00014 5.00013 4.99701 4.99763 
    4.99742 4.99998 5.02836 5.07262 4.96856 4.57267 3.85637 
    2.79544 1.45942 0.408016 0.084885 0.0271375 0.0119294 0.00707546 
    0.0051087 0.00373035 0.00264737 0.00186477 0.00130379 0.000915857 
    0.000653121 0.000483893 0.000380852 0.000302362 0.000219498 
    0.000154435 0.000121928 0.000104026 8.61242e-05 7.48526e-05 
    6.49216e-05 5.56238e-05 5.29689e-05 5.03139e-05 4.7659e-05 
    4.5004e-05 4.23491e-05 4.00356e-05 3.79522e-05 3.58687e-05 
    3.37852e-05 3.17018e-05 2.97592e-05 2.89804e-05 2.82016e-05 
    2.74228e-05 2.66441e-05 2.58653e-05 2.50865e-05 2.43077e-05 
    2.35289e-05 2.27501e-05 2.19714e-05 2.12346e-05 2.07821e-05 
    2.03295e-05 1.98769e-05 1.94244e-05 1.89718e-05 1.85192e-05 
    1.80667e-05 1.76141e-05 1.71615e-05 1.6709e-05 1.62828e-05 
    1.60061e-05 1.57294e-05 1.54527e-05 1.5176e-05 1.48993e-05 
    1.46226e-05 1.43459e-05 1.40692e-05 1.37925e-05 1.35158e-05 
    1.3262e-05 1.31191e-05 1.29761e-05 1.28332e-05 1.26903e-05 
    1.25474e-05 1.24045e-05 1.22615e-05 1.21186e-05 1.19757e-05 
    1.18328e-05 1.16898e-05 1.15469e-05 1.1404e-05 1.12611e-05 
    1.11182e-05 1.09752e-05 1.08323e-05 1.06894e-05 1.05465e-05 
    1.04036e-05 1.02606e-05 1.00185e-05 3.8343e-05 -3.06781e-05 
    -0.000111758 0.000111673 0.000130815 -0.000210491 -0.000231304 
    0.000310226 0.000265303 3.0878e-05 -4.48405e-05 -1.2852e-05 
    -7.84469e-06 3.29986e-05 -1.23286e-05 -6.07871e-05 5.35082e-05 
    7.69194e-05 0.000126221 6.57178e-05 0.00223349 -0.0148854 
    -0.0476636 -0.0491447 0.220125 1.11174 2.03988 2.90209 3.61069 
    4.13554 4.50679 4.71501 4.83916 4.91027 4.95284 4.98086 
    4.99151 4.98651 4.97113 4.95075 4.93102 4.93683 4.95457 
    4.97071 4.98212 4.98948 4.99386 4.99636 4.99785 4.9987 4.99927 
    4.99989 5.00014 5.00007 4.99988 4.99982 4.99976 4.99973 
    4.99972 4.99972 4.99973 4.99974 4.99975 4.99977 4.99979 
    4.99981 4.99984 4.99986 4.99988 4.99989 4.99991 4.99992 
    4.99993 4.99994 4.99995 4.99996 4.99996 4.99997 4.99997 
    4.99998 4.99998 4.99998 4.99998 4.99999 4.99999 4.99999 
    4.99999 5 5 5 5.00001 5.00001 5.00001 5.00002 5.00001 5.00001 
    5.00001 5.00001 5.00001 5 5 5 5 5 5 5 5 4.99999 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 4.99999 
    4.99999 4.99999 4.99999 5 5.00012 4.99946 4.99839 4.99733 
    4.99948 5.00114 5.00158 5.00147 5.00113 5.00073 5.00043 
    5.0002 5.00006 4.99995 4.99986 4.99973 4.99976 4.9999 5.00029 
    5.00055 4.99704 4.99734 4.9972 5.00278 5.03354 5.07184 4.94057 
    4.51936 3.75638 2.60982 1.23803 0.315016 0.0796102 0.0252894 
    0.0165723 0.0827785 0.491298 1.40686 2.33436 3.1251 3.7691 
    4.22201 4.49976 4.68115 4.80513 4.88509 4.93208 4.95861 
    4.97579 4.98655 4.99268 4.99571 4.99771 4.99881 4.99929 
    4.99954 4.99965 4.9997 4.99971 4.99971 4.99971 4.99971 4.99972 
    4.99974 4.99976 4.99978 4.99981 4.99984 4.99987 4.99989 
    4.99991 4.99991 4.99992 4.99992 4.99993 4.99997 5.00003 
    5.00006 5.00004 5.00001 5 4.99999 4.99998 4.99998 4.99997 
    4.99997 4.99997 4.99998 4.99998 4.99998 4.99999 4.99999 
    4.99999 4.99999 5 5 5 5 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5 5 5 5 5 5 5 4.99999 
    4.99999 4.99999 4.99999 4.99998 4.99998 
}
.graph element create V33 -x x -y v33
v34 set {
    5 5.00207 5.00813 5.01486 5.00156 5.0018 4.99861 4.99844 
    4.99888 4.9993 4.99956 4.99971 4.99979 4.99983 4.99987 4.99989 
    4.99671 4.9974 4.99864 5.00131 5.00377 5.0021 5.00039 4.99993 
    5.00004 5.0009 5.00109 4.99636 4.98617 4.96778 4.92047 4.89528 
    4.91112 4.9559 4.98286 4.99369 4.99812 4.99951 4.99994 5.00014 
    5.00008 4.99994 4.99984 4.99989 4.99998 5.00004 5.00004 
    5.00006 5.00005 5.00001 4.99997 4.99992 4.99993 4.99994 
    4.99996 4.99996 4.99996 4.99996 4.99996 4.99996 4.99996 
    4.99996 4.99996 4.99996 4.99996 4.99996 4.99996 4.99996 
    4.99997 4.99997 4.99997 4.99997 4.99997 4.99997 4.99997 
    4.99997 4.99997 4.99997 4.99997 4.99997 4.99997 4.99997 
    4.99997 4.99997 4.99997 4.99997 4.99997 4.99997 4.99997 
    4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 
    4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 
    4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 
    4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 
    4.99998 4.99998 4.99998 4.99998 5.00131 5.00072 4.9977 4.99811 
    5.00325 4.99647 4.98948 4.99459 5.00262 5.00276 5.00156 
    5.00072 5.0003 5.00013 4.99995 4.99668 4.99775 4.99917 5.00173 
    5.00386 5.00188 4.99888 4.99757 4.99951 5.01712 5.0557 5.07088 
    5.07704 5.07758 5.06958 5.04223 5.03331 5.0279 5.03408 5.07611 
    5.01911 4.68594 3.99152 2.92195 1.69878 0.809 0.344091 0.154663 
    0.0788717 0.0467212 0.0336168 0.0280514 0.0254947 0.024173 
    0.0223567 0.0220555 0.0271514 0.0295872 0.0296052 0.0283971 
    0.0264726 0.0241813 0.0218244 0.0195349 0.017368 0.0152495 
    0.013295 0.0115444 0.00996982 0.00857091 0.00733891 0.00627261 
    0.0053494 0.00456316 0.00388373 0.00331073 0.00282181 0.00240991 
    0.00206389 0.00177187 0.00152283 0.00131167 0.00112558 0.000954373 
    0.000805726 0.00069326 0.000600991 0.000525743 0.00047355 
    0.00044359 0.000434815 0.000436053 0.000402511 0.000368969 
    0.000335427 0.000301886 0.000268344 0.000234802 0.00020126 
    0.000184967 0.000169932 0.000154896 0.000139861 0.000124825 
    0.00010979 9.47546e-05 8.67896e-05 8.24901e-05 7.81906e-05 
    7.38911e-05 6.95915e-05 6.5292e-05 6.09925e-05 5.66929e-05 
    5.23934e-05 4.80939e-05 4.37943e-05 3.94948e-05 3.51953e-05 
    3.08957e-05 2.67968e-05 2.42936e-05 2.17904e-05 1.92872e-05 
    1.6784e-05 0.00125927 -0.00794344 -0.0305499 -0.0621697 
    -0.0463796 -0.0224608 -0.00538381 0.00546086 0.0108675 0.012883 
    0.0131787 0.0127271 0.0119702 0.0110398 0.0100635 0.00649617 
    0.00489388 0.00545863 0.0098351 0.0167428 0.0126563 0.00697542 
    0.00427027 0.00330002 0.00390774 0.00408999 -0.00259143 
    -0.0160578 -0.0451849 -0.0409651 0.1301 0.597429 1.3848 
    2.63426 3.81272 4.51373 4.8412 4.98731 4.88165 4.37165 3.40034 
    2.17681 1.12217 0.505129 0.219703 0.104992 0.0622333 0.0448317 
    0.0355782 0.0311867 0.0293529 0.0274615 0.0288739 0.0307845 
    0.0304909 0.029245 0.0273602 0.0251006 0.022697 0.0202765 
    0.0179357 0.0157106 0.0136562 0.0117951 0.0101273 0.00865784 
    0.00739394 0.00634364 0.00551356 0.00480538 0.00415747 0.00356084 
    0.00297585 0.00236711 0.00181853 0.00160713 0.00169822 0.00166542 
    0.00145504 0.00120252 0.00109259 0.000982658 0.00087273 
    0.000762802 0.000652874 0.000584068 0.000528263 0.000472458 
    0.000416653 0.000360848 0.000321155 0.000301442 0.000281729 
    0.000262016 0.000242303 0.00022259 0.000202877 0.000183164 
    0.000163451 0.000143738 0.000124025 0.000114582 0.000107399 
    0.000100216 9.30332e-05 8.58502e-05 7.86672e-05 7.14841e-05 
    6.43011e-05 5.7118e-05 4.9935e-05 4.35378e-05 4.04281e-05 
    3.73184e-05 3.42088e-05 3.10991e-05 2.79894e-05 2.48798e-05 
    2.17701e-05 1.86604e-05 
}
.graph element create V34 -x x -y v34
v35 set {
    7.24585e-12 2.21843e-05 3.20014e-05 1.25076e-05 -2.44947e-05 
    1.8425e-05 5.50546e-06 3.53025e-05 -1.07551e-05 -3.94383e-06 
    -2.27848e-06 -9.04789e-05 7.44215e-05 -2.7662e-05 0.000200038 
    -2.11998e-05 -2.09011e-05 2.37098e-05 2.18751e-05 -2.28422e-05 
    -6.23659e-05 3.58241e-05 1.76386e-05 -4.28311e-05 0.000355626 
    0.00156903 0.00100999 -0.0085304 -0.02067 -0.0389485 -0.0651568 
    -0.128475 -0.314362 -0.406837 -0.421558 -0.421277 -0.418176 
    -0.414481 -0.410845 -0.407348 -0.403971 -0.400716 -0.397582 
    -0.394563 -0.391658 -0.388866 -0.386178 -0.383585 -0.381094 
    -0.378789 -0.376569 -0.37435 -0.372256 -0.370188 -0.36815 
    -0.366422 -0.364694 -0.362967 -0.361239 -0.359511 -0.357888 
    -0.356334 -0.354781 -0.353227 -0.351674 -0.350152 -0.348888 
    -0.347625 -0.346361 -0.345098 -0.343834 -0.342571 -0.341307 
    -0.340044 -0.33878 -0.337517 -0.336279 -0.335215 -0.334152 
    -0.333088 -0.332024 -0.330961 -0.329897 -0.328833 -0.32777 
    -0.326706 -0.325642 -0.324601 -0.323683 -0.322766 -0.321849 
    -0.320932 -0.320014 -0.319097 -0.31818 -0.317263 -0.316345 
    -0.315428 -0.314545 -0.313825 -0.313106 -0.312387 -0.311667 
    -0.310948 -0.310228 -0.309509 -0.308789 -0.30807 -0.307351 
    -0.306631 -0.305912 -0.305192 -0.304473 -0.303754 -0.303034 
    -0.302315 -0.301595 -0.300876 -0.300157 -0.299437 -0.298716 
    -0.29798 -0.297329 -0.296691 -0.295837 -0.29516 -0.294725 
    -0.294044 -0.292917 -0.292351 -0.291965 -0.291365 -0.290687 
    -0.290027 -0.289376 -0.288772 -0.288193 -0.287505 -0.286892 
    -0.28626 -0.285714 -0.284545 -0.289246 -0.298717 -0.298492 
    -0.214163 0.181451 0.0749974 0.0454707 0.0292987 0.0196837 
    0.0124119 0.00884715 0.00527181 0.00585821 0.0296361 0.169856 
    0.361207 0.538856 0.67469 0.685933 0.392802 0.17772 0.0813085 
    0.0424601 0.0246654 0.0175258 0.0144256 0.0129859 0.012205 
    0.0112846 0.010933 0.0134813 0.0147254 0.0147981 0.0142156 
    0.0132732 0.0121355 0.0109587 0.00981238 0.00872731 0.00767007 
    0.00669346 0.00581341 0.00502167 0.00431819 0.00369842 0.00316168 
    0.00269663 0.00230035 0.00195801 0.00166928 0.00142286 0.00121522 
    0.00104072 0.000893384 0.000767675 0.000661268 0.000567659 
    0.000481766 0.000407101 0.000350044 0.000302721 0.000263424 
    0.000236813 0.00022199 0.000218182 0.000219548 0.0002027 
    0.000185853 0.000169006 0.000152158 0.000135311 0.000118463 
    0.000101616 9.33782e-05 8.57685e-05 7.81588e-05 7.0549e-05 
    6.29393e-05 5.53296e-05 4.77199e-05 4.36954e-05 4.15296e-05 
    3.93637e-05 3.71978e-05 3.50319e-05 3.28661e-05 3.07002e-05 
    2.85343e-05 2.63685e-05 2.42026e-05 2.20367e-05 1.98709e-05 
    1.7705e-05 1.55391e-05 1.34772e-05 1.22416e-05 1.10061e-05 
    9.77055e-06 8.535e-06 0.000631271 -0.00362586 -0.0146235 
    -0.0308486 -0.0237466 -0.0117522 -0.00304171 0.00251033 
    0.00531986 0.0063897 0.00657351 0.00636494 0.00599705 0.00553442 
    0.00505994 0.00330925 0.00246671 0.0027006 0.00473161 0.00830333 
    0.00649147 0.00356815 0.00217448 0.00187579 0.00270447 0.00219543 
    -0.00546118 -0.0179576 -0.0445306 -0.0649309 0.0197935 0.473629 
    0.87268 0.269542 0.0086094 0.0844602 0.606456 1.04929 0.906014 
    0.916205 0.919425 0.872867 0.556244 0.262457 0.11838 0.0571226 
    0.0333451 0.0237133 0.0185096 0.0159617 0.0148663 0.0138683 
    0.0144081 0.0153797 0.0152551 0.0146487 0.0137192 0.0125973 
    0.0113996 0.0101903 0.00901851 0.00790495 0.00687502 0.00593994 
    0.00510092 0.00436111 0.00372439 0.0031945 0.00277537 0.00241888 
    0.002095 0.00179943 0.00150419 0.00119264 0.00090934 0.000802394 
    0.000852816 0.000838368 0.000730842 0.000601028 0.000546616 
    0.000492205 0.000437793 0.000383381 0.000328969 0.00029454 
    0.000266428 0.000238317 0.000210205 0.000182093 0.000162091 
    0.000152145 0.000142198 0.000132252 0.000122306 0.000112359 
    0.000102413 9.24665e-05 8.25201e-05 7.25738e-05 6.26274e-05 
    5.78553e-05 5.42216e-05 5.05878e-05 4.69541e-05 4.33204e-05 
    3.96867e-05 3.60529e-05 3.24192e-05 2.87855e-05 2.51518e-05 
    2.19153e-05 2.03406e-05 1.8766e-05 1.71913e-05 1.56167e-05 
    1.4042e-05 1.24674e-05 1.08927e-05 9.31806e-06 
}
.graph element create V35 -x x -y v35
v36 set {
    5 5.01426 5.02852 5.01923 4.77685 4.56471 4.52338 4.56813 
    4.63122 4.693 4.74776 4.79385 4.83258 4.86358 4.88918 4.91021 
    4.90553 4.89733 4.89554 4.91953 5.00757 5.07101 5.06318 
    5.05241 5.05535 5.08042 5.07251 4.90973 4.56136 3.98637 
    3.237 2.67216 2.33678 2.13529 2.00544 1.91429 1.84638 1.79461 
    1.75338 1.71958 1.69175 1.6686 1.64918 1.63258 1.61836 1.60607 
    1.59506 1.58483 1.57575 1.56847 1.56193 1.55538 1.54968 
    1.54416 1.5388 1.53523 1.53165 1.52807 1.52449 1.52091 1.51771 
    1.51477 1.51182 1.50888 1.50593 1.50309 1.50113 1.49917 
    1.4972 1.49524 1.49328 1.49132 1.48935 1.48739 1.48543 1.48346 
    1.48157 1.48012 1.47868 1.47724 1.47579 1.47435 1.47291 
    1.47146 1.47002 1.46857 1.46713 1.46574 1.46462 1.4635 1.46238 
    1.46126 1.46014 1.45902 1.4579 1.45678 1.45567 1.45455 1.45349 
    1.45275 1.45201 1.45127 1.45053 1.44979 1.44905 1.44831 
    1.44757 1.44683 1.44609 1.44535 1.44461 1.44387 1.44313 
    1.44239 1.44165 1.44091 1.44017 1.43943 1.43869 1.43795 
    1.43721 1.43874 1.43976 1.43619 1.43182 1.43726 1.43084 
    1.42587 1.42383 1.42642 1.42728 1.42736 1.4271 1.42669 1.42621 
    1.42569 1.41703 1.41244 1.41019 1.41199 1.41833 1.42502 
    1.41504 1.37535 1.28381 1.44779 2.33713 3.25835 3.67554 
    3.84975 4.01125 4.2253 4.45433 4.62215 4.74478 4.82998 4.8868 
    4.92396 4.94768 4.96498 4.98537 5.0128 5.04467 5.06722 5.06535 
    5.01475 4.91956 4.80647 4.7242 4.7059 4.73552 4.76379 4.81684 
    4.87376 4.92276 4.96112 4.9884 5.0045 5.00999 5.00933 5.00619 
    5.00384 5.00342 5.00373 5.00362 5.00309 5.00272 5.00239 
    5.00204 5.00172 5.00146 5.00124 5.00105 5.00089 5.00076 
    5.00065 5.00057 5.00048 5.00041 5.00034 5.00028 5.00023 
    5.00019 5.00015 5.00015 5.00016 5.0002 5.00023 5.00021 5.00019 
    5.00017 5.00015 5.00012 5.0001 5.00008 5.00007 5.00006 5.00005 
    5.00004 5.00003 5.00002 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00002 5.00002 5.00002 5.00002 
    5.00002 5.00002 5.00002 5.00002 5.00002 5.00002 5.00001 
    5.00001 5.00001 5.00062 4.99506 4.9835 4.96726 4.9728 4.97877 
    4.98675 4.9966 5.00406 5.00679 5.00629 5.00561 5.00487 5.00429 
    5.00384 5.002 5.00164 5.00229 5.00484 5.00769 5.00019 5.00242 
    5.01319 5.0335 5.07265 5.10129 5.11485 5.12551 5.13953 5.16048 
    5.18862 5.22811 5.25656 5.25627 5.19975 4.9139 4.24745 3.43732 
    2.8202 2.43224 2.17409 2.01333 1.93951 1.94622 1.98861 2.02217 
    2.05383 2.08376 2.11184 2.13793 2.16191 2.18267 2.20502 
    2.22837 2.24958 2.26901 2.28648 2.302 2.31582 2.32802 2.33869 
    2.34795 2.35596 2.36282 2.3687 2.37371 2.37797 2.38161 2.38476 
    2.38743 2.3897 2.39168 2.39329 2.39463 2.39575 2.39671 2.39756 
    2.39835 2.39907 2.39968 2.39999 2.4003 2.40061 2.40091 2.40122 
    2.40142 2.40159 2.40176 2.40193 2.4021 2.40222 2.40228 2.40234 
    2.4024 2.40247 2.40253 2.40259 2.40265 2.40271 2.40277 2.40284 
    2.40287 2.40289 2.40291 2.40294 2.40296 2.40298 2.40301 
    2.40303 2.40305 2.40308 2.4031 2.40311 2.40312 2.40313 2.40314 
    2.40315 2.40316 2.40317 2.40318 
}
.graph element create V36 -x x -y v36
v37 set {
    5 5.01732 5.03181 5.05944 5.12686 5.20725 5.28103 5.31254 
    5.32901 5.33709 5.3408 5.34257 5.34311 5.34347 5.34386 5.34411 
    5.3406 5.33484 5.32942 5.32904 5.33644 5.34869 5.35001 5.34882 
    5.34758 5.34672 5.34599 5.34496 5.34364 5.34165 5.33712 
    5.33502 5.3366 5.34067 5.34306 5.34398 5.34434 5.34442 5.34443 
    5.34443 5.34441 5.34439 5.34437 5.34437 5.34438 5.34438 
    5.34438 5.34438 5.34438 5.34437 5.34437 5.34436 5.34436 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 5.34437 
    5.34437 5.34437 5.34437 5.34437 5.34437 5.35377 5.35451 
    5.34265 5.34488 5.35861 5.28622 4.90033 4.75027 4.89731 
    4.97098 4.99293 4.99832 4.99909 4.99956 4.99858 4.99829 
    4.9998 5.00035 5.0038 5.00989 5.00251 4.99438 4.9953 4.99761 
    4.99985 5.00152 5.0011 5.00046 4.99996 4.99925 4.99862 4.99919 
    4.99961 5.00048 5.00234 4.99654 4.98235 4.95936 4.83738 
    4.53021 4.21004 4.00593 3.91207 3.88059 3.87822 3.89117 
    3.91278 3.94044 3.97376 4.01152 4.05052 4.10679 4.17908 
    4.25673 4.33414 4.40875 4.47879 4.54342 4.60258 4.65595 
    4.70291 4.74414 4.78018 4.81185 4.83915 4.86291 4.88301 
    4.90048 4.91528 4.92802 4.9387 4.94777 4.95539 4.9618 4.96725 
    4.97195 4.97588 4.97932 4.98247 4.98512 4.98697 4.98831 
    4.98919 4.99015 4.99101 4.99169 4.99222 4.99282 4.99341 
    4.994 4.9946 4.99519 4.99578 4.99638 4.99667 4.99693 4.9972 
    4.99747 4.99773 4.998 4.99827 4.99841 4.99849 4.99856 4.99864 
    4.99872 4.9988 4.99888 4.99896 4.99904 4.99911 4.99919 4.99927 
    4.99935 4.99943 4.9995 4.99955 4.9996 4.99965 4.9997 5.00736 
    4.98252 4.87516 4.66727 4.49142 4.43103 4.4301 4.4571 4.49729 
    4.5407 4.5835 4.62363 4.66114 4.69577 4.72738 4.74632 4.75971 
    4.77576 4.80671 4.87073 4.91665 4.93252 4.94418 4.95331 
    4.96094 4.96727 4.97148 4.97471 4.97612 4.98276 5.00247 
    5.04086 5.08628 5.10673 5.08887 5.0564 5.02767 5.01336 4.99685 
    4.97422 4.90866 4.67035 4.33117 4.07888 3.94432 3.89105 
    3.88174 3.89292 3.91442 3.94564 3.98708 4.0355 4.09134 4.16315 
    4.24088 4.31918 4.39527 4.46693 4.53337 4.59405 4.6486 4.69693 
    4.73938 4.77617 4.80809 4.83551 4.85895 4.87894 4.89596 
    4.91081 4.92417 4.93651 4.94552 4.95198 4.9565 4.96096 4.96523 
    4.96972 4.97428 4.97868 4.98064 4.9826 4.98455 4.98651 4.98847 
    4.98967 4.99064 4.9916 4.99257 4.99353 4.99422 4.99457 4.99493 
    4.99528 4.99563 4.99598 4.99633 4.99668 4.99703 4.99738 
    4.99773 4.9979 4.99804 4.99817 4.9983 4.99843 4.99856 4.99869 
    4.99883 4.99896 4.99909 4.99921 4.99926 4.99931 4.99937 
    4.99942 4.99948 4.99953 4.99959 4.99964 
}
.graph element create V37 -x x -y v37
v38 set {
    4.49849 4.53282 4.58329 4.66625 4.83345 4.97823 5.0207 5.01816 
    5.01116 5.00595 5.00296 5.00148 5.00073 5.00062 5.00033 
    5.0003 4.99864 4.99661 4.99652 4.99928 5.00361 5.12573 5.17251 
    5.22612 5.33479 5.44503 5.44432 5.44379 5.44334 5.443 5.44276 
    5.44258 5.44246 5.44238 5.44232 5.44228 5.44225 5.44223 
    5.44221 5.4422 5.44219 5.44219 5.44218 5.44218 5.44218 5.44218 
    5.44217 5.44217 5.44217 5.44217 5.44217 5.44217 5.44217 
    5.44217 5.44217 5.44217 5.44217 5.44217 5.44217 5.44217 
    5.44217 5.44217 5.44217 5.44217 5.44217 5.44217 5.44216 
    5.44216 5.44216 5.44216 5.44216 5.44216 5.44216 5.44216 
    5.44216 5.44216 5.44216 5.44216 5.44216 5.44216 5.44216 
    5.44216 5.44216 5.44216 5.44216 5.44215 5.44215 5.44215 
    5.44215 5.44215 5.44215 5.44215 5.44215 5.44215 5.44215 
    5.44215 5.44215 5.44215 5.44215 5.44215 5.44215 5.44215 
    5.44215 5.44215 5.44215 5.44215 5.44215 5.44215 5.44215 
    5.44214 5.44214 5.44214 5.44214 5.44214 5.44214 5.44214 
    5.44214 5.44214 5.44214 5.44214 5.44212 5.45159 5.45236 
    5.44064 5.44307 5.45616 5.38122 4.77163 3.53297 2.74466 
    2.34448 2.11802 1.9783 1.88656 1.82001 1.77389 1.72955 1.69632 
    1.66971 1.6526 1.65236 1.56034 1.53764 1.97139 2.75096 3.39212 
    3.74042 3.82345 3.85696 3.88547 3.91862 3.9585 4.00467 4.05903 
    4.1254 4.19533 4.26791 4.34517 4.42112 4.49238 4.55807 4.6179 
    4.6713 4.71815 4.75889 4.79418 4.82456 4.85062 4.87291 4.89196 
    4.90823 4.92209 4.93388 4.9439 4.95242 4.95968 4.96585 4.97108 
    4.9755 4.97923 4.98237 4.98503 4.98732 4.98927 4.99094 4.99233 
    4.99353 4.99452 4.99538 4.99608 4.99668 4.99718 4.9976 4.99794 
    4.99822 4.99847 4.99867 4.99884 4.99899 4.99913 4.99924 
    4.99932 4.99938 4.99943 4.99947 4.99951 4.99953 4.99955 
    4.99958 4.99961 4.99964 4.99967 4.99969 4.99972 4.99975 
    4.99977 4.99978 4.99979 4.99981 4.99982 4.99983 4.99985 
    4.99986 4.99986 4.99987 4.99987 4.99988 4.99988 4.99988 
    4.99989 4.99989 4.9999 4.9999 4.99991 4.99991 4.99992 4.99992 
    4.99993 4.99993 4.99993 4.99994 5.00381 5.00064 4.99246 
    4.99823 5.00349 5.00076 5.00033 5.00015 5.00009 5.00007 
    5.00005 5.00004 5.00003 5.00002 4.99988 4.99732 4.99728 
    4.9978 5.00187 5.00927 5.08712 5.07654 4.92855 4.4863 3.76162 
    3.00049 2.49834 2.20883 2.03492 1.92384 1.84676 1.79021 
    1.74716 1.7132 1.68576 1.66309 1.64406 1.62785 1.61383 1.60162 
    1.59081 1.58117 1.57253 1.56473 1.55765 1.55117 1.54527 
    1.53988 1.53485 1.53012 1.5257 1.5216 1.51773 1.51411 1.51071 
    1.50746 1.50438 1.50146 1.49868 1.49603 1.4935 1.49109 1.48878 
    1.48657 1.48445 1.48242 1.48046 1.47858 1.47677 1.47502 
    1.47333 1.4717 1.47012 1.46859 1.46711 1.46568 1.46428 1.46292 
    1.4616 1.46034 1.45923 1.45812 1.45701 1.4559 1.45479 1.45378 
    1.45279 1.45181 1.45082 1.44983 1.44893 1.44813 1.44732 
    1.44652 1.44571 1.44491 1.4441 1.4433 1.44249 1.44169 1.44089 
    1.44019 1.43951 1.43883 1.43815 1.43747 1.4368 1.43612 1.43544 
    1.43476 1.43408 1.43342 1.43283 1.43223 1.43163 1.43104 
    1.43044 1.42984 1.42924 1.42865 
}
.graph element create V38 -x x -y v38
v39 set {
    5 5.01048 5.01221 4.98887 4.76261 4.54943 4.51564 4.56249 
    4.62621 4.68843 4.74374 4.79044 4.82972 4.86127 4.88724 
    4.90862 4.90791 4.89858 4.89589 4.91767 5.00405 5.16956 
    5.12391 4.7557 3.87953 3.01124 2.48482 2.20424 2.03812 1.92679 
    1.84956 1.79256 1.74907 1.71487 1.68724 1.6644 1.64513 1.6287 
    1.61446 1.60197 1.59095 1.58117 1.57245 1.5646 1.55752 1.55109 
    1.54516 1.53958 1.53444 1.53008 1.52606 1.52205 1.51843 
    1.5149 1.51146 1.50893 1.50639 1.50387 1.50133 1.4988 1.49651 
    1.49436 1.49222 1.49007 1.48793 1.48585 1.48433 1.4828 1.48128 
    1.47975 1.47823 1.4767 1.47518 1.47365 1.47213 1.4706 1.46912 
    1.46795 1.46678 1.46561 1.46444 1.46327 1.4621 1.46093 1.45976 
    1.45859 1.45741 1.45628 1.45534 1.45441 1.45347 1.45254 
    1.4516 1.45067 1.44973 1.4488 1.44786 1.44693 1.44604 1.44539 
    1.44475 1.4441 1.44345 1.44281 1.44216 1.44151 1.44086 1.44022 
    1.43957 1.43892 1.43828 1.43763 1.43698 1.43633 1.43569 
    1.43504 1.43439 1.43375 1.4331 1.43245 1.4318 1.43157 1.43089 
    1.43001 1.43042 1.42899 1.42439 1.42216 1.43447 1.44048 
    1.43705 1.43314 1.43039 1.42861 1.42739 1.42651 1.42548 
    1.42488 1.4243 1.42392 1.4235 1.32443 1.31149 1.78169 2.64844 
    3.43211 3.95252 4.20231 4.3746 4.49948 4.58929 4.65742 4.71183 
    4.77057 4.83196 4.88354 4.92894 4.96625 4.99235 5.00651 
    5.00941 5.00813 5.00689 5.00588 5.00504 5.00431 5.00368 
    5.00314 5.00268 5.00228 5.00194 5.00165 5.0014 5.00118 5.001 
    5.00085 5.00072 5.00061 5.00052 5.00044 5.00037 5.00031 
    5.00027 5.00022 5.00019 5.00016 5.00013 5.00011 5.00009 
    5.00008 5.00007 5.00006 5.00005 5.00004 5.00003 5.00003 
    5.00003 5.00002 5.00002 5.00002 5.00001 5.00001 5.00001 
    5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 5.00001 
    5.00001 5.00001 5 5 5 5 5 4.99999 4.99999 4.99999 4.99998 
    4.99998 4.99998 4.99998 4.99998 4.99998 4.99998 4.99999 
    4.99999 4.99999 4.99999 4.99999 4.99999 5 5 5 5 5.00001 
    5.00002 5.00003 5.00004 5.00022 4.99974 4.99942 4.99997 
    5.00063 5.00002 5.00003 4.99994 4.99998 4.99999 5 5 5 5 
    5 4.99981 4.99998 5.00004 5.00036 5.00049 5.12012 5.16315 
    5.19712 5.21835 4.87874 4.10151 3.31555 2.74207 2.38075 
    2.15872 2.01614 1.91886 1.84852 1.79401 1.75052 1.71508 
    1.68672 1.66467 1.64602 1.62985 1.61576 1.60343 1.59256 
    1.58287 1.57418 1.56632 1.55922 1.55282 1.54687 1.54132 
    1.53618 1.53143 1.52698 1.52282 1.51895 1.51527 1.5118 1.50851 
    1.5054 1.50244 1.49963 1.49695 1.4944 1.49196 1.48963 1.4874 
    1.48527 1.48322 1.48124 1.47934 1.47751 1.47574 1.47403 
    1.47239 1.4708 1.46926 1.46777 1.46632 1.46491 1.46355 1.46237 
    1.4612 1.46002 1.45884 1.45766 1.45659 1.45555 1.45451 1.45346 
    1.45242 1.45147 1.45062 1.44978 1.44894 1.44809 1.44725 
    1.4464 1.44556 1.44472 1.44387 1.44303 1.4423 1.44159 1.44088 
    1.44017 1.43947 1.43876 1.43805 1.43734 1.43664 1.43593 
    1.43524 1.43462 1.434 1.43338 1.43276 1.43213 1.43151 1.43089 
    1.43027 
}
.graph element create V39 -x x -y v39
toplevel .top 
.graph legend configure -position .top.legend 
pack .top.legend -fill both -expand yes

button .quit -text "quit" -bg "red" -command "exit"
table . \
    .graph 0,0 -fill both  \

Blt_ZoomStack $graph
Blt_Crosshairs $graph
Blt_ClosestPoint $graph
Blt_PrintKey $graph

$graph legend bind all <ButtonRelease-1> { HighlightTrace %W }
$graph legend bind all <ButtonRelease-3> { 
    %W legend deactivate *
    eval %W element deactivate [%W element activate]
}

proc HighlightTrace { graph } {
    set entry [$graph legend get current]
    set active [$graph legend activate]
    if { [lsearch $active $entry] < 0 } {
	$graph legend activate $entry
	$graph element activate $entry
    } else {
        $graph legend deactivate $entry
	$graph element deactivate $entry
    }
}

set lastRow 0
set logicPlots {}
set leftMargin 0
set rightMargin 0

proc LogicPlot { from graph signal args } {
    if { ![winfo exists $graph] } {
	global rightMargin leftMargin
	graph $graph -title "" -topmargin 1 -bottommargin 1 -height 0.75i \
	    -plotpadx 4 -plotpady 8 -bd 0 \
		-leftmargin $leftMargin -rightmargin $rightMargin
	$graph grid off
	set xMin [$from axis cget x -min]
	set xMax [$from axis cget x -max]
	set yLim [$from axis limits y]
	set yMin [lindex $yLim 0]
	set yMax [lindex $yLim 1]
	$graph axis configure x -title "" -hide yes -min $xMin -max $xMax
	$graph axis configure y -title $signal -min $yMin -max $yMax
	$graph legend configure -anchor nw
	global lastRow
	incr lastRow
	table . $graph $lastRow,0 -fill both
	global logicPlots
	lappend logicPlots $graph
    }
    set list [linsert $args 0 $signal ]
    foreach i [$graph element names] {
	if { [lsearch $list $i] < 0 } {
	    $graph element delete $i
	}
    }
    foreach i $list { 
	if { ![$graph element exists $i] } {
	    $graph element create $i
	}
	set pen [$from element cget $i -pen]
	set xData [$from element cget $i -x]
	set yData [$from element cget $i -y]
	$graph element configure $i -x $xData -y $yData -pen $pen
    }
}

set changePending "no"
proc EventuallyChangePlots { p1 p2 how } {
    global changePending
    if { $changePending == "no" } {
        after idle ChangePlots
    }
    set changePending "yes"
}

proc ChangePlots { } {
    global changePending
    global logicPlots
    global leftMargin rightMargin
    set from .graph
    set xMin [$from axis cget x -min]
    set xMax [$from axis cget x -max]
    set yLim [$from axis limits y]
    set yMin [lindex $yLim 0]
    set yMax [lindex $yLim 1]
    foreach g ".graph .g2 .g3" {
	$g configure -leftmargin $leftMargin -rightmargin $rightMargin
	$g axis configure x -min $xMin -max $xMax
	#$g axis configure y -min $yMin -max $yMax
    }
    set changePending "no"
}

#LogicPlot .graph .g1 V1 
#LogicPlot .graph .g2 V5
#LogicPlot .graph .g3 V9 
# LogicPlot .graph .g4 V13
# LogicPlot .graph .g5 V17
# LogicPlot .graph .g6 V22
# LogicPlot .graph .g7 V26

#.g1 configure -leftvariable leftMargin -rightvariable rightMargin 
trace add variable leftMargin write EventuallyChangePlots
trace add variable rightMargin write EventuallyChangePlots

