#!../src/bltwish

package require BLT
# --------------------------------------------------------------------------
# Starting with Tcl 8.x, the BLT commands are stored in their own 
# namespace called "blt".  The idea is to prevent name clashes with
# Tcl commands and variables from other packages, such as a "table"
# command in two different packages.  
#
# You can access the BLT commands in a couple of ways.  You can prefix
# all the BLT commands with the namespace qualifier "blt::"
#  
#    blt::graph .g
#    blt::table . .g -resize both
# 
# or you can import all the command into the global namespace.
#
#    namespace import blt::*
#    graph .g
#    table . .g -resize both
#
# --------------------------------------------------------------------------

if { $tcl_version >= 8.0 } {
    namespace import blt::*
    namespace import -force blt::tile::*
}

source [file join [file dirname [info script]] scripts demo.tcl]

proc random {{max 1.0} {min 0.0}} {
    global randomSeed

    set randomSeed [expr (7141*$randomSeed+54773) % 259200]
    set num  [expr $randomSeed/259200.0*($max-$min)+$min]
    return $num
}
set randomSeed 14823


set graph .graph

source [file join [file dirname [info script]] scripts stipples.tcl]
source [file join [file dirname [info script]] scripts patterns.tcl]

option add *Barchart.title		"A Simple Barchart"
option add *Barchart.relief 		raised
option add *Barchart.borderWidth 	2
option add *Barchart.plotBackground 	white
option add *Barchart.baseline   	57.299

option add *Element.borderWidth		2
option add *Element.Background		white
option add *Element.Relief		raised

option add *x.Title			"X Axis"
if {[tk windowingsystem] eq "win32"} {
    option add *x.Font			{Arial 10}
} else {
    option add *x.Font			{Helvetica 10}
}
option add *y.Title			"Y Axis"
option add *LineMarker.Foreground	yellow

set visual [winfo screenvisual .] 
if { $visual != "staticgray" && $visual != "grayscale" } {
    option add *print.background yellow
    option add *quit.background red
    option add *graph.background palegreen
}

barchart $graph 
$graph xaxis configure -rotate 90 -stepsize 0

set attributes { 
    red		bdiagonal1
    orange	bdiagonal2
    yellow	fdiagonal1
    green	fdiagonal2
    blue	hline1 
    cyan	hline2
    magenta	vline1 
    violetred	vline2
    purple	crossdiag
    lightblue 	hobbes	
}

set count 0
foreach { color stipple } $attributes {
    $graph pen create pen$count -fg ${color}1 -bg ${color}4 -stipple $stipple
    lappend styles [list pen$count $count $count]
    incr count
}

vector x y w

x seq 0 1000
y expr random(x)*90.0
w expr round(y/10.0)%$count
y expr y+10.0

$graph element create data -label {} \
    -x x -y y -weight w -styles $styles

table . \
    0,0 .graph -fill both

	
wm min . 0 0

Blt_ZoomStack $graph
Blt_Crosshairs $graph
Blt_ActiveLegend $graph
Blt_ClosestPoint $graph

