#!../src/bltwish

package require BLT
# --------------------------------------------------------------------------
# Starting with Tcl 8.x, the BLT commands are stored in their own 
# namespace called "blt".  The idea is to prevent name clashes with
# Tcl commands and variables from other packages, such as a "table"
# command in two different packages.  
#
# You can access the BLT commands in a couple of ways.  You can prefix
# all the BLT commands with the namespace qualifier "blt::"
#  
#    blt::graph .g
#    blt::table . .g -resize both
# 
# or you can import all the command into the global namespace.
#
#    namespace import blt::*
#    graph .g
#    table . .g -resize both
#
# --------------------------------------------------------------------------

if { $tcl_version >= 8.0 } {
    namespace import blt::*
}

source [file join [file dirname [info script]] scripts demo.tcl]

set graph .bc

proc random {{max 1.0} {min 0.0}} {
    global randomSeed

    set randomSeed [expr (7141*$randomSeed+54773) % 259200]
    set num  [expr $randomSeed/259200.0*($max-$min)+$min]
    return $num
}
set randomSeed 148230

proc FormatLabel { w value } {

    # Determine the element name from the value

    set names [$w element show]
    set index [expr round($value)]
    if { $index != $value } {
	return $value 
    }
    global elemLabels
    if { [info exists elemLabels($index)] } {
	return $elemLabels($index)
    }
    return $value
}

source [file join [file dirname [info script]] scripts stipples.tcl]

image create photo bgTexture -file \
    [file join [file dirname [info script]] images rain.gif]

option add *Barchart.title		"A Simple Barchart"

if {[tk windowingsystem] eq "win32"} {
    option add *Barchart.font		{Arial 12 bold}
    option add *Axis.tickFont		{{Courier New} 8}
    option add *Axis.titleFont		{Arial 10 bold}
} else {
    option add *Barchart.font		{Helvetica 12 bold}
    option add *Axis.tickFont		{Courier 8}
    option add *Axis.titleFont		{Helvetica 10 bold}
}

option add *x.Title			"X Axis Label"
option add *x.Rotate			90
option add *x.Command			FormatLabel
option add *y.Title			"Y Axis Label"

option add *Element.Background		white
option add *Element.Relief		solid
option add *Element.BorderWidth		1

option add *Legend.hide			yes

option add *Grid.hide			no
option add *Grid.dashes			{ 2 4 }
option add *Grid.mapX			""

set visual [winfo screenvisual .] 
if { $visual != "staticgray" && $visual != "grayscale" } {
    option add *print.background yellow
    option add *quit.background red
    option add *graph.background palegreen
}

barchart .bc

#
# Element attributes:  
#
#    Label	Foreground	Background	Stipple Pattern

set bitmaps { 
    bdiagonal1 bdiagonal2 checker2 checker3 cross1 cross2 cross3 crossdiag
    dot1 dot2 dot3 dot4 fdiagonal1 fdiagonal2 hline1 hline2 lbottom ltop
    rbottom rtop vline1 vline2
}
set count 1
foreach stipple $bitmaps {
    set label [file tail $stipple]
    set label [file root $label] 
    set y [random -2 10]
    set yhigh [expr $y + 0.5]
    set ylow [expr $y - 0.5]
    .bc element create $label -y $y -x $count \
	-fg brown -bg orange -stipple $stipple -yhigh $yhigh -ylow $ylow 
    set elemLabels($count) $label
    incr count
}

table . \
    0,0 .bc -fill both
	
Blt_ZoomStack .bc
Blt_Crosshairs .bc
Blt_ActiveLegend .bc
Blt_ClosestPoint .bc

.bc axis bind x <Enter> {
    set axis [%W axis get current]
    %W axis configure $axis -color blue3 -titlecolor blue3
}
.bc axis bind x <Leave> {
    set axis [%W axis get current]
    %W axis configure $axis -color black -titlecolor black
}


