#! /bin/sh
# The next line restarts using tclsh \
exec tclsh "$0" ${1+"$@"}

package require Tk
package require Canvas3d

canvas3d .w1
canvas3d .w2
pack .w1 .w2 -expand yes -fill both -side left
.w1 configure -width 300 -height 300 -background black
.w2 configure -width 300 -height 300 -background black

. configure -menu [menu .menu]
.menu add cascade -menu [menu .menu.file -tearoff 0]    -label File
.menu.file add command -label Quit -command exit

# Camera control
proc T {w args} {
    $w transform -camera type(light) $args
    $w delete CameraString
}

# Mouse control
bind .w1 <B1-Motion> {
    set ry [expr 360.0 * (%y  - $::Y) / [%W cget -height]]
    set rx [expr 360.0 * (%x  - $::X) / [%W cget -width]]
    T %W orbitup $ry orbitleft $rx
    set ::X %x
    set ::Y %y
}
bind .w2 <B1-Motion> {
    set ry [expr 360.0 * (%y  - $::Y) / [%W cget -height]]
    set rx [expr 360.0 * (%x  - $::X) / [%W cget -width]]
    T %W orbitup $ry orbitleft $rx
    set ::X %x
    set ::Y %y
}
bind .w1 <1> {
    set ::X %x
    set ::Y %y
}
bind .w2 <1> {
    set ::X %x
    set ::Y %y
}

proc Exit {} {
  destroy .w1
  destroy .w2
  if {[llength [info commands canvas3d_alloc]] > 0} {
    foreach {res cnt} [canvas3d_alloc] {
      puts "$cnt outstanding ${res}s"
    }
  }
  exit
}

proc Menu {title cmd} {
  if {0 == [llength [info commands .menu.demo]]} {
    .menu add cascade -menu [menu .menu.demo -tearoff 0] -label Demo
  }
  .menu.demo add command -label $title -command $cmd
}

proc cube {w sidelength tag} {
  set p [expr $sidelength / 2.0]
  set m [expr $sidelength / -2.0]

  $w create polygon [list $p $p $p  $m $p $p  $m $m $p  $p $m $p]
  $w create polygon [list $p $p $m  $m $p $m  $m $m $m  $p $m $m]

  $w create polygon [list $p $p $p  $m $p $p  $m $p $m  $p $p $m]
  $w create polygon [list $p $m $p  $m $m $p  $m $m $m  $p $m $m]

  $w create polygon [list $p $p $p  $p $m $p  $p $m $m  $p $p $m]
  $w create polygon [list $m $p $p  $m $m $p  $m $m $m  $m $p $m]
}

cube .w1 1.0 cube_one
cube .w2 1.0 cube_one
.w1 create light {0.0 0.0 3.0}
.w2 create light {0.0 0.0 3.0}
.w1 transform -camera light {lookat all}
.w2 transform -camera light {lookat all}
