/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.WindowInsets;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.Insets;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.DisplayCutoutCompat;
import androidx.core.view.ViewCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;

public class WindowInsetsCompat {
    private static final String TAG = "WindowInsetsCompat";
    @NonNull
    public static final WindowInsetsCompat CONSUMED = Build.VERSION.SDK_INT >= 30 ? Impl30.CONSUMED : Impl.CONSUMED;
    private final Impl mImpl;

    @RequiresApi(value=20)
    private WindowInsetsCompat(@NonNull WindowInsets insets) {
        this.mImpl = Build.VERSION.SDK_INT >= 30 ? new Impl30(this, insets) : (Build.VERSION.SDK_INT >= 29 ? new Impl29(this, insets) : (Build.VERSION.SDK_INT >= 28 ? new Impl28(this, insets) : (Build.VERSION.SDK_INT >= 21 ? new Impl21(this, insets) : (Build.VERSION.SDK_INT >= 20 ? new Impl20(this, insets) : new Impl(this)))));
    }

    public WindowInsetsCompat(@Nullable WindowInsetsCompat src) {
        if (src != null) {
            Impl srcImpl = src.mImpl;
            this.mImpl = Build.VERSION.SDK_INT >= 30 && srcImpl instanceof Impl30 ? new Impl30(this, (Impl30)srcImpl) : (Build.VERSION.SDK_INT >= 29 && srcImpl instanceof Impl29 ? new Impl29(this, (Impl29)srcImpl) : (Build.VERSION.SDK_INT >= 28 && srcImpl instanceof Impl28 ? new Impl28(this, (Impl28)srcImpl) : (Build.VERSION.SDK_INT >= 21 && srcImpl instanceof Impl21 ? new Impl21(this, (Impl21)srcImpl) : (Build.VERSION.SDK_INT >= 20 && srcImpl instanceof Impl20 ? new Impl20(this, (Impl20)srcImpl) : new Impl(this)))));
            srcImpl.copyWindowDataInto(this);
        } else {
            this.mImpl = new Impl(this);
        }
    }

    @NonNull
    @RequiresApi(value=20)
    public static WindowInsetsCompat toWindowInsetsCompat(@NonNull WindowInsets insets) {
        return WindowInsetsCompat.toWindowInsetsCompat(insets, null);
    }

    @NonNull
    @RequiresApi(value=20)
    public static WindowInsetsCompat toWindowInsetsCompat(@NonNull WindowInsets insets, @Nullable View view) {
        WindowInsetsCompat wic = new WindowInsetsCompat(Preconditions.checkNotNull(insets));
        if (view != null && view.isAttachedToWindow()) {
            wic.setRootWindowInsets(ViewCompat.getRootWindowInsets(view));
            wic.copyRootViewBounds(view.getRootView());
        }
        return wic;
    }

    @Deprecated
    public int getSystemWindowInsetLeft() {
        return this.mImpl.getSystemWindowInsets().left;
    }

    @Deprecated
    public int getSystemWindowInsetTop() {
        return this.mImpl.getSystemWindowInsets().top;
    }

    @Deprecated
    public int getSystemWindowInsetRight() {
        return this.mImpl.getSystemWindowInsets().right;
    }

    @Deprecated
    public int getSystemWindowInsetBottom() {
        return this.mImpl.getSystemWindowInsets().bottom;
    }

    @Deprecated
    public boolean hasSystemWindowInsets() {
        return !this.mImpl.getSystemWindowInsets().equals(Insets.NONE);
    }

    public boolean hasInsets() {
        return !this.getInsets(Type.all()).equals(Insets.NONE) || !this.getInsetsIgnoringVisibility(Type.all() ^ Type.ime()).equals(Insets.NONE) || this.getDisplayCutout() != null;
    }

    public boolean isConsumed() {
        return this.mImpl.isConsumed();
    }

    public boolean isRound() {
        return this.mImpl.isRound();
    }

    @Deprecated
    @NonNull
    public WindowInsetsCompat consumeSystemWindowInsets() {
        return this.mImpl.consumeSystemWindowInsets();
    }

    @Deprecated
    @NonNull
    public WindowInsetsCompat replaceSystemWindowInsets(int left, int top, int right, int bottom) {
        return new Builder(this).setSystemWindowInsets(Insets.of(left, top, right, bottom)).build();
    }

    @Deprecated
    @NonNull
    public WindowInsetsCompat replaceSystemWindowInsets(@NonNull Rect systemWindowInsets) {
        return new Builder(this).setSystemWindowInsets(Insets.of(systemWindowInsets)).build();
    }

    @Deprecated
    public int getStableInsetTop() {
        return this.mImpl.getStableInsets().top;
    }

    @Deprecated
    public int getStableInsetLeft() {
        return this.mImpl.getStableInsets().left;
    }

    @Deprecated
    public int getStableInsetRight() {
        return this.mImpl.getStableInsets().right;
    }

    @Deprecated
    public int getStableInsetBottom() {
        return this.mImpl.getStableInsets().bottom;
    }

    @Deprecated
    public boolean hasStableInsets() {
        return !this.mImpl.getStableInsets().equals(Insets.NONE);
    }

    @Deprecated
    @NonNull
    public WindowInsetsCompat consumeStableInsets() {
        return this.mImpl.consumeStableInsets();
    }

    @Nullable
    public DisplayCutoutCompat getDisplayCutout() {
        return this.mImpl.getDisplayCutout();
    }

    @Deprecated
    @NonNull
    public WindowInsetsCompat consumeDisplayCutout() {
        return this.mImpl.consumeDisplayCutout();
    }

    @Deprecated
    @NonNull
    public Insets getSystemWindowInsets() {
        return this.mImpl.getSystemWindowInsets();
    }

    @Deprecated
    @NonNull
    public Insets getStableInsets() {
        return this.mImpl.getStableInsets();
    }

    @Deprecated
    @NonNull
    public Insets getMandatorySystemGestureInsets() {
        return this.mImpl.getMandatorySystemGestureInsets();
    }

    @Deprecated
    @NonNull
    public Insets getTappableElementInsets() {
        return this.mImpl.getTappableElementInsets();
    }

    @Deprecated
    @NonNull
    public Insets getSystemGestureInsets() {
        return this.mImpl.getSystemGestureInsets();
    }

    @NonNull
    public WindowInsetsCompat inset(@NonNull Insets insets) {
        return this.inset(insets.left, insets.top, insets.right, insets.bottom);
    }

    @NonNull
    public WindowInsetsCompat inset(@IntRange(from=0L) int left, @IntRange(from=0L) int top, @IntRange(from=0L) int right, @IntRange(from=0L) int bottom) {
        return this.mImpl.inset(left, top, right, bottom);
    }

    @NonNull
    public Insets getInsets(int typeMask) {
        return this.mImpl.getInsets(typeMask);
    }

    @NonNull
    public Insets getInsetsIgnoringVisibility(int typeMask) {
        return this.mImpl.getInsetsIgnoringVisibility(typeMask);
    }

    public boolean isVisible(int typeMask) {
        return this.mImpl.isVisible(typeMask);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowInsetsCompat)) {
            return false;
        }
        WindowInsetsCompat other = (WindowInsetsCompat)o;
        return ObjectsCompat.equals(this.mImpl, other.mImpl);
    }

    public int hashCode() {
        return this.mImpl == null ? 0 : this.mImpl.hashCode();
    }

    @Nullable
    @RequiresApi(value=20)
    public WindowInsets toWindowInsets() {
        return this.mImpl instanceof Impl20 ? ((Impl20)this.mImpl).mPlatformInsets : null;
    }

    static Insets insetInsets(@NonNull Insets insets, int left, int top, int right, int bottom) {
        int newLeft = Math.max(0, insets.left - left);
        int newTop = Math.max(0, insets.top - top);
        int newRight = Math.max(0, insets.right - right);
        int newBottom = Math.max(0, insets.bottom - bottom);
        if (newLeft == left && newTop == top && newRight == right && newBottom == bottom) {
            return insets;
        }
        return Insets.of(newLeft, newTop, newRight, newBottom);
    }

    void setOverriddenInsets(Insets[] insetsTypeMask) {
        this.mImpl.setOverriddenInsets(insetsTypeMask);
    }

    void setStableInsets(@Nullable Insets stableInsets) {
        this.mImpl.setStableInsets(stableInsets);
    }

    void setRootWindowInsets(@Nullable WindowInsetsCompat rootWindowInsets) {
        this.mImpl.setRootWindowInsets(rootWindowInsets);
    }

    void setRootViewData(@NonNull Insets visibleInsets) {
        this.mImpl.setRootViewData(visibleInsets);
    }

    void copyRootViewBounds(@NonNull View rootView) {
        this.mImpl.copyRootViewBounds(rootView);
    }

    @RequiresApi(value=21)
    static class Api21ReflectionHolder {
        private static Field sViewAttachInfoField;
        private static Field sStableInsets;
        private static Field sContentInsets;
        private static boolean sReflectionSucceeded;

        private Api21ReflectionHolder() {
        }

        @Nullable
        public static WindowInsetsCompat getRootWindowInsets(@NonNull View v) {
            if (!sReflectionSucceeded || !v.isAttachedToWindow()) {
                return null;
            }
            View rootView = v.getRootView();
            try {
                Object attachInfo = sViewAttachInfoField.get(rootView);
                if (attachInfo != null) {
                    Rect stableInsets = (Rect)sStableInsets.get(attachInfo);
                    Rect visibleInsets = (Rect)sContentInsets.get(attachInfo);
                    if (stableInsets != null && visibleInsets != null) {
                        WindowInsetsCompat insets = new Builder().setStableInsets(Insets.of(stableInsets)).setSystemWindowInsets(Insets.of(visibleInsets)).build();
                        insets.setRootWindowInsets(insets);
                        insets.copyRootViewBounds(v.getRootView());
                        return insets;
                    }
                }
            }
            catch (IllegalAccessException e) {
                Log.w((String)WindowInsetsCompat.TAG, (String)("Failed to get insets from AttachInfo. " + e.getMessage()), (Throwable)e);
            }
            return null;
        }

        static {
            try {
                sViewAttachInfoField = View.class.getDeclaredField("mAttachInfo");
                sViewAttachInfoField.setAccessible(true);
                Class<?> sAttachInfoClass = Class.forName("android.view.View$AttachInfo");
                sStableInsets = sAttachInfoClass.getDeclaredField("mStableInsets");
                sStableInsets.setAccessible(true);
                sContentInsets = sAttachInfoClass.getDeclaredField("mContentInsets");
                sContentInsets.setAccessible(true);
                sReflectionSucceeded = true;
            }
            catch (ReflectiveOperationException e) {
                Log.w((String)WindowInsetsCompat.TAG, (String)("Failed to get visible insets from AttachInfo " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @RequiresApi(value=30)
    private static final class TypeImpl30 {
        private TypeImpl30() {
        }

        static int toPlatformType(int typeMask) {
            int result = 0;
            block10: for (int i = 1; i <= 256; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                switch (i) {
                    case 1: {
                        result |= WindowInsets.Type.statusBars();
                        continue block10;
                    }
                    case 2: {
                        result |= WindowInsets.Type.navigationBars();
                        continue block10;
                    }
                    case 4: {
                        result |= WindowInsets.Type.captionBar();
                        continue block10;
                    }
                    case 8: {
                        result |= WindowInsets.Type.ime();
                        continue block10;
                    }
                    case 16: {
                        result |= WindowInsets.Type.systemGestures();
                        continue block10;
                    }
                    case 32: {
                        result |= WindowInsets.Type.mandatorySystemGestures();
                        continue block10;
                    }
                    case 64: {
                        result |= WindowInsets.Type.tappableElement();
                        continue block10;
                    }
                    case 128: {
                        result |= WindowInsets.Type.displayCutout();
                    }
                }
            }
            return result;
        }
    }

    public static final class Type {
        static final int FIRST = 1;
        static final int STATUS_BARS = 1;
        static final int NAVIGATION_BARS = 2;
        static final int CAPTION_BAR = 4;
        static final int IME = 8;
        static final int SYSTEM_GESTURES = 16;
        static final int MANDATORY_SYSTEM_GESTURES = 32;
        static final int TAPPABLE_ELEMENT = 64;
        static final int DISPLAY_CUTOUT = 128;
        static final int LAST = 256;
        static final int SIZE = 9;
        static final int WINDOW_DECOR = 256;

        private Type() {
        }

        public static int statusBars() {
            return 1;
        }

        public static int navigationBars() {
            return 2;
        }

        public static int captionBar() {
            return 4;
        }

        public static int ime() {
            return 8;
        }

        public static int systemGestures() {
            return 16;
        }

        public static int mandatorySystemGestures() {
            return 32;
        }

        public static int tappableElement() {
            return 64;
        }

        public static int displayCutout() {
            return 128;
        }

        public static int systemBars() {
            return 7;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @SuppressLint(value={"WrongConstant"})
        static int all() {
            return -1;
        }

        static int indexOf(int type) {
            switch (type) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 8: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 32: {
                    return 5;
                }
                case 64: {
                    return 6;
                }
                case 128: {
                    return 7;
                }
                case 256: {
                    return 8;
                }
            }
            throw new IllegalArgumentException("type needs to be >= FIRST and <= LAST, type=" + type);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface InsetsType {
        }
    }

    @RequiresApi(value=30)
    private static class BuilderImpl30
    extends BuilderImpl29 {
        BuilderImpl30() {
        }

        BuilderImpl30(@NonNull WindowInsetsCompat insets) {
            super(insets);
        }

        @Override
        void setInsets(int typeMask, @NonNull Insets insets) {
            this.mPlatBuilder.setInsets(TypeImpl30.toPlatformType(typeMask), insets.toPlatformInsets());
        }

        @Override
        void setInsetsIgnoringVisibility(int typeMask, @NonNull Insets insets) {
            this.mPlatBuilder.setInsetsIgnoringVisibility(TypeImpl30.toPlatformType(typeMask), insets.toPlatformInsets());
        }

        @Override
        void setVisible(int typeMask, boolean visible) {
            this.mPlatBuilder.setVisible(TypeImpl30.toPlatformType(typeMask), visible);
        }
    }

    @RequiresApi(api=29)
    private static class BuilderImpl29
    extends BuilderImpl {
        final WindowInsets.Builder mPlatBuilder;

        BuilderImpl29() {
            this.mPlatBuilder = new WindowInsets.Builder();
        }

        BuilderImpl29(@NonNull WindowInsetsCompat insets) {
            WindowInsets platInsets = insets.toWindowInsets();
            this.mPlatBuilder = platInsets != null ? new WindowInsets.Builder(platInsets) : new WindowInsets.Builder();
        }

        @Override
        void setSystemWindowInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setSystemWindowInsets(insets.toPlatformInsets());
        }

        @Override
        void setSystemGestureInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setSystemGestureInsets(insets.toPlatformInsets());
        }

        @Override
        void setMandatorySystemGestureInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setMandatorySystemGestureInsets(insets.toPlatformInsets());
        }

        @Override
        void setTappableElementInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setTappableElementInsets(insets.toPlatformInsets());
        }

        @Override
        void setStableInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setStableInsets(insets.toPlatformInsets());
        }

        @Override
        void setDisplayCutout(@Nullable DisplayCutoutCompat displayCutout) {
            this.mPlatBuilder.setDisplayCutout(displayCutout != null ? displayCutout.unwrap() : null);
        }

        @Override
        @NonNull
        WindowInsetsCompat build() {
            this.applyInsetTypes();
            WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat(this.mPlatBuilder.build());
            windowInsetsCompat.setOverriddenInsets(this.mInsetsTypeMask);
            return windowInsetsCompat;
        }
    }

    @RequiresApi(api=20)
    private static class BuilderImpl20
    extends BuilderImpl {
        private static Field sConsumedField;
        private static boolean sConsumedFieldFetched;
        private static Constructor<WindowInsets> sConstructor;
        private static boolean sConstructorFetched;
        private WindowInsets mInsets;
        private Insets mStableInsets;

        BuilderImpl20() {
            this.mInsets = BuilderImpl20.createWindowInsetsInstance();
        }

        BuilderImpl20(@NonNull WindowInsetsCompat insets) {
            this.mInsets = insets.toWindowInsets();
        }

        @Override
        void setSystemWindowInsets(@NonNull Insets insets) {
            if (this.mInsets != null) {
                this.mInsets = this.mInsets.replaceSystemWindowInsets(insets.left, insets.top, insets.right, insets.bottom);
            }
        }

        @Override
        void setStableInsets(@Nullable Insets insets) {
            this.mStableInsets = insets;
        }

        @Override
        @NonNull
        WindowInsetsCompat build() {
            this.applyInsetTypes();
            WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat(this.mInsets);
            windowInsetsCompat.setOverriddenInsets(this.mInsetsTypeMask);
            windowInsetsCompat.setStableInsets(this.mStableInsets);
            return windowInsetsCompat;
        }

        @Nullable
        private static WindowInsets createWindowInsetsInstance() {
            if (!sConsumedFieldFetched) {
                try {
                    sConsumedField = WindowInsets.class.getDeclaredField("CONSUMED");
                }
                catch (ReflectiveOperationException e) {
                    Log.i((String)WindowInsetsCompat.TAG, (String)"Could not retrieve WindowInsets.CONSUMED field", (Throwable)e);
                }
                sConsumedFieldFetched = true;
            }
            if (sConsumedField != null) {
                try {
                    WindowInsets consumed = (WindowInsets)sConsumedField.get(null);
                    if (consumed != null) {
                        return new WindowInsets(consumed);
                    }
                }
                catch (ReflectiveOperationException e) {
                    Log.i((String)WindowInsetsCompat.TAG, (String)"Could not get value from WindowInsets.CONSUMED field", (Throwable)e);
                }
            }
            if (!sConstructorFetched) {
                try {
                    sConstructor = WindowInsets.class.getConstructor(Rect.class);
                }
                catch (ReflectiveOperationException e) {
                    Log.i((String)WindowInsetsCompat.TAG, (String)"Could not retrieve WindowInsets(Rect) constructor", (Throwable)e);
                }
                sConstructorFetched = true;
            }
            if (sConstructor != null) {
                try {
                    return sConstructor.newInstance(new Rect());
                }
                catch (ReflectiveOperationException e) {
                    Log.i((String)WindowInsetsCompat.TAG, (String)"Could not invoke WindowInsets(Rect) constructor", (Throwable)e);
                }
            }
            return null;
        }

        static {
            sConsumedFieldFetched = false;
            sConstructorFetched = false;
        }
    }

    private static class BuilderImpl {
        private final WindowInsetsCompat mInsets;
        Insets[] mInsetsTypeMask;

        BuilderImpl() {
            this(new WindowInsetsCompat((WindowInsetsCompat)null));
        }

        BuilderImpl(@NonNull WindowInsetsCompat insets) {
            this.mInsets = insets;
        }

        void setSystemWindowInsets(@NonNull Insets insets) {
        }

        void setSystemGestureInsets(@NonNull Insets insets) {
        }

        void setMandatorySystemGestureInsets(@NonNull Insets insets) {
        }

        void setTappableElementInsets(@NonNull Insets insets) {
        }

        void setStableInsets(@NonNull Insets insets) {
        }

        void setDisplayCutout(@Nullable DisplayCutoutCompat displayCutout) {
        }

        void setInsets(int typeMask, @NonNull Insets insets) {
            if (this.mInsetsTypeMask == null) {
                this.mInsetsTypeMask = new Insets[9];
            }
            for (int i = 1; i <= 256; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.mInsetsTypeMask[Type.indexOf((int)i)] = insets;
            }
        }

        void setInsetsIgnoringVisibility(int typeMask, @NonNull Insets insets) {
            if (typeMask == 8) {
                throw new IllegalArgumentException("Ignoring visibility inset not available for IME");
            }
        }

        void setVisible(int typeMask, boolean visible) {
        }

        protected final void applyInsetTypes() {
            if (this.mInsetsTypeMask != null) {
                Insets statusBars = this.mInsetsTypeMask[Type.indexOf(1)];
                Insets navigationBars = this.mInsetsTypeMask[Type.indexOf(2)];
                if (statusBars != null && navigationBars != null) {
                    this.setSystemWindowInsets(Insets.max(statusBars, navigationBars));
                } else if (statusBars != null) {
                    this.setSystemWindowInsets(statusBars);
                } else if (navigationBars != null) {
                    this.setSystemWindowInsets(navigationBars);
                }
                Insets i = this.mInsetsTypeMask[Type.indexOf(16)];
                if (i != null) {
                    this.setSystemGestureInsets(i);
                }
                if ((i = this.mInsetsTypeMask[Type.indexOf(32)]) != null) {
                    this.setMandatorySystemGestureInsets(i);
                }
                if ((i = this.mInsetsTypeMask[Type.indexOf(64)]) != null) {
                    this.setTappableElementInsets(i);
                }
            }
        }

        @NonNull
        WindowInsetsCompat build() {
            this.applyInsetTypes();
            return this.mInsets;
        }
    }

    public static final class Builder {
        private final BuilderImpl mImpl;

        public Builder() {
            this.mImpl = Build.VERSION.SDK_INT >= 30 ? new BuilderImpl30() : (Build.VERSION.SDK_INT >= 29 ? new BuilderImpl29() : (Build.VERSION.SDK_INT >= 20 ? new BuilderImpl20() : new BuilderImpl()));
        }

        public Builder(@NonNull WindowInsetsCompat insets) {
            this.mImpl = Build.VERSION.SDK_INT >= 30 ? new BuilderImpl30(insets) : (Build.VERSION.SDK_INT >= 29 ? new BuilderImpl29(insets) : (Build.VERSION.SDK_INT >= 20 ? new BuilderImpl20(insets) : new BuilderImpl(insets)));
        }

        @Deprecated
        @NonNull
        public Builder setSystemWindowInsets(@NonNull Insets insets) {
            this.mImpl.setSystemWindowInsets(insets);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setSystemGestureInsets(@NonNull Insets insets) {
            this.mImpl.setSystemGestureInsets(insets);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setMandatorySystemGestureInsets(@NonNull Insets insets) {
            this.mImpl.setMandatorySystemGestureInsets(insets);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setTappableElementInsets(@NonNull Insets insets) {
            this.mImpl.setTappableElementInsets(insets);
            return this;
        }

        @NonNull
        public Builder setInsets(int typeMask, @NonNull Insets insets) {
            this.mImpl.setInsets(typeMask, insets);
            return this;
        }

        @NonNull
        public Builder setInsetsIgnoringVisibility(int typeMask, @NonNull Insets insets) {
            this.mImpl.setInsetsIgnoringVisibility(typeMask, insets);
            return this;
        }

        @NonNull
        public Builder setVisible(int typeMask, boolean visible) {
            this.mImpl.setVisible(typeMask, visible);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setStableInsets(@NonNull Insets insets) {
            this.mImpl.setStableInsets(insets);
            return this;
        }

        @NonNull
        public Builder setDisplayCutout(@Nullable DisplayCutoutCompat displayCutout) {
            this.mImpl.setDisplayCutout(displayCutout);
            return this;
        }

        @NonNull
        public WindowInsetsCompat build() {
            return this.mImpl.build();
        }
    }

    @RequiresApi(value=30)
    private static class Impl30
    extends Impl29 {
        @NonNull
        static final WindowInsetsCompat CONSUMED = WindowInsetsCompat.toWindowInsetsCompat(WindowInsets.CONSUMED);

        Impl30(@NonNull WindowInsetsCompat host, @NonNull WindowInsets insets) {
            super(host, insets);
        }

        Impl30(@NonNull WindowInsetsCompat host, @NonNull Impl30 other) {
            super(host, other);
        }

        @Override
        @NonNull
        public Insets getInsets(int typeMask) {
            return Insets.toCompatInsets(this.mPlatformInsets.getInsets(TypeImpl30.toPlatformType(typeMask)));
        }

        @Override
        @NonNull
        public Insets getInsetsIgnoringVisibility(int typeMask) {
            return Insets.toCompatInsets(this.mPlatformInsets.getInsetsIgnoringVisibility(TypeImpl30.toPlatformType(typeMask)));
        }

        @Override
        public boolean isVisible(int typeMask) {
            return this.mPlatformInsets.isVisible(TypeImpl30.toPlatformType(typeMask));
        }

        @Override
        final void copyRootViewBounds(@NonNull View rootView) {
        }
    }

    @RequiresApi(value=29)
    private static class Impl29
    extends Impl28 {
        private Insets mSystemGestureInsets = null;
        private Insets mMandatorySystemGestureInsets = null;
        private Insets mTappableElementInsets = null;

        Impl29(@NonNull WindowInsetsCompat host, @NonNull WindowInsets insets) {
            super(host, insets);
        }

        Impl29(@NonNull WindowInsetsCompat host, @NonNull Impl29 other) {
            super(host, other);
        }

        @Override
        @NonNull
        Insets getSystemGestureInsets() {
            if (this.mSystemGestureInsets == null) {
                this.mSystemGestureInsets = Insets.toCompatInsets(this.mPlatformInsets.getSystemGestureInsets());
            }
            return this.mSystemGestureInsets;
        }

        @Override
        @NonNull
        Insets getMandatorySystemGestureInsets() {
            if (this.mMandatorySystemGestureInsets == null) {
                this.mMandatorySystemGestureInsets = Insets.toCompatInsets(this.mPlatformInsets.getMandatorySystemGestureInsets());
            }
            return this.mMandatorySystemGestureInsets;
        }

        @Override
        @NonNull
        Insets getTappableElementInsets() {
            if (this.mTappableElementInsets == null) {
                this.mTappableElementInsets = Insets.toCompatInsets(this.mPlatformInsets.getTappableElementInsets());
            }
            return this.mTappableElementInsets;
        }

        @Override
        @NonNull
        WindowInsetsCompat inset(int left, int top, int right, int bottom) {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets.inset(left, top, right, bottom));
        }

        @Override
        public void setStableInsets(@Nullable Insets stableInsets) {
        }
    }

    @RequiresApi(value=28)
    private static class Impl28
    extends Impl21 {
        Impl28(@NonNull WindowInsetsCompat host, @NonNull WindowInsets insets) {
            super(host, insets);
        }

        Impl28(@NonNull WindowInsetsCompat host, @NonNull Impl28 other) {
            super(host, other);
        }

        @Override
        @Nullable
        DisplayCutoutCompat getDisplayCutout() {
            return DisplayCutoutCompat.wrap(this.mPlatformInsets.getDisplayCutout());
        }

        @Override
        @NonNull
        WindowInsetsCompat consumeDisplayCutout() {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets.consumeDisplayCutout());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Impl28)) {
                return false;
            }
            Impl28 otherImpl28 = (Impl28)o;
            return Objects.equals(this.mPlatformInsets, otherImpl28.mPlatformInsets) && Objects.equals(this.mRootViewVisibleInsets, otherImpl28.mRootViewVisibleInsets);
        }

        @Override
        public int hashCode() {
            return this.mPlatformInsets.hashCode();
        }
    }

    @RequiresApi(value=21)
    private static class Impl21
    extends Impl20 {
        private Insets mStableInsets = null;

        Impl21(@NonNull WindowInsetsCompat host, @NonNull WindowInsets insets) {
            super(host, insets);
        }

        Impl21(@NonNull WindowInsetsCompat host, @NonNull Impl21 other) {
            super(host, other);
            this.mStableInsets = other.mStableInsets;
        }

        @Override
        boolean isConsumed() {
            return this.mPlatformInsets.isConsumed();
        }

        @Override
        @NonNull
        WindowInsetsCompat consumeStableInsets() {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets.consumeStableInsets());
        }

        @Override
        @NonNull
        WindowInsetsCompat consumeSystemWindowInsets() {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets.consumeSystemWindowInsets());
        }

        @Override
        @NonNull
        final Insets getStableInsets() {
            if (this.mStableInsets == null) {
                this.mStableInsets = Insets.of(this.mPlatformInsets.getStableInsetLeft(), this.mPlatformInsets.getStableInsetTop(), this.mPlatformInsets.getStableInsetRight(), this.mPlatformInsets.getStableInsetBottom());
            }
            return this.mStableInsets;
        }

        @Override
        public void setStableInsets(@Nullable Insets stableInsets) {
            this.mStableInsets = stableInsets;
        }
    }

    @RequiresApi(value=20)
    private static class Impl20
    extends Impl {
        private static boolean sVisibleRectReflectionFetched = false;
        private static Method sGetViewRootImplMethod;
        private static Class<?> sViewRootImplClass;
        private static Class<?> sAttachInfoClass;
        private static Field sVisibleInsetsField;
        private static Field sAttachInfoField;
        @NonNull
        final WindowInsets mPlatformInsets;
        private Insets[] mOverriddenInsets;
        private Insets mSystemWindowInsets = null;
        private WindowInsetsCompat mRootWindowInsets;
        Insets mRootViewVisibleInsets;

        Impl20(@NonNull WindowInsetsCompat host, @NonNull WindowInsets insets) {
            super(host);
            this.mPlatformInsets = insets;
        }

        Impl20(@NonNull WindowInsetsCompat host, @NonNull Impl20 other) {
            this(host, new WindowInsets(other.mPlatformInsets));
        }

        @Override
        boolean isRound() {
            return this.mPlatformInsets.isRound();
        }

        @Override
        @NonNull
        public Insets getInsets(int typeMask) {
            return this.getInsets(typeMask, false);
        }

        @Override
        @NonNull
        public Insets getInsetsIgnoringVisibility(int typeMask) {
            return this.getInsets(typeMask, true);
        }

        @Override
        @SuppressLint(value={"WrongConstant"})
        boolean isVisible(int typeMask) {
            for (int i = 1; i <= 256; i <<= 1) {
                if ((typeMask & i) == 0 || this.isTypeVisible(i)) continue;
                return false;
            }
            return true;
        }

        @SuppressLint(value={"WrongConstant"})
        @NonNull
        private Insets getInsets(int typeMask, boolean ignoreVisibility) {
            Insets result = Insets.NONE;
            for (int i = 1; i <= 256; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                result = Insets.max(result, this.getInsetsForType(i, ignoreVisibility));
            }
            return result;
        }

        @NonNull
        protected Insets getInsetsForType(int type, boolean ignoreVisibility) {
            switch (type) {
                case 1: {
                    if (ignoreVisibility) {
                        Insets rootStable = this.getRootStableInsets();
                        return Insets.of(0, Math.max(rootStable.top, this.getSystemWindowInsets().top), 0, 0);
                    }
                    return Insets.of(0, this.getSystemWindowInsets().top, 0, 0);
                }
                case 2: {
                    if (ignoreVisibility) {
                        Insets rootStable = this.getRootStableInsets();
                        Insets stable = this.getStableInsets();
                        return Insets.of(Math.max(rootStable.left, stable.left), 0, Math.max(rootStable.right, stable.right), Math.max(rootStable.bottom, stable.bottom));
                    }
                    Insets systemWindow = this.getSystemWindowInsets();
                    Insets rootStable = this.mRootWindowInsets != null ? this.mRootWindowInsets.getStableInsets() : null;
                    int bottom = systemWindow.bottom;
                    if (rootStable != null) {
                        bottom = Math.min(bottom, rootStable.bottom);
                    }
                    return Insets.of(systemWindow.left, 0, systemWindow.right, bottom);
                }
                case 8: {
                    Insets overriddenInsets;
                    Insets insets = overriddenInsets = this.mOverriddenInsets != null ? this.mOverriddenInsets[Type.indexOf(8)] : null;
                    if (overriddenInsets != null) {
                        return overriddenInsets;
                    }
                    Insets systemWindow = this.getSystemWindowInsets();
                    Insets rootStable = this.getRootStableInsets();
                    if (systemWindow.bottom > rootStable.bottom) {
                        return Insets.of(0, 0, 0, systemWindow.bottom);
                    }
                    if (this.mRootViewVisibleInsets != null && !this.mRootViewVisibleInsets.equals(Insets.NONE) && this.mRootViewVisibleInsets.bottom > rootStable.bottom) {
                        return Insets.of(0, 0, 0, this.mRootViewVisibleInsets.bottom);
                    }
                    return Insets.NONE;
                }
                case 16: {
                    return this.getSystemGestureInsets();
                }
                case 32: {
                    return this.getMandatorySystemGestureInsets();
                }
                case 64: {
                    return this.getTappableElementInsets();
                }
                case 128: {
                    DisplayCutoutCompat cutout;
                    DisplayCutoutCompat displayCutoutCompat = cutout = this.mRootWindowInsets != null ? this.mRootWindowInsets.getDisplayCutout() : this.getDisplayCutout();
                    if (cutout != null) {
                        return Insets.of(cutout.getSafeInsetLeft(), cutout.getSafeInsetTop(), cutout.getSafeInsetRight(), cutout.getSafeInsetBottom());
                    }
                    return Insets.NONE;
                }
            }
            return Insets.NONE;
        }

        protected boolean isTypeVisible(int type) {
            switch (type) {
                case 1: 
                case 2: 
                case 8: 
                case 128: {
                    return !this.getInsetsForType(type, false).equals(Insets.NONE);
                }
                case 4: {
                    return false;
                }
            }
            return true;
        }

        @Override
        @NonNull
        final Insets getSystemWindowInsets() {
            if (this.mSystemWindowInsets == null) {
                this.mSystemWindowInsets = Insets.of(this.mPlatformInsets.getSystemWindowInsetLeft(), this.mPlatformInsets.getSystemWindowInsetTop(), this.mPlatformInsets.getSystemWindowInsetRight(), this.mPlatformInsets.getSystemWindowInsetBottom());
            }
            return this.mSystemWindowInsets;
        }

        @Override
        @NonNull
        WindowInsetsCompat inset(int left, int top, int right, int bottom) {
            Builder b = new Builder(WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets));
            b.setSystemWindowInsets(WindowInsetsCompat.insetInsets(this.getSystemWindowInsets(), left, top, right, bottom));
            b.setStableInsets(WindowInsetsCompat.insetInsets(this.getStableInsets(), left, top, right, bottom));
            return b.build();
        }

        @Override
        void copyWindowDataInto(@NonNull WindowInsetsCompat other) {
            other.setRootWindowInsets(this.mRootWindowInsets);
            other.setRootViewData(this.mRootViewVisibleInsets);
        }

        @Override
        void setRootWindowInsets(@Nullable WindowInsetsCompat rootWindowInsets) {
            this.mRootWindowInsets = rootWindowInsets;
        }

        @Override
        void setRootViewData(@NonNull Insets visibleInsets) {
            this.mRootViewVisibleInsets = visibleInsets;
        }

        private Insets getRootStableInsets() {
            if (this.mRootWindowInsets != null) {
                return this.mRootWindowInsets.getStableInsets();
            }
            return Insets.NONE;
        }

        @Override
        void copyRootViewBounds(@NonNull View rootView) {
            Insets visibleInsets = this.getVisibleInsets(rootView);
            if (visibleInsets == null) {
                visibleInsets = Insets.NONE;
            }
            this.setRootViewData(visibleInsets);
        }

        @Nullable
        private Insets getVisibleInsets(@NonNull View rootView) {
            if (Build.VERSION.SDK_INT >= 30) {
                throw new UnsupportedOperationException("getVisibleInsets() should not be called on API >= 30. Use WindowInsets.isVisible() instead.");
            }
            if (!sVisibleRectReflectionFetched) {
                Impl20.loadReflectionField();
            }
            if (sGetViewRootImplMethod == null || sAttachInfoClass == null || sVisibleInsetsField == null) {
                return null;
            }
            try {
                Object viewRootImpl = sGetViewRootImplMethod.invoke((Object)rootView, new Object[0]);
                if (viewRootImpl == null) {
                    Log.w((String)WindowInsetsCompat.TAG, (String)"Failed to get visible insets. getViewRootImpl() returned null from the provided view. This means that the view is either not attached or the method has been overridden", (Throwable)new NullPointerException());
                    return null;
                }
                Object mAttachInfo = sAttachInfoField.get(viewRootImpl);
                Rect visibleRect = (Rect)sVisibleInsetsField.get(mAttachInfo);
                return visibleRect != null ? Insets.of(visibleRect) : null;
            }
            catch (ReflectiveOperationException e) {
                Log.e((String)WindowInsetsCompat.TAG, (String)("Failed to get visible insets. (Reflection error). " + e.getMessage()), (Throwable)e);
                return null;
            }
        }

        @Override
        public void setOverriddenInsets(Insets[] insetsTypeMask) {
            this.mOverriddenInsets = insetsTypeMask;
        }

        @SuppressLint(value={"PrivateApi"})
        private static void loadReflectionField() {
            try {
                sGetViewRootImplMethod = View.class.getDeclaredMethod("getViewRootImpl", new Class[0]);
                sViewRootImplClass = Class.forName("android.view.ViewRootImpl");
                sAttachInfoClass = Class.forName("android.view.View$AttachInfo");
                sVisibleInsetsField = sAttachInfoClass.getDeclaredField("mVisibleInsets");
                sAttachInfoField = sViewRootImplClass.getDeclaredField("mAttachInfo");
                sVisibleInsetsField.setAccessible(true);
                sAttachInfoField.setAccessible(true);
            }
            catch (ReflectiveOperationException e) {
                Log.e((String)WindowInsetsCompat.TAG, (String)("Failed to get visible insets. (Reflection error). " + e.getMessage()), (Throwable)e);
            }
            sVisibleRectReflectionFetched = true;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            Impl20 impl20 = (Impl20)o;
            return Objects.equals(this.mRootViewVisibleInsets, impl20.mRootViewVisibleInsets);
        }
    }

    private static class Impl {
        @NonNull
        static final WindowInsetsCompat CONSUMED = new Builder().build().consumeDisplayCutout().consumeStableInsets().consumeSystemWindowInsets();
        final WindowInsetsCompat mHost;

        Impl(@NonNull WindowInsetsCompat host) {
            this.mHost = host;
        }

        boolean isRound() {
            return false;
        }

        boolean isConsumed() {
            return false;
        }

        @NonNull
        WindowInsetsCompat consumeSystemWindowInsets() {
            return this.mHost;
        }

        @NonNull
        WindowInsetsCompat consumeStableInsets() {
            return this.mHost;
        }

        @Nullable
        DisplayCutoutCompat getDisplayCutout() {
            return null;
        }

        @NonNull
        WindowInsetsCompat consumeDisplayCutout() {
            return this.mHost;
        }

        @NonNull
        Insets getSystemWindowInsets() {
            return Insets.NONE;
        }

        @NonNull
        Insets getStableInsets() {
            return Insets.NONE;
        }

        @NonNull
        Insets getSystemGestureInsets() {
            return this.getSystemWindowInsets();
        }

        @NonNull
        Insets getMandatorySystemGestureInsets() {
            return this.getSystemWindowInsets();
        }

        @NonNull
        Insets getTappableElementInsets() {
            return this.getSystemWindowInsets();
        }

        @NonNull
        WindowInsetsCompat inset(int left, int top, int right, int bottom) {
            return CONSUMED;
        }

        @NonNull
        Insets getInsets(int typeMask) {
            return Insets.NONE;
        }

        @NonNull
        Insets getInsetsIgnoringVisibility(int typeMask) {
            if ((typeMask & 8) != 0) {
                throw new IllegalArgumentException("Unable to query the maximum insets for IME");
            }
            return Insets.NONE;
        }

        boolean isVisible(int typeMask) {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Impl)) {
                return false;
            }
            Impl impl = (Impl)o;
            return this.isRound() == impl.isRound() && this.isConsumed() == impl.isConsumed() && ObjectsCompat.equals(this.getSystemWindowInsets(), impl.getSystemWindowInsets()) && ObjectsCompat.equals(this.getStableInsets(), impl.getStableInsets()) && ObjectsCompat.equals(this.getDisplayCutout(), impl.getDisplayCutout());
        }

        public int hashCode() {
            return ObjectsCompat.hash(this.isRound(), this.isConsumed(), this.getSystemWindowInsets(), this.getStableInsets(), this.getDisplayCutout());
        }

        void setRootWindowInsets(@Nullable WindowInsetsCompat rootWindowInsets) {
        }

        void setRootViewData(@NonNull Insets visibleInsets) {
        }

        void copyRootViewBounds(@NonNull View rootView) {
        }

        void copyWindowDataInto(@NonNull WindowInsetsCompat other) {
        }

        public void setOverriddenInsets(Insets[] insetsTypeMask) {
        }

        public void setStableInsets(Insets stableInsets) {
        }
    }
}

