/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialDriver;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cp2102SerialDriver
extends CommonUsbSerialDriver {
    private static final String TAG = Cp2102SerialDriver.class.getSimpleName();
    private static final int DEFAULT_BAUD_RATE = 9600;
    private static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
    private static final int REQTYPE_HOST_TO_DEVICE = 65;
    private static final int SILABSER_IFC_ENABLE_REQUEST_CODE = 0;
    private static final int SILABSER_SET_BAUDDIV_REQUEST_CODE = 1;
    private static final int SILABSER_SET_LINE_CTL_REQUEST_CODE = 3;
    private static final int SILABSER_SET_MHS_REQUEST_CODE = 7;
    private static final int SILABSER_SET_BAUDRATE = 30;
    private static final int SILABSER_FLUSH_REQUEST_CODE = 18;
    private static final int FLUSH_READ_CODE = 10;
    private static final int FLUSH_WRITE_CODE = 5;
    private static final int UART_ENABLE = 1;
    private static final int UART_DISABLE = 0;
    private static final int BAUD_RATE_GEN_FREQ = 3686400;
    private static final int MCR_DTR = 1;
    private static final int MCR_RTS = 2;
    private static final int MCR_ALL = 3;
    private static final int CONTROL_WRITE_DTR = 256;
    private static final int CONTROL_WRITE_RTS = 512;
    private UsbEndpoint mReadEndpoint;
    private UsbEndpoint mWriteEndpoint;

    public Cp2102SerialDriver(UsbDevice device, UsbDeviceConnection connection) {
        super(device, connection);
    }

    private int setConfigSingle(int request, int value) {
        return this.mConnection.controlTransfer(65, request, value, 0, null, 0, 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        boolean opened = false;
        try {
            for (int i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                UsbInterface usbIface = this.mDevice.getInterface(i);
                if (this.mConnection.claimInterface(usbIface, true)) {
                    Log.d((String)TAG, (String)("claimInterface " + i + " SUCCESS"));
                    continue;
                }
                Log.d((String)TAG, (String)("claimInterface " + i + " FAIL"));
            }
            UsbInterface dataIface = this.mDevice.getInterface(this.mDevice.getInterfaceCount() - 1);
            for (int i = 0; i < dataIface.getEndpointCount(); ++i) {
                UsbEndpoint ep = dataIface.getEndpoint(i);
                if (ep.getType() != 2) continue;
                if (ep.getDirection() == 128) {
                    this.mReadEndpoint = ep;
                    continue;
                }
                this.mWriteEndpoint = ep;
            }
            this.setConfigSingle(0, 1);
            this.setConfigSingle(7, 771);
            this.setConfigSingle(1, 384);
            opened = true;
        }
        finally {
            if (!opened) {
                this.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.setConfigSingle(0, 0);
        this.mConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] dest, int timeoutMillis) throws IOException {
        int numBytesRead;
        Object object = this.mReadBufferLock;
        synchronized (object) {
            int readAmt = Math.min(dest.length, this.mReadBuffer.length);
            numBytesRead = this.mConnection.bulkTransfer(this.mReadEndpoint, this.mReadBuffer, readAmt, timeoutMillis);
            if (numBytesRead < 0) {
                return 0;
            }
            System.arraycopy(this.mReadBuffer, 0, dest, 0, numBytesRead);
        }
        return numBytesRead;
    }

    @Override
    public int write(byte[] src, int timeoutMillis) throws IOException {
        return this.write(src, 0, src.length, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] src, int offset, int length, int timeoutMillis) throws IOException {
        int count = 0;
        while (offset < src.length && length > 0) {
            int amtWritten;
            int writeLength;
            Object object = this.mWriteBufferLock;
            synchronized (object) {
                byte[] writeBuffer;
                writeLength = Math.min(length, this.mWriteBuffer.length);
                if (offset == 0) {
                    writeBuffer = src;
                } else {
                    System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                    writeBuffer = this.mWriteBuffer;
                }
                amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, timeoutMillis);
            }
            if (amtWritten <= 0) {
                throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
            }
            Log.d((String)TAG, (String)("Wrote amt=" + amtWritten + " attempted=" + writeLength));
            offset += amtWritten;
            count += amtWritten;
            length -= amtWritten;
        }
        return count;
    }

    private void setBaudRate(int baudRate) throws IOException {
        byte[] data = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF)};
        int ret = this.mConnection.controlTransfer(65, 30, 0, 0, data, 4, 5000);
        if (ret < 0) {
            throw new IOException("Error setting baud rate.");
        }
    }

    @Override
    public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
        this.setBaudRate(baudRate);
        int configDataBits = 0;
        switch (dataBits) {
            case 5: {
                configDataBits |= 0x500;
                break;
            }
            case 6: {
                configDataBits |= 0x600;
                break;
            }
            case 7: {
                configDataBits |= 0x700;
                break;
            }
            case 8: {
                configDataBits |= 0x800;
                break;
            }
            default: {
                configDataBits |= 0x800;
            }
        }
        this.setConfigSingle(3, configDataBits);
        int configParityBits = 0;
        switch (parity) {
            case 1: {
                configParityBits |= 0x10;
                break;
            }
            case 2: {
                configParityBits |= 0x20;
            }
        }
        this.setConfigSingle(3, configParityBits);
        int configStopBits = 0;
        switch (stopBits) {
            case 1: {
                configStopBits |= 0;
                break;
            }
            case 2: {
                configStopBits |= 2;
            }
        }
        this.setConfigSingle(3, configStopBits);
    }

    @Override
    public boolean getCD() throws IOException {
        return false;
    }

    @Override
    public boolean getCTS() throws IOException {
        return false;
    }

    @Override
    public boolean getDSR() throws IOException {
        return false;
    }

    @Override
    public boolean getDTR() throws IOException {
        return true;
    }

    @Override
    public void setDTR(boolean value) throws IOException {
    }

    @Override
    public boolean getRI() throws IOException {
        return false;
    }

    @Override
    public boolean getRTS() throws IOException {
        return true;
    }

    @Override
    public boolean purgeHwBuffers(boolean purgeReadBuffers, boolean purgeWriteBuffers) throws IOException {
        int value = (purgeReadBuffers ? 10 : 0) | (purgeWriteBuffers ? 5 : 0);
        if (value != 0) {
            this.setConfigSingle(18, value);
        }
        return true;
    }

    @Override
    public void setRTS(boolean value) throws IOException {
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(4292, new int[]{60000, 60016, 60017, 60032});
        return supportedDevices;
    }
}

