/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialDriver;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ch34xSerialDriver
extends CommonUsbSerialDriver {
    private final String TAG = Ch34xSerialDriver.class.getSimpleName();
    private static final int USB_TIMEOUT_MILLIS = 5000;
    private final int DEFAULT_BAUD_RATE = 9600;
    private boolean dtr = false;
    private boolean rts = false;
    private UsbEndpoint mReadEndpoint;
    private UsbEndpoint mWriteEndpoint;

    public Ch34xSerialDriver(UsbDevice usbDevice, UsbDeviceConnection usbConnection) {
        super(usbDevice, usbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        boolean opened = false;
        try {
            for (int i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                if (!this.mConnection.claimInterface(this.mDevice.getInterface(i), true)) {
                    throw new IOException("Error claiming interface " + i);
                }
                Log.d((String)this.TAG, (String)("claimInterface " + i + " SUCCESS"));
            }
            UsbInterface dataIface = this.mDevice.getInterface(this.mDevice.getInterfaceCount() - 1);
            for (int i = 0; i < dataIface.getEndpointCount(); ++i) {
                UsbEndpoint ep = dataIface.getEndpoint(i);
                if (ep.getType() != 2) continue;
                if (ep.getDirection() == 128) {
                    this.mReadEndpoint = ep;
                    continue;
                }
                if (ep.getDirection() != 0) continue;
                this.mWriteEndpoint = ep;
            }
            this.initialize();
            this.setBaudRate(9600);
            opened = true;
        }
        finally {
            if (!opened) {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        this.mConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] dest, int timeoutMillis) throws IOException {
        int numBytesRead;
        Object object = this.mReadBufferLock;
        synchronized (object) {
            int readAmt = Math.min(dest.length, this.mReadBuffer.length);
            numBytesRead = this.mConnection.bulkTransfer(this.mReadEndpoint, this.mReadBuffer, readAmt, timeoutMillis);
            if (numBytesRead < 0) {
                return 0;
            }
            System.arraycopy(this.mReadBuffer, 0, dest, 0, numBytesRead);
        }
        return numBytesRead;
    }

    @Override
    public int write(byte[] src, int timeoutMillis) throws IOException {
        return this.write(src, 0, src.length, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] src, int offset, int length, int timeoutMillis) throws IOException {
        int count = 0;
        while (offset < src.length && length > 0) {
            int amtWritten;
            int writeLength;
            Object object = this.mWriteBufferLock;
            synchronized (object) {
                byte[] writeBuffer;
                writeLength = Math.min(length - offset, this.mWriteBuffer.length);
                if (offset == 0) {
                    writeBuffer = src;
                } else {
                    System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                    writeBuffer = this.mWriteBuffer;
                }
                amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, timeoutMillis);
            }
            if (amtWritten <= 0) {
                throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
            }
            Log.d((String)this.TAG, (String)("Wrote amtWritten=" + amtWritten + " attempted=" + writeLength));
            offset += amtWritten;
            count += amtWritten;
            length -= amtWritten;
        }
        return count;
    }

    private int controlOut(int request, int value, int index) {
        int REQTYPE_HOST_TO_DEVICE = 65;
        return this.mConnection.controlTransfer(65, request, value, index, null, 0, 5000);
    }

    private int controlIn(int request, int value, int index, byte[] buffer) {
        int REQTYPE_HOST_TO_DEVICE = 192;
        return this.mConnection.controlTransfer(192, request, value, index, buffer, buffer.length, 5000);
    }

    private void checkState(String msg, int request, int value, int[] expected) throws IOException {
        byte[] buffer = new byte[expected.length];
        int ret = this.controlIn(request, value, 0, buffer);
        if (ret < 0) {
            throw new IOException("Faild send cmd [" + msg + "]");
        }
        if (ret != expected.length) {
            throw new IOException("Expected " + expected.length + " bytes, but get " + ret + " [" + msg + "]");
        }
        for (int i = 0; i < expected.length; ++i) {
            int current;
            if (expected[i] == -1 || expected[i] == (current = buffer[i] & 0xFF)) continue;
            throw new IOException("Expected 0x" + Integer.toHexString(expected[i]) + " bytes, but get 0x" + Integer.toHexString(current) + " [" + msg + "]");
        }
    }

    private void writeHandshakeByte() throws IOException {
        if (this.controlOut(164, ~((this.dtr ? 32 : 0) | (this.rts ? 64 : 0)), 0) < 0) {
            throw new IOException("Faild to set handshake byte");
        }
    }

    private void initialize() throws IOException {
        this.checkState("init #1", 95, 0, new int[]{-1, 0});
        if (this.controlOut(161, 0, 0) < 0) {
            throw new IOException("init failed! #2");
        }
        this.setBaudRate(9600);
        this.checkState("init #4", 149, 9496, new int[]{-1, 0});
        if (this.controlOut(154, 9496, 80) < 0) {
            throw new IOException("init failed! #5");
        }
        this.checkState("init #6", 149, 1798, new int[]{255, 238});
        if (this.controlOut(161, 20511, 55562) < 0) {
            throw new IOException("init failed! #7");
        }
        this.setBaudRate(9600);
        this.writeHandshakeByte();
        this.checkState("init #10", 149, 1798, new int[]{-1, 238});
    }

    private void setBaudRate(int baudRate) throws IOException {
        int divisor;
        if (baudRate <= 0) {
            throw new IOException("Illegal baud rate #1");
        }
        int factor = 1532620800 / baudRate;
        for (divisor = 3; factor > 65520 && divisor > 0; factor >>= 3, --divisor) {
        }
        if (factor > 65520) {
            throw new IOException("Illegal baud rate #2");
        }
        int ret = this.controlOut(154, 4882, (factor = 65536 - factor) & 0xFF00 | divisor);
        if (ret < 0) {
            throw new IOException("Error setting baud rate #1");
        }
        ret = this.controlOut(154, 3884, factor & 0xFF);
        if (ret < 0) {
            throw new IOException("Error setting baud rate #2");
        }
    }

    @Override
    public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
        int divisor;
        int val = 49308;
        if (baudRate <= 0) {
            throw new IOException("Illegal baud rate #1");
        }
        int factor = 1532620800 / baudRate;
        for (divisor = 3; factor > 65520 && divisor > 0; factor >>= 3, --divisor) {
        }
        if (factor > 65520) {
            throw new IOException("Illegal baud rate #2");
        }
        factor = 65536 - factor;
        int rate = 0x80 | divisor | factor & 0xFF00;
        switch (parity) {
            case 0: {
                val |= 0;
                break;
            }
            case 1: {
                val |= 0x800;
                break;
            }
            case 2: {
                val |= 0x1800;
                break;
            }
            default: {
                throw new IOException("Illegal parity value " + parity);
            }
        }
        if (stopBits > 1) {
            val |= 0x400;
        }
        switch (dataBits) {
            case 5: {
                val |= 0;
                break;
            }
            case 6: {
                val |= 0x100;
                break;
            }
            case 7: {
                val |= 0x200;
                break;
            }
            default: {
                val |= 0x300;
            }
        }
        int ret = this.controlOut(161, val, rate);
        if (ret < 0) {
            throw new IOException("Set parameters failed #1");
        }
        ret = this.controlOut(154, 10023, 0);
        if (ret < 0) {
            throw new IOException("Set parameters failed #2");
        }
    }

    @Override
    public boolean getCD() throws IOException {
        return false;
    }

    @Override
    public boolean getCTS() throws IOException {
        return false;
    }

    @Override
    public boolean getDSR() throws IOException {
        return false;
    }

    @Override
    public boolean getDTR() throws IOException {
        return this.dtr;
    }

    @Override
    public void setDTR(boolean value) throws IOException {
        this.dtr = value;
        this.writeHandshakeByte();
    }

    @Override
    public boolean getRI() throws IOException {
        return false;
    }

    @Override
    public boolean getRTS() throws IOException {
        return this.rts;
    }

    @Override
    public void setRTS(boolean value) throws IOException {
        this.rts = value;
        this.writeHandshakeByte();
    }

    @Override
    public boolean purgeHwBuffers(boolean purgeReadBuffers, boolean purgeWriteBuffers) throws IOException {
        return true;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(6790, new int[]{29987, 21795});
        supportedDevices.put(17224, new int[]{21795});
        return supportedDevices;
    }
}

