/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialProber;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import tk.tcl.wish.AndroWish;

public class UsbSerial {
    private FileDescriptor fd;
    private UsbSerialDriver drv = null;
    private IOThread io1;
    private IOThread io2;
    private int mode = 9830592;
    private volatile boolean running;

    public static String[] listdevs() {
        UsbManager um = AndroWish.getUsbManager();
        if (um == null) {
            return null;
        }
        List list = UsbSerialProber.findSupportedDevices((UsbManager)um);
        String[] result = new String[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((UsbDevice)list.get(i)).getDeviceName();
        }
        return result;
    }

    public UsbSerial(FileDescriptor fd, String devname) {
        UsbManager um = AndroWish.getUsbManager();
        if (um == null) {
            throw new RuntimeException("no USB manager");
        }
        UsbDevice dev = AndroWish.getUsbDevCheck(devname);
        if (dev == null) {
            throw new RuntimeException("can't connect");
        }
        List dlist = UsbSerialProber.probeSingleDevice((UsbManager)um, (UsbDevice)dev);
        if (!dlist.isEmpty()) {
            this.drv = (UsbSerialDriver)dlist.get(0);
        }
        try {
            if (this.drv != null) {
                this.drv.open();
                this.setmode(this.mode);
                this.setlstatus(3);
                this.running = true;
                this.io1 = new IOThread(this, new FileOutputStream(fd));
                this.io2 = new IOThread(this, new FileInputStream(fd));
                this.io1.start();
                this.io2.start();
                this.fd = fd;
            }
        }
        catch (Exception e) {
            Log.e((String)"UsbSerial", (String)("<init>: " + e));
            this.close0();
            throw new RuntimeException("can't connect");
        }
        if (this.drv == null) {
            throw new RuntimeException("no driver found");
        }
    }

    void close0() {
        try {
            if (this.drv != null) {
                this.drv.close();
                this.drv = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this.running = false;
        try {
            if (this.io1 != null) {
                this.io1.join();
                this.io1 = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.io2 != null) {
                this.io2.join();
                this.io2 = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close0();
    }

    public void setmode(int mode) {
        try {
            this.drv.setParameters(mode >> 9 & 0x7FFFFF, mode >> 3 & 0xF, mode >> 7 & 3, mode & 7);
            this.mode = mode;
        }
        catch (Exception e) {
            Log.e((String)"UsbSerial", (String)("setmode: " + e));
        }
    }

    public int getmode() {
        return this.mode;
    }

    public void setlstatus(int status) {
        try {
            this.drv.setRTS((status & 1) != 0);
            this.drv.setDTR((status & 2) != 0);
        }
        catch (Exception e) {
            Log.e((String)"UsbSerial", (String)("setlstatus: " + e));
        }
    }

    public int getlstatus() {
        int status = 0;
        try {
            if (this.drv.getCTS()) {
                status |= 1;
            }
            if (this.drv.getDSR()) {
                status |= 2;
            }
            if (this.drv.getRI()) {
                status |= 4;
            }
            if (this.drv.getCD()) {
                status |= 8;
            }
        }
        catch (Exception e) {
            Log.e((String)"UsbSerial", (String)("getlstatus: " + e));
        }
        return status;
    }

    public static native void shutdown(FileDescriptor var0);

    private class IOThread
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private UsbSerial ser;

        public IOThread(UsbSerial ser, InputStream in) {
            this.ser = ser;
            this.in = in;
            this.out = null;
        }

        public IOThread(UsbSerial ser, OutputStream out) {
            this.ser = ser;
            this.in = null;
            this.out = out;
        }

        public void run() {
            Log.v((String)"UsbSerial", (String)"IOThread: start");
            IOLoop loop = new IOLoop(this.ser, this.in, this.out);
            loop.loop();
            this.ser.running = false;
            UsbSerial.shutdown(this.ser.fd);
            Log.v((String)"UsbSerial", (String)"IOThread: end");
        }
    }

    private class IOLoop {
        private UsbSerial ser;
        private InputStream in;
        private OutputStream out;

        public IOLoop(UsbSerial ser, InputStream in, OutputStream out) {
            this.ser = ser;
            this.in = in;
            this.out = out;
        }

        public void loop() {
            byte[] buf = new byte[256];
            while (this.ser.running) {
                try {
                    if (this.in != null) {
                        int data = this.in.read();
                        if (data < 0) break;
                        buf[0] = (byte)data;
                        int n = this.in.available();
                        if (n > 0) {
                            if (n > buf.length - 1) {
                                n = buf.length - 1;
                            }
                            if ((n = this.in.read(buf, 1, n)) < 0) break;
                            ++n;
                        } else {
                            n = 1;
                        }
                        n = this.ser.drv.write(buf, 0, n, 1000000);
                        if (n < 0) {
                            throw new IOException("UsbSerial write error " + n);
                        }
                    }
                    if (this.out == null) continue;
                    int n = this.ser.drv.read(buf, 500);
                    if (n > 0) {
                        this.out.write(buf, 0, n);
                        continue;
                    }
                    if (n >= 0) continue;
                    throw new IOException("UsbSerial read error " + n);
                }
                catch (IOException e) {
                    Log.e((String)"UsbSerial", (String)("loop: " + e));
                    break;
                }
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

