/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.media.AudioTrack;
import android.os.Process;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import tk.tcl.wish.AudioIO;

class PlayThread
extends Thread
implements AudioIO {
    static final String TAG = "SnackAudio/W";
    static final int CMD_CLOSE = -1;
    static final int CMD_IDLE = 0;
    static final int CMD_PLAY = 1;
    static final int CMD_STOP = 2;
    static final int STAT_INIT = -1;
    static final int STAT_STOP = 0;
    static final int STAT_PLAY = 1;
    AudioTrack mOut;
    FileInputStream mIs;
    int mCommand;
    int mStatus;
    int mBufSize;
    int mCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayThread(FileDescriptor fd, AudioTrack out, int n) {
        this.mOut = out;
        this.mIs = new FileInputStream(fd);
        this.mBufSize = n * 4;
        this.mCommand = 0;
        this.mStatus = -1;
        this.mCount = 0;
        this.start();
        PlayThread playThread = this;
        synchronized (playThread) {
            while (this.mStatus < 0) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAudio() {
        Log.v((String)TAG, (String)"stopAudio");
        this.mOut.pause();
        this.mOut.flush();
        PlayThread playThread = this;
        synchronized (playThread) {
            while (this.mStatus > 0) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAudio() {
        Log.v((String)TAG, (String)"startAudio");
        PlayThread playThread = this;
        synchronized (playThread) {
            if (this.mOut.getPlayState() != 3) {
                this.mCommand = 1;
                this.notifyAll();
            }
            while (this.mStatus == 0) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    public void flush() {
        this.mOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int played() {
        int ret;
        PlayThread playThread = this;
        synchronized (playThread) {
            ret = this.mCount;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Log.v((String)TAG, (String)"close");
        PlayThread playThread = this;
        synchronized (playThread) {
            while (this.mCommand >= 0) {
                this.mCommand = -1;
                this.notifyAll();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mOut.release();
        this.mOut = null;
        try {
            this.mIs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mIs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean done = false;
        byte[] buffer = new byte[this.mBufSize];
        PlayThread playThread = this;
        synchronized (playThread) {
            this.mStatus = 0;
            this.notifyAll();
            done = this.mCommand == -1;
        }
        Process.setThreadPriority((int)-19);
        Log.v((String)TAG, (String)"thread start");
        while (!done) {
            PlayThread playThread2;
            int docmd;
            PlayThread playThread3 = this;
            synchronized (playThread3) {
                while (this.mCommand == 0) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
                if (this.mCommand < 0) {
                    done = true;
                    continue;
                }
                docmd = this.mCommand;
                this.mCommand = 0;
            }
            if (docmd != 1) continue;
            try {
                this.mOut.play();
            }
            catch (Exception e) {
                playThread2 = this;
                synchronized (playThread2) {
                    this.mStatus = -1;
                    this.notifyAll();
                    continue;
                }
            }
            PlayThread e = this;
            synchronized (e) {
                this.mStatus = 1;
                this.notifyAll();
            }
            while (true) {
                e = this;
                synchronized (e) {
                    if (this.mCommand != 0) {
                        break;
                    }
                }
                int n = 0;
                while (n < buffer.length / 8) {
                    try {
                        int nn = this.mIs.read(buffer, n, buffer.length - n);
                        if (nn <= 0) {
                            playThread2 = this;
                            synchronized (playThread2) {
                                try {
                                    this.wait(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (this.mCommand != 0) {
                                    break;
                                }
                                continue;
                            }
                        }
                        n += nn;
                    }
                    catch (IOException ioe) {
                        Log.e((String)TAG, (String)("I/O error: " + ioe));
                        break;
                    }
                }
                if ((n = this.mOut.write(buffer, 0, n)) < 0) break;
                playThread3 = this;
                synchronized (playThread3) {
                    this.mCount += n;
                }
            }
            playThread3 = this;
            synchronized (playThread3) {
                this.mStatus = 0;
                this.notifyAll();
            }
        }
        Log.v((String)TAG, (String)"thread exiting");
    }
}

