/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.location.GpsSatellite;
import android.location.GpsStatus;
import tk.tcl.wish.AndroWish;

class GpsInfo
implements GpsStatus.Listener {
    AndroWish mAW;
    boolean mStarted = false;
    int mFirstFix = 0;
    GpsStatus mGpsStatus = null;

    public GpsInfo(AndroWish aw) {
        this.mAW = aw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGpsStatusChanged(int event) {
        boolean trigger = false;
        GpsInfo gpsInfo = this;
        synchronized (gpsInfo) {
            switch (event) {
                case 1: {
                    this.mGpsStatus = AndroWish.mLocationMgr.getGpsStatus(this.mGpsStatus);
                    if (this.mGpsStatus != null) {
                        this.mFirstFix = this.mGpsStatus.getTimeToFirstFix();
                    }
                    this.mStarted = true;
                    trigger = true;
                    break;
                }
                case 2: {
                    this.mGpsStatus = null;
                    this.mStarted = false;
                    this.mFirstFix = 0;
                    trigger = true;
                    break;
                }
                case 3: 
                case 4: {
                    this.mGpsStatus = AndroWish.mLocationMgr.getGpsStatus(this.mGpsStatus);
                    if (this.mGpsStatus == null) break;
                    this.mFirstFix = this.mGpsStatus.getTimeToFirstFix();
                    trigger = true;
                }
            }
        }
        if (event == 2) {
            if (AndroWish.mNmeaInfo != null) {
                AndroWish.mNmeaInfo.clear();
            }
        }
        if (trigger) {
            GpsInfo gpsInfo2 = this;
            gpsInfo2.mAW.nativeTriggerGpsUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo() {
        StringBuilder sb = new StringBuilder(64);
        GpsInfo gpsInfo = this;
        synchronized (gpsInfo) {
            sb.append("state ").append(this.mStarted ? "on" : "off");
            sb.append(" first_fix ").append(this.mFirstFix);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSatellites() {
        StringBuilder sb = new StringBuilder(4096);
        GpsInfo gpsInfo = this;
        synchronized (gpsInfo) {
            if (this.mGpsStatus != null) {
                int n = 0;
                for (GpsSatellite s : this.mGpsStatus.getSatellites()) {
                    if (n > 0) {
                        sb.append(" ");
                    }
                    sb.append(n).append(" {index ").append(n);
                    sb.append(" azimuth ").append(s.getAzimuth());
                    sb.append(" elevation ").append(s.getElevation());
                    sb.append(" prn ").append(s.getPrn());
                    sb.append(" snr ").append(s.getSnr());
                    sb.append(" almanac ").append(s.hasAlmanac() ? 1 : 0);
                    sb.append(" ephemeris ").append(s.hasEphemeris() ? 1 : 0);
                    sb.append(" infix ").append(s.usedInFix() ? 1 : 0);
                    sb.append("}");
                    ++n;
                }
            }
        }
        return sb.toString();
    }
}

