/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.hardware.Camera;
import android.util.Log;
import tk.tcl.wish.ImageCapture;

final class Callbacks
implements Camera.PreviewCallback,
Camera.ShutterCallback,
Camera.PictureCallback {
    public static String TAG = "ImageCallbacks";
    private ImageCapture mCapture;
    private int mImageRotation = 0;
    private boolean mNewImageNeeded;
    private long mLastImageReq;
    private int mLastImageRotation = 0;
    private int mLastImageWidth = 0;
    private int mLastImageHeight = 0;
    private int mImageNum = 0;
    private byte[] mLastImage = null;
    private byte[] mLastPicture = null;

    public Callbacks(ImageCapture capture) {
        this.mCapture = capture;
        this.mNewImageNeeded = true;
        this.mLastImageReq = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Callbacks callbacks = this;
        synchronized (callbacks) {
            this.mLastImage = null;
            this.mLastPicture = null;
            this.mNewImageNeeded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRotation() {
        Callbacks callbacks = this;
        synchronized (callbacks) {
            return this.mImageRotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRotation(int rotation) {
        Callbacks callbacks = this;
        synchronized (callbacks) {
            this.mImageRotation = rotation;
            this.mNewImageNeeded = true;
            this.mLastImage = null;
            this.mLastPicture = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLastImage(int[] info) {
        Callbacks callbacks = this;
        synchronized (callbacks) {
            this.mNewImageNeeded = true;
            this.mLastImageReq = System.currentTimeMillis();
        }
        callbacks = this;
        synchronized (callbacks) {
            if (info != null && this.mLastImage != null) {
                info[0] = this.mLastImageWidth;
                info[1] = this.mLastImageHeight;
                info[2] = this.mLastImageRotation;
                info[3] = this.mImageNum;
            }
            return this.mLastImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLastPicture() {
        byte[] ret;
        Callbacks callbacks = this;
        synchronized (callbacks) {
            ret = this.mLastPicture;
            this.mLastPicture = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        Log.v((String)TAG, (String)("onPreviewFrame " + this.mNewImageNeeded + " " + this.mImageRotation));
        if (!this.mNewImageNeeded && System.currentTimeMillis() - this.mLastImageReq > 5000L && this.mCapture.mPreviewing && this.mCapture.mCamera != null) {
            this.mCapture.mCamera.stopPreview();
            this.mCapture.mPreviewing = false;
        }
        Callbacks callbacks = this;
        synchronized (callbacks) {
            this.mCapture.mTakingPicture = false;
            this.mNewImageNeeded = false;
            int length = this.mCapture.mCameraRes.x * this.mCapture.mCameraRes.y;
            length = length / 2 * 3;
            if (data.length >= length) {
                this.mLastImageRotation = this.mImageRotation;
                this.mLastImageWidth = this.mCapture.mCameraRes.x;
                this.mLastImageHeight = this.mCapture.mCameraRes.y;
                ++this.mImageNum;
                this.mLastImage = data;
            } else {
                Log.e((String)TAG, (String)("onPreviewFrame " + data.length + "<" + length));
            }
        }
        ImageCapture.nativeTriggerImageCapture(this.mCapture.mPreviewing ? 1 : 0);
    }

    public void onShutter() {
        Log.v((String)TAG, (String)"onShutter");
        ImageCapture.nativeTriggerImageCapture(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPictureTaken(byte[] data, Camera camera) {
        Log.v((String)TAG, (String)"onPictureTaken");
        Callbacks callbacks = this;
        synchronized (callbacks) {
            this.mLastPicture = data;
            this.mCapture.mTakingPicture = false;
            this.mCapture.mPreviewing = false;
        }
        ImageCapture.nativeTriggerImageCapture(3);
    }
}

