/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class BTClient {
    private FileDescriptor fd;
    private BluetoothSocket sock;
    private IOThread io1;
    private IOThread io2;
    private int connected;
    private Object lock;

    public BTClient(FileDescriptor fd, String bdaddr, String uuid, int async) {
        BluetoothAdapter bt = BluetoothAdapter.getDefaultAdapter();
        BluetoothDevice dev = null;
        this.connected = 0;
        try {
            dev = bt.getRemoteDevice(bdaddr);
            this.sock = dev.createRfcommSocketToServiceRecord(UUID.fromString(uuid));
            if (async != 0) {
                this.lock = new Object();
                this.io1 = new IOThread(this, null, new FileOutputStream(fd));
                this.io2 = new IOThread(this, new FileInputStream(fd), null);
            } else {
                this.sock.connect();
                this.connected = 1;
                this.io1 = new IOThread(this, this.sock.getInputStream(), new FileOutputStream(fd));
                this.io2 = new IOThread(this, new FileInputStream(fd), this.sock.getOutputStream());
            }
            this.io1.start();
            this.io2.start();
            this.fd = fd;
        }
        catch (Exception e) {
            Log.e((String)"BTClient", (String)("<init>: " + e));
            this.sock = null;
            throw new RuntimeException("can't connect");
        }
    }

    public BTClient(FileDescriptor fd, BluetoothSocket sock) {
        try {
            this.io1 = new IOThread(this, sock.getInputStream(), new FileOutputStream(fd));
            this.io2 = new IOThread(this, new FileInputStream(fd), sock.getOutputStream());
            this.io1.start();
            this.io2.start();
            this.sock = sock;
            this.fd = fd;
        }
        catch (Exception e) {
            Log.e((String)"BTClient", (String)("<init>: " + e));
            this.sock = null;
            throw new RuntimeException("can't connect");
        }
    }

    public String peername() {
        String ret = null;
        try {
            BluetoothDevice dev = this.sock.getRemoteDevice();
            ret = dev.getAddress();
        }
        catch (Exception e) {
            Log.e((String)"BTClient", (String)("peername: " + e));
        }
        return ret;
    }

    void close0() {
        try {
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this.close0();
        try {
            if (this.io1 != null) {
                this.io1.join();
                this.io1 = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.io2 != null) {
                this.io2.join();
                this.io2 = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static native void shutdown(FileDescriptor var0);

    private class IOThread
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private BTClient btc;

        public IOThread(BTClient btc, InputStream in, OutputStream out) {
            this.btc = btc;
            this.in = in;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            Log.e((String)"BTClient", (String)"IOThread: start");
            if (this.in == null) {
                object = this.btc.lock;
                synchronized (object) {
                    try {
                        this.btc.sock.connect();
                        this.in = this.btc.sock.getInputStream();
                        this.out.write(0);
                        this.out.flush();
                        this.btc.connected = 1;
                    }
                    catch (Exception e) {
                        this.btc.connected = -1;
                        Log.e((String)"BTClient", (String)("connect failed: " + e));
                    }
                    this.btc.lock.notifyAll();
                }
            }
            if (this.out == null) {
                object = this.btc.lock;
                synchronized (object) {
                    try {
                        while (this.btc.connected == 0) {
                            this.btc.lock.wait();
                        }
                        if (this.btc.connected > 0) {
                            this.out = this.btc.sock.getOutputStream();
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"BTClient", (String)("connect failed: " + e));
                    }
                }
            }
            if (this.in != null && this.out != null) {
                IOLoop loop = new IOLoop(this.in, this.out);
                loop.loop();
            }
            this.btc.close0();
            BTClient.shutdown(this.btc.fd);
            Log.e((String)"BTClient", (String)"IOThread: end");
        }
    }

    private class IOLoop {
        private InputStream in;
        private OutputStream out;

        public IOLoop(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public void loop() {
            byte[] buf = new byte[1024];
            try {
                int data;
                while ((data = this.in.read()) >= 0) {
                    buf[0] = (byte)data;
                    int n = this.in.available();
                    if (n > 0) {
                        if (n > buf.length - 1) {
                            n = buf.length - 1;
                        }
                        if ((n = this.in.read(buf, 1, n)) < 0) break;
                        ++n;
                    } else {
                        n = 1;
                    }
                    this.out.write(buf, 0, n);
                }
            }
            catch (IOException e) {
                Log.e((String)"BTClient", (String)("loop: " + e));
            }
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

