/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.nfc.NfcManager;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.telephony.PhoneStateListener;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.core.location.LocationManagerCompat;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.libsdl.app.SDLActivity;
import tk.tcl.wish.BCRecvr;
import tk.tcl.wish.GpsInfo;
import tk.tcl.wish.ImageCapture;
import tk.tcl.wish.LocaleAPI1;
import tk.tcl.wish.NmeaInfo;
import tk.tcl.wish.PSListener;
import tk.tcl.wish.RadioVersion_ICS;
import tk.tcl.wish.Runner;
import tk.tcl.wish.Sensors;
import tk.tcl.wish.Shortcut_API26;
import tk.tcl.wish.SpRunner;
import tk.tcl.wish.SpeechRec;
import tk.tcl.wish.TTS_UPL;
import tk.tcl.wish.TextFromHtml;
import tk.tcl.wish.UsbPermissionTest;
import tk.tcl.wish.WrappedCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroWish
extends SDLActivity
implements LocationListener,
ActivityCompat.OnRequestPermissionsResultCallback {
    static final String TAG = "AndroWish";
    protected static AndroWish mSingleton;
    protected static PackageManager mPackageManager;
    protected static Vibrator mVibrator;
    protected static TextToSpeech mTTS;
    protected static CountDownLatch mTTSLock;
    protected static TTS_UPL mTTSUPL;
    protected static boolean mTTSAvailable;
    protected static int mTTSCount;
    protected static Map<String, Location> mLocations;
    protected static LocationManager mLocationMgr;
    protected static ConnectivityManager mConnMgr;
    protected static Object mNetLock;
    protected static NetworkInfo mNetworkInfo;
    protected static String[] mNTl;
    protected static String[] mNTa;
    protected static String[] mNTe;
    protected static BroadcastReceiver mNWRecvr;
    protected static BroadcastReceiver mNTRecvr;
    protected static NotificationManager mNotificationMgr;
    protected static BluetoothAdapter mBluetoothAdap;
    protected static BroadcastReceiver mBTRecvr;
    protected static BroadcastReceiver mBDRecvr;
    protected static ProgressDialog mSpinner;
    protected static ContentResolver mContentResolver;
    protected static AlarmManager mAlarmManager;
    protected static Ringtone mCurrentTone;
    protected static UsbManager mUsbManager;
    protected static Sensors mSensors;
    protected static SpeechRec mSpeechRec;
    protected static Object mConfigLock;
    protected static Configuration mConfig;
    protected static GpsInfo mGpsInfo;
    protected static NmeaInfo mNmeaInfo;
    protected static TelephonyManager mPhoneManager;
    protected static PSListener mPSListener;
    protected static Map<String, BCRecvr> mBCRecvrs;
    protected static ImageCapture mCamera;
    protected static BroadcastReceiver mUsbRecvr;
    protected static Map<String, UsbDeviceConnection> mUsbHold;
    protected static BCRecvr mNfcBCRecvr;
    protected static NfcAdapter mNfcAdapter;
    protected static Tag mNfcTag;
    protected static CountDownLatch mPermLock;
    private int mSavedOrient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreate(Bundle savedInstanceData) {
        Object pm;
        IntentFilter filter;
        super.onCreate(savedInstanceData);
        if (mSingleton != null) {
            this.finish();
            return;
        }
        mSingleton = this;
        int glesVer = AndroWish.getGLESVersion((Context)this);
        String lang = Locale.getDefault().toString();
        Log.v((String)TAG, (String)("onCreate GLES=" + glesVer + " LANG=" + lang));
        AndroWish.nativeInit(glesVer, lang);
        mPackageManager = this.getPackageManager();
        mNotificationMgr = (NotificationManager)this.getSystemService("notification");
        mContentResolver = this.getContentResolver();
        if (AndroWish.hasPerm("android.permission.VIBRATE")) {
            mVibrator = (Vibrator)this.getSystemService("vibrator");
        }
        if ((AndroWish.hasPerm("android.permission.ACCESS_FINE_LOCATION") || AndroWish.hasPerm("android.permission.ACCESS_COARSE_LOCATION")) && (mLocationMgr = (LocationManager)this.getSystemService("location")) != null) {
            mGpsInfo = new GpsInfo(this);
            mLocationMgr.addGpsStatusListener((GpsStatus.Listener)mGpsInfo);
            mNmeaInfo = new NmeaInfo(this);
            mLocationMgr.addNmeaListener((GpsStatus.NmeaListener)mNmeaInfo);
        }
        mLocations = new HashMap<String, Location>();
        mNetLock = new Object();
        mNTl = null;
        mNTa = null;
        mNTe = null;
        if (AndroWish.hasPerm("android.permission.ACCESS_NETWORK_STATE")) {
            mConnMgr = (ConnectivityManager)this.getSystemService("connectivity");
            filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            mNWRecvr = new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onReceive(Context context, Intent intent) {
                    Object object = mNetLock;
                    synchronized (object) {
                        mNetworkInfo = mConnMgr.getActiveNetworkInfo();
                    }
                    mSingleton.nativeTriggerNetworkInfo();
                }
            };
            this.registerReceiver(mNWRecvr, filter);
            filter = new IntentFilter();
            filter.addAction("android.net.conn.TETHER_STATE_CHANGED");
            mNTRecvr = new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onReceive(Context context, Intent intent) {
                    if (intent.getAction().equals("android.net.conn.TETHER_STATE_CHANGED")) {
                        ArrayList a = intent.getStringArrayListExtra("activeArray");
                        ArrayList l = intent.getStringArrayListExtra("availableArray");
                        ArrayList e = intent.getStringArrayListExtra("erroredArray");
                        Object object = mNetLock;
                        synchronized (object) {
                            if (a != null) {
                                mNTa = new String[a.size()];
                                a.toArray(mNTa);
                            } else {
                                mNTa = null;
                            }
                            if (l != null) {
                                mNTl = new String[l.size()];
                                l.toArray(mNTl);
                            } else {
                                mNTl = null;
                            }
                            if (e != null) {
                                mNTe = new String[e.size()];
                                e.toArray(mNTe);
                            } else {
                                mNTe = null;
                            }
                        }
                        mSingleton.nativeTriggerTetherInfo();
                    }
                }
            };
            this.registerReceiver(mNTRecvr, filter);
        }
        if (AndroWish.hasPerm("android.permission.BLUETOOTH") && AndroWish.hasPerm("android.permission.BLUETOOTH_ADMIN")) {
            mBluetoothAdap = BluetoothAdapter.getDefaultAdapter();
            filter = new IntentFilter();
            filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            filter.addAction("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
            mBTRecvr = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    mSingleton.nativeTriggerBluetooth();
                }
            };
            this.registerReceiver(mBTRecvr, filter);
            filter = new IntentFilter();
            filter.addAction("android.bluetooth.device.action.FOUND");
            filter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
            filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
            filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
            mBDRecvr = new BroadcastReceiver(){

                public void onReceive(Context context, Intent i) {
                    String action = i.getAction();
                    String uristr = i.getDataString();
                    String type = i.getType();
                    String[] cats = null;
                    String[] args = null;
                    try {
                        BluetoothDevice dev = (BluetoothDevice)i.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                        if (dev.getAddress() != null && dev.getName() != null) {
                            args = new String[]{dev.getAddress(), dev.getName()};
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Log.v((String)AndroWish.TAG, (String)("nativeTriggerIntent: " + action + "," + uristr + "," + type + "," + cats + "," + args));
                    AndroWish.nativeTriggerIntent(action, uristr, type, cats, args);
                }
            };
            this.registerReceiver(mBDRecvr, filter);
        }
        mAlarmManager = (AlarmManager)this.getSystemService("alarm");
        if (AndroWish.hasPerm("android.permission.WAKE_LOCK") && this.getIntent().getBooleanExtra("tk.tcl.wish.wakeup", false)) {
            pm = (PowerManager)this.getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(0x1000001A, TAG);
            wl.acquire();
            wl.release();
        }
        mCurrentTone = null;
        if (Build.VERSION.SDK_INT >= 11) {
            mUsbManager = (UsbManager)this.getSystemService("usb");
        }
        mSensors = new Sensors(this);
        if (AndroWish.hasPerm("android.permission.RECORD_AUDIO")) {
            mSpeechRec = new SpeechRec(this);
        }
        mConfigLock = new Object();
        pm = mConfigLock;
        synchronized (pm) {
            mConfig = new Configuration(this.getResources().getConfiguration());
        }
        mPSListener = null;
        mPhoneManager = (TelephonyManager)this.getSystemService("phone");
        if (mPhoneManager != null && AndroWish.hasPerm("android.permission.READ_PHONE_STATE")) {
            mPSListener = new PSListener(this);
            mPhoneManager.listen((PhoneStateListener)mPSListener, 481);
        }
        mBCRecvrs = new HashMap<String, BCRecvr>();
        if (AndroWish.hasPerm("android.permission.CAMERA")) {
            ImageCapture.init(AndroWish.getContext());
            mCamera = ImageCapture.get();
        }
        if (Build.VERSION.SDK_INT >= 11 && mUsbManager != null) {
            mUsbHold = new HashMap<String, UsbDeviceConnection>();
            filter = new IntentFilter();
            filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            mUsbRecvr = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String a = intent.getAction();
                    if (a.equals("android.hardware.usb.action.USB_DEVICE_ATTACHED")) {
                        AndroWish.nativeTriggerUsb(1);
                    } else if (a.equals("android.hardware.usb.action.USB_DEVICE_DETACHED")) {
                        String n;
                        UsbDeviceConnection c;
                        AndroWish.nativeTriggerUsb(0);
                        UsbDevice d = (UsbDevice)intent.getParcelableExtra("device");
                        if (d != null && (c = mUsbHold.get(n = d.getDeviceName())) != null) {
                            c.close();
                            mUsbHold.remove(n);
                        }
                    }
                }
            };
            this.registerReceiver(mUsbRecvr, filter);
        }
        if (AndroWish.hasPerm("android.permission.NFC")) {
            NfcManager manager = (NfcManager)this.getSystemService("nfc");
            mNfcAdapter = manager.getDefaultAdapter();
        } else {
            mNfcAdapter = null;
        }
        mNfcBCRecvr = null;
        mNfcTag = null;
        this.mSavedOrient = this.getRequestedOrientation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDestroy() {
        Log.v((String)TAG, (String)"onDestroy()");
        super.onDestroy();
        if (mPSListener != null) {
            mPhoneManager.listen((PhoneStateListener)mPSListener, 0);
            mPSListener = null;
        }
        if (mSpeechRec != null) {
            mSpeechRec.destroy();
            mSpeechRec = null;
        }
        if (mNWRecvr != null) {
            this.unregisterReceiver(mNWRecvr);
            mNWRecvr = null;
        }
        if (mNTRecvr != null) {
            this.unregisterReceiver(mNTRecvr);
            mNTRecvr = null;
        }
        if (mBTRecvr != null) {
            this.unregisterReceiver(mBTRecvr);
            mBTRecvr = null;
        }
        if (mBDRecvr != null) {
            this.unregisterReceiver(mBDRecvr);
            mBDRecvr = null;
        }
        if (mGpsInfo != null) {
            mLocationMgr.removeGpsStatusListener((GpsStatus.Listener)mGpsInfo);
            mGpsInfo = null;
        }
        if (mNmeaInfo != null) {
            mLocationMgr.removeNmeaListener((GpsStatus.NmeaListener)mNmeaInfo);
            mNmeaInfo = null;
        }
        if (mLocationMgr != null) {
            mLocationMgr.removeUpdates((LocationListener)this);
            mLocationMgr = null;
        }
        this.nfcEnable(false);
        Map<String, BCRecvr> map = mBCRecvrs;
        synchronized (map) {
            for (Map.Entry<String, BCRecvr> entry : mBCRecvrs.entrySet()) {
                BCRecvr bcr = entry.getValue();
                this.unregisterReceiver(bcr);
            }
            mBCRecvrs.clear();
        }
        mNfcBCRecvr = null;
        if (mCamera != null) {
            mCamera.onDestroy();
            mCamera = null;
        }
        if (mUsbRecvr != null) {
            this.unregisterReceiver(mUsbRecvr);
            mUsbRecvr = null;
        }
        if (mUsbHold != null) {
            for (UsbDeviceConnection c : mUsbHold.values()) {
                c.close();
            }
            mUsbHold.clear();
            mUsbHold = null;
        }
    }

    private static int getGLESVersion(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo ci = am.getDeviceConfigurationInfo();
        return (ci.reqGlEsVersion & 0xFFFF0000) >> 16;
    }

    static boolean hasPerm(String which) {
        int result = mSingleton.getContext().checkCallingOrSelfPermission(which);
        return result == 0;
    }

    @Override
    public void onPause() {
        super.onPause();
        mSensors.pause();
        if (mPSListener != null) {
            mPhoneManager.listen((PhoneStateListener)mPSListener, 0);
        }
        if (mCamera != null) {
            mCamera.onPause();
        }
        this.nfcEnable(false);
        this.mSavedOrient = this.getRequestedOrientation();
        int orient = AndroWish.mConfig.orientation == 1 ? 7 : 6;
        if (Build.VERSION.SDK_INT >= 27) {
            this.setRequestedOrientation(orient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResume() {
        super.onResume();
        mSensors.resume();
        if (mPSListener != null) {
            mPhoneManager.listen((PhoneStateListener)mPSListener, 481);
        }
        Configuration config = this.getResources().getConfiguration();
        boolean trigger = false;
        Object object = mConfigLock;
        synchronized (object) {
            if (config.keyboard != AndroWish.mConfig.keyboard || config.keyboardHidden != AndroWish.mConfig.keyboardHidden || config.hardKeyboardHidden != AndroWish.mConfig.hardKeyboardHidden) {
                trigger = true;
            }
            mConfig = new Configuration(config);
        }
        if (trigger) {
            mSingleton.nativeTriggerKeyboard();
        }
        if (mCamera != null) {
            mCamera.onResume();
        }
        this.nfcEnable(true);
        if (Build.VERSION.SDK_INT >= 27) {
            this.setRequestedOrientation(this.mSavedOrient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationChanged(Configuration config) {
        Log.v((String)TAG, (String)("onConfigurationChanged: " + config));
        super.onConfigurationChanged(config);
        boolean trigger = false;
        boolean hideIM = false;
        Object object = mConfigLock;
        synchronized (object) {
            if (config.keyboard != AndroWish.mConfig.keyboard || config.keyboardHidden != AndroWish.mConfig.keyboardHidden || config.hardKeyboardHidden != AndroWish.mConfig.hardKeyboardHidden) {
                hideIM = AndroWish.mConfig.hardKeyboardHidden == 1 && config.hardKeyboardHidden == 2;
                trigger = true;
            }
            mConfig = new Configuration(config);
        }
        if (hideIM) {
            super.hideTextInput();
        }
        if (trigger) {
            mSingleton.nativeTriggerKeyboard();
        }
    }

    int nfcEnable(boolean on) {
        if (mNfcAdapter == null) {
            return -1;
        }
        if (mNfcBCRecvr != null && on) {
            PendingIntent pi = PendingIntent.getBroadcast((Context)AndroWish.getContext(), (int)0, (Intent)new Intent("tk.tcl.wish.nfc"), (int)0);
            IntentFilter ndef = new IntentFilter("android.nfc.action.NDEF_DISCOVERED");
            IntentFilter[] filt = new IntentFilter[]{ndef};
            String[][] techs = new String[][]{{Ndef.class.getName()}, {NdefFormatable.class.getName()}};
            try {
                mNfcAdapter.enableForegroundDispatch((Activity)this, pi, filt, techs);
            }
            catch (Exception e) {
                return 0;
            }
            mNfcTag = null;
        } else {
            try {
                mNfcAdapter.disableForegroundDispatch((Activity)this);
            }
            catch (Exception e) {
                return 0;
            }
            mNfcTag = null;
        }
        return 1;
    }

    String[] formatBundle(Bundle b, String[] add) {
        Set keys = b.keySet();
        String[] ret = new String[keys.size() * 2 + (add != null ? add.length : 0)];
        int k = 0;
        for (String key : keys) {
            Object obj = b.get(key);
            ret[k++] = key;
            if (obj == null) {
                ret[k] = new String("");
            } else if (obj instanceof String) {
                ret[k] = (String)obj;
            } else if (obj instanceof String[]) {
                ret[k] = this.encodeStringList((String[])obj);
            } else if (obj instanceof byte[]) {
                ret[k] = Base64.encodeToString((byte[])((byte[])obj), (int)0);
            } else if (obj instanceof Bitmap) {
                ret[k] = this.encodeBitmap((Bitmap)obj);
            } else if (obj instanceof ArrayList) {
                ret[k] = this.encodeToList((ArrayList)obj);
            } else if (obj instanceof double[]) {
                ret[k] = this.encodeDoubleList((double[])obj);
            } else if (obj instanceof float[]) {
                ret[k] = this.encodeFloatList((float[])obj);
            } else if (obj instanceof short[]) {
                ret[k] = this.encodeShortList((short[])obj);
            } else if (obj instanceof int[]) {
                ret[k] = this.encodeIntList((int[])obj);
            } else if (obj instanceof long[]) {
                ret[k] = this.encodeLongList((long[])obj);
            } else if (obj instanceof boolean[]) {
                ret[k] = this.encodeBoolList((boolean[])obj);
            } else if (obj instanceof char[]) {
                ret[k] = this.encodeCharList((char[])obj);
            } else if (obj instanceof Boolean) {
                ret[k] = (Boolean)obj != false ? "1" : "0";
            } else if (obj instanceof Parcelable[] && key.equals("android.nfc.extra.NDEF_MESSAGES")) {
                ArrayList<byte[]> al = new ArrayList<byte[]>();
                Parcelable[] pa = (Parcelable[])obj;
                for (int n = 0; n < pa.length; ++n) {
                    NdefMessage msg = (NdefMessage)pa[n];
                    byte[] ba = msg != null ? msg.toByteArray() : new byte[]{};
                    al.add(ba);
                }
                ret[k] = this.encodeToList(al);
            } else {
                ret[k] = obj.toString();
            }
            ++k;
        }
        if (add != null) {
            for (int i = 0; i < add.length; ++i) {
                ret[k++] = add[i];
            }
        }
        return ret;
    }

    String[] formatCategories(Set<String> cset) {
        String[] ret = new String[cset.size()];
        cset.toArray(ret);
        return ret;
    }

    public void onNewIntent(Intent i) {
        this.setIntent(i);
        if (AndroWish.hasPerm("android.permission.WAKE_LOCK") && i.getBooleanExtra("tk.tcl.wish.wakeup", false)) {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(0x1000001A, TAG);
            wl.acquire();
            wl.release();
        }
        String action = i.getAction();
        String uristr = i.getDataString();
        String type = i.getType();
        String[] cats = null;
        String[] args = null;
        if (i.getCategories() != null) {
            cats = this.formatCategories(i.getCategories());
        }
        if (i.getExtras() != null) {
            args = this.formatBundle(i.getExtras(), null);
        }
        Log.v((String)TAG, (String)("nativeTriggerIntent: " + action + "," + uristr + "," + type + "," + cats + "," + args));
        AndroWish.nativeTriggerIntent(action, uristr, type, cats, args);
    }

    public static void syncIntent() {
        Runnable synci = new Runnable(){

            public void run() {
                mSingleton.onNewIntent(mSingleton.getIntent());
            }
        };
        mSingleton.runOnUiThread(synci);
    }

    public static Context getContext() {
        return mSingleton.getApplicationContext();
    }

    public static UsbManager getUsbManager() {
        return mUsbManager;
    }

    public static void setOrientation(final int orient) {
        Runnable do_orient = new Runnable(){

            public void run() {
                mSingleton.setRequestedOrientation(orient);
            }
        };
        mSingleton.runOnUiThread(do_orient);
    }

    public static int getOrientation() {
        return mSingleton.getRequestedOrientation();
    }

    public static int getResourceId(String name, String res) {
        try {
            return mSingleton.getResources().getIdentifier(name, res, mSingleton.getPackageName());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void onActivityResult(int id, int ret, Intent i) {
        super.onActivityResult(id, ret, i);
        String action = null;
        String uristr = null;
        String type = null;
        String[] cats = null;
        String[] args = null;
        if (i != null) {
            action = i.getAction();
            uristr = i.getDataString();
            type = i.getType();
            if (i.getCategories() != null) {
                cats = this.formatCategories(i.getCategories());
            }
            if (i.getExtras() != null) {
                args = this.formatBundle(i.getExtras(), null);
            }
        }
        Log.v((String)TAG, (String)("nativeIntentCallback: " + id + "," + ret + "," + action + "," + uristr + "," + type + "," + cats + "," + args));
        AndroWish.nativeIntentCallback(id, ret, action, uristr, type, cats, args);
    }

    String encodeBitmap(Bitmap bm) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bs);
        byte[] bytes = bs.toByteArray();
        bs = null;
        return Base64.encodeToString((byte[])bytes, (int)0);
    }

    String toElement(String in) {
        int i;
        int level = 0;
        int flags = 0;
        if (in == null) {
            return "{}";
        }
        int len = in.length();
        if (len == 0) {
            return "{}";
        }
        for (i = 0; i < len; ++i) {
            if (in.charAt(i) != '{' && in.charAt(i) != '}') continue;
            flags |= 1;
        }
        block16: for (i = 0; i < len; ++i) {
            switch (in.charAt(i)) {
                case '{': {
                    ++level;
                    continue block16;
                }
                case '}': {
                    if (--level >= 0) continue block16;
                    flags |= 2;
                    continue block16;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '$': 
                case ';': 
                case '[': {
                    flags |= 1;
                    continue block16;
                }
                case '\\': {
                    if (i + 1 == len || in.charAt(i + 1) == '\n') {
                        flags = 2;
                        continue block16;
                    }
                    flags |= 1;
                }
            }
        }
        if (level != 0) {
            flags = 2;
        }
        StringBuilder r = new StringBuilder(in.length() + 64);
        if ((flags & 1) == 1) {
            r.append("{");
            r.append(in);
            r.append("}");
        } else {
            i = 0;
            if (in.charAt(i) == '{') {
                flags |= 2;
                r.append("\\");
                r.append("{");
                ++i;
            }
            while (i < len) {
                switch (in.charAt(i)) {
                    case ' ': 
                    case '\"': 
                    case '$': 
                    case ';': 
                    case '[': 
                    case '\\': 
                    case ']': {
                        r.append("\\");
                        r.append(in.charAt(i));
                        break;
                    }
                    case '{': 
                    case '}': {
                        if ((flags & 2) != 0) {
                            r.append("\\");
                        }
                        r.append(in.charAt(i));
                        break;
                    }
                    case '\f': {
                        r.append("\\f");
                        break;
                    }
                    case '\n': {
                        r.append("\\n");
                        break;
                    }
                    case '\r': {
                        r.append("\\r");
                        break;
                    }
                    case '\t': {
                        r.append("\\t");
                        break;
                    }
                    case '\u000b': {
                        r.append("\\v");
                        break;
                    }
                    default: {
                        r.append(in.charAt(i));
                    }
                }
                ++i;
            }
        }
        return r.toString();
    }

    String encodeToList(ArrayList list) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (i != 0) {
                r.append(" ");
            }
            if (obj == null) {
                r.append("{}");
                continue;
            }
            if (obj instanceof String) {
                r.append(this.toElement((String)obj));
                continue;
            }
            if (obj instanceof byte[]) {
                r.append(Base64.encodeToString((byte[])((byte[])obj), (int)0));
                continue;
            }
            r.append(this.toElement(obj.toString()));
        }
        return r.toString();
    }

    String encodeDoubleList(double[] list) {
        StringBuilder r = new StringBuilder(list.length * 16);
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                r.append(" ");
            }
            r.append("" + list[i]);
        }
        return r.toString();
    }

    String encodeFloatList(float[] list) {
        StringBuilder r = new StringBuilder(list.length * 16);
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                r.append(" ");
            }
            r.append("" + list[i]);
        }
        return r.toString();
    }

    String encodeShortList(short[] list) {
        StringBuilder r = new StringBuilder(list.length * 8);
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                r.append(" ");
            }
            r.append("" + list[i]);
        }
        return r.toString();
    }

    String encodeIntList(int[] list) {
        StringBuilder r = new StringBuilder(list.length * 8);
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                r.append(" ");
            }
            r.append("" + list[i]);
        }
        return r.toString();
    }

    String encodeLongList(long[] list) {
        StringBuilder r = new StringBuilder(list.length * 8);
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                r.append(" ");
            }
            r.append("" + list[i]);
        }
        return r.toString();
    }

    String encodeBoolList(boolean[] list) {
        StringBuilder r = new StringBuilder(list.length * 3);
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                r.append(" ");
            }
            r.append("" + (list[i] ? "1" : "0"));
        }
        return r.toString();
    }

    String encodeCharList(char[] list) {
        StringBuilder r = new StringBuilder(list.length * 2);
        for (int i = 0; i < list.length; ++i) {
            r.append(list[i]);
        }
        return r.toString();
    }

    String encodeStringList(String[] list) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            if (i != 0) {
                r.append(" ");
            }
            if (s == null || s.length() == 0) {
                r.append("{}");
                continue;
            }
            r.append(this.toElement(s));
        }
        return r.toString();
    }

    static Intent buildIntent(Intent i, String uristr, String type, String[] cats, String[] comp) {
        Uri uri = null;
        if (uristr != null && uristr.length() > 0) {
            uri = Uri.parse((String)uristr);
        }
        if (type != null && type.length() == 0) {
            type = null;
        }
        if (uri != null && type != null) {
            i.setDataAndType(uri, type);
        } else if (uri != null) {
            i.setData(uri);
        } else if (type != null) {
            i.setType(type);
        }
        if (cats != null) {
            for (int k = 0; k < cats.length; ++k) {
                i.addCategory(cats[k]);
            }
        }
        if (comp != null && comp.length > 1) {
            i.setComponent(new ComponentName(comp[0], comp[1]));
        }
        return i;
    }

    static void addArgsToIntent(Intent i, String[] types, String[] argv) {
        if (argv != null) {
            for (int k = 0; k < argv.length; k += 2) {
                if (types != null && types[k] != null) {
                    if (types[k].equals("int")) {
                        i.putExtra(argv[k], Integer.parseInt(argv[k + 1]));
                        continue;
                    }
                    if (types[k].equals("long")) {
                        i.putExtra(argv[k], Long.parseLong(argv[k + 1]));
                        continue;
                    }
                    if (types[k].equals("short")) {
                        i.putExtra(argv[k], Short.parseShort(argv[k + 1]));
                        continue;
                    }
                    if (types[k].equals("char")) {
                        i.putExtra(argv[k], argv[k + 1].charAt(0));
                        continue;
                    }
                    if (types[k].equals("byte")) {
                        i.putExtra(argv[k], Byte.parseByte(argv[k + 1]));
                        continue;
                    }
                    if (types[k].equals("boolean")) {
                        i.putExtra(argv[k], Boolean.parseBoolean(argv[k + 1]));
                        continue;
                    }
                    if (types[k].equals("float")) {
                        i.putExtra(argv[k], Float.parseFloat(argv[k + 1]));
                        continue;
                    }
                    if (types[k].equals("double")) {
                        i.putExtra(argv[k], Double.parseDouble(argv[k + 1]));
                        continue;
                    }
                    if (types[k].equals("Uri")) {
                        i.putExtra(argv[k], (Parcelable)Uri.parse((String)argv[k + 1]));
                        continue;
                    }
                    if (types[k].equals("String")) {
                        i.putExtra(argv[k], argv[k + 1]);
                        continue;
                    }
                    i.putExtra(argv[k], argv[k + 1]);
                    continue;
                }
                i.putExtra(argv[k], argv[k + 1]);
            }
        }
    }

    public static int runActivity(String action, String uristr, String type, String[] cats, String[] types, String[] argv, int id) {
        int err = id < 0 ? id - 1 : -100;
        try {
            Intent i = new Intent(action);
            i = AndroWish.buildIntent(i, uristr, type, cats, null);
            AndroWish.addArgsToIntent(i, types, argv);
            Runner r = new Runner(mSingleton, i, id);
            mSingleton.runOnUiThread(r);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("runActivity failed: " + e.toString()));
            return err;
        }
        return id;
    }

    public static int runActivityEx(String action, String uristr, String type, String[] cats, String[] comp, String[] types, String[] argv, int id) {
        int err = id < 0 ? id - 1 : -100;
        try {
            Intent i = new Intent(action);
            i = AndroWish.buildIntent(i, uristr, type, cats, comp);
            AndroWish.addArgsToIntent(i, types, argv);
            Runner r = new Runner(mSingleton, i, id);
            mSingleton.runOnUiThread(r);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("runActivity failed: " + e.toString()));
            return err;
        }
        return id;
    }

    public void broadcastReceived(Intent i, int retcode) {
        Bundle extras;
        String action = i.getAction();
        String uristr = i.getDataString();
        String type = i.getType();
        String[] cats = null;
        String[] args = null;
        if (i.getCategories() != null) {
            cats = this.formatCategories(i.getCategories());
        }
        if ((extras = i.getExtras()) != null) {
            String[] addargs = null;
            if (action.equals("android.provider.Telephony.SMS_RECEIVED")) {
                Object[] pdus = (Object[])extras.get("pdus");
                if (pdus.length > 0) {
                    SmsMessage[] msgs = new SmsMessage[pdus.length];
                    StringBuilder sb = new StringBuilder();
                    for (int k = 0; k < pdus.length; ++k) {
                        msgs[k] = SmsMessage.createFromPdu((byte[])((byte[])pdus[k]));
                        sb.append(msgs[k].getMessageBody());
                    }
                    addargs = new String[]{"phone_number", msgs[0].getOriginatingAddress(), "sms_text", sb.toString()};
                }
            } else if (action.equals("tk.tcl.wish.nfc") && extras.get("android.nfc.extra.TAG") != null) {
                mNfcTag = (Tag)extras.get("android.nfc.extra.TAG");
            }
            args = this.formatBundle(extras, addargs);
        }
        Log.v((String)TAG, (String)("nativeBroadcastCallback: " + retcode + "," + action + "," + uristr + "," + type + "," + cats + "," + args));
        AndroWish.nativeBroadcastCallback(retcode, action, uristr, type, cats, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int handleBroadcastListener(int op, String action) {
        int ret = -1;
        if (action == null) {
            return ret;
        }
        final boolean isNfc = action.equals("tk.tcl.wish.nfc");
        Map<String, BCRecvr> map = mBCRecvrs;
        synchronized (map) {
            BCRecvr bcr = mBCRecvrs.get(action);
            if (op == 0) {
                ret = 0;
                if (bcr != null) {
                    mBCRecvrs.remove(action);
                    final BCRecvr unreg_bcr = bcr;
                    if (isNfc) {
                        mNfcBCRecvr = null;
                    }
                    Runnable unreg = new Runnable(){

                        public void run() {
                            mSingleton.unregisterReceiver(unreg_bcr);
                            if (isNfc) {
                                mSingleton.nfcEnable(false);
                            }
                        }
                    };
                    mSingleton.runOnUiThread(unreg);
                    ret = 1;
                }
            } else if (op == 1) {
                ret = 0;
                if (bcr == null) {
                    final BCRecvr reg_bcr = new BCRecvr(mSingleton);
                    final IntentFilter filter = new IntentFilter();
                    filter.addAction(action);
                    mBCRecvrs.put(action, reg_bcr);
                    if (isNfc) {
                        mNfcBCRecvr = reg_bcr;
                    }
                    Runnable reg = new Runnable(){

                        public void run() {
                            mSingleton.registerReceiver(reg_bcr, filter);
                            if (isNfc) {
                                mSingleton.nfcEnable(true);
                            }
                        }
                    };
                    mSingleton.runOnUiThread(reg);
                    ret = 1;
                }
            }
        }
        return ret;
    }

    public static int sendSMS(String phone, String msg, String actionSent, String actionDelivered, String smsc) {
        PendingIntent piSent = null;
        PendingIntent piDelivered = null;
        if (phone == null || msg == null) {
            return 0;
        }
        if (!AndroWish.hasPerm("android.permission.SEND_SMS")) {
            Log.e((String)TAG, (String)"sendSMS failed: no permission");
            return 0;
        }
        SmsManager sms = SmsManager.getDefault();
        if (sms == null) {
            Log.e((String)TAG, (String)"sendSMS failed: no SmsManager");
            return 0;
        }
        if (actionSent != null) {
            piSent = PendingIntent.getBroadcast((Context)mSingleton, (int)0, (Intent)new Intent(actionSent), (int)0);
        }
        if (actionDelivered != null) {
            piDelivered = PendingIntent.getBroadcast((Context)mSingleton, (int)0, (Intent)new Intent(actionDelivered), (int)0);
        }
        sms.sendTextMessage(phone, smsc, msg, piSent, piDelivered);
        return 1;
    }

    public static int speechRecognition(String[] types, String[] argv, int id) {
        if (mSpeechRec == null) {
            return -1;
        }
        if (id < 0) {
            Intent i = null;
            if (id == -3) {
                try {
                    i = new Intent("android.speech.action.RECOGNIZE_SPEECH");
                    i.putExtra("calling_package", ((Object)((Object)mSingleton)).getClass().getPackage().getName());
                    AndroWish.addArgsToIntent(i, types, argv);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("speechRecognition failed: " + e.toString()));
                }
            }
            SpRunner sr = new SpRunner(mSpeechRec, i, id);
            mSingleton.runOnUiThread(sr);
            return 0;
        }
        try {
            Intent i = new Intent("android.speech.action.RECOGNIZE_SPEECH");
            i.putExtra("calling_package", ((Object)((Object)mSingleton)).getClass().getPackage().getName());
            AndroWish.addArgsToIntent(i, types, argv);
            Runner r = new Runner(mSingleton, i, id);
            mSingleton.runOnUiThread(r);
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)("speechRecognition failed: " + e.toString()));
            return -1;
        }
        return id;
    }

    public static String[] queryIntents(int which, String action, String uristr, String type, String[] cats, String[] comp) {
        List acts;
        int k;
        ArrayList<String> apps = new ArrayList<String>();
        Uri uri = null;
        if (uristr != null && uristr.length() > 0) {
            uri = Uri.parse((String)uristr);
        }
        if (type != null && type.length() == 0) {
            type = null;
        }
        Intent i = new Intent(action);
        if (uri != null && type != null) {
            i.setDataAndType(uri, type);
        } else if (uri != null) {
            i.setData(uri);
        } else if (type != null) {
            i.setType(type);
        }
        if (cats != null) {
            for (k = 0; k < cats.length; ++k) {
                i.addCategory(cats[k]);
            }
        }
        try {
            if (comp != null && comp.length > 1) {
                i.setComponent(new ComponentName(comp[0], comp[1]));
            }
        }
        catch (Exception e) {
            return null;
        }
        switch (which) {
            default: {
                acts = mPackageManager.queryIntentActivities(i, 0);
                break;
            }
            case 1: {
                acts = mPackageManager.queryIntentServices(i, 0);
                break;
            }
            case 2: {
                acts = mPackageManager.queryBroadcastReceivers(i, 0);
            }
        }
        k = 0;
        for (ResolveInfo res : acts) {
            ActivityInfo actinfo = res.activityInfo;
            if (actinfo == null) continue;
            apps.add(actinfo.name);
            ++k;
        }
        String[] ret = new String[k];
        apps.toArray(ret);
        return ret;
    }

    public static String[] queryFeatures() {
        FeatureInfo[] fi = mPackageManager.getSystemAvailableFeatures();
        if (fi == null || fi.length == 0) {
            return null;
        }
        String[] ret = new String[fi.length];
        for (int i = 0; i < fi.length; ++i) {
            ret[i] = fi[i].name;
        }
        return ret;
    }

    public static String[] packageInfo(String name) {
        if (name == null) {
            List pl = mPackageManager.getInstalledPackages(0);
            ArrayList<String> ps = new ArrayList<String>();
            int k = 0;
            for (PackageInfo pi : pl) {
                ps.add(pi.packageName);
                ++k;
            }
            String[] ret = new String[k];
            ps.toArray(ret);
            return ret;
        }
        try {
            PackageInfo pi = mPackageManager.getPackageInfo(name, 1);
            String[] ret = new String[]{"classname", pi.applicationInfo.className, "datadir", pi.applicationInfo.dataDir, "sourcedir", pi.applicationInfo.sourceDir, "sharedlibrarydir", pi.applicationInfo.nativeLibraryDir, "publicsourcedir", pi.applicationInfo.publicSourceDir};
            return ret;
        }
        catch (PackageManager.NameNotFoundException ne) {
            return null;
        }
    }

    public static String[] providerInfo() {
        List pl = mPackageManager.getInstalledPackages(8);
        ArrayList<String> ps = new ArrayList<String>();
        int k = 0;
        for (PackageInfo pi : pl) {
            if (pi.providers == null) continue;
            for (int i = 0; i < pi.providers.length; ++i) {
                String[] auth = pi.providers[i].authority.split(";");
                for (int j = 0; j < auth.length; ++j) {
                    ps.add(auth[j]);
                    ++k;
                }
            }
        }
        String[] ret = new String[k];
        ps.toArray(ret);
        return ret;
    }

    public static WrappedCursor contentQuery(String uristr, String[] columns, String where, String[] whereArgs, String orderby) {
        WrappedCursor wc = null;
        Uri uri = Uri.parse((String)uristr);
        try {
            Cursor c = mContentResolver.query(uri, columns, where, whereArgs, orderby);
            if (c != null) {
                wc = new WrappedCursor(c);
            }
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)("contentQuery:" + e.toString()));
        }
        return wc;
    }

    public static String contentInsert(String uristr, String[] args) {
        Uri uri = Uri.parse((String)uristr);
        ContentValues vals = new ContentValues();
        for (int i = 0; i < args.length / 2; ++i) {
            vals.put(args[i * 2], args[i * 2 + 1]);
        }
        try {
            uri = mContentResolver.insert(uri, vals);
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)("contentInsert:" + e.toString()));
        }
        return null;
    }

    public static int contentUpdate(String uristr, String[] uvals, String sel, String[] args) {
        int i;
        Uri uri = Uri.parse((String)uristr);
        ContentValues vals = new ContentValues();
        for (i = 0; i < uvals.length / 2; ++i) {
            vals.put(uvals[i * 2], uvals[i * 2 + 1]);
        }
        i = 0;
        try {
            i = mContentResolver.update(uri, vals, sel, args);
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)("contentUpdate:" + e.toString()));
        }
        return i;
    }

    public static int contentDelete(String uristr, String sel, String[] args) {
        Uri uri = Uri.parse((String)uristr);
        int i = 0;
        try {
            i = mContentResolver.delete(uri, sel, args);
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)("contentDelete:" + e.toString()));
        }
        return i;
    }

    public static void vibrate(int duration) {
        if (duration <= 0) {
            duration = 500;
        }
        if (mVibrator != null) {
            mVibrator.vibrate((long)duration);
        }
    }

    public static void beep() {
        Runnable beeper = new Runnable(){

            public void run() {
                Uri ringuri = RingtoneManager.getDefaultUri((int)2);
                Ringtone tone = RingtoneManager.getRingtone((Context)mSingleton.getBaseContext(), (Uri)ringuri);
                if (tone != null && !tone.isPlaying()) {
                    tone.play();
                }
            }
        };
        mSingleton.runOnUiThread(beeper);
    }

    public static void beepEx(final String uristr) {
        Runnable beeper = new Runnable(){

            public void run() {
                Ringtone tone;
                if (mCurrentTone != null) {
                    mCurrentTone.stop();
                    mCurrentTone = null;
                }
                Uri ringuri = null;
                if (uristr != null) {
                    if (uristr.length() == 0) {
                        return;
                    }
                    ringuri = Uri.parse((String)uristr);
                }
                if (ringuri == null) {
                    ringuri = RingtoneManager.getDefaultUri((int)2);
                }
                if ((tone = RingtoneManager.getRingtone((Context)mSingleton.getBaseContext(), (Uri)ringuri)) != null && !tone.isPlaying()) {
                    tone.play();
                    if (uristr != null) {
                        mCurrentTone = tone;
                    }
                }
            }
        };
        mSingleton.runOnUiThread(beeper);
    }

    public static void toast(final String text, final int duration) {
        Runnable toaster = new Runnable(){

            public void run() {
                Toast toast = Toast.makeText((Context)mSingleton.getBaseContext(), (CharSequence)text, (int)(duration > 0 ? 1 : 0));
                if (toast != null) {
                    toast.show();
                }
            }
        };
        mSingleton.runOnUiThread(toaster);
    }

    public static void toastHtml(final String text, final int duration) {
        Runnable toaster = new Runnable(){

            public void run() {
                Toast toast = Toast.makeText((Context)mSingleton.getBaseContext(), (CharSequence)TextFromHtml.text(text), (int)(duration > 0 ? 1 : 0));
                if (toast != null) {
                    toast.show();
                }
            }
        };
        mSingleton.runOnUiThread(toaster);
    }

    public static int speak(int op, String text, String lang, float pitch, float rate) {
        int ret;
        block25: {
            ret = 0;
            if (op < 0) {
                if (mTTS != null) {
                    mTTS.stop();
                    mTTS.shutdown();
                    if (Build.VERSION.SDK_INT > 14) {
                        mTTSUPL.onShutdown();
                        mTTSUPL = null;
                    } else {
                        mTTSLock = null;
                    }
                    mTTS = null;
                }
                return ret;
            }
            if (mTTS == null) {
                if (Build.VERSION.SDK_INT > 14) {
                    mTTSUPL = new TTS_UPL(mSingleton);
                } else {
                    mTTSLock = new CountDownLatch(1);
                }
                mTTSCount = 999;
                Runnable speaker = new Runnable(){

                    public void run() {
                        mTTS = Build.VERSION.SDK_INT > 14 ? new TextToSpeech(mSingleton.getContext(), (TextToSpeech.OnInitListener)mTTSUPL) : new TextToSpeech(mSingleton.getContext(), new TextToSpeech.OnInitListener(){

                            public void onInit(int status) {
                                mTTSLock.countDown();
                            }
                        });
                    }
                };
                mSingleton.runOnUiThread(speaker);
            }
            try {
                if (Build.VERSION.SDK_INT > 14) {
                    if (!mTTSAvailable) {
                        return -1;
                    }
                } else {
                    mTTSLock.await();
                }
                switch (op) {
                    case 0: {
                        mTTS.stop();
                        break;
                    }
                    case 1: {
                        Locale loc;
                        if (pitch >= 0.0f) {
                            ret = mTTS.setPitch(pitch);
                        }
                        if (ret == 0 && rate > 0.0f) {
                            ret = mTTS.setSpeechRate(rate);
                        }
                        if (ret == 0 && lang != null && (ret = mTTS.isLanguageAvailable(loc = new Locale(lang))) >= 0 && text != null && text.length() > 0) {
                            ret = mTTS.setLanguage(loc);
                        }
                        if (ret < 0 || text == null || text.length() <= 0) break;
                        HashMap<String, String> uplid = null;
                        int id = 0;
                        if (Build.VERSION.SDK_INT > 14) {
                            if ((id = ++mTTSCount) > 1999) {
                                mTTSCount = 999;
                                id = ++mTTSCount;
                            }
                            uplid = new HashMap<String, String>();
                            uplid.put("utteranceId", "" + id);
                        }
                        if ((ret = mTTS.speak(text, 1, uplid)) == 0) {
                            ret = id;
                        }
                        break;
                    }
                    case 2: {
                        if (!mTTS.isSpeaking()) break;
                        ret = 1;
                    }
                }
            }
            catch (InterruptedException e) {
                if (mTTS == null) break block25;
                mTTS.shutdown();
                if (Build.VERSION.SDK_INT > 14) {
                    mTTSUPL.onShutdown();
                    mTTSUPL = null;
                } else {
                    mTTSLock = null;
                }
                mTTS = null;
            }
        }
        return ret;
    }

    public static String[] queryFields(String clsname, int reqFlags) {
        ArrayList<String> list = new ArrayList<String>();
        int atLeastFlags = 5;
        int k = 0;
        try {
            Class<?> cls = Class.forName(clsname);
            for (Field field : cls.getFields()) {
                if ((field.getModifiers() & reqFlags) != reqFlags || (field.getModifiers() & atLeastFlags) == 0) continue;
                Class<?> type = field.getType();
                list.add(field.getName());
                Object obj = field.get(null);
                if (obj == null) {
                    list.add("");
                } else if (obj instanceof String) {
                    list.add((String)obj);
                } else if (obj instanceof String[]) {
                    list.add(mSingleton.encodeStringList((String[])obj));
                } else if (obj instanceof double[]) {
                    list.add(mSingleton.encodeDoubleList((double[])obj));
                } else if (obj instanceof float[]) {
                    list.add(mSingleton.encodeFloatList((float[])obj));
                } else if (obj instanceof short[]) {
                    list.add(mSingleton.encodeShortList((short[])obj));
                } else if (obj instanceof int[]) {
                    list.add(mSingleton.encodeIntList((int[])obj));
                } else if (obj instanceof long[]) {
                    list.add(mSingleton.encodeLongList((long[])obj));
                } else {
                    list.add(obj.toString());
                }
                k += 2;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("queryConsts failed: " + e));
        }
        String[] ret = new String[k];
        list.toArray(ret);
        return ret;
    }

    public static String[] queryConsts(String clsname) {
        return AndroWish.queryFields(clsname, 24);
    }

    public static String[] queryConsts(String clsname, int fields) {
        int reqFlags = 8;
        if (fields == 0) {
            reqFlags |= 0x10;
        }
        return AndroWish.queryFields(clsname, reqFlags);
    }

    public static String getDisplayMetrics() {
        DisplayMetrics metrics = new DisplayMetrics();
        mSingleton.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int rot = mSingleton.getWindowManager().getDefaultDisplay().getRotation();
        StringBuilder sb = new StringBuilder(128);
        sb.append("density ").append(metrics.density);
        sb.append(" densitydpi ").append(metrics.densityDpi);
        sb.append(" width ").append(metrics.widthPixels);
        sb.append(" height ").append(metrics.heightPixels);
        sb.append(" xdpi ").append(metrics.xdpi);
        sb.append(" ydpi ").append(metrics.ydpi);
        sb.append(" scaleddensity ").append(metrics.scaledDensity);
        switch (rot) {
            case 1: {
                rot = 90;
                break;
            }
            case 2: {
                rot = 180;
                break;
            }
            case 3: {
                rot = 270;
                break;
            }
            default: {
                rot = 0;
            }
        }
        sb.append(" rotation ").append(rot);
        return sb.toString();
    }

    public static String[] getOSBuildInfo() {
        String[] ret = new String[]{"version.codename", Build.VERSION.CODENAME, "version.incremental", Build.VERSION.INCREMENTAL, "version.release", Build.VERSION.RELEASE, "version.sdk", "" + Build.VERSION.SDK_INT, "board", Build.BOARD, "bootloader", Build.BOOTLOADER, "brand", Build.BRAND, "cpu_abi", Build.CPU_ABI, "cpu_abi2", Build.CPU_ABI2, "device", Build.DEVICE, "display", Build.DISPLAY, "fingerprint", Build.FINGERPRINT, "hardware", Build.HARDWARE, "host", Build.HOST, "id", Build.ID, "manufacturer", Build.MANUFACTURER, "model", Build.MODEL, "product", Build.PRODUCT, "serial", Build.VERSION.SDK_INT < 26 ? Build.SERIAL : Settings.Secure.getString((ContentResolver)mContentResolver, (String)"android_id"), "tags", Build.TAGS, "time", "" + Build.TIME, "type", Build.TYPE, "user", Build.USER, "radio", Build.VERSION.SDK_INT < 14 ? Build.RADIO : RadioVersion_ICS.getRadioVersion()};
        return ret;
    }

    public static void withdraw() {
        Runnable dowithdraw = new Runnable(){

            public void run() {
                mSingleton.moveTaskToBack(true);
            }
        };
        mSingleton.runOnUiThread(dowithdraw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getKeyboardInfo() {
        int hardKeyboardHidden;
        int keyboardHidden;
        int keyboard;
        Object object = mConfigLock;
        synchronized (object) {
            keyboard = AndroWish.mConfig.keyboard;
            keyboardHidden = AndroWish.mConfig.keyboardHidden;
            hardKeyboardHidden = AndroWish.mConfig.hardKeyboardHidden;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("keyboard ");
        switch (keyboard) {
            case 1: {
                sb.append("none");
                break;
            }
            case 2: {
                sb.append("qwerty");
                break;
            }
            case 3: {
                sb.append("12key");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        sb.append(" hidden ");
        switch (keyboardHidden) {
            case 2: {
                sb.append("1");
                break;
            }
            case 1: {
                sb.append("0");
                break;
            }
            default: {
                sb.append("-1");
            }
        }
        sb.append(" hard_hidden ");
        switch (hardKeyboardHidden) {
            case 2: {
                sb.append("1");
                break;
            }
            case 1: {
                sb.append("0");
                break;
            }
            default: {
                sb.append("-1");
            }
        }
        return sb.toString();
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLocationChanged(Location location) {
        String provider = location.getProvider();
        if (provider == null) {
            return;
        }
        Map<String, Location> map = mLocations;
        synchronized (map) {
            mLocations.put(provider, location);
        }
        if (mSingleton.nativeTriggerLocation() < 0) {
            AndroWish.stopLocating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocation() {
        StringBuilder sb = new StringBuilder(128);
        int k = 0;
        Map<String, Location> map = mLocations;
        synchronized (map) {
            for (Map.Entry<String, Location> entry : mLocations.entrySet()) {
                Location loc = entry.getValue();
                if (loc.getProvider() == null) continue;
                if (++k > 1) {
                    sb.append(" ");
                }
                sb.append(loc.getProvider()).append(" {");
                sb.append("latitude ").append(loc.getLatitude());
                sb.append(" longitude ").append(loc.getLongitude());
                sb.append(" time ").append(loc.getTime() / 1000L);
                sb.append(" velocity ").append(loc.getSpeed());
                sb.append(" altitude ").append(loc.getAltitude());
                sb.append(" bearing ").append(loc.getBearing());
                sb.append(" accuracy ").append(loc.getAccuracy());
                sb.append("}");
            }
        }
        return sb.toString();
    }

    public static String getGpsNmeaInfo(int which) {
        if (mGpsInfo != null) {
            switch (which) {
                case 0: {
                    return mGpsInfo.getInfo();
                }
                case 1: {
                    return mGpsInfo.getSatellites();
                }
            }
        }
        if (mNmeaInfo != null && which == 2) {
            return mNmeaInfo.getInfo();
        }
        return null;
    }

    public static void startLocating(final int minrate, final int mindist) {
        if (mLocationMgr == null) {
            return;
        }
        Runnable locStart = new Runnable(){

            public void run() {
                for (String provider : mLocationMgr.getAllProviders()) {
                    mLocationMgr.requestLocationUpdates(provider, (long)minrate, (float)mindist, (LocationListener)mSingleton);
                }
            }
        };
        mSingleton.runOnUiThread(locStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopLocating() {
        if (mLocationMgr == null) {
            return;
        }
        mLocationMgr.removeUpdates((LocationListener)mSingleton);
        Map<String, Location> map = mLocations;
        synchronized (map) {
            mLocations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNetworkInfo() {
        String result = "none";
        if (mConnMgr == null) {
            return result;
        }
        Object object = mNetLock;
        synchronized (object) {
            if (mNetworkInfo == null) {
                mNetworkInfo = mConnMgr.getActiveNetworkInfo();
            }
            if (mNetworkInfo != null && mNetworkInfo.isConnected()) {
                String type = mNetworkInfo.getTypeName();
                result = type.toLowerCase().equals("mobile") ? "mobile " + mNetworkInfo.getSubtypeName() : type.toLowerCase();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getTetherInfo() {
        String[] list = new String[6];
        if (mConnMgr != null) {
            Object object = mNetLock;
            synchronized (object) {
                list[0] = "active";
                list[1] = mNTa != null && mNTa.length > 0 ? mSingleton.encodeStringList(mNTa) : null;
                list[2] = "available";
                list[3] = mNTl != null && mNTl.length > 0 ? mSingleton.encodeStringList(mNTl) : null;
                list[4] = "error";
                list[5] = mNTe != null && mNTe.length > 0 ? mSingleton.encodeStringList(mNTe) : null;
            }
        }
        return list;
    }

    public static String getLocationInfo() {
        String result = "none";
        try {
            LocationManager lm = (LocationManager)mSingleton.getContext().getSystemService("location");
            boolean on = LocationManagerCompat.isLocationEnabled((LocationManager)lm);
            result = on ? "on" : "off";
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getLocationInfo failed: " + e.toString()));
        }
        return result;
    }

    public static void shortcut(int op, String name, String arg, String icon) {
        Intent toRun;
        switch (op) {
            case 0: {
                if (Build.VERSION.SDK_INT < 19 || AndroWish.hasPerm("com.android.launcher.permission.INSTALL_SHORTCUT")) break;
                return;
            }
            case 1: {
                if (Build.VERSION.SDK_INT < 19 || AndroWish.hasPerm("com.android.launcher.permission.UNINSTALL_SHORTCUT")) break;
                return;
            }
            default: {
                return;
            }
        }
        Intent.ShortcutIconResource iconRes = null;
        Bitmap iconBitmap = null;
        try {
            iconRes = Intent.ShortcutIconResource.fromContext((Context)mSingleton.getContext(), (int)2130837505);
        }
        catch (Exception e) {
            iconRes = null;
        }
        if (Build.VERSION.SDK_INT < 19 || Build.VERSION.SDK_INT >= 26) {
            ComponentName comp = new ComponentName(mSingleton.getPackageName(), "tk.tcl.wish.AndroWishLauncher");
            toRun = new Intent("android.intent.action.MAIN");
            toRun.setComponent(comp);
        } else {
            toRun = new Intent("android.intent.action.VIEW");
            toRun.setFlags(0x10000000);
            toRun.addCategory("android.intent.category.DEFAULT");
        }
        if (arg != null && arg.length() > 0) {
            if (Build.VERSION.SDK_INT < 14) {
                toRun.putExtra("arg", arg);
            } else {
                toRun.setData(Uri.parse((String)arg));
            }
        }
        if (icon != null) {
            byte[] b;
            try {
                b = Base64.decode((String)icon, (int)0);
            }
            catch (Exception be) {
                b = null;
            }
            if (b != null && b.length > 0) {
                iconBitmap = BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
            }
        }
        switch (op) {
            case 0: {
                if (Build.VERSION.SDK_INT >= 26) {
                    if (Shortcut_API26.add((Context)mSingleton.getContext(), (Intent)toRun, (String)name, iconBitmap, (int)2130837505)) {
                        Log.v((String)TAG, (String)("add shortcut(API26) '" + name + "'" + (arg != null ? " -> '" + arg + "'" : "")));
                        break;
                    }
                }
                Intent shortcut = new Intent("com.android.launcher.action.INSTALL_SHORTCUT");
                shortcut.putExtra("android.intent.extra.shortcut.NAME", name);
                shortcut.putExtra("duplicate", false);
                shortcut.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)toRun);
                if (iconBitmap != null) {
                    shortcut.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)iconBitmap);
                } else if (iconRes != null) {
                    shortcut.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)iconRes);
                }
                Log.v((String)TAG, (String)("add shortcut '" + name + "'" + (arg != null ? " -> '" + arg + "'" : "")));
                mSingleton.sendBroadcast(shortcut);
                break;
            }
            case 1: {
                if (Build.VERSION.SDK_INT >= 26) {
                    Log.v((String)TAG, (String)("not deleting shortcut(API26) '" + name + "'"));
                    break;
                }
                Intent shortcut = new Intent("com.android.launcher.action.UNINSTALL_SHORTCUT");
                shortcut.putExtra("android.intent.extra.shortcut.NAME", name);
                shortcut.putExtra("duplicate", false);
                shortcut.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)toRun);
                if (iconBitmap != null) {
                    shortcut.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)iconBitmap);
                } else if (iconRes != null) {
                    shortcut.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)iconRes);
                }
                Log.v((String)TAG, (String)("delete shortcut '" + name + "'" + (arg != null ? " -> '" + arg + "'" : "")));
                mSingleton.sendBroadcast(shortcut);
            }
        }
    }

    public static void notify(int op, int id, String title, String text, String icon, String action, String uristr, String type, String[] cats, String[] comp, String[] types, String[] argv) {
        switch (op) {
            case 0: {
                Intent i;
                if (comp != null && comp[0].equals("self")) {
                    i = new Intent(mSingleton.getContext(), ((Object)((Object)mSingleton)).getClass());
                    i.setAction(action);
                    comp = null;
                } else {
                    i = action != null ? new Intent(action) : new Intent();
                }
                i = AndroWish.buildIntent(i, uristr, type, cats, comp);
                i.setFlags(0x20000000);
                AndroWish.addArgsToIntent(i, types, argv);
                PendingIntent pi = PendingIntent.getActivity((Context)mSingleton.getContext(), (int)0, (Intent)i, (int)0);
                NotificationCompat.Builder nb = new NotificationCompat.Builder(mSingleton.getContext());
                nb.setSmallIcon(2130837505);
                nb.setContentTitle((CharSequence)title);
                nb.setContentText((CharSequence)text);
                if (icon != null) {
                    byte[] b;
                    try {
                        b = Base64.decode((String)icon, (int)0);
                    }
                    catch (Exception be) {
                        b = null;
                    }
                    if (b != null && b.length > 0) {
                        Bitmap iconBitmap = BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
                        nb.setLargeIcon(iconBitmap);
                    }
                }
                nb.setContentIntent(pi);
                mNotificationMgr.notify(id, nb.build());
                break;
            }
            case 1: {
                mNotificationMgr.cancel(id);
                break;
            }
            case 2: {
                mNotificationMgr.cancelAll();
                break;
            }
            case 3: {
                if (Build.VERSION.SDK_INT < 11) {
                    Notification n = new Notification();
                    n.defaults = 0;
                    n.flags = 1;
                    n.ledARGB = Integer.parseInt(action);
                    n.ledOffMS = Integer.parseInt(uristr);
                    n.ledOnMS = Integer.parseInt(type);
                    mNotificationMgr.notify(id, n);
                    break;
                }
                NotificationCompat.Builder nb = new NotificationCompat.Builder(mSingleton.getContext());
                nb.setDefaults(0);
                nb.setLights(Integer.parseInt(action), Integer.parseInt(uristr), Integer.parseInt(type));
                nb.setPriority(2);
                mNotificationMgr.notify(id, nb.build());
            }
        }
    }

    public static String[] bluetooth(int op, String arg) {
        if (mBluetoothAdap == null) {
            return null;
        }
        switch (op) {
            case 0: {
                Set btDevs = mBluetoothAdap.getBondedDevices();
                int i = 0;
                for (BluetoothDevice dev : btDevs) {
                    ++i;
                }
                String[] result = new String[i * 2];
                i = 0;
                for (BluetoothDevice dev : btDevs) {
                    result[i++] = dev.getAddress();
                    result[i++] = dev.getName();
                }
                return result;
            }
            case 1: {
                String[] result = new String[1];
                int i = mBluetoothAdap.getState();
                switch (i) {
                    case 10: {
                        result[0] = "off";
                        return result;
                    }
                    case 12: {
                        result[0] = "on";
                        return result;
                    }
                    case 13: {
                        result[0] = "turning_off";
                        return result;
                    }
                    case 11: {
                        result[0] = "turning_on";
                        return result;
                    }
                }
                result[0] = mBluetoothAdap.isEnabled() ? "on" : "off";
                return result;
            }
            case 2: {
                String[] result = new String[1];
                int i = mBluetoothAdap.getScanMode();
                result[0] = i == 20 ? "passive" : (i == 21 ? "connectable" : (i == 23 ? "visible" : "off"));
                return result;
            }
            case 3: {
                String[] result = new String[]{mBluetoothAdap.getAddress(), mBluetoothAdap.getName()};
                return result;
            }
            case 4: {
                try {
                    BluetoothDevice btDev = mBluetoothAdap.getRemoteDevice(arg);
                    String[] result = new String[]{btDev.getName()};
                    return result;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            case 5: {
                String[] result = new String[1];
                int i = mBluetoothAdap.getState();
                result[0] = i == 12 || i == 11 ? "1" : (!AndroWish.hasPerm("android.permission.BLUETOOTH_ADMIN") ? "0" : (mBluetoothAdap.enable() ? "1" : "0"));
                return result;
            }
            case 6: {
                String[] result = new String[1];
                int i = mBluetoothAdap.getState();
                result[0] = i == 10 || i == 13 ? "1" : (!AndroWish.hasPerm("android.permission.BLUETOOTH_ADMIN") ? "0" : (mBluetoothAdap.disable() ? "1" : "0"));
                return result;
            }
            case 7: {
                String[] result = new String[1];
                int i = mBluetoothAdap.getState();
                result[0] = i != 12 ? "0" : (Build.VERSION.SDK_INT < 31 && !AndroWish.hasPerm("android.permission.BLUETOOTH_ADMIN") ? "0" : (Build.VERSION.SDK_INT >= 31 && !AndroWish.hasPerm("android.permission.BLUETOOTH_SCAN") ? "0" : (mBluetoothAdap.startDiscovery() ? "1" : "0")));
                return result;
            }
            case 8: {
                String[] result = new String[1];
                int i = mBluetoothAdap.getState();
                result[0] = i != 12 ? "0" : (Build.VERSION.SDK_INT < 31 && !AndroWish.hasPerm("android.permission.BLUETOOTH_ADMIN") ? "0" : (Build.VERSION.SDK_INT >= 31 && !AndroWish.hasPerm("android.permission.BLUETOOTH_SCAN") ? "0" : (mBluetoothAdap.cancelDiscovery() ? "1" : "0")));
                return result;
            }
        }
        return null;
    }

    static String usbHex(int i) {
        if (i < 0 || i > 4095) {
            return Integer.toHexString(i);
        }
        if (i <= 15) {
            return "000" + Integer.toHexString(i);
        }
        if (i <= 255) {
            return "00" + Integer.toHexString(i);
        }
        return "0" + Integer.toHexString(i);
    }

    static String usbIfString(UsbDevice dev) {
        int v;
        int n;
        if (dev == null) {
            return "";
        }
        int[] list = new int[dev.getInterfaceCount()];
        int k = 0;
        for (n = 0; n < dev.getInterfaceCount(); ++n) {
            int i;
            v = dev.getInterface(n).getInterfaceClass();
            if (v < 0 || v > 255) continue;
            int csp = v << 16;
            v = dev.getInterface(n).getInterfaceSubclass();
            if (v < 0 || v > 255) continue;
            csp |= v << 8;
            v = dev.getInterface(n).getInterfaceProtocol();
            if (v < 0 || v > 255) continue;
            csp |= v;
            for (i = 0; i < k && list[i] != csp; ++i) {
            }
            if (i < k) continue;
            list[k++] = csp;
        }
        if (k == 0) {
            return "";
        }
        StringBuilder ifs = new StringBuilder(k * 8);
        for (n = 0; n < k; ++n) {
            ifs.append(":");
            for (v = 0xF00000; v != 0 && (v & list[n]) == 0; v >>= 4) {
                ifs.append("0");
            }
            ifs.append(Integer.toHexString(list[n]));
        }
        if (n > 0) {
            ifs.append(":");
        }
        return ifs.toString();
    }

    public static String[] usbdevices() {
        return AndroWish.usbdevicesEx(0);
    }

    public static String[] usbdevicesEx(int op) {
        if (mUsbManager == null) {
            Log.v((String)TAG, (String)"no USB manager");
            return null;
        }
        int inc = op == 0 ? 2 : 3;
        HashMap list = mUsbManager.getDeviceList();
        String[] result = new String[list.size() * inc];
        Iterator iter = list.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            UsbDevice dev = (UsbDevice)iter.next();
            result[i] = dev.getDeviceName();
            result[i + 1] = AndroWish.usbHex(dev.getVendorId()) + ":" + AndroWish.usbHex(dev.getProductId());
            if (inc > 2) {
                result[i + 2] = AndroWish.usbIfString(dev);
            }
            Log.v((String)TAG, (String)("USB '" + result[i] + "' -> " + result[i + 1]));
            i += inc;
        }
        return result;
    }

    public static int usbpermission(String devName, int ask) {
        if (mUsbManager == null) {
            Log.v((String)TAG, (String)"no USB manager");
            return -1;
        }
        HashMap list = mUsbManager.getDeviceList();
        int ret = -1;
        for (UsbDevice dev : list.values()) {
            UsbDeviceConnection c;
            if (!devName.equals(dev.getDeviceName())) continue;
            if (mUsbManager.hasPermission(dev)) {
                ret = 1;
            } else if (ask == 0) {
                ret = 0;
            } else {
                UsbPermissionTest uph = new UsbPermissionTest(mSingleton);
                ret = uph.ask(dev);
            }
            if (ret != 1 || (c = mUsbHold.get(devName)) != null) break;
            c = mUsbManager.openDevice(dev);
            if (c != null) {
                mUsbHold.put(devName, c);
                break;
            }
            ret = 0;
            break;
        }
        return ret;
    }

    public static UsbDevice getUsbDevCheck(String devName) {
        if (mUsbManager == null) {
            Log.v((String)TAG, (String)"no USB manager");
            return null;
        }
        HashMap list = mUsbManager.getDeviceList();
        for (UsbDevice dev : list.values()) {
            if (!devName.equals(dev.getDeviceName())) continue;
            if (mUsbManager.hasPermission(dev)) {
                return dev;
            }
            UsbPermissionTest uph = new UsbPermissionTest(mSingleton);
            return uph.ask(dev) == 1 ? dev : null;
        }
        return null;
    }

    public static void spinner(final int show) {
        Runnable spin = new Runnable(){

            public void run() {
                if (show != 0) {
                    if (mSpinner != null) {
                        mSpinner.dismiss();
                        mSpinner = null;
                    }
                    mSpinner = ProgressDialog.show((Context)mSingleton, null, null);
                    mSpinner.setContentView((View)new ProgressBar((Context)mSingleton));
                } else if (mSpinner != null) {
                    mSpinner.dismiss();
                    mSpinner = null;
                }
            }
        };
        mSingleton.runOnUiThread(spin);
    }

    public static void alarm(int op, long trigger, long interval, String action, String uristr, String type, String[] cats, String[] comp, String[] types, String[] argv) {
        Intent i;
        if (comp != null && comp[0].equals("self")) {
            i = new Intent(mSingleton.getContext(), ((Object)((Object)mSingleton)).getClass());
            i.setAction(action);
            comp = null;
        } else {
            i = new Intent(action);
        }
        i = AndroWish.buildIntent(i, uristr, type, cats, comp);
        i.setFlags(0x20000000);
        if (op == 0 || op == 1) {
            AndroWish.addArgsToIntent(i, types, argv);
        }
        if (op == 1) {
            i.putExtra("tk.tcl.wish.wakeup", true);
        }
        PendingIntent pi = PendingIntent.getActivity((Context)mSingleton.getContext(), (int)0, (Intent)i, (int)0x10000000);
        switch (op) {
            case 0: {
                if (interval > 0L) {
                    mAlarmManager.setRepeating(1, trigger, interval, pi);
                    break;
                }
                mAlarmManager.set(1, trigger, pi);
                break;
            }
            case 1: {
                if (interval > 0L) {
                    mAlarmManager.setRepeating(0, trigger, interval, pi);
                    break;
                }
                mAlarmManager.set(0, trigger, pi);
                break;
            }
            default: {
                mAlarmManager.cancel(pi);
            }
        }
    }

    public static String[] sensorList() {
        return mSensors.getList();
    }

    public static int sensorState(int op, int n) {
        return mSensors.getState(op, n);
    }

    public static String sensorGet(int n) {
        return mSensors.getData(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPhoneInfo() {
        if (mPSListener == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(512);
        sb.append("device_id ");
        sb.append(mSingleton.toElement(mPhoneManager.getDeviceId()));
        sb.append(" device_sw_version ");
        sb.append(mSingleton.toElement(mPhoneManager.getDeviceSoftwareVersion()));
        sb.append(" line1_number ");
        sb.append(mSingleton.toElement(mPhoneManager.getLine1Number()));
        sb.append(" sim_serial_number ");
        sb.append(mSingleton.toElement(mPhoneManager.getSimSerialNumber()));
        sb.append(" voice_mail_alpha_tag ");
        sb.append(mSingleton.toElement(mPhoneManager.getVoiceMailAlphaTag()));
        sb.append(" voice_mail_number ");
        sb.append(mSingleton.toElement(mPhoneManager.getVoiceMailNumber()));
        sb.append(" network_country_iso ");
        sb.append(mSingleton.toElement(mPhoneManager.getNetworkCountryIso()));
        sb.append(" network_operator ");
        sb.append(mSingleton.toElement(mPhoneManager.getNetworkOperator()));
        sb.append(" network_operator_name ");
        sb.append(mSingleton.toElement(mPhoneManager.getNetworkOperatorName()));
        sb.append(" sim_country_iso ");
        sb.append(mSingleton.toElement(mPhoneManager.getSimCountryIso()));
        sb.append(" sim_operator ");
        sb.append(mSingleton.toElement(mPhoneManager.getSimOperator()));
        sb.append(" sim_operator_name ");
        sb.append(mSingleton.toElement(mPhoneManager.getSimOperatorName()));
        sb.append(" subscriber_id ");
        sb.append(mSingleton.toElement(mPhoneManager.getSubscriberId()));
        sb.append(" call_state ");
        switch (mPhoneManager.getCallState()) {
            case 0: {
                sb.append("idle");
                break;
            }
            case 2: {
                sb.append("offhook");
                break;
            }
            case 1: {
                sb.append("ringing");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        sb.append(" phone_number ");
        Object object = AndroWish.mPSListener.mLock;
        synchronized (object) {
            sb.append(mSingleton.toElement(AndroWish.mPSListener.mNumber));
        }
        sb.append(" data_state ");
        switch (mPhoneManager.getDataState()) {
            case 0: {
                sb.append("disconnected");
                break;
            }
            case 1: {
                sb.append("connecting");
                break;
            }
            case 2: {
                sb.append("connected");
                break;
            }
            case 3: {
                sb.append("suspended");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        sb.append(" data_activity ");
        switch (mPhoneManager.getDataActivity()) {
            case 0: {
                sb.append("none");
                break;
            }
            case 1: {
                sb.append("in");
                break;
            }
            case 2: {
                sb.append("out");
                break;
            }
            case 3: {
                sb.append("inout");
                break;
            }
            case 4: {
                sb.append("dormant");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        sb.append(" sim_state ");
        switch (mPhoneManager.getSimState()) {
            case 1: {
                sb.append("absent");
                break;
            }
            case 2: {
                sb.append("pin_required");
                break;
            }
            case 3: {
                sb.append("puk_required");
                break;
            }
            case 4: {
                sb.append("network_locked");
                break;
            }
            case 5: {
                sb.append("ready");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        sb.append(" phone_type ");
        switch (mPhoneManager.getPhoneType()) {
            case 0: {
                sb.append("none");
                break;
            }
            case 1: {
                sb.append("gsm");
                break;
            }
            case 2: {
                sb.append("cdma");
                break;
            }
            case 3: {
                sb.append("sip");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        sb.append(" network_type ");
        switch (mPhoneManager.getNetworkType()) {
            case 7: {
                sb.append("1xrtt");
                break;
            }
            case 4: {
                sb.append("cdma");
                break;
            }
            case 2: {
                sb.append("edge");
                break;
            }
            case 14: {
                sb.append("ehrpd");
                break;
            }
            case 5: {
                sb.append("evdo_0");
                break;
            }
            case 6: {
                sb.append("evdo_a");
                break;
            }
            case 12: {
                sb.append("evdo_b");
                break;
            }
            case 1: {
                sb.append("gprs");
                break;
            }
            case 10: {
                sb.append("hspa");
                break;
            }
            case 15: {
                sb.append("hspa+");
                break;
            }
            case 9: {
                sb.append("hsupa");
                break;
            }
            case 11: {
                sb.append("iden");
                break;
            }
            case 13: {
                sb.append("lte");
                break;
            }
            case 3: {
                sb.append("umts");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        object = AndroWish.mPSListener.mLock;
        synchronized (object) {
            sb.append(" cdma_dbm ");
            sb.append("" + AndroWish.mPSListener.mCdmaDbm);
            sb.append(" cdma_ecio ");
            sb.append("" + AndroWish.mPSListener.mCdmaEcio);
            sb.append(" cdma_ecio ");
            sb.append("" + AndroWish.mPSListener.mCdmaEcio);
            sb.append(" evdo_dbm ");
            sb.append("" + AndroWish.mPSListener.mEvdoDbm);
            sb.append(" evdo_ecio ");
            sb.append("" + AndroWish.mPSListener.mEvdoEcio);
            sb.append(" evdo_snr ");
            sb.append("" + AndroWish.mPSListener.mEvdoSnr);
            sb.append(" gsm_bit_error_rate ");
            sb.append("" + AndroWish.mPSListener.mGsmBitErrorRate);
            sb.append(" gsm_signal_strength ");
            sb.append("" + AndroWish.mPSListener.mGsmSignalStrength);
            sb.append(" is_gsm ");
            sb.append(AndroWish.mPSListener.mIsGsm ? "1" : "0");
        }
        return sb.toString();
    }

    public static int brightness(int query, int percent) {
        if (query != 0) {
            WindowManager.LayoutParams lp = mSingleton.getWindow().getAttributes();
            return (int)(lp.screenBrightness * 100.0f);
        }
        if (percent < 0) {
            percent = -100;
        } else if (percent > 100) {
            percent = 100;
        }
        final float brightness = (float)((double)percent / 100.0);
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable setBrightness = new Runnable(){

            public void run() {
                WindowManager.LayoutParams lp = mSingleton.getWindow().getAttributes();
                lp.screenBrightness = brightness;
                mSingleton.getWindow().setAttributes(lp);
                latch.countDown();
            }
        };
        mSingleton.runOnUiThread(setBrightness);
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 0;
    }

    public static String[] locale(String lang) {
        if (lang == null || lang.equals("default")) {
            return LocaleAPI1.get(null);
        }
        if (lang.equals("tts")) {
            if (mTTS != null) {
                return LocaleAPI1.get(mTTS.getLanguage());
            }
            return LocaleAPI1.get(null);
        }
        String[] str = lang.split("_|\\.", 3);
        if (str != null) {
            if (str.length > 2) {
                return LocaleAPI1.get(new Locale(str[0], str[1], str[2]));
            }
            if (str.length > 1) {
                return LocaleAPI1.get(new Locale(str[0], str[1]));
            }
        }
        return LocaleAPI1.get(new Locale(lang));
    }

    public static String setLocale(String lang) {
        if (lang == null) {
            return null;
        }
        String[] str = lang.split("_|\\.", 3);
        if (str != null) {
            if (str.length > 2) {
                Locale.setDefault(new Locale(str[0], str[1], str[2]));
            } else if (str.length > 1) {
                Locale.setDefault(new Locale(str[0], str[1]));
            } else {
                return null;
            }
        }
        return Locale.getDefault().toString();
    }

    public static boolean cameraOpen(int id) {
        if (mCamera != null) {
            return mCamera.open(id);
        }
        return false;
    }

    public static boolean cameraClose() {
        if (mCamera != null) {
            return mCamera.close();
        }
        return false;
    }

    public static boolean cameraStartStop(int start) {
        if (mCamera != null) {
            if (start != 0) {
                return mCamera.startPreview();
            }
            return mCamera.stopPreview();
        }
        return false;
    }

    public static int cameraGetID(int current) {
        if (mCamera != null) {
            return mCamera.getID(current != 0);
        }
        return current != 0 ? -1 : 0;
    }

    public static String cameraParameters(String set) {
        if (mCamera != null) {
            if (set == null) {
                return mCamera.getParameters();
            }
            return mCamera.setParameters(set);
        }
        return null;
    }

    public static int cameraOrientation(int degrees) {
        if (mCamera != null) {
            return mCamera.setCameraDisplayOrientation(degrees);
        }
        return -1;
    }

    public static byte[] cameraGetImage(int[] info) {
        if (mCamera != null) {
            return mCamera.lastImage(info);
        }
        return null;
    }

    public static int cameraGetState() {
        if (mCamera != null) {
            return mCamera.getState();
        }
        return -1;
    }

    public static boolean cameraTakePicture() {
        if (mCamera != null) {
            return mCamera.takePicture();
        }
        return false;
    }

    public static byte[] cameraGetPicture() {
        if (mCamera != null) {
            return mCamera.lastPicture();
        }
        return null;
    }

    public static String cameraInfo() {
        if (mCamera != null) {
            return mCamera.getInfo();
        }
        return null;
    }

    public static boolean checkPermission(String perm) {
        if (perm == null) {
            return false;
        }
        return AndroWish.hasPerm(perm);
    }

    public static boolean[] checkPermission(int ask, String[] perms) {
        if (perms == null) {
            return null;
        }
        if (ask != 0) {
            AndroWish.askForPermissions(perms);
        }
        int len = perms.length;
        boolean[] ret = new boolean[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = AndroWish.hasPerm(perms[i]);
        }
        return ret;
    }

    public static void showIMPicker() {
        Runnable r = new Runnable(){

            public void run() {
                InputMethodManager imm = (InputMethodManager)mSingleton.getContext().getSystemService("input_method");
                if (imm != null) {
                    imm.showInputMethodPicker();
                }
            }
        };
        mSingleton.runOnUiThread(r);
    }

    public static String osenvGetString(int op, String arg) {
        File f = null;
        if (op != 3 && arg != null) {
            f = new File(arg);
        }
        switch (op) {
            case 0: {
                return Environment.getDataDirectory().getAbsolutePath();
            }
            case 1: {
                return Environment.getDownloadCacheDirectory().getAbsolutePath();
            }
            case 2: {
                return Environment.getExternalStorageDirectory().getAbsolutePath();
            }
            case 3: {
                if (arg == null) {
                    return Environment.getExternalStorageDirectory().getAbsolutePath();
                }
                return Environment.getExternalStoragePublicDirectory((String)arg).getAbsolutePath();
            }
            case 4: {
                return Environment.getExternalStorageState();
            }
            case 5: {
                return Environment.getRootDirectory().getAbsolutePath();
            }
        }
        return null;
    }

    public static int osenvGetFlag(int op) {
        boolean b = false;
        switch (op) {
            case 0: {
                b = Environment.isExternalStorageEmulated();
                break;
            }
            case 1: {
                b = Environment.isExternalStorageRemovable();
            }
        }
        return b ? 1 : 0;
    }

    public static String[] ndefRead(String tagstr, int cached) {
        String[] result = new String[2];
        Tag tag = mNfcTag;
        byte[] tb = null;
        result[0] = "unknown error";
        result[1] = null;
        try {
            tb = Base64.decode((String)tagstr, (int)0);
        }
        catch (Exception te) {
            tb = null;
        }
        if (tb == null) {
            result[0] = "tag invalid";
            Log.e((String)TAG, (String)("ndefRead: " + result[0]));
            return result;
        }
        if (tag == null) {
            result[0] = "no current tag";
            Log.e((String)TAG, (String)("nfcRead: " + result[0]));
            return result;
        }
        if (!Arrays.equals(tag.getId(), tb)) {
            result[0] = "wrong tag id";
            Log.e((String)TAG, (String)("nfcRead: tag not current: " + tagstr + " expecting " + Base64.encodeToString((byte[])tag.getId(), (int)0)));
            return result;
        }
        try {
            NdefMessage ndmsg;
            Ndef ndef = Ndef.get((Tag)tag);
            if (cached == 0) {
                ndef.connect();
                ndmsg = ndef.getNdefMessage();
                ndef.close();
            } else {
                ndmsg = ndef.getCachedNdefMessage();
            }
            if (ndmsg != null) {
                result[1] = Base64.encodeToString((byte[])ndmsg.toByteArray(), (int)0);
            }
        }
        catch (Exception e) {
            result[0] = "read error";
            result[1] = null;
            Log.e((String)TAG, (String)("nfcRead: exception: " + e.toString()));
            return result;
        }
        result[0] = null;
        return result;
    }

    public static String ndefWrite(String tagstr, String msg) {
        byte[] mb;
        byte[] tb;
        Tag tag = mNfcTag;
        try {
            tb = Base64.decode((String)tagstr, (int)0);
        }
        catch (Exception te) {
            tb = null;
        }
        if (tb == null) {
            Log.e((String)TAG, (String)"ndefWrite: tag invalid");
            return "tag invalid";
        }
        try {
            mb = Base64.decode((String)msg, (int)0);
        }
        catch (Exception me) {
            mb = null;
        }
        if (mb == null) {
            Log.e((String)TAG, (String)"ndefWrite: message invalid");
            return "message invalid";
        }
        if (tag == null) {
            Log.e((String)TAG, (String)"ndefWrite: no current tag");
            return "no current tag";
        }
        if (!Arrays.equals(tag.getId(), tb)) {
            Log.e((String)TAG, (String)("ndefWrite: tag not current: " + tagstr + " expecting " + Base64.encodeToString((byte[])tag.getId(), (int)0)));
            return "wrong tag id";
        }
        try {
            NdefMessage ndmsg = new NdefMessage(mb);
            int size = ndmsg.toByteArray().length;
            Ndef ndef = Ndef.get((Tag)tag);
            if (ndef == null) {
                NdefFormatable nfmt = NdefFormatable.get((Tag)tag);
                if (nfmt == null) {
                    Log.e((String)TAG, (String)"ndefWrite: unsupported tech");
                    return "unsupported tech";
                }
                nfmt.connect();
                nfmt.format(ndmsg);
                nfmt.close();
            } else {
                ndef.connect();
                if (!ndef.isWritable()) {
                    ndef.close();
                    Log.e((String)TAG, (String)"ndefWrite: read only tag");
                    return "read only tag";
                }
                if (size > ndef.getMaxSize()) {
                    ndef.close();
                    Log.e((String)TAG, (String)("ndefWrite: message too large (" + size + ">" + ndef.getMaxSize() + ")"));
                    return "message too large";
                }
                ndef.writeNdefMessage(ndmsg);
                ndef.close();
            }
        }
        catch (FormatException fe) {
            Log.e((String)TAG, (String)("ndefWrite: format exception: " + fe.toString()));
            return "wrong ndef format";
        }
        catch (IOException ie) {
            Log.e((String)TAG, (String)("ndefWrite: I/O exception: " + ie.toString()));
            return "I/O error";
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("ndefWrite: other exception: " + e.toString()));
            return "unknown error";
        }
        return null;
    }

    public static String ndefFormat(String tagstr, String msg) {
        byte[] tb;
        Tag tag = mNfcTag;
        try {
            tb = Base64.decode((String)tagstr, (int)0);
        }
        catch (Exception te) {
            tb = null;
        }
        if (tb == null) {
            Log.e((String)TAG, (String)"ndefFormat: tag invalid");
            return "tag invalid";
        }
        byte[] mb = null;
        try {
            mb = Base64.decode((String)msg, (int)0);
        }
        catch (Exception me) {
            mb = null;
        }
        if (mb == null) {
            Log.e((String)TAG, (String)"ndefFormat: message invalid");
            return "message invalid";
        }
        if (tag == null) {
            Log.e((String)TAG, (String)"ndefFormat: no current tag");
            return "no current tag";
        }
        if (!Arrays.equals(tag.getId(), tb)) {
            Log.e((String)TAG, (String)("ndefFormat: tag not current: " + tagstr + " expecting " + Base64.encodeToString((byte[])tag.getId(), (int)0)));
            return "wrong tag id";
        }
        try {
            NdefFormatable nfmt = NdefFormatable.get((Tag)tag);
            if (nfmt == null) {
                Log.e((String)TAG, (String)"ndefFormat: unsupported tech");
                return "unsupported tech";
            }
            nfmt.connect();
            NdefMessage ndmsg = new NdefMessage(mb);
            nfmt.format(ndmsg);
            nfmt.close();
        }
        catch (FormatException fe) {
            Log.e((String)TAG, (String)("ndefFormat: format exception: " + fe.toString()));
            return "wrong ndef format";
        }
        catch (IOException ie) {
            Log.e((String)TAG, (String)("ndefFormat: I/O exception: " + ie.toString()));
            return "I/O error";
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("ndefFormat: other exception: " + e.toString()));
            return "unknown error";
        }
        return null;
    }

    public static int shpGetBoolean(String file, String key, int def) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        return sp.getBoolean(key, def != 0) ? 1 : 0;
    }

    public static float shpGetFloat(String file, String key, float def) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        return sp.getFloat(key, def);
    }

    public static int shpGetInt(String file, String key, int def) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        return sp.getInt(key, def);
    }

    public static long shpGetLong(String file, String key, long def) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        return sp.getLong(key, def);
    }

    public static String shpGetString(String file, String key, String def) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        return sp.getString(key, def);
    }

    public static void shpSetBoolean(String file, String key, int val) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        SharedPreferences.Editor ed = sp.edit();
        ed.putBoolean(key, val != 0);
        ed.apply();
    }

    public static void shpSetFloat(String file, String key, float val) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        SharedPreferences.Editor ed = sp.edit();
        ed.putFloat(key, val);
        ed.apply();
    }

    public static void shpSetInt(String file, String key, int val) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        SharedPreferences.Editor ed = sp.edit();
        ed.putInt(key, val);
        ed.apply();
    }

    public static void shpSetLong(String file, String key, long val) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        SharedPreferences.Editor ed = sp.edit();
        ed.putLong(key, val);
        ed.apply();
    }

    public static void shpSetString(String file, String key, String val) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        SharedPreferences.Editor ed = sp.edit();
        ed.putString(key, val);
        ed.apply();
    }

    public static void shpRemove(String file, String key) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        SharedPreferences.Editor ed = sp.edit();
        ed.remove(key);
        ed.apply();
    }

    public static void shpClear(String file) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        SharedPreferences.Editor ed = sp.edit();
        ed.clear();
        ed.apply();
    }

    public static String[] shpKeys(String file, int how) {
        SharedPreferences sp = mSingleton.getContext().getSharedPreferences(file, 0);
        Map keys = sp.getAll();
        int size = keys.size();
        if (how >= 1 && how <= 2) {
            size *= 2;
        }
        String[] result = new String[size];
        int i = 0;
        for (Map.Entry entry : keys.entrySet()) {
            Object obj = entry.getValue();
            if (obj == null || obj instanceof Set) continue;
            result[i] = (String)entry.getKey();
            ++i;
            if (how == 2) {
                result[i] = obj.toString();
                ++i;
                continue;
            }
            if (how != 1) continue;
            result[i] = obj instanceof Boolean ? "boolean" : (obj instanceof Float ? "float" : (obj instanceof Integer ? "int" : (obj instanceof Long ? "long" : "string")));
            ++i;
        }
        return result;
    }

    public static String getPermissionList() {
        ArrayList<String> r = new ArrayList<String>();
        PackageManager pm = mSingleton.getContext().getPackageManager();
        try {
            List g = pm.getAllPermissionGroups(0);
            for (PermissionGroupInfo pgi : g) {
                CharSequence csg = pgi.loadLabel(pm);
                try {
                    List p = pm.queryPermissionsByGroup(pgi.name, 0);
                    for (PermissionInfo pi : p) {
                        r.add(pi.name);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mSingleton.encodeToList(r);
    }

    public void onRequestPermissionsResult(int requestCode, String[] perms, int[] results) {
        if (requestCode == 42 && mPermLock != null) {
            mPermLock.countDown();
        }
    }

    public static synchronized void askForPermissions(final String[] perms) {
        mPermLock = new CountDownLatch(1);
        Runnable r = new Runnable(){

            public void run() {
                ActivityCompat.requestPermissions((Activity)mSingleton, (String[])perms, (int)42);
            }
        };
        mSingleton.runOnUiThread(r);
        try {
            mPermLock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        mPermLock = null;
    }

    public static native int nativeSetenv(String var0, String var1);

    public static native int nativeAddpath(String var0, String var1);

    public static native void nativeInit(int var0, String var1);

    public static native void nativeSetStartupFile(String var0);

    public static native void nativeIntentCallback(int var0, int var1, String var2, String var3, String var4, String[] var5, String[] var6);

    public static native void nativeBroadcastCallback(int var0, String var1, String var2, String var3, String[] var4, String[] var5);

    public static native int nativeTriggerLocation();

    public static native int nativeTriggerGpsUpdate();

    public static native int nativeTriggerNmeaUpdate();

    public static native int nativeTriggerNetworkInfo();

    public static native int nativeTriggerTetherInfo();

    public static native int nativeTriggerBluetooth();

    public static native int nativeTriggerKeyboard();

    public static native int nativeTriggerSensor(int var0);

    public static native int nativeTriggerUsb(int var0);

    public static native void nativeTriggerIntent(String var0, String var1, String var2, String[] var3, String[] var4);

    public static native void nativeTriggerSpeech(String[] var0);

    public static native void nativeTriggerPhoneState(int var0);

    public static native void nativeTriggerTTS(int var0, int var1);
}

