/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class TclDouble
implements InternalRep {
    double value;
    private static final boolean validate = false;

    private TclDouble(double d) {
        this.value = d;
    }

    private TclDouble(Interp interp, String str) throws TclException {
        this.value = Util.getDouble(interp, str);
    }

    public InternalRep duplicate() {
        return new TclDouble(this.value);
    }

    public void dispose() {
    }

    public static TclObject newInstance(double d) {
        return new TclObject(new TclDouble(d));
    }

    private static void setDoubleFromAny(Interp interp, TclObject tobj) throws TclException {
        tobj.setInternalRep(new TclDouble(interp, tobj.toString()));
    }

    public static double get(Interp interp, TclObject tobj) throws TclException {
        TclDouble tdouble;
        if (!tobj.isDoubleType()) {
            if (Util.isJacl()) {
                TclDouble.setDoubleFromAny(interp, tobj);
                tdouble = (TclDouble)tobj.getInternalRep();
                double dval = tdouble.value;
                if (Util.looksLikeInt(tobj.toString())) {
                    try {
                        int ival = TclInteger.get(null, tobj);
                        return dval;
                    }
                    catch (TclException te) {
                        throw new TclRuntimeError("looksLikeInt() is true, but TclInteger.get() failed for \"" + tobj.toString() + "\"");
                    }
                }
            } else {
                TclDouble.setDoubleFromAny(interp, tobj);
                tdouble = (TclDouble)tobj.getInternalRep();
            }
        } else {
            tdouble = (TclDouble)tobj.getInternalRep();
        }
        return tdouble.value;
    }

    public static void set(TclObject tobj, double d) {
        tobj.invalidateStringRep();
        if (tobj.isDoubleType()) {
            TclDouble tdouble = (TclDouble)tobj.getInternalRep();
            tdouble.value = d;
        } else {
            tobj.setInternalRep(new TclDouble(d));
        }
    }

    public String toString() {
        return Util.printDouble(this.value);
    }

    static void exprSetInternalRep(TclObject tobj, double d) {
        tobj.setInternalRep(new TclDouble(d));
    }

    static void setRecycledInternalRep(TclObject tobj) {
        tobj.setInternalRep(new TclDouble(0.0));
    }
}

