/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import tcl.lang.Interp;
import tcl.lang.JarFilenameFilter;
import tcl.lang.PackageNameException;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class TclClassLoader
extends ClassLoader {
    private HashMap class_cache = new HashMap();
    private String[] classpath = null;
    private String[] loadpath = null;
    private String cached_tclclasspath = null;
    private String lastSearchedClassFile = null;
    private String lastSearchedJarFile = null;
    private ClassLoader parent;
    private Interp interp = null;

    TclClassLoader(Interp interp, TclObject pathList, ClassLoader parent) {
        super(parent);
        if (parent == null) {
            throw new TclRuntimeError("parent ClassLoader can't be null");
        }
        this.parent = parent;
        this.interp = interp;
        this.init(interp, pathList);
    }

    private void init(Interp interp, TclObject pathList) {
        try {
            boolean searchTclClasspath = true;
            if (this.parent instanceof TclClassLoader) {
                if (pathList == null) {
                    throw new TclRuntimeError("TclClassLoader is a child of the interp class loader but it does not have a -classpath to search");
                }
                searchTclClasspath = false;
            }
            if (pathList != null) {
                TclObject[] elem = TclList.getElements(interp, pathList);
                this.classpath = new String[elem.length];
                for (int i = 0; i < elem.length; ++i) {
                    this.classpath[i] = TclClassLoader.absolutePath(interp, elem[i].toString());
                }
            }
            if (searchTclClasspath) {
                this.checkTclClasspath();
            }
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    private void checkTclClasspath() {
        boolean debug = false;
        TclObject[] elems = null;
        try {
            TclObject tobj = this.interp.getVar("env", "TCL_CLASSPATH", 1);
            String current_tclclasspath = tobj.toString();
            if (current_tclclasspath.length() == 0) {
                this.cached_tclclasspath = "";
                this.loadpath = null;
                return;
            }
            if (this.cached_tclclasspath == null || !current_tclclasspath.equals(this.cached_tclclasspath)) {
                this.cached_tclclasspath = current_tclclasspath;
                elems = TclList.getElements(this.interp, tobj);
            }
        }
        catch (TclException e) {
            this.interp.resetResult();
            this.cached_tclclasspath = null;
            this.loadpath = null;
            return;
        }
        if (elems == null) {
            return;
        }
        this.loadpath = new String[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            this.loadpath[i] = TclClassLoader.absolutePath(this.interp, elems[i].toString());
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException, PackageNameException {
        return this.loadClass(className, true);
    }

    protected Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException, PackageNameException, SecurityException {
        byte[] classData = null;
        boolean debug = false;
        boolean printStack = false;
        Class<?> result = (Class<?>)this.class_cache.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = Class.forName(className, resolveIt, this.parent);
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
        if (className.startsWith("java.") || className.startsWith("tcl.")) {
            throw new PackageNameException("Java loader failed to load the class and the TclClassLoader is not permitted to load classes in the tcl or java package at runtime, check your CLASSPATH.", className);
        }
        if (this.classpath != null) {
            classData = this.getClassFromPath(this.classpath, className);
        }
        if (classData == null) {
            this.checkTclClasspath();
            if (this.loadpath != null) {
                classData = this.getClassFromPath(this.loadpath, className);
            }
        }
        if (classData == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            result = this.defineClass(className, classData, 0, classData.length);
        }
        catch (NoClassDefFoundError err) {
            throw new ClassFormatError();
        }
        catch (ClassFormatError err) {
            StringBuffer buf = new StringBuffer(50);
            buf.append(err.getMessage());
            buf.append(". ");
            if (this.lastSearchedClassFile != null) {
                buf.append(this.lastSearchedClassFile);
            } else {
                buf.append(className);
            }
            if (this.lastSearchedJarFile != null) {
                buf.append(" loaded from ");
                buf.append(this.lastSearchedJarFile);
            }
            buf.append(": class name does not match");
            buf.append(" the name defined in the classfile");
            throw new ClassFormatError(buf.toString());
        }
        if (result == null) {
            throw new ClassFormatError();
        }
        if (resolveIt) {
            this.resolveClass(result);
        }
        this.class_cache.put(className, result);
        return result;
    }

    protected URL findResource(String resName) throws PackageNameException {
        boolean debug = false;
        URL result = null;
        if (resName.length() == 0) {
            return null;
        }
        if (resName.charAt(0) == '/') {
            resName = resName.substring(1);
        }
        if (resName.startsWith("java/") || resName.startsWith("tcl/")) {
            throw new PackageNameException("Can't load resource \"" + resName + "\" with java or tcl prefix via TCL_CLASSPATH", resName);
        }
        if (this.classpath != null) {
            result = this.getURLFromPath(this.classpath, resName);
        }
        if (result == null) {
            this.checkTclClasspath();
            if (this.loadpath != null) {
                result = this.getURLFromPath(this.loadpath, resName);
            }
        }
        return result;
    }

    public URL getResource(String resName) {
        boolean debug = false;
        URL res = null;
        if (res == null) {
            res = Interp.class.getResource(resName);
        }
        if (res == null) {
            res = this.parent.getResource(resName);
        }
        if (res == null) {
            res = this.findResource(resName);
        }
        return res;
    }

    Class defineClass(String className, byte[] classData) {
        Class<?> result = null;
        try {
            result = this.defineClass(null, classData, 0, classData.length);
        }
        catch (ClassFormatError ex) {
            System.err.println("TclClassLoader.defineClass():");
            System.err.println(ex.getClass().getName() + ": " + ex.getMessage());
        }
        catch (LinkageError ex) {
            System.err.println("TclClassLoader.defineClass():");
            System.err.println(ex.getClass().getName() + ": " + ex.getMessage());
        }
        if (result != null) {
            if (className == null) {
                className = result.getName();
            }
            this.class_cache.put(className, result);
        }
        return result;
    }

    private byte[] getClassFromPath(String[] paths, String className) {
        boolean debug = false;
        int i = 0;
        byte[] classData = null;
        this.lastSearchedClassFile = null;
        this.lastSearchedJarFile = null;
        if (paths != null) {
            String curDir;
            className = className.replace('.', '/') + ".class";
            for (i = 0; i < paths.length; ++i) {
                curDir = paths[i].toString();
                try {
                    if (curDir.endsWith(".jar") || curDir.endsWith(".zip")) {
                        classData = this.extractClassFromJar(curDir, className);
                        if (classData == null) continue;
                        return classData;
                    }
                    File file = new File(curDir, className);
                    if (!file.exists()) continue;
                    FileInputStream fi = new FileInputStream(file);
                    classData = new byte[fi.available()];
                    for (int total = fi.read(classData); total != classData.length; total += fi.read(classData, total, classData.length - total)) {
                    }
                    this.lastSearchedClassFile = file.toString();
                    return classData;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (i = 0; i < paths.length; ++i) {
                curDir = paths[i].toString();
                try {
                    classData = this.getClassFromJar(curDir, className);
                    if (classData == null) continue;
                    return classData;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private byte[] getClassFromJar(String curDir, String className) throws IOException {
        byte[] result = null;
        File file = new File(curDir);
        if (!file.isDirectory()) {
            return null;
        }
        JarFilenameFilter jarFilter = new JarFilenameFilter();
        String[] jarFiles = file.list(jarFilter);
        if (jarFiles == null) {
            return null;
        }
        for (int i = 0; i < jarFiles.length && (result = this.extractClassFromJar(curDir + File.separatorChar + jarFiles[i], className)) == null; ++i) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] extractClassFromJar(String jarName, String className) throws IOException {
        boolean debug = false;
        ZipInputStream zin = new ZipInputStream(new FileInputStream(jarName));
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                if (!className.equals(entry.getName())) continue;
                int size = this.getEntrySize(jarName, className);
                byte[] buffer = new byte[size];
                for (int total = zin.read(buffer); total != size; total += zin.read(buffer, total, size - total)) {
                }
                this.lastSearchedClassFile = className;
                this.lastSearchedJarFile = jarName;
                byte[] byArray = buffer;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            zin.close();
        }
    }

    private int getEntrySize(String jarName, String className) throws IOException {
        ZipFile zip = new ZipFile(jarName);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!className.equals(entry.getName())) continue;
            zip.close();
            return (int)entry.getSize();
        }
        return -1;
    }

    private static String absolutePath(Interp interp, String dirName) {
        File dir = new File(dirName);
        if (!dir.isAbsolute()) {
            String newName = interp.getWorkingDir().toString() + System.getProperty("file.separator") + dirName;
            dir = new File(newName);
        }
        return dir.toString();
    }

    void removeCache(String className) {
        this.class_cache.remove(className);
    }

    private URL getURLFromPath(String[] paths, String resName) {
        boolean debug = false;
        int i = 0;
        URL url = null;
        this.lastSearchedClassFile = null;
        this.lastSearchedJarFile = null;
        if (paths != null) {
            String curDir;
            for (i = 0; i < paths.length; ++i) {
                curDir = paths[i].toString();
                try {
                    if (curDir.endsWith(".jar") || curDir.endsWith(".zip")) {
                        url = this.extractURLFromJar(curDir, resName);
                        if (url == null) continue;
                        return url;
                    }
                    File file = new File(curDir, resName);
                    if (!file.exists()) continue;
                    url = file.toURL();
                    return url;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (i = 0; i < paths.length; ++i) {
                curDir = paths[i].toString();
                try {
                    url = this.getURLFromJar(curDir, resName);
                    if (url == null) continue;
                    return url;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private URL getURLFromJar(String curDir, String resName) throws IOException {
        URL result = null;
        JarFilenameFilter jarFilter = new JarFilenameFilter();
        String[] jarFiles = new File(curDir).list(jarFilter);
        for (int i = 0; i < jarFiles.length && (result = this.extractURLFromJar(curDir + File.separatorChar + jarFiles[i], resName)) == null; ++i) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL extractURLFromJar(String jarName, String resName) throws IOException {
        boolean debug = false;
        ZipInputStream zin = new ZipInputStream(new FileInputStream(jarName));
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                URL jarURL;
                if (!resName.equals(entry.getName())) continue;
                File file = new File(jarName);
                URL fileURL = file.toURL();
                URL uRL = jarURL = new URL("jar:" + fileURL.toString() + "!/" + resName);
                return uRL;
            }
            URL uRL = null;
            return uRL;
        }
        finally {
            zin.close();
        }
    }
}

