/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Collection;
import java.util.Iterator;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class JavaForCmd
implements Command {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int typeId;
        if (objv.length != 4) {
            throw new TclNumArgsException(interp, 1, objv, "type_var collection script");
        }
        TclObject type_var = objv[1];
        TclObject collectionObj = objv[2];
        TclObject script = objv[3];
        Class type = null;
        if (TclList.getLength(interp, type_var) != 2) {
            throw new TclException(interp, "invalid type_var \"" + type_var + "\"");
        }
        String typename = TclList.index(interp, type_var, 0).toString();
        String varname = TclList.index(interp, type_var, 1).toString();
        if (typename.length() == 0 || varname.length() == 0) {
            throw new TclException(interp, "invalid type_var \"" + type_var + "\"");
        }
        if (JavaForCmd.isArrayVarname(varname) || varname.indexOf("::") != -1) {
            throw new TclException(interp, "invalid type_var \"" + type_var + "\", varname must be simple scalar");
        }
        if (typename.equals("void") || typename.equals("Void") || typename.equals("java.lang.Void")) {
            throw new TclException(interp, "void type is invalid");
        }
        type = JavaInvoke.getClassByName(interp, typename);
        Object collection_obj = ReflectObject.get(interp, collectionObj);
        Class collection_class = ReflectObject.getClass(interp, collectionObj);
        boolean ARRAY_OBJECT = true;
        int ARRAY_STRING = 2;
        int ARRAY_INT = 3;
        int ARRAY_BOOLEAN = 4;
        int ARRAY_LONG = 5;
        int ARRAY_FLOAT = 6;
        int ARRAY_DOUBLE = 7;
        int ARRAY_BYTE = 8;
        int ARRAY_SHORT = 9;
        int ARRAY_CHAR = 10;
        int COLLECTION = 11;
        int[] intArray = null;
        boolean[] booleanArray = null;
        long[] longArray = null;
        float[] floatArray = null;
        double[] doubleArray = null;
        byte[] byteArray = null;
        short[] shortArray = null;
        char[] charArray = null;
        String[] stringArray = null;
        Object[] objArray = null;
        int arrayLength = 0;
        if (!collection_class.isArray()) {
            typeId = 11;
        } else if (type == Integer.TYPE) {
            typeId = 3;
            if (!(collection_obj instanceof int[])) {
                throw new TclException(interp, "expected collection object to be array of int");
            }
            intArray = (int[])collection_obj;
            arrayLength = intArray.length;
        } else if (type == Boolean.TYPE) {
            typeId = 4;
            if (!(collection_obj instanceof boolean[])) {
                throw new TclException(interp, "expected collection object to be array of boolean");
            }
            booleanArray = (boolean[])collection_obj;
            arrayLength = booleanArray.length;
        } else if (type == Long.TYPE) {
            typeId = 5;
            if (!(collection_obj instanceof long[])) {
                throw new TclException(interp, "expected collection object to be array of long");
            }
            longArray = (long[])collection_obj;
            arrayLength = longArray.length;
        } else if (type == Float.TYPE) {
            typeId = 6;
            if (!(collection_obj instanceof float[])) {
                throw new TclException(interp, "expected collection object to be array of float");
            }
            floatArray = (float[])collection_obj;
            arrayLength = floatArray.length;
        } else if (type == Double.TYPE) {
            typeId = 7;
            if (!(collection_obj instanceof double[])) {
                throw new TclException(interp, "expected collection object to be array of double");
            }
            doubleArray = (double[])collection_obj;
            arrayLength = doubleArray.length;
        } else if (type == Byte.TYPE) {
            typeId = 8;
            if (!(collection_obj instanceof byte[])) {
                throw new TclException(interp, "expected collection object to be array of byte");
            }
            byteArray = (byte[])collection_obj;
            arrayLength = byteArray.length;
        } else if (type == Short.TYPE) {
            typeId = 9;
            if (!(collection_obj instanceof short[])) {
                throw new TclException(interp, "expected collection object to be array of short");
            }
            shortArray = (short[])collection_obj;
            arrayLength = shortArray.length;
        } else if (type == Character.TYPE) {
            typeId = 10;
            if (!(collection_obj instanceof char[])) {
                throw new TclException(interp, "expected collection object to be array of char");
            }
            charArray = (char[])collection_obj;
            arrayLength = charArray.length;
        } else if (type == String.class) {
            typeId = 2;
            if (!(collection_obj instanceof String[])) {
                throw new TclException(interp, "expected collection object to be array of String");
            }
            stringArray = (String[])collection_obj;
            arrayLength = stringArray.length;
        } else {
            typeId = 1;
            if (!(collection_obj instanceof Object[])) {
                throw new TclException(interp, "expected collection object to be array of Object");
            }
            objArray = (Object[])collection_obj;
            arrayLength = objArray.length;
        }
        Collection collection = null;
        if (typeId == 11) {
            if (!(collection_obj instanceof Collection)) {
                throw new TclException(interp, "passed collection argument of type " + JavaInfoCmd.getNameFromClass(collection_class) + " which does not implement Collection interface");
            }
            collection = (Collection)collection_obj;
        }
        Iterator iterator = null;
        int i = 0;
        switch (typeId) {
            case 11: {
                iterator = collection.iterator();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            default: {
                throw new TclRuntimeError("unmatched typeId " + typeId);
            }
        }
        while (true) {
            TclObject wrapper;
            boolean done;
            switch (typeId) {
                case 11: {
                    done = !iterator.hasNext();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    done = i >= arrayLength;
                    break;
                }
                default: {
                    throw new TclRuntimeError("unmatched typeId " + typeId);
                }
            }
            if (done) break;
            switch (typeId) {
                case 1: 
                case 11: {
                    void var48_47;
                    if (typeId == 11) {
                        Object e = iterator.next();
                    } else {
                        void var48_49 = objArray[i];
                    }
                    Class<?> elem_class = var48_47.getClass();
                    if (!(type.isPrimitive() && (type == Integer.TYPE && elem_class == Integer.class || type == Boolean.TYPE && elem_class == Boolean.class || type == Long.TYPE && elem_class == Long.class || type == Float.TYPE && elem_class == Float.class || type == Double.TYPE && elem_class == Double.class || type == Byte.TYPE && elem_class == Byte.class || type == Short.TYPE && elem_class == Short.class || type == Character.TYPE && elem_class == Character.class) || JavaInvoke.isAssignable(type, elem_class))) {
                        throw new TclException(interp, (typeId == 11 ? "collection" : "array") + " element of type " + JavaInfoCmd.getNameFromClass(elem_class) + " could not be assigned to iteration variable of type " + JavaInfoCmd.getNameFromClass(type));
                    }
                    if (type.isPrimitive() || type == String.class) {
                        wrapper = JavaInvoke.convertJavaObject(interp, type, var48_47);
                        break;
                    }
                    wrapper = ReflectObject.newInstance(interp, type, var48_47);
                    break;
                }
                case 2: {
                    void stringIndexValue = stringArray[i];
                    wrapper = TclString.newInstance((String)stringIndexValue);
                    break;
                }
                case 3: {
                    int intIndexValue = intArray[i];
                    wrapper = TclInteger.newInstance(intIndexValue);
                    break;
                }
                case 4: {
                    boolean booleanIndexValue = booleanArray[i];
                    wrapper = TclInteger.newInstance(booleanIndexValue ? 1 : 0);
                    break;
                }
                case 5: {
                    long longIndexValue = longArray[i];
                    wrapper = TclString.newInstance(String.valueOf(longIndexValue));
                    break;
                }
                case 6: {
                    float floatIndexValue = floatArray[i];
                    wrapper = TclDouble.newInstance(floatIndexValue);
                    break;
                }
                case 7: {
                    double doubleIndexValue = doubleArray[i];
                    wrapper = TclDouble.newInstance(doubleIndexValue);
                    break;
                }
                case 8: {
                    byte byteIndexValue = byteArray[i];
                    wrapper = TclInteger.newInstance(byteIndexValue);
                    break;
                }
                case 9: {
                    void shortIndexValue = shortArray[i];
                    wrapper = TclInteger.newInstance((int)shortIndexValue);
                    break;
                }
                case 10: {
                    void charIndexValue = charArray[i];
                    wrapper = TclString.newInstance((char)charIndexValue);
                    break;
                }
                default: {
                    throw new TclRuntimeError("unmatched typeId " + typeId);
                }
            }
            ++i;
            interp.setVar(varname, wrapper, 0);
            try {
                interp.eval(script, 0);
                continue;
            }
            catch (TclException e) {
                int ccode = e.getCompletionCode();
                if (ccode == 3) break;
                if (ccode != 4) throw e;
                continue;
            }
            break;
        }
        interp.resetResult();
    }

    static final boolean isArrayVarname(String varName) {
        int lastInd = varName.length() - 1;
        return varName.charAt(lastInd) == ')' && varName.indexOf(40) != -1;
    }
}

