/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.reflect.PkgInvoker;

class FuncSig
implements InternalRep {
    Class targetCls;
    PkgInvoker pkgInvoker;
    Object func;
    static Hashtable instanceMethodTable = new Hashtable();
    static Hashtable staticMethodTable = new Hashtable();

    FuncSig(Class cls, PkgInvoker p, Object f) {
        this.targetCls = cls;
        this.pkgInvoker = p;
        this.func = f;
    }

    public InternalRep duplicate() {
        return new FuncSig(this.targetCls, this.pkgInvoker, this.func);
    }

    public void dispose() {
    }

    static FuncSig get(Interp interp, Class cls, TclObject signature, TclObject[] argv, int startIdx, int count, boolean isStatic) throws TclException {
        Object match;
        boolean isConstructor = cls == null;
        int sigLength = TclList.getLength(interp, signature);
        String methodName = null;
        if (sigLength == 0) {
            throw new TclException(interp, "bad signature \"" + signature + "\"");
        }
        TclObject class_or_method = sigLength == 1 ? signature : TclList.index(interp, signature, 0);
        if (isConstructor) {
            cls = JavaInvoke.getClassByName(interp, class_or_method.toString());
        } else {
            methodName = class_or_method.toString();
        }
        if ((isConstructor || isStatic) && !PkgInvoker.isAccessible(cls)) {
            JavaInvoke.notAccessibleError(interp, cls);
        }
        if (isConstructor && Modifier.isAbstract(cls.getModifiers())) {
            throw new TclException(interp, "Class \"" + JavaInfoCmd.getNameFromClass(cls) + "\" is abstract");
        }
        if (sigLength > 1 || sigLength == 1 && count == 0) {
            int sigNumArgs = sigLength - 1;
            Class[] paramTypes = new Class[sigNumArgs];
            for (int i = 0; i < sigNumArgs; ++i) {
                String clsName = TclList.index(interp, signature, i + 1).toString();
                paramTypes[i] = JavaInvoke.getClassByName(interp, clsName);
            }
            if (isConstructor) {
                try {
                    match = FuncSig.getAccessibleConstructor(cls, paramTypes);
                }
                catch (NoSuchMethodException e) {
                    if (sigLength > 1) {
                        throw new TclException(interp, "no accessible constructor \"" + signature + "\"");
                    }
                    throw new TclException(interp, "can't find accessible constructor with " + count + " argument(s) for class \"" + JavaInfoCmd.getNameFromClass(cls) + "\"");
                }
            } else {
                match = FuncSig.lookupMethod(interp, cls, methodName, paramTypes, signature, isStatic);
            }
        } else {
            match = FuncSig.matchSignature(interp, cls, signature, methodName, isConstructor, argv, startIdx, count, isStatic);
        }
        FuncSig sig = new FuncSig(cls, PkgInvoker.getPkgInvoker(cls), match);
        return sig;
    }

    static Method lookupMethod(Interp interp, Class cls, String methodName, Class[] paramTypes, TclObject signature, boolean isStatic) throws TclException {
        boolean foundSameName = false;
        Method[] methods = isStatic ? FuncSig.getAccessibleStaticMethods(cls) : FuncSig.getAccessibleInstanceMethods(cls);
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            foundSameName = true;
            Class<?>[] pt = methods[i].getParameterTypes();
            if (pt.length != paramTypes.length) continue;
            boolean good = true;
            for (int j = 0; j < pt.length; ++j) {
                if (pt[j] == paramTypes[j]) continue;
                good = false;
                break;
            }
            if (!good) continue;
            return methods[i];
        }
        if (paramTypes.length > 0 || !foundSameName) {
            throw new TclException(interp, "no accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" in class " + JavaInfoCmd.getNameFromClass(cls));
        }
        throw new TclException(interp, "can't find accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" with " + paramTypes.length + " argument(s) for class \"" + JavaInfoCmd.getNameFromClass(cls) + "\"");
    }

    static Object matchSignature(Interp interp, Class cls, TclObject signature, String methodName, boolean isConstructor, TclObject[] argv, int startIdx, int argv_count, boolean isStatic) throws TclException {
        int i;
        boolean foundSameName = false;
        ArrayList<Executable> match_list = new ArrayList<Executable>();
        boolean debug = false;
        Executable[] funcs = isConstructor ? FuncSig.getAccessibleConstructors(cls) : (isStatic ? FuncSig.getAccessibleStaticMethods(cls) : FuncSig.getAccessibleInstanceMethods(cls));
        for (i = 0; i < funcs.length; ++i) {
            Class<?>[] paramTypes;
            if (isConstructor) {
                paramTypes = ((Constructor)funcs[i]).getParameterTypes();
            } else {
                Method method = (Method)funcs[i];
                if (!methodName.equals(method.getName())) continue;
                foundSameName = true;
                paramTypes = method.getParameterTypes();
            }
            if (paramTypes.length != argv_count) continue;
            match_list.add(funcs[i]);
        }
        if (match_list.size() == 1) {
            return match_list.get(0);
        }
        if (match_list.size() > 1) {
            int j;
            Class<?>[] match_classes;
            Class c;
            Class[] argv_classes = new Class[argv_count];
            for (i = 0; i < argv_count; ++i) {
                TclObject tobj = argv[startIdx + i];
                boolean isJavaObj = true;
                c = null;
                try {
                    c = ReflectObject.getClass(interp, tobj);
                }
                catch (TclException e) {
                    isJavaObj = false;
                }
                argv_classes[i] = isJavaObj ? c : String.class;
            }
            for (i = 0; i < match_list.size(); ++i) {
                match_classes = isConstructor ? ((Constructor)match_list.get(i)).getParameterTypes() : ((Method)match_list.get(i)).getParameterTypes();
                boolean exact = true;
                for (j = 0; j < argv_count; ++j) {
                    if (match_classes[j] == argv_classes[j]) continue;
                    exact = false;
                    break;
                }
                if (!exact) continue;
                return match_list.get(i);
            }
            block6: for (i = match_list.size() - 1; i >= 0; --i) {
                match_classes = isConstructor ? ((Constructor)match_list.get(i)).getParameterTypes() : ((Method)match_list.get(i)).getParameterTypes();
                for (j = 0; j < argv_count; ++j) {
                    if (JavaInvoke.isAssignable(match_classes[j], argv_classes[j])) continue;
                    match_list.remove(i);
                    continue block6;
                }
            }
            if (match_list.size() == 1) {
                return match_list.get(0);
            }
            if (match_list.size() > 1) {
                Class[][] argv_classes_lookup = new Class[argv_count][];
                ArrayList class_list = new ArrayList();
                for (i = 0; i < argv_count; ++i) {
                    c = argv_classes[i];
                    if (c == null) continue;
                    for (j = 0; j < i; ++j) {
                        if (c != argv_classes_lookup[j][0]) continue;
                        argv_classes_lookup[i] = argv_classes_lookup[j];
                    }
                    while (c != null) {
                        class_list.add(null);
                        FuncSig.addInterfaces(c, class_list);
                        c = c.getSuperclass();
                    }
                    class_list.remove(0);
                    Class[] classes = new Class[class_list.size()];
                    for (j = 0; j < classes.length; ++j) {
                        classes[j] = (Class)class_list.get(j);
                    }
                    argv_classes_lookup[i] = classes;
                    class_list.clear();
                }
                int[] super_steps = new int[match_list.size()];
                int[] total_steps = new int[match_list.size()];
                boolean[] trim_matches = new boolean[match_list.size()];
                for (j = 0; j < argv_count; ++j) {
                    int min_super_step = Integer.MAX_VALUE;
                    int min_total_step = Integer.MAX_VALUE;
                    Class min_class = Object.class;
                    block13: for (i = 0; i < match_list.size(); ++i) {
                        match_classes = isConstructor ? ((Constructor)match_list.get(i)).getParameterTypes() : ((Method)match_list.get(i)).getParameterTypes();
                        Class<?> match_to = match_classes[j];
                        Class[] arg_classes = argv_classes_lookup[j];
                        if (arg_classes == null) {
                            super_steps[i] = Integer.MAX_VALUE;
                            total_steps[i] = Integer.MAX_VALUE;
                            continue;
                        }
                        int super_step = 0;
                        for (int total_step = 0; total_step < arg_classes.length; ++total_step) {
                            Class c2 = arg_classes[total_step];
                            if (c2 == null) {
                                ++super_step;
                                continue;
                            }
                            if (c2 != match_to) continue;
                            super_steps[i] = super_step;
                            total_steps[i] = total_step;
                            if (super_step > min_super_step || c2.isInterface() && min_class != Object.class && !min_class.isInterface()) continue block13;
                            min_class = c2;
                            min_super_step = super_step;
                            if (total_step >= min_total_step) continue block13;
                            min_total_step = total_step;
                            continue block13;
                        }
                    }
                    for (i = match_list.size() - 1; i >= 0; --i) {
                        if (super_steps[i] <= min_super_step && (super_steps[i] != min_super_step || total_steps[i] <= min_total_step)) continue;
                        trim_matches[i] = true;
                    }
                }
                for (i = match_list.size() - 1; i >= 0; --i) {
                    if (!trim_matches[i]) continue;
                    match_list.remove(i);
                }
            }
            if (match_list.size() == 1) {
                return match_list.get(0);
            }
            StringBuffer sb = new StringBuffer(100);
            sb.append("ambiguous ");
            if (isConstructor) {
                sb.append("constructor");
            } else {
                sb.append("method");
            }
            sb.append(" signature");
            if (match_list.size() == 0) {
                sb.append(", could not choose between ");
                funcs = isConstructor ? FuncSig.getAccessibleConstructors(cls) : (isStatic ? FuncSig.getAccessibleStaticMethods(cls) : FuncSig.getAccessibleInstanceMethods(cls));
                for (i = 0; i < funcs.length; ++i) {
                    Class<?>[] paramTypes;
                    if (isConstructor) {
                        paramTypes = ((Constructor)funcs[i]).getParameterTypes();
                    } else {
                        Method method = (Method)funcs[i];
                        if (!methodName.equals(method.getName())) continue;
                        foundSameName = true;
                        paramTypes = method.getParameterTypes();
                    }
                    if (paramTypes.length != argv_count) continue;
                    match_list.add(funcs[i]);
                }
            } else {
                sb.append(", assignable signatures are ");
            }
            TclObject siglist = TclList.newInstance();
            siglist.preserve();
            for (i = 0; i < match_list.size(); ++i) {
                TclObject cur_siglist = TclList.newInstance();
                cur_siglist.preserve();
                if (isConstructor) {
                    Constructor con = (Constructor)match_list.get(i);
                    TclList.append(interp, cur_siglist, TclString.newInstance(con.getName()));
                    match_classes = con.getParameterTypes();
                } else {
                    Method meth = (Method)match_list.get(i);
                    TclList.append(interp, cur_siglist, TclString.newInstance(meth.getName()));
                    match_classes = meth.getParameterTypes();
                }
                for (j = 0; j < argv_count; ++j) {
                    Class<?> c3 = match_classes[j];
                    TclList.append(interp, cur_siglist, TclString.newInstance(JavaInfoCmd.getNameFromClass(c3)));
                }
                TclList.append(interp, siglist, cur_siglist);
                cur_siglist.release();
            }
            sb.append(siglist.toString());
            siglist.release();
            throw new TclException(interp, sb.toString());
        }
        if (isConstructor) {
            throw new TclException(interp, "can't find accessible constructor with " + argv_count + " argument(s) for class \"" + JavaInfoCmd.getNameFromClass(cls) + "\"");
        }
        if (!foundSameName) {
            throw new TclException(interp, "no accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" in class " + JavaInfoCmd.getNameFromClass(cls));
        }
        throw new TclException(interp, "can't find accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" with " + argv_count + " argument(s) for class \"" + JavaInfoCmd.getNameFromClass(cls) + "\"");
    }

    private static void addInterfaces(Class cls, ArrayList alist) {
        alist.add(cls);
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            FuncSig.addInterfaces(interfaces[i], alist);
        }
    }

    static Constructor[] getAccessibleConstructors(Class cls) {
        int i;
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getConstructors();
        }
        Constructor[] constructors = cls.getDeclaredConstructors();
        ArrayList alist = null;
        boolean skipped_any = false;
        for (i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (PkgInvoker.isAccessible(c)) {
                if (alist == null) {
                    alist = new ArrayList(constructors.length);
                }
                alist.add(c);
                continue;
            }
            skipped_any = true;
        }
        if (skipped_any) {
            if (alist == null) {
                constructors = new Constructor[]{};
            } else {
                constructors = new Constructor[alist.size()];
                for (i = 0; i < constructors.length; ++i) {
                    constructors[i] = (Constructor)alist.get(i);
                }
            }
        }
        return constructors;
    }

    static Constructor getAccessibleConstructor(Class cls, Class[] parameterTypes) throws NoSuchMethodException {
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getConstructor(parameterTypes);
        }
        Constructor constructor = cls.getDeclaredConstructor(parameterTypes);
        if (!PkgInvoker.isAccessible(constructor)) {
            throw new NoSuchMethodException();
        }
        return constructor;
    }

    static Method[] getAccessibleInstanceMethods(Class cls) {
        Method[] methods = (Method[])instanceMethodTable.get(cls);
        if (methods != null) {
            return methods;
        }
        ArrayList alist = new ArrayList();
        Class c = cls;
        while (c != null) {
            methods = c.getDeclaredMethods();
            FuncSig.mergeInstanceMethods(c, methods, alist);
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                FuncSig.mergeInstanceMethods(interfaces[i], interfaces[i].getMethods(), alist);
            }
            if (c.isInterface()) {
                c = Object.class;
                continue;
            }
            c = c.getSuperclass();
        }
        FuncSig.sortMethods(alist);
        methods = new Method[alist.size()];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = (Method)alist.get(i);
        }
        instanceMethodTable.put(cls, methods);
        return methods;
    }

    static Method[] getAccessibleStaticMethods(Class cls) {
        int i;
        Method[] methods = (Method[])staticMethodTable.get(cls);
        if (methods != null) {
            return methods;
        }
        methods = cls.getDeclaredMethods();
        ArrayList<Method> alist = new ArrayList<Method>();
        for (i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!Modifier.isStatic(m.getModifiers()) || !PkgInvoker.isAccessible(m)) continue;
            alist.add(m);
        }
        FuncSig.sortMethods(alist);
        methods = new Method[alist.size()];
        for (i = 0; i < methods.length; ++i) {
            methods[i] = (Method)alist.get(i);
        }
        staticMethodTable.put(cls, methods);
        return methods;
    }

    private static void mergeInstanceMethods(Class c, Method[] methods, ArrayList alist) {
        for (int i = 0; i < methods.length; ++i) {
            boolean sameSigExists = false;
            Method newMeth = methods[i];
            if (newMeth == null || Modifier.isStatic(newMeth.getModifiers()) || !PkgInvoker.isAccessible(newMeth)) continue;
            for (int j = 0; j < alist.size(); ++j) {
                int oldRank;
                Method oldMeth = (Method)alist.get(j);
                if (!FuncSig.methodSigEqual(oldMeth, newMeth)) continue;
                sameSigExists = true;
                Class<?> oldCls = oldMeth.getDeclaringClass();
                int newRank = FuncSig.getMethodRank(c, newMeth);
                if (newRank <= (oldRank = FuncSig.getMethodRank(oldCls, oldMeth))) break;
                alist.set(j, newMeth);
                break;
            }
            if (sameSigExists) continue;
            alist.add(newMeth);
        }
    }

    private static boolean methodSigEqual(Method method1, Method method2) {
        Class<?>[] param2;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] param1 = method1.getParameterTypes();
        if (param1.length != (param2 = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < param1.length; ++i) {
            if (param1[i] == param2[i]) continue;
            return false;
        }
        return true;
    }

    private static void sortMethods(ArrayList alist) {
        boolean debug = false;
        int insize = alist.size();
        for (int i = 1; i < alist.size(); ++i) {
            Method jm;
            String jms;
            int c = i;
            Method cm = (Method)alist.get(c);
            String cms = FuncSig.getMethodDescription(cm);
            int j = c - 1;
            while (j >= 0 && cms.compareTo(jms = FuncSig.getMethodDescription(jm = (Method)alist.get(j))) <= 0) {
                alist.set(c, jm);
                alist.set(j, cm);
                c = j--;
            }
        }
        if (insize != alist.size()) {
            throw new RuntimeException("lost elements");
        }
    }

    private static String getMethodDescription(Method m) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(m.getName());
        Class<?>[] params = m.getParameterTypes();
        sb.append('(');
        for (int i = 0; i < params.length; ++i) {
            sb.append(JavaInfoCmd.getNameFromClass(params[i]));
            if (i >= params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") returns ");
        Class<?> ret = m.getReturnType();
        sb.append(JavaInfoCmd.getNameFromClass(ret));
        return sb.toString();
    }

    private static int getMethodRank(Class declaringCls, Method method) {
        int methMod = method.getModifiers();
        if (Modifier.isPrivate(methMod)) {
            return 0;
        }
        int clsMod = declaringCls.getModifiers();
        if (Modifier.isPublic(methMod) && Modifier.isPublic(clsMod)) {
            return 2;
        }
        return 0;
    }
}

