/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.ListIterator;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class CObject
implements InternalRep {
    protected long objPtr;
    protected int refsHeld;
    protected boolean refCountUnchanged;
    protected boolean onCleanupQueue;
    protected boolean emptyNeedsCleanup;
    protected boolean disposed;

    protected CObject() {
        this(CObject.newCObject(null));
        this.emptyNeedsCleanup = true;
    }

    protected CObject(long objPtr) {
        if (objPtr == 0L) {
            throw new TclRuntimeError("objPtr can not be 0");
        }
        this.objPtr = objPtr;
        this.refsHeld = 0;
        this.refCountUnchanged = true;
        this.onCleanupQueue = false;
        this.emptyNeedsCleanup = false;
        this.disposed = false;
    }

    public void dispose() {
        if (this.disposed) {
            throw new TclRuntimeError("CObject already disposed");
        }
        while (this.refsHeld > 0) {
            this.decrRefCount();
        }
        if (this.refCountUnchanged && (this.onCleanupQueue || this.emptyNeedsCleanup)) {
            CObject.incrRefCount(this.objPtr);
            CObject.decrRefCount(this.objPtr);
            this.emptyNeedsCleanup = false;
        }
        this.disposed = true;
    }

    public InternalRep duplicate() {
        if (this.disposed) {
            throw new TclRuntimeError("CObject was disposed");
        }
        return new CObject(this.objPtr);
    }

    public String toString() {
        if (this.disposed) {
            throw new TclRuntimeError("CObject was disposed");
        }
        return CObject.getString(this.objPtr);
    }

    private static TclObject newInstance(long objPtr) {
        return new TclObject(new CObject(objPtr));
    }

    private static final native void decrRefCount(long var0);

    final void decrRefCount() {
        if (this.disposed) {
            throw new TclRuntimeError("CObject was disposed");
        }
        CObject.decrRefCount(this.objPtr);
        --this.refsHeld;
        this.refCountUnchanged = false;
    }

    private static final native void incrRefCount(long var0);

    final void incrRefCount() {
        if (this.disposed) {
            throw new TclRuntimeError("CObject was disposed");
        }
        CObject.incrRefCount(this.objPtr);
        ++this.refsHeld;
        this.refCountUnchanged = false;
    }

    private static final native long newCObject(String var0);

    private static final native String getString(long var0);

    final void makeReference(TclObject object) {
        if (!this.onCleanupQueue) {
            CObject.makeRef(this.objPtr, object);
        }
    }

    private static final native void makeRef(long var0, TclObject var2);

    final long getCObjectPtr() {
        return this.objPtr;
    }

    static void cleanupAdd(Interp interp, CObject cobj) {
        if (cobj == null) {
            throw new NullPointerException();
        }
        if (cobj.onCleanupQueue) {
            throw new TclRuntimeError("CObject already in cleanup queue");
        }
        if (cobj.disposed) {
            throw new TclRuntimeError("CObject already disposed");
        }
        interp.cobjCleanup.add(cobj);
        cobj.onCleanupQueue = true;
    }

    static void cleanupPush(Interp interp) {
        interp.cobjCleanup.add(null);
    }

    static void cleanupPop(Interp interp) {
        ArrayList cleanup = interp.cobjCleanup;
        int last = cleanup.size() - 1;
        CObject cobj = (CObject)cleanup.get(last);
        cleanup.remove(last);
        while (cobj != null) {
            if (!cobj.onCleanupQueue) {
                throw new TclRuntimeError("CObject not in queue");
            }
            if (cobj.refCountUnchanged && !cobj.disposed) {
                CObject.incrRefCount(cobj.objPtr);
                CObject.decrRefCount(cobj.objPtr);
            }
            cobj.onCleanupQueue = false;
            cobj = (CObject)cleanup.get(--last);
            cleanup.remove(last);
        }
    }

    private static void dump(ArrayList alist) {
        ListIterator iter = alist.listIterator();
        while (iter.hasNext()) {
            CObject cobj = (CObject)iter.next();
            if (cobj == null) {
                System.out.println("XXX FRAME PUSHED XXX");
                continue;
            }
            if (cobj.disposed) {
                System.out.println("XXX " + Long.toHexString(cobj.objPtr) + " DISPOSED XXX");
                continue;
            }
            System.out.println("\"" + cobj.toString() + "\" at " + Long.toHexString(cobj.objPtr));
        }
        System.out.println("-----------------");
    }
}

