/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Array;
import tcl.lang.FuncSig;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class ArrayObject
extends ReflectObject {
    private static final String[] validCmds = new String[]{"length", "get", "getrange", "set", "setrange"};
    private static final int OPT_LENGTH = 0;
    private static final int OPT_GET = 1;
    private static final int OPT_GETRANGE = 2;
    private static final int OPT_SET = 3;
    private static final int OPT_SETRANGE = 4;

    ArrayObject() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int option;
        int numArgs;
        int optionIdx;
        boolean convert;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?-noconvert? option ?arg arg ...?");
        }
        String arg1 = argv[1].toString();
        if (arg1.length() >= 2 && "-noconvert".startsWith(arg1)) {
            convert = false;
            optionIdx = 2;
            numArgs = argv.length - 3;
        } else {
            convert = true;
            optionIdx = 1;
            numArgs = argv.length - 2;
        }
        if (numArgs < 0) {
            throw new TclNumArgsException(interp, 1, argv, "?-noconvert? option ?arg arg ...?");
        }
        try {
            option = TclIndex.get(interp, argv[optionIdx], validCmds, "option", 1);
        }
        catch (TclException e) {
            try {
                int startIdx = optionIdx + 1;
                FuncSig.get(interp, this.javaClass, argv[optionIdx], argv, startIdx, argv.length - startIdx, false);
            }
            catch (TclException e1) {
                throw new TclException(interp, "bad option \"" + argv[optionIdx] + "\": must be length, get, getrange, " + "set, setrange, or a valid method signature");
            }
            super.cmdProc(interp, argv);
            return;
        }
        switch (option) {
            case 0: {
                if (numArgs != 0) {
                    throw new TclNumArgsException(interp, optionIdx + 1, argv, "");
                }
                if (!convert) {
                    throw new TclException(interp, "-noconvert flag not allowed for the \"length\" sub-command");
                }
                interp.setResult(Array.getLength(this.javaObj));
                return;
            }
            case 1: {
                int index;
                Class subArrayClass;
                Object subArrayObj;
                if (numArgs != 1) {
                    throw new TclNumArgsException(interp, optionIdx + 1, argv, "indexList");
                }
                TclObject indexListObj = argv[optionIdx + 1];
                int numDims = TclList.getLength(interp, indexListObj);
                if (numDims == 0) {
                    subArrayObj = this.javaObj;
                    subArrayClass = ArrayObject.dereferenceClassDims(interp, this.javaClass, 1);
                    index = 0;
                } else {
                    subArrayObj = ArrayObject.dereferenceArrayDims(interp, this.javaObj, numDims, indexListObj);
                    subArrayClass = ArrayObject.dereferenceClassDims(interp, this.javaClass, numDims);
                    index = TclInteger.get(interp, TclList.index(interp, indexListObj, numDims - 1));
                }
                interp.setResult(ArrayObject.getArrayElt(interp, subArrayObj, subArrayClass, index, convert));
                return;
            }
            case 3: {
                int index;
                Class subArrayClass;
                Object subArrayObj;
                if (numArgs != 2) {
                    throw new TclNumArgsException(interp, optionIdx + 1, argv, "indexList value");
                }
                if (!convert) {
                    throw new TclException(interp, "-noconvert flag not allowed for the \"set\" sub-command");
                }
                TclObject indexListObj = argv[optionIdx + 1];
                int numDims = TclList.getLength(interp, indexListObj);
                if (numDims == 0) {
                    subArrayObj = this.javaObj;
                    subArrayClass = ArrayObject.dereferenceClassDims(interp, this.javaClass, 1);
                    index = 0;
                } else {
                    subArrayObj = ArrayObject.dereferenceArrayDims(interp, this.javaObj, numDims, indexListObj);
                    subArrayClass = ArrayObject.dereferenceClassDims(interp, this.javaClass, numDims);
                    index = TclInteger.get(interp, TclList.index(interp, indexListObj, numDims - 1));
                }
                ArrayObject.setArrayElt(interp, subArrayObj, subArrayClass, index, argv[optionIdx + 2]);
                interp.resetResult();
                return;
            }
            case 2: {
                TclObject indexListObj;
                int numDims;
                if (numArgs > 2) {
                    throw new TclNumArgsException(interp, optionIdx + 1, argv, "?indexList ?count??");
                }
                Object subArrayObj = this.javaObj;
                Class subArrayClass = ArrayObject.dereferenceClassDims(interp, this.javaClass, 1);
                int index = 0;
                if (numArgs > 0 && (numDims = TclList.getLength(interp, indexListObj = argv[optionIdx + 1])) > 0) {
                    subArrayObj = ArrayObject.dereferenceArrayDims(interp, this.javaObj, numDims, indexListObj);
                    subArrayClass = ArrayObject.dereferenceClassDims(interp, this.javaClass, numDims);
                    index = TclInteger.get(interp, TclList.index(interp, indexListObj, numDims - 1));
                }
                int count = Array.getLength(subArrayObj) - index;
                if (numArgs > 1) {
                    count = Math.min(count, TclInteger.get(interp, argv[optionIdx + 2]));
                }
                interp.setResult(ArrayObject.getArrayElts(interp, subArrayObj, subArrayClass, index, count, convert));
                return;
            }
            case 4: {
                TclObject indexListObj;
                int numDims;
                if (numArgs < 1 || numArgs > 3) {
                    throw new TclNumArgsException(interp, optionIdx + 1, argv, "?indexList ?count?? valueList");
                }
                if (!convert) {
                    throw new TclException(interp, "-noconvert flag not allowed for the \"setrange\" sub-command");
                }
                TclObject tclValueListObj = argv[argv.length - 1];
                Object subArrayObj = this.javaObj;
                Class subArrayClass = ArrayObject.dereferenceClassDims(interp, this.javaClass, 1);
                int index = 0;
                if (numArgs > 1 && (numDims = TclList.getLength(interp, indexListObj = argv[optionIdx + 1])) > 0) {
                    subArrayObj = ArrayObject.dereferenceArrayDims(interp, this.javaObj, numDims, indexListObj);
                    subArrayClass = ArrayObject.dereferenceClassDims(interp, this.javaClass, numDims);
                    index = TclInteger.get(interp, TclList.index(interp, indexListObj, numDims - 1));
                }
                int count = Math.min(TclList.getLength(interp, tclValueListObj), Array.getLength(subArrayObj) - index);
                if (numArgs > 2) {
                    count = Math.min(count, TclInteger.get(interp, argv[optionIdx + 2]));
                }
                ArrayObject.setArrayElts(interp, subArrayObj, subArrayClass, index, count, tclValueListObj);
                interp.resetResult();
                return;
            }
        }
    }

    static Object initArray(Interp interp, TclObject sizeListObj, int sizeListLen, int dim, int numDims, Class cls, TclObject valueListObj) throws TclException {
        Object arrayObj;
        int arrayLength;
        Class<?> compCls = cls.getComponentType();
        int valueListLen = 0;
        if (valueListObj != null) {
            valueListLen = TclList.getLength(interp, valueListObj);
        }
        if ((arrayLength = dim < sizeListLen ? TclInteger.get(interp, TclList.index(interp, sizeListObj, dim)) : valueListLen) == 0 && dim < numDims - 1) {
            throw new TclException(interp, "cannot initialize a " + numDims + " dimensional array with zero size in dimension " + dim);
        }
        try {
            arrayObj = Array.newInstance(compCls, arrayLength);
        }
        catch (NegativeArraySizeException ex) {
            throw new TclException(interp, "negative array size " + arrayLength);
        }
        if (compCls.isArray()) {
            int nextDim = dim + 1;
            for (int i = 0; i < arrayLength; ++i) {
                TclObject subValueListObj = null;
                if (i < valueListLen) {
                    subValueListObj = TclList.index(interp, valueListObj, i);
                }
                Object subArrayObj = ArrayObject.initArray(interp, sizeListObj, sizeListLen, nextDim, numDims, compCls, subValueListObj);
                Array.set(arrayObj, i, subArrayObj);
            }
        } else if (valueListLen > 0) {
            int count = Math.min(arrayLength, valueListLen);
            ArrayObject.setArrayElts(interp, arrayObj, compCls, 0, count, valueListObj);
        }
        return arrayObj;
    }

    private static Object dereferenceArrayDims(Interp interp, Object arrayObj, int numDerefDims, TclObject indexListObj) throws TclException {
        int numDims = JavaInfoCmd.getNumDimsFromClass(arrayObj.getClass());
        if (numDims < numDerefDims) {
            throw new TclException(interp, "bad indexList \"" + indexListObj.toString() + "\": javaObj only has " + numDims + " dimension(s)");
        }
        Object subArrayObj = arrayObj;
        for (int dim = 0; dim < numDerefDims - 1; ++dim) {
            int index = TclInteger.get(interp, TclList.index(interp, indexListObj, dim));
            try {
                subArrayObj = Array.get(subArrayObj, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                int max = Array.getLength(subArrayObj) - 1;
                throw new TclException(interp, "array index \"" + index + "\" is out of bounds: must be between 0 and " + max);
            }
            if (subArrayObj != null) continue;
            throw new TclException(interp, "null value in dimension " + dim + ": can't dereference " + numDims + " dimensions");
        }
        return subArrayObj;
    }

    private static Class dereferenceClassDims(Interp interp, Class arrayClass, int numDerefDims) throws TclException {
        int numDims = JavaInfoCmd.getNumDimsFromClass(arrayClass);
        if (numDims < numDerefDims) {
            throw new TclException(interp, "bad class dereference class only has " + numDims + " dimension(s)");
        }
        Class<?> subArrayClass = arrayClass;
        for (int dim = 0; dim < numDerefDims; ++dim) {
            subArrayClass = subArrayClass.getComponentType();
        }
        return subArrayClass;
    }

    static TclObject getArrayElts(Interp interp, Object arrayObj, Class arrayClass, int index, int count, boolean convert) throws TclException {
        TclObject resultListObj = TclList.newInstance();
        try {
            int i = 0;
            while (i < count) {
                TclList.append(interp, resultListObj, ArrayObject.getArrayElt(interp, arrayObj, arrayClass, index, convert));
                ++i;
                ++index;
            }
        }
        catch (TclException e) {
            resultListObj.release();
            throw e;
        }
        return resultListObj;
    }

    static TclObject getArrayElt(Interp interp, Object arrayObj, Class arrayClass, int index, boolean convert) throws TclException {
        Object obj;
        try {
            obj = Array.get(arrayObj, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int max = Array.getLength(arrayObj) - 1;
            throw new TclException(interp, "array index \"" + index + "\" is out of bounds: must be between 0 and " + max);
        }
        if (convert) {
            return JavaInvoke.convertJavaObject(interp, arrayClass, obj);
        }
        return ReflectObject.newInstance(interp, arrayClass, obj);
    }

    static void setArrayElts(Interp interp, Object arrayObj, Class arrayClass, int index, int count, TclObject tclValueListObj) throws TclException {
        int i = 0;
        while (i < count) {
            ArrayObject.setArrayElt(interp, arrayObj, arrayClass, index, TclList.index(interp, tclValueListObj, i));
            ++i;
            ++index;
        }
    }

    static void setArrayElt(Interp interp, Object arrayObj, Class arrayClass, int index, TclObject value) throws TclException {
        Class componentType = arrayClass;
        Object javaValue = JavaInvoke.convertTclObject(interp, componentType, value);
        try {
            Array.set(arrayObj, index, javaValue);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int max = Array.getLength(arrayObj) - 1;
            throw new TclException(interp, "array index \"" + index + "\" is out of bounds: must be between 0 and " + max);
        }
    }

    static String getBaseName(String clsName) {
        if (clsName.endsWith("[]")) {
            int end = clsName.indexOf(91);
            return clsName.substring(0, end);
        }
        if (clsName.charAt(0) == '[') {
            if (clsName.endsWith("[")) {
                return clsName;
            }
            String baseName = clsName.substring(1);
            while (baseName.charAt(0) == '[') {
                baseName = baseName.substring(1);
            }
            if (baseName.charAt(0) == 'L' && baseName.endsWith(";")) {
                return baseName.substring(1, baseName.length() - 1);
            }
            if (baseName.charAt(0) == 'I') {
                return "int";
            }
            if (baseName.charAt(0) == 'Z') {
                return "boolean";
            }
            if (baseName.charAt(0) == 'J') {
                return "long";
            }
            if (baseName.charAt(0) == 'F') {
                return "float";
            }
            if (baseName.charAt(0) == 'D') {
                return "double";
            }
            if (baseName.charAt(0) == 'B') {
                return "byte";
            }
            if (baseName.charAt(0) == 'S') {
                return "short";
            }
            if (baseName.charAt(0) == 'C') {
                return "char";
            }
        }
        return clsName;
    }
}

