/*
 * Decompiled with CFR 0.152.
 */
package org.libsdl.app;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.WindowManager;
import org.libsdl.app.SDLActivity;
import org.libsdl.app.SDLGenericMotionListener_API12;
import org.libsdl.app.SDLGenericMotionListener_API26;

class SDLSurface
extends SurfaceView
implements SurfaceHolder.Callback,
View.OnKeyListener,
View.OnTouchListener,
SensorEventListener {
    private static final String TAG = "SDL";
    protected static SensorManager mSensorManager;
    protected static Display mDisplay;
    protected static float mWidth;
    protected static float mHeight;

    public SDLSurface(Context context) {
        super(context);
        this.getHolder().setFormat(3);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.setOnKeyListener(this);
        this.setOnTouchListener(this);
        mDisplay = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        mSensorManager = (SensorManager)context.getSystemService("sensor");
        if (Build.VERSION.SDK_INT >= 26) {
            this.setOnGenericMotionListener(new SDLGenericMotionListener_API26());
        } else if (Build.VERSION.SDK_INT >= 12) {
            this.setOnGenericMotionListener(new SDLGenericMotionListener_API12());
        }
        mWidth = 1.0f;
        mHeight = 1.0f;
    }

    public void handlePause() {
        this.enableSensor(1, false);
    }

    public void handleResume() {
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.setOnKeyListener(this);
        this.setOnTouchListener(this);
        this.enableSensor(1, true);
    }

    public Surface getNativeSurface() {
        return this.getHolder().getSurface();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.v((String)TAG, (String)"surfaceCreated()");
        holder.setType(2);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.v((String)TAG, (String)"surfaceDestroyed()");
        SDLActivity.mNextNativeState = SDLActivity.NativeState.PAUSED;
        SDLActivity.handleNativeState();
        SDLActivity.mIsSurfaceReady = false;
        SDLActivity.onNativeSurfaceDestroyed();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.v((String)TAG, (String)"surfaceChanged()");
        int sdlFormat = 370546692;
        switch (format) {
            case 8: {
                Log.v((String)TAG, (String)"pixel format A_8");
                break;
            }
            case 10: {
                Log.v((String)TAG, (String)"pixel format LA_88");
                break;
            }
            case 9: {
                Log.v((String)TAG, (String)"pixel format L_8");
                break;
            }
            case 7: {
                Log.v((String)TAG, (String)"pixel format RGBA_4444");
                sdlFormat = 356651010;
                break;
            }
            case 6: {
                Log.v((String)TAG, (String)"pixel format RGBA_5551");
                sdlFormat = 356782082;
                break;
            }
            case 1: {
                Log.v((String)TAG, (String)"pixel format RGBA_8888");
                sdlFormat = 373694468;
                break;
            }
            case 2: {
                Log.v((String)TAG, (String)"pixel format RGBX_8888");
                sdlFormat = 371595268;
                break;
            }
            case 11: {
                Log.v((String)TAG, (String)"pixel format RGB_332");
                sdlFormat = 336660481;
                break;
            }
            case 4: {
                Log.v((String)TAG, (String)"pixel format RGB_565");
                sdlFormat = 353701890;
                break;
            }
            case 3: {
                Log.v((String)TAG, (String)"pixel format RGB_888");
                sdlFormat = 370546692;
                break;
            }
            default: {
                Log.v((String)TAG, (String)("pixel format unknown " + format));
            }
        }
        mWidth = width;
        mHeight = height;
        DisplayMetrics dm = new DisplayMetrics();
        mDisplay.getMetrics(dm);
        int rot = mDisplay.getRotation();
        if (rot == 1 || rot == 3) {
            SDLActivity.onNativeResize(width, height, sdlFormat, (int)dm.ydpi, (int)dm.xdpi, mDisplay.getRefreshRate());
        } else {
            SDLActivity.onNativeResize(width, height, sdlFormat, (int)dm.xdpi, (int)dm.ydpi, mDisplay.getRefreshRate());
        }
        Log.v((String)TAG, (String)("Window size: " + width + "x" + height));
        boolean skip = false;
        int requestedOrientation = SDLActivity.mSingleton.getRequestedOrientation();
        if (requestedOrientation != -1) {
            if (requestedOrientation == 1 || requestedOrientation == 7) {
                if (mWidth > mHeight) {
                    skip = true;
                }
            } else if ((requestedOrientation == 0 || requestedOrientation == 6) && mWidth < mHeight) {
                skip = true;
            }
        }
        if (skip) {
            double min = Math.min(mWidth, mHeight);
            double max = Math.max(mWidth, mHeight);
            if (max / min < 1.2) {
                Log.v((String)TAG, (String)"Don't skip on such aspect-ratio. Could be a square resolution.");
                skip = false;
            }
        }
        if (skip) {
            Log.v((String)TAG, (String)"Skip .. Surface is not ready.");
            SDLActivity.mIsSurfaceReady = false;
            return;
        }
        SDLActivity.mIsSurfaceReady = true;
        SDLActivity.onNativeSurfaceChanged();
        SDLActivity.handleNativeState();
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        InputDevice device;
        int deviceId = event.getDeviceId();
        int source = event.getSource();
        int action = event.getAction();
        if (keyCode == 23 && SDLActivity.isAndroidTV()) {
            if (action == 0) {
                SDLActivity.onNativeKeyDown(66);
                return true;
            }
            if (action == 1) {
                SDLActivity.onNativeKeyUp(66);
                return true;
            }
        }
        if (SDLActivity.isDeviceSDLJoystick(deviceId) && (action == 0 ? SDLActivity.onNativePadDown(deviceId, keyCode) == 0 : action == 1 && SDLActivity.onNativePadUp(deviceId, keyCode) == 0)) {
            return true;
        }
        if (source == 0 && (device = InputDevice.getDevice((int)deviceId)) != null) {
            source = device.getSources();
        }
        if ((source & 0x101) != 0) {
            if (action == 0) {
                SDLActivity.onNativeKeyDown(keyCode);
                return true;
            }
            if (action == 1) {
                SDLActivity.onNativeKeyUp(keyCode);
                return true;
            }
        }
        if ((source & 0x2002) != 0 && (keyCode == 4 || keyCode == 125)) {
            switch (action) {
                case 0: 
                case 1: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onTouch(View v, MotionEvent event) {
        int touchDevId = event.getDeviceId();
        int pointerCount = event.getPointerCount();
        int action = event.getActionMasked();
        int i = -1;
        if (event.getSource() == 8194 || event.getSource() == 12290) {
            int mouseButton;
            if (Build.VERSION.SDK_INT < 14) {
                mouseButton = 1;
            } else {
                try {
                    mouseButton = (Integer)event.getClass().getMethod("getButtonState", new Class[0]).invoke((Object)event, new Object[0]);
                }
                catch (Exception e) {
                    mouseButton = 1;
                }
            }
            SDLActivity.onNativeMouse(mouseButton, action, event.getX(0), event.getY(0));
        } else {
            switch (action) {
                case 2: {
                    for (i = 0; i < pointerCount; ++i) {
                        int pointerFingerId = event.getPointerId(i);
                        float x = event.getX(i) / mWidth;
                        float y = event.getY(i) / mHeight;
                        float p = event.getPressure(i);
                        if (p > 1.0f) {
                            p = 1.0f;
                        }
                        SDLActivity.onNativeTouch(touchDevId, pointerFingerId, action, x, y, p);
                    }
                    break;
                }
                case 0: 
                case 1: {
                    i = 0;
                }
                case 5: 
                case 6: {
                    if (i == -1) {
                        i = event.getActionIndex();
                    }
                    int pointerFingerId = event.getPointerId(i);
                    float x = event.getX(i) / mWidth;
                    float y = event.getY(i) / mHeight;
                    float p = event.getPressure(i);
                    if (p > 1.0f) {
                        p = 1.0f;
                    }
                    SDLActivity.onNativeTouch(touchDevId, pointerFingerId, action, x, y, p);
                    break;
                }
                case 3: {
                    for (i = 0; i < pointerCount; ++i) {
                        int pointerFingerId = event.getPointerId(i);
                        float x = event.getX(i) / mWidth;
                        float y = event.getY(i) / mHeight;
                        float p = event.getPressure(i);
                        if (p > 1.0f) {
                            p = 1.0f;
                        }
                        SDLActivity.onNativeTouch(touchDevId, pointerFingerId, 1, x, y, p);
                    }
                    break;
                }
            }
        }
        return true;
    }

    public void enableSensor(int sensortype, boolean enabled) {
        if (enabled) {
            mSensorManager.registerListener((SensorEventListener)this, mSensorManager.getDefaultSensor(sensortype), 1, null);
        } else {
            mSensorManager.unregisterListener((SensorEventListener)this, mSensorManager.getDefaultSensor(sensortype));
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 1) {
            float y;
            float x;
            switch (mDisplay.getRotation()) {
                case 1: {
                    x = -event.values[1];
                    y = event.values[0];
                    break;
                }
                case 3: {
                    x = event.values[1];
                    y = -event.values[0];
                    break;
                }
                case 2: {
                    x = -event.values[1];
                    y = -event.values[0];
                    break;
                }
                default: {
                    x = event.values[0];
                    y = event.values[1];
                }
            }
            SDLActivity.onNativeAccel(-x / 9.80665f, y / 9.80665f, event.values[2] / 9.80665f);
        }
    }
}

