/*
 * Decompiled with CFR 0.152.
 */
package org.libsdl.app;

import android.view.InputDevice;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.libsdl.app.SDLActivity;
import org.libsdl.app.SDLJoystickHandler;

class SDLJoystickHandler_API12
extends SDLJoystickHandler {
    private ArrayList<SDLJoystick> mJoysticks = new ArrayList();

    public void pollInputDevices() {
        int i;
        int[] deviceIds = InputDevice.getDeviceIds();
        for (int i2 = deviceIds.length - 1; i2 > -1; --i2) {
            SDLJoystick joystick = this.getJoystick(deviceIds[i2]);
            if (joystick != null) continue;
            joystick = new SDLJoystick();
            InputDevice joystickDevice = InputDevice.getDevice((int)deviceIds[i2]);
            if (!SDLActivity.isDeviceSDLJoystick(deviceIds[i2])) continue;
            joystick.device_id = deviceIds[i2];
            joystick.name = joystickDevice.getName();
            joystick.desc = this.getJoystickDescriptor(joystickDevice);
            joystick.axes = new ArrayList();
            joystick.hats = new ArrayList();
            List ranges = joystickDevice.getMotionRanges();
            Collections.sort(ranges, new RangeComparator());
            for (InputDevice.MotionRange range : ranges) {
                if ((range.getSource() & 0x10) == 0) continue;
                if (range.getAxis() == 15 || range.getAxis() == 16) {
                    joystick.hats.add(range);
                    continue;
                }
                joystick.axes.add(range);
            }
            this.mJoysticks.add(joystick);
            SDLActivity.nativeAddJoystick(joystick.device_id, joystick.name, joystick.desc, 0, -1, joystick.axes.size(), joystick.hats.size() / 2, 0);
        }
        ArrayList<Integer> removedDevices = new ArrayList<Integer>();
        for (i = 0; i < this.mJoysticks.size(); ++i) {
            int j;
            int device_id = this.mJoysticks.get((int)i).device_id;
            for (j = 0; j < deviceIds.length && device_id != deviceIds[j]; ++j) {
            }
            if (j != deviceIds.length) continue;
            removedDevices.add(device_id);
        }
        block4: for (i = 0; i < removedDevices.size(); ++i) {
            int device_id = (Integer)removedDevices.get(i);
            SDLActivity.nativeRemoveJoystick(device_id);
            for (int j = 0; j < this.mJoysticks.size(); ++j) {
                if (this.mJoysticks.get((int)j).device_id != device_id) continue;
                this.mJoysticks.remove(j);
                continue block4;
            }
        }
    }

    protected SDLJoystick getJoystick(int device_id) {
        for (int i = 0; i < this.mJoysticks.size(); ++i) {
            if (this.mJoysticks.get((int)i).device_id != device_id) continue;
            return this.mJoysticks.get(i);
        }
        return null;
    }

    public boolean handleMotionEvent(MotionEvent event) {
        if ((event.getSource() & 0x1000010) != 0) {
            int actionPointerIndex = event.getActionIndex();
            int action = event.getActionMasked();
            switch (action) {
                case 2: {
                    int i;
                    SDLJoystick joystick = this.getJoystick(event.getDeviceId());
                    if (joystick == null) break;
                    for (i = 0; i < joystick.axes.size(); ++i) {
                        InputDevice.MotionRange range = joystick.axes.get(i);
                        float value = (event.getAxisValue(range.getAxis(), actionPointerIndex) - range.getMin()) / range.getRange() * 2.0f - 1.0f;
                        SDLActivity.onNativeJoy(joystick.device_id, i, value);
                    }
                    for (i = 0; i < joystick.hats.size(); i += 2) {
                        int hatX = Math.round(event.getAxisValue(joystick.hats.get(i).getAxis(), actionPointerIndex));
                        int hatY = Math.round(event.getAxisValue(joystick.hats.get(i + 1).getAxis(), actionPointerIndex));
                        SDLActivity.onNativeHat(joystick.device_id, i / 2, hatX, hatY);
                    }
                    break;
                }
            }
        }
        return true;
    }

    public String getJoystickDescriptor(InputDevice joystickDevice) {
        return joystickDevice.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RangeComparator
    implements Comparator<InputDevice.MotionRange> {
        RangeComparator() {
        }

        @Override
        public int compare(InputDevice.MotionRange arg0, InputDevice.MotionRange arg1) {
            return arg0.getAxis() - arg1.getAxis();
        }
    }

    static class SDLJoystick {
        public int device_id;
        public String name;
        public String desc;
        public ArrayList<InputDevice.MotionRange> axes;
        public ArrayList<InputDevice.MotionRange> hats;

        SDLJoystick() {
        }
    }
}

