/*
 * Decompiled with CFR 0.152.
 */
package org.libsdl.app;

import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import org.libsdl.app.SDLActivity;

class SDLInputConnection
extends BaseInputConnection {
    String keptSurrogate = null;

    public SDLInputConnection(View targetView, boolean fullEditor) {
        super(targetView, fullEditor);
    }

    public boolean sendKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (event.getAction() == 0) {
            int ch;
            if (SDLActivity.isTextInputEvent(event) && (ch = event.getUnicodeChar()) != 0) {
                this.commitText(String.valueOf((char)ch), 1);
                return true;
            }
            SDLActivity.onNativeKeyDown(keyCode);
            return true;
        }
        if (event.getAction() == 1) {
            SDLActivity.onNativeKeyUp(keyCode);
            return true;
        }
        return super.sendKeyEvent(event);
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        char ch;
        boolean useText = true;
        if (this.keptSurrogate != null) {
            char ch2;
            if (text.length() > 0 && (ch2 = text.charAt(0)) >= '\udc00' && ch2 <= '\udfff') {
                this.nativeCommitText(this.keptSurrogate + text.toString(), newCursorPosition);
                useText = false;
            }
            this.keptSurrogate = null;
        } else if (text.length() == 1 && (ch = text.charAt(0)) >= '\ud800' && ch <= '\udbff') {
            this.keptSurrogate = text.toString();
            useText = false;
        }
        if (useText) {
            this.nativeCommitText(text.toString(), newCursorPosition);
        }
        return super.commitText(text, newCursorPosition);
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        this.nativeSetComposingText(text.toString(), newCursorPosition);
        return super.setComposingText(text, newCursorPosition);
    }

    public native void nativeCommitText(String var1, int var2);

    public native void nativeSetComposingText(String var1, int var2);

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        if (beforeLength > 0 && afterLength == 0) {
            boolean ret = true;
            while (beforeLength-- > 0) {
                boolean ret_key = this.sendKeyEvent(new KeyEvent(0, 67)) && this.sendKeyEvent(new KeyEvent(1, 67));
                ret = ret && ret_key;
            }
            return ret;
        }
        return super.deleteSurroundingText(beforeLength, afterLength);
    }
}

