/*
 * Decompiled with CFR 0.152.
 */
package org.libsdl.app;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.UiModeManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.libsdl.app.DummyEdit;
import org.libsdl.app.FocusHighlight_API26;
import org.libsdl.app.SDLClipboardHandler;
import org.libsdl.app.SDLClipboardHandler_API11;
import org.libsdl.app.SDLClipboardHandler_Old;
import org.libsdl.app.SDLCtrlKey;
import org.libsdl.app.SDLHapticHandler;
import org.libsdl.app.SDLJoystickHandler;
import org.libsdl.app.SDLJoystickHandler_API12;
import org.libsdl.app.SDLJoystickHandler_API16;
import org.libsdl.app.SDLMain;
import org.libsdl.app.SDLSurface;
import org.libsdl.app.SystemUI;

public class SDLActivity
extends Activity {
    private static final String TAG = "SDL";
    public static boolean mIsResumedCalled;
    public static boolean mIsSurfaceReady;
    public static boolean mHasFocus;
    public static NativeState mNextNativeState;
    public static NativeState mCurrentNativeState;
    protected static int mInputType;
    protected static boolean mSysUIFlagsSet;
    protected static int mSysUIFlags;
    public static boolean mExitCalledFromJava;
    public static boolean mBrokenLibraries;
    public static boolean mSeparateMouseAndTouch;
    protected static Context mContext;
    protected static SDLActivity mSingleton;
    protected static SDLSurface mSurface;
    protected static View mTextEdit;
    protected static boolean mScreenKeyboardShown;
    protected static ViewGroup mLayout;
    protected static SDLJoystickHandler mJoystickHandler;
    protected static SDLHapticHandler mHapticHandler;
    protected static SDLClipboardHandler mClipboardHandler;
    protected static Thread mSDLThread;
    protected static AudioTrack mAudioTrack;
    protected static AudioRecord mAudioRecord;
    protected static final int COMMAND_CHANGE_TITLE = 1;
    protected static final int COMMAND_UNUSED = 2;
    protected static final int COMMAND_TEXTEDIT_HIDE = 3;
    protected static final int COMMAND_SET_KEEP_SCREEN_ON = 5;
    protected static final int COMMAND_USER = 32768;
    Handler commandHandler = new SDLCommandHandler();
    private Object expansionFile;
    private Method expansionFileMethod;
    protected final int[] messageboxSelection = new int[1];
    protected int dialogs = 0;

    public void loadLibraries() {
        System.loadLibrary("SDL2");
        System.loadLibrary("tcl");
        System.loadLibrary("freetype");
        System.loadLibrary("tk");
        try {
            System.loadLibrary("jpeg_tkimg");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"no jpeg");
        }
        try {
            System.loadLibrary("tiff_tkimg");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"no tiff");
        }
        try {
            System.loadLibrary("png_tkimg");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"no png");
        }
        try {
            System.loadLibrary("crypto_tls");
            System.loadLibrary("ssl_tls");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"no libressl");
        }
        try {
            System.loadLibrary("curl");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"no libcurl");
        }
        try {
            System.loadLibrary("xml2xslt");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"no xml2xslt");
        }
        try {
            System.loadLibrary("mikmod");
            System.loadLibrary("smpeg2");
            System.loadLibrary("SDL2_mixer");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"no SDL2_mixer");
        }
        System.loadLibrary("main");
    }

    public static void initialize() {
        mContext = null;
        mSingleton = null;
        mSurface = null;
        mTextEdit = null;
        mLayout = null;
        mJoystickHandler = null;
        mHapticHandler = null;
        mClipboardHandler = null;
        mSDLThread = null;
        mAudioTrack = null;
        mAudioRecord = null;
        mExitCalledFromJava = false;
        mBrokenLibraries = false;
        mIsResumedCalled = false;
        mIsSurfaceReady = false;
        mHasFocus = true;
        mNextNativeState = NativeState.INIT;
        mCurrentNativeState = NativeState.INIT;
        mSysUIFlagsSet = false;
        mInputType = 0;
    }

    public static void setContext(Context context) {
        mContext = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        String filename;
        Log.v((String)TAG, (String)("Device: " + Build.DEVICE));
        Log.v((String)TAG, (String)("Model: " + Build.MODEL));
        Log.v((String)TAG, (String)"onCreate()");
        super.onCreate(savedInstanceState);
        if (mSingleton != null) {
            return;
        }
        this.getWindow().setFormat(3);
        SDLActivity.initialize();
        mSingleton = this;
        mContext = mSingleton;
        String errorMsgBrokenLib = "";
        try {
            this.loadLibraries();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getMessage());
            mBrokenLibraries = true;
            errorMsgBrokenLib = e.getMessage();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            mBrokenLibraries = true;
            errorMsgBrokenLib = e.getMessage();
        }
        if (mBrokenLibraries) {
            AlertDialog.Builder dlgAlert = new AlertDialog.Builder((Context)this);
            dlgAlert.setMessage((CharSequence)("An error occurred while trying to start the application. Please try again and/or reinstall." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Error: " + errorMsgBrokenLib));
            dlgAlert.setTitle((CharSequence)"SDL Error");
            dlgAlert.setPositiveButton((CharSequence)"Exit", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id) {
                    mSingleton.finish();
                }
            });
            dlgAlert.setCancelable(false);
            dlgAlert.create().show();
            return;
        }
        SDLActivity.nativeSetupJNI();
        mJoystickHandler = Build.VERSION.SDK_INT >= 16 ? new SDLJoystickHandler_API16() : (Build.VERSION.SDK_INT >= 12 ? new SDLJoystickHandler_API12() : new SDLJoystickHandler());
        mHapticHandler = new SDLHapticHandler();
        mClipboardHandler = Build.VERSION.SDK_INT >= 11 ? new SDLClipboardHandler_API11() : new SDLClipboardHandler_Old();
        mSurface = new SDLSurface((Context)this.getApplication());
        if (Build.VERSION.SDK_INT >= 26) {
            FocusHighlight_API26.setDefaultFocusHighlightEnabled((View)mSurface, (boolean)false);
        }
        mLayout = new RelativeLayout((Context)this);
        mLayout.addView((View)mSurface);
        this.setContentView((View)mLayout);
        Intent intent = this.getIntent();
        if (intent != null && intent.getData() != null && (filename = intent.getData().getPath()) != null) {
            Log.v((String)TAG, (String)("Got filename: " + filename));
            SDLActivity.onNativeDropFile(filename);
        }
    }

    public void hideTextInput() {
        if (mTextEdit != null && mScreenKeyboardShown) {
            mTextEdit.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(0, 0));
            InputMethodManager imm = (InputMethodManager)mContext.getSystemService("input_method");
            imm.hideSoftInputFromWindow(mTextEdit.getWindowToken(), 0);
            mScreenKeyboardShown = false;
        }
    }

    protected void onPause() {
        Log.v((String)TAG, (String)"onPause()");
        this.hideTextInput();
        super.onPause();
        mNextNativeState = NativeState.PAUSED;
        mIsResumedCalled = false;
        if (mBrokenLibraries) {
            return;
        }
        SDLActivity.handleNativeState();
    }

    protected void onResume() {
        Log.v((String)TAG, (String)"onResume()");
        super.onResume();
        mNextNativeState = NativeState.RESUMED;
        mIsResumedCalled = true;
        if (mBrokenLibraries) {
            return;
        }
        SDLActivity.handleNativeState();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        Log.v((String)TAG, (String)("onWindowFocusChanged(): " + hasFocus));
        if (mBrokenLibraries) {
            return;
        }
        mHasFocus = hasFocus;
        if (hasFocus) {
            mNextNativeState = NativeState.RESUMED;
            SDLActivity.handleNativeState();
        }
    }

    public void onLowMemory() {
        Log.v((String)TAG, (String)"onLowMemory()");
        super.onLowMemory();
        if (mBrokenLibraries) {
            return;
        }
        SDLActivity.nativeLowMemory();
    }

    protected void onDestroy() {
        Log.v((String)TAG, (String)"onDestroy()");
        if (mBrokenLibraries) {
            super.onDestroy();
            SDLActivity.initialize();
            return;
        }
        mNextNativeState = NativeState.PAUSED;
        SDLActivity.handleNativeState();
        mExitCalledFromJava = true;
        SDLActivity.nativeQuit();
        if (mSDLThread != null) {
            try {
                mSDLThread.join();
            }
            catch (Exception e) {
                Log.v((String)TAG, (String)("Problem stopping thread: " + e));
            }
            mSDLThread = null;
        }
        super.onDestroy();
        SDLActivity.initialize();
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (mBrokenLibraries) {
            return false;
        }
        int keyCode = event.getKeyCode();
        if (keyCode == 25 || keyCode == 24 || keyCode == 27 || keyCode == 168 || keyCode == 169) {
            return false;
        }
        return super.dispatchKeyEvent(event);
    }

    public static void handleNativeState() {
        if (mNextNativeState == mCurrentNativeState) {
            return;
        }
        if (mNextNativeState == NativeState.INIT) {
            mCurrentNativeState = mNextNativeState;
            return;
        }
        if (mNextNativeState == NativeState.PAUSED) {
            SDLActivity.nativePause();
            if (mSurface != null) {
                mSurface.handlePause();
            }
            mCurrentNativeState = mNextNativeState;
            return;
        }
        if (mNextNativeState == NativeState.RESUMED) {
            if (mIsSurfaceReady && mHasFocus && mIsResumedCalled) {
                if (mSDLThread == null) {
                    final Thread sdlThread = new Thread((Runnable)new SDLMain(), "SDLThread");
                    mSurface.enableSensor(1, true);
                    sdlThread.start();
                    mSDLThread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                sdlThread.join();
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                if (!mExitCalledFromJava) {
                                    SDLActivity.handleNativeExit();
                                }
                            }
                        }
                    }, "SDLThreadListener");
                    mSDLThread.start();
                    mSurface.handleResume();
                } else {
                    SDLActivity.restoreSystemUI();
                    SDLActivity.nativeResume();
                    mSurface.handleResume();
                }
                mCurrentNativeState = mNextNativeState;
            }
            return;
        }
    }

    public static void handleNativeExit() {
        mSDLThread = null;
        if (mSingleton != null) {
            mSingleton.finish();
        }
    }

    protected boolean onUnhandledMessage(int command, Object param) {
        return false;
    }

    boolean sendCommand(int command, Object data) {
        Message msg = this.commandHandler.obtainMessage();
        msg.arg1 = command;
        msg.obj = data;
        return this.commandHandler.sendMessage(msg);
    }

    public static native int nativeSetupJNI();

    public static native int nativeRunMain(String var0, String var1, Object var2);

    public static native void nativeLowMemory();

    public static native void nativeQuit();

    public static native void nativePause();

    public static native void nativeResume();

    public static native void onNativeDropFile(String var0);

    public static native void onNativeResize(int var0, int var1, int var2, int var3, int var4, float var5);

    public static native int onNativePadDown(int var0, int var1);

    public static native int onNativePadUp(int var0, int var1);

    public static native void onNativeJoy(int var0, int var1, float var2);

    public static native void onNativeHat(int var0, int var1, int var2, int var3);

    public static native void onNativeKeyDown(int var0);

    public static native void onNativeKeyUp(int var0);

    public static native void onNativeKeyboardFocusLost();

    public static native void onNativeMouse(int var0, int var1, float var2, float var3);

    public static native void onNativeTouch(int var0, int var1, int var2, float var3, float var4, float var5);

    public static native void onNativeAccel(float var0, float var1, float var2);

    public static native void onNativeClipboardChanged();

    public static native void onNativeSurfaceChanged();

    public static native void onNativeSurfaceDestroyed();

    public static native int nativeAddJoystick(int var0, String var1, String var2, int var3, int var4, int var5, int var6, int var7);

    public static native int nativeRemoveJoystick(int var0);

    public static native int nativeAddHaptic(int var0, String var1);

    public static native int nativeRemoveHaptic(int var0);

    public static native String nativeGetHint(String var0);

    public static boolean setActivityTitle(String title) {
        return mSingleton.sendCommand(1, title);
    }

    public static void setOrientation(int w, int h, boolean resizable, String hint) {
        if (mSingleton != null) {
            mSingleton.setOrientationBis(w, h, resizable, hint);
        }
    }

    public void setOrientationBis(int w, int h, boolean resizable, String hint) {
        int orientation = -1;
        if (hint.length() > 0) {
            if (hint.contains("LandscapeRight") && hint.contains("LandscapeLeft")) {
                orientation = 6;
            } else if (hint.contains("LandscapeRight")) {
                orientation = 0;
            } else if (hint.contains("LandscapeLeft")) {
                orientation = 8;
            } else if (hint.contains("Portrait") && hint.contains("PortraitUpsideDown")) {
                orientation = 7;
            } else if (hint.contains("Portrait")) {
                orientation = 1;
            } else if (hint.contains("PortraitUpsideDown")) {
                orientation = 9;
            }
        }
        if (orientation == -1 && !resizable) {
            orientation = w > h ? 6 : 7;
        }
        Log.v((String)TAG, (String)("setOrientation() orientation=" + orientation + " width=" + w + " height=" + h + " resizable=" + resizable + " hint=" + hint));
        if (orientation != -1) {
            mSingleton.setRequestedOrientation(orientation);
        }
    }

    public static boolean isScreenKeyboardShown() {
        if (mTextEdit == null) {
            return false;
        }
        if (!mScreenKeyboardShown) {
            return false;
        }
        InputMethodManager imm = (InputMethodManager)SDLActivity.getContext().getSystemService("input_method");
        return imm.isAcceptingText();
    }

    public static boolean sendMessage(int command, int param) {
        if (mSingleton == null) {
            return false;
        }
        return mSingleton.sendCommand(command, param);
    }

    public static Context getContext() {
        return mContext;
    }

    public static boolean showTextInput(int x, int y, int w, int h, int hints) {
        mInputType = hints;
        return SDLActivity.mSingleton.commandHandler.post((Runnable)new ShowTextInputTask(x, y, w, h));
    }

    public static boolean isTextInputEvent(KeyEvent event) {
        boolean lalt;
        boolean ctrl = false;
        boolean bl = lalt = (event.getMetaState() & 0x10) != 0;
        if (Build.VERSION.SDK_INT >= 11) {
            ctrl = SDLCtrlKey.pressed(event);
        } else {
            boolean bl2 = ctrl = (event.getMetaState() & 0x7000) != 0;
        }
        return !lalt && !ctrl && (event.isPrintingKey() || event.getKeyCode() == 62);
    }

    public static int getSystemUI() {
        if (Build.VERSION.SDK_INT >= 19) {
            mSysUIFlags = SystemUI.getSystemUI(mSingleton);
        }
        return mSysUIFlags;
    }

    static void restoreSystemUI() {
        if (mSysUIFlagsSet && Build.VERSION.SDK_INT >= 19) {
            SystemUI.setSystemUI(mSingleton, mSysUIFlags);
        }
    }

    public static void setSystemUI(final int flags) {
        if (Build.VERSION.SDK_INT >= 19) {
            Runnable doSysUI = new Runnable(){

                public void run() {
                    mSysUIFlags = flags;
                    mSysUIFlagsSet = true;
                    SystemUI.setSystemUI(mSingleton, flags);
                }
            };
            mSingleton.runOnUiThread(doSysUI);
        }
    }

    public static Surface getNativeSurface() {
        if (mSurface == null) {
            return null;
        }
        return mSurface.getNativeSurface();
    }

    public static int audioOpen(int sampleRate, boolean is16Bit, boolean isStereo, int desiredFrames) {
        int channelConfig = isStereo ? 3 : 2;
        int audioFormat = is16Bit ? 2 : 3;
        int frameSize = (isStereo ? 2 : 1) * (is16Bit ? 2 : 1);
        Log.v((String)TAG, (String)("SDL audio: wanted " + (isStereo ? "stereo" : "mono") + " " + (is16Bit ? "16-bit" : "8-bit") + " " + (float)sampleRate / 1000.0f + "kHz, " + desiredFrames + " frames buffer"));
        desiredFrames = Math.max(desiredFrames, (AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat) + frameSize - 1) / frameSize);
        if (mAudioTrack == null) {
            mAudioTrack = new AudioTrack(3, sampleRate, channelConfig, audioFormat, desiredFrames * frameSize, 1);
            if (mAudioTrack.getState() != 1) {
                Log.e((String)TAG, (String)"Failed during initialization of Audio Track");
                mAudioTrack = null;
                return -1;
            }
            mAudioTrack.play();
        }
        Log.v((String)TAG, (String)("SDL audio: got " + (mAudioTrack.getChannelCount() >= 2 ? "stereo" : "mono") + " " + (mAudioTrack.getAudioFormat() == 2 ? "16-bit" : "8-bit") + " " + (float)mAudioTrack.getSampleRate() / 1000.0f + "kHz, " + desiredFrames + " frames buffer"));
        return 0;
    }

    public static void audioWriteShortBuffer(short[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            int result = mAudioTrack.write(buffer, i, buffer.length - i);
            if (result > 0) {
                i += result;
                continue;
            }
            if (result == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Log.w((String)TAG, (String)"SDL audio: error return from write(short)");
            return;
        }
    }

    public static void audioWriteByteBuffer(byte[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            int result = mAudioTrack.write(buffer, i, buffer.length - i);
            if (result > 0) {
                i += result;
                continue;
            }
            if (result == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Log.w((String)TAG, (String)"SDL audio: error return from write(byte)");
            return;
        }
    }

    public static int captureOpen(int sampleRate, boolean is16Bit, boolean isStereo, int desiredFrames) {
        int channelConfig = isStereo ? 3 : 2;
        int audioFormat = is16Bit ? 2 : 3;
        int frameSize = (isStereo ? 2 : 1) * (is16Bit ? 2 : 1);
        Log.v((String)TAG, (String)("SDL capture: wanted " + (isStereo ? "stereo" : "mono") + " " + (is16Bit ? "16-bit" : "8-bit") + " " + (float)sampleRate / 1000.0f + "kHz, " + desiredFrames + " frames buffer"));
        desiredFrames = Math.max(desiredFrames, (AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat) + frameSize - 1) / frameSize);
        if (mAudioRecord == null) {
            mAudioRecord = new AudioRecord(0, sampleRate, channelConfig, audioFormat, desiredFrames * frameSize);
            if (mAudioRecord.getState() != 1) {
                Log.e((String)TAG, (String)"Failed during initialization of AudioRecord");
                mAudioRecord.release();
                mAudioRecord = null;
                return -1;
            }
            mAudioRecord.startRecording();
        }
        Log.v((String)TAG, (String)("SDL capture: got " + (mAudioRecord.getChannelCount() >= 2 ? "stereo" : "mono") + " " + (mAudioRecord.getAudioFormat() == 2 ? "16-bit" : "8-bit") + " " + (float)mAudioRecord.getSampleRate() / 1000.0f + "kHz, " + desiredFrames + " frames buffer"));
        return 0;
    }

    public static int captureReadShortBuffer(short[] buffer, boolean blocking) {
        return mAudioRecord.read(buffer, 0, buffer.length);
    }

    public static int captureReadByteBuffer(byte[] buffer, boolean blocking) {
        return mAudioRecord.read(buffer, 0, buffer.length);
    }

    public static void audioClose() {
        if (mAudioTrack != null) {
            mAudioTrack.stop();
            mAudioTrack.release();
            mAudioTrack = null;
        }
    }

    public static void captureClose() {
        if (mAudioRecord != null) {
            mAudioRecord.stop();
            mAudioRecord.release();
            mAudioRecord = null;
        }
    }

    public static int[] inputGetInputDeviceIds(int sources) {
        int[] ids = InputDevice.getDeviceIds();
        int[] filtered = new int[ids.length];
        int used = 0;
        for (int i = 0; i < ids.length; ++i) {
            InputDevice device = InputDevice.getDevice((int)ids[i]);
            if (device == null || (device.getSources() & sources) == 0) continue;
            filtered[used++] = device.getId();
        }
        return Arrays.copyOf(filtered, used);
    }

    public static boolean handleJoystickMotionEvent(MotionEvent event) {
        return mJoystickHandler.handleMotionEvent(event);
    }

    public static void pollInputDevices() {
        if (mSDLThread != null) {
            mJoystickHandler.pollInputDevices();
        }
    }

    public static void pollHapticDevices() {
        if (mSDLThread != null) {
            mHapticHandler.pollHapticDevices();
        }
    }

    public static void hapticRun(int device_id, int length) {
        if (mSDLThread != null) {
            mHapticHandler.run(device_id, length);
        }
    }

    public static boolean isDeviceSDLJoystick(int deviceId) {
        InputDevice device = InputDevice.getDevice((int)deviceId);
        if (device == null || deviceId < 0) {
            return false;
        }
        int sources = device.getSources();
        return (sources & 0x10) == 16 || (sources & 0x201) == 513 || (sources & 0x401) == 1025;
    }

    public InputStream openAPKExpansionInputStream(String fileName) throws IOException {
        InputStream fileStream;
        if (this.expansionFile == null) {
            Integer patchVersion;
            Integer mainVersion;
            String mainHint = SDLActivity.nativeGetHint("SDL_ANDROID_APK_EXPANSION_MAIN_FILE_VERSION");
            if (mainHint == null) {
                return null;
            }
            String patchHint = SDLActivity.nativeGetHint("SDL_ANDROID_APK_EXPANSION_PATCH_FILE_VERSION");
            if (patchHint == null) {
                return null;
            }
            try {
                mainVersion = Integer.valueOf(mainHint);
                patchVersion = Integer.valueOf(patchHint);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                throw new IOException("No valid file versions set for APK expansion files", ex);
            }
            try {
                this.expansionFile = Class.forName("com.android.vending.expansion.zipfile.APKExpansionSupport").getMethod("getAPKExpansionZipFile", Context.class, Integer.TYPE, Integer.TYPE).invoke(null, new Object[]{this, mainVersion, patchVersion});
                this.expansionFileMethod = this.expansionFile.getClass().getMethod("getInputStream", String.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.expansionFile = null;
                this.expansionFileMethod = null;
                throw new IOException("Could not access APK expansion support library", ex);
            }
        }
        try {
            fileStream = (InputStream)this.expansionFileMethod.invoke(this.expansionFile, fileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Could not open stream from APK expansion file", ex);
        }
        if (fileStream == null) {
            throw new IOException("Could not find path in APK expansion file");
        }
        return fileStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int messageboxShowMessageBox(int flags, String title, String message, int[] buttonFlags, int[] buttonIds, String[] buttonTexts, int[] colors) {
        this.messageboxSelection[0] = -1;
        if (buttonFlags.length != buttonIds.length && buttonIds.length != buttonTexts.length) {
            return -1;
        }
        final Bundle args = new Bundle();
        args.putInt("flags", flags);
        args.putString("title", title);
        args.putString("message", message);
        args.putIntArray("buttonFlags", buttonFlags);
        args.putIntArray("buttonIds", buttonIds);
        args.putStringArray("buttonTexts", buttonTexts);
        args.putIntArray("colors", colors);
        this.runOnUiThread(new Runnable(){

            public void run() {
                SDLActivity.this.showDialog(SDLActivity.this.dialogs++, args);
            }
        });
        int[] nArray = this.messageboxSelection;
        synchronized (this.messageboxSelection) {
            try {
                this.messageboxSelection.wait();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return -1;
            }
            return this.messageboxSelection[0];
        }
    }

    protected Dialog onCreateDialog(int ignore, Bundle args) {
        int buttonSelectedColor;
        int buttonBackgroundColor;
        int buttonBorderColor;
        int textColor;
        int backgroundColor;
        int[] colors = args.getIntArray("colors");
        if (colors != null) {
            int i = -1;
            backgroundColor = colors[++i];
            textColor = colors[++i];
            buttonBorderColor = colors[++i];
            buttonBackgroundColor = colors[++i];
            buttonSelectedColor = colors[++i];
        } else {
            backgroundColor = 0;
            textColor = 0;
            buttonBorderColor = 0;
            buttonBackgroundColor = 0;
            buttonSelectedColor = 0;
        }
        final Dialog dialog = new Dialog((Context)this);
        dialog.setTitle((CharSequence)args.getString("title"));
        dialog.setCancelable(false);
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDismiss(DialogInterface unused) {
                int[] nArray = SDLActivity.this.messageboxSelection;
                synchronized (SDLActivity.this.messageboxSelection) {
                    SDLActivity.this.messageboxSelection.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        TextView message = new TextView((Context)this);
        message.setGravity(17);
        message.setText((CharSequence)args.getString("message"));
        if (textColor != 0) {
            message.setTextColor(textColor);
        }
        int[] buttonFlags = args.getIntArray("buttonFlags");
        int[] buttonIds = args.getIntArray("buttonIds");
        String[] buttonTexts = args.getStringArray("buttonTexts");
        final SparseArray mapping = new SparseArray();
        LinearLayout buttons = new LinearLayout((Context)this);
        buttons.setOrientation(0);
        buttons.setGravity(17);
        for (int i = 0; i < buttonTexts.length; ++i) {
            Button button = new Button((Context)this);
            final int id = buttonIds[i];
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SDLActivity.this.messageboxSelection[0] = id;
                    dialog.dismiss();
                }
            });
            if (buttonFlags[i] != 0) {
                if ((buttonFlags[i] & 1) != 0) {
                    mapping.put(66, (Object)button);
                }
                if ((buttonFlags[i] & 2) != 0) {
                    mapping.put(111, (Object)button);
                }
            }
            button.setText((CharSequence)buttonTexts[i]);
            if (textColor != 0) {
                button.setTextColor(textColor);
            }
            if (buttonBorderColor != 0) {
                // empty if block
            }
            if (buttonBackgroundColor != 0) {
                Drawable drawable = button.getBackground();
                if (drawable == null) {
                    button.setBackgroundColor(buttonBackgroundColor);
                } else {
                    drawable.setColorFilter(buttonBackgroundColor, PorterDuff.Mode.MULTIPLY);
                }
            }
            if (buttonSelectedColor != 0) {
                // empty if block
            }
            buttons.addView((View)button);
        }
        LinearLayout content = new LinearLayout((Context)this);
        content.setOrientation(1);
        content.addView((View)message);
        content.addView((View)buttons);
        if (backgroundColor != 0) {
            content.setBackgroundColor(backgroundColor);
        }
        dialog.setContentView((View)content);
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface d, int keyCode, KeyEvent event) {
                Button button = (Button)mapping.get(keyCode);
                if (button != null) {
                    if (event.getAction() == 1) {
                        button.performClick();
                    }
                    return true;
                }
                return false;
            }
        });
        return dialog;
    }

    public static boolean clipboardHasText() {
        return mClipboardHandler.clipboardHasText();
    }

    public static String clipboardGetText() {
        return mClipboardHandler.clipboardGetText();
    }

    public static void clipboardSetText(String string) {
        mClipboardHandler.clipboardSetText(string);
    }

    public static boolean isAndroidTV() {
        UiModeManager uiModeManager = (UiModeManager)SDLActivity.getContext().getSystemService("uimode");
        return uiModeManager.getCurrentModeType() == 4;
    }

    public static boolean isChromebook() {
        return SDLActivity.getContext().getPackageManager().hasSystemFeature("org.chromium.arc.device_management");
    }

    static class ShowTextInputTask
    implements Runnable {
        static final int HEIGHT_PADDING = 15;
        public int x;
        public int y;
        public int w;
        public int h;

        public ShowTextInputTask(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            if (this.w <= 0) {
                this.w = 1;
            }
            if (this.h + 15 <= 0) {
                this.h = -14;
            }
        }

        public void run() {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.w, this.h + 15);
            params.leftMargin = this.x;
            params.topMargin = this.y;
            if (mTextEdit == null) {
                mTextEdit = new DummyEdit(SDLActivity.getContext());
                mLayout.addView(mTextEdit, (ViewGroup.LayoutParams)params);
            } else {
                mTextEdit.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            mTextEdit.setVisibility(0);
            mTextEdit.requestFocus();
            InputMethodManager imm = (InputMethodManager)SDLActivity.getContext().getSystemService("input_method");
            imm.showSoftInput(mTextEdit, 0);
            if (!mScreenKeyboardShown) {
                imm.restartInput(mTextEdit);
            }
            mScreenKeyboardShown = true;
        }
    }

    protected static class SDLCommandHandler
    extends Handler {
        protected SDLCommandHandler() {
        }

        public void handleMessage(Message msg) {
            Context context = SDLActivity.getContext();
            if (context == null) {
                Log.e((String)SDLActivity.TAG, (String)"error handling message, getContext() returned null");
                return;
            }
            switch (msg.arg1) {
                case 1: {
                    if (context instanceof Activity) {
                        ((Activity)context).setTitle((CharSequence)((String)msg.obj));
                        break;
                    }
                    Log.e((String)SDLActivity.TAG, (String)"error handling message, getContext() returned no Activity");
                    break;
                }
                case 3: {
                    if (mTextEdit == null) break;
                    mTextEdit.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(0, 0));
                    InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                    imm.hideSoftInputFromWindow(mTextEdit.getWindowToken(), 0);
                    mScreenKeyboardShown = false;
                    SDLActivity.restoreSystemUI();
                    break;
                }
                case 5: {
                    Window window;
                    if (!(context instanceof Activity) || (window = ((Activity)context).getWindow()) == null) break;
                    if (msg.obj instanceof Integer && (Integer)msg.obj != 0) {
                        window.addFlags(128);
                        break;
                    }
                    window.clearFlags(128);
                    break;
                }
                default: {
                    if (!(context instanceof SDLActivity) || ((SDLActivity)context).onUnhandledMessage(msg.arg1, msg.obj)) break;
                    Log.e((String)SDLActivity.TAG, (String)("error handling message, command is " + msg.arg1));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NativeState {
        INIT,
        RESUMED,
        PAUSED;

    }
}

